/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument.tracing;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class PrintLogger {
    private final PrintWriter writer;

    private PrintLogger(String name, OutputStream out) {
        this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out)));
    }

    public PrintLogger(String name) {
        this(name, PrintLogger.createOutputStream(name));
    }

    private static OutputStream createOutputStream(String name) {
        try {
            return new FileOutputStream(name + ".log");
        }
        catch (IOException e) {
            e.printStackTrace();
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
        }
    }

    public void log(String info) {
        this.writer.println(info);
        this.writer.flush();
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void close() {
        this.writer.flush();
        this.writer.close();
    }
}

