/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument.tracing;

import edu.berkeley.cs.jqf.instrument.InstrumentationException;
import edu.berkeley.cs.jqf.instrument.tracing.ControlFlowInstructionVisitor;
import edu.berkeley.cs.jqf.instrument.tracing.SingleSnoop;
import edu.berkeley.cs.jqf.instrument.tracing.events.AllocEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.BranchEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.ReadEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.ReturnEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import janala.logger.inst.ARETURN;
import janala.logger.inst.ConditionalBranch;
import janala.logger.inst.DRETURN;
import janala.logger.inst.FRETURN;
import janala.logger.inst.GETVALUE_boolean;
import janala.logger.inst.GETVALUE_int;
import janala.logger.inst.HEAPLOAD;
import janala.logger.inst.INVOKEMETHOD_END;
import janala.logger.inst.INVOKEMETHOD_EXCEPTION;
import janala.logger.inst.IRETURN;
import janala.logger.inst.IVisitor;
import janala.logger.inst.Instruction;
import janala.logger.inst.InvokeInstruction;
import janala.logger.inst.LOOKUPSWITCH;
import janala.logger.inst.LRETURN;
import janala.logger.inst.METHOD_BEGIN;
import janala.logger.inst.METHOD_THROW;
import janala.logger.inst.MemberRef;
import janala.logger.inst.NEW;
import janala.logger.inst.NEWARRAY;
import janala.logger.inst.RETURN;
import janala.logger.inst.SPECIAL;
import janala.logger.inst.TABLESWITCH;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;

public class ThreadTracer {
    protected final Thread tracee;
    protected final String entryPointClass;
    protected final String entryPointMethod;
    protected final Consumer<TraceEvent> callback;
    private final Deque<IVisitor> handlers = new ArrayDeque<IVisitor>();
    private final Values values = new Values();
    private final boolean traceGenerators = Boolean.getBoolean("jqf.tracing.TRACE_GENERATORS");
    private final boolean MATCH_CALLEE_NAMES = Boolean.getBoolean("jqf.tracing.MATCH_CALLEE_NAMES");
    protected RuntimeException callBackException = null;

    protected ThreadTracer(Thread tracee, String entryPoint, Consumer<TraceEvent> callback) {
        this.tracee = tracee;
        if (entryPoint != null) {
            int separator = entryPoint.indexOf(35);
            if (separator <= 0 || separator == entryPoint.length() - 1) {
                throw new IllegalArgumentException("Invalid entry point: " + entryPoint);
            }
            this.entryPointClass = entryPoint.substring(0, separator).replace('.', '/');
            this.entryPointMethod = entryPoint.substring(separator + 1);
        } else {
            this.entryPointClass = null;
            this.entryPointMethod = null;
        }
        this.callback = callback;
        this.handlers.push(new BaseHandler());
    }

    protected static ThreadTracer spawn(Thread thread) {
        String entryPoint = SingleSnoop.entryPoints.get(thread);
        Consumer<TraceEvent> callback = SingleSnoop.callbackGenerator.apply(thread);
        ThreadTracer t = new ThreadTracer(thread, entryPoint, callback);
        return t;
    }

    protected final void emit(TraceEvent e) {
        try {
            this.callback.accept(e);
        }
        catch (RuntimeException ex) {
            this.callBackException = ex;
        }
    }

    protected final void consume(Instruction ins) {
        ins.visit(this.handlers.peek());
        if (this.callBackException != null) {
            RuntimeException e = this.callBackException;
            this.callBackException = null;
            throw e;
        }
    }

    private static boolean isReturnOrMethodThrow(Instruction inst) {
        return inst instanceof ARETURN || inst instanceof LRETURN || inst instanceof DRETURN || inst instanceof FRETURN || inst instanceof IRETURN || inst instanceof RETURN || inst instanceof METHOD_THROW;
    }

    private static boolean isInvoke(Instruction inst) {
        return inst instanceof InvokeInstruction;
    }

    private static boolean isIfJmp(Instruction inst) {
        return inst instanceof ConditionalBranch;
    }

    private static boolean sameNameDesc(MemberRef m1, MemberRef m2) {
        if (m2 != null && m2.getOwner().contains("java/util/function") || m1 != null && m1.getName().startsWith("lambda$") || m2 != null && m2.getOwner().startsWith("java/util/stream")) {
            return true;
        }
        return m1 != null && m2 != null && m1.getName().equals(m2.getName()) && m1.getDesc().equals(m2.getDesc());
    }

    private static class Values {
        private boolean booleanValue;
        private byte byteValue;
        private char charValue;
        private double doubleValue;
        private float floatValue;
        private int intValue;
        private long longValue;
        private Object objectValue;
        private short shortValue;

        private Values() {
        }
    }

    class BaseHandler
    extends ControlFlowInstructionVisitor {
        BaseHandler() {
        }

        @Override
        public void visitMETHOD_BEGIN(METHOD_BEGIN begin) {
            String clazz = begin.getOwner();
            String method = begin.getName();
            if (!ThreadTracer.this.MATCH_CALLEE_NAMES || clazz.equals(ThreadTracer.this.entryPointClass) && method.equals(ThreadTracer.this.entryPointMethod) || ThreadTracer.this.traceGenerators && clazz.endsWith("Generator") && method.equals("generate")) {
                ThreadTracer.this.emit(new CallEvent(0, null, 0, begin));
                ThreadTracer.this.handlers.push(new TraceEventGeneratingHandler(begin, 0));
            } else {
                ThreadTracer.this.handlers.push(new MatchingNullHandler());
            }
        }
    }

    class MatchingNullHandler
    extends ControlFlowInstructionVisitor {
        MatchingNullHandler() {
        }

        @Override
        public void visitMETHOD_BEGIN(METHOD_BEGIN begin) {
            ThreadTracer.this.handlers.push(new MatchingNullHandler());
        }

        @Override
        public void visitReturnOrMethodThrow(Instruction ins) {
            ThreadTracer.this.handlers.pop();
        }
    }

    class TraceEventGeneratingHandler
    extends ControlFlowInstructionVisitor {
        private final int depth;
        private final MemberRef method;
        private MemberRef invokeTarget = null;
        private boolean invokingSuperOrThis = false;

        TraceEventGeneratingHandler(METHOD_BEGIN begin, int depth) {
            this.depth = depth;
            this.method = begin;
        }

        private String tabs() {
            StringBuffer sb = new StringBuffer(this.depth);
            for (int i = 0; i < this.depth; ++i) {
                sb.append("  ");
            }
            return sb.toString();
        }

        @Override
        public void visitMETHOD_BEGIN(METHOD_BEGIN begin) {
            if (!ThreadTracer.this.MATCH_CALLEE_NAMES && !begin.name.equals("<clinit>") || ThreadTracer.sameNameDesc(begin, this.invokeTarget)) {
                int invokerIid = this.invokeTarget != null ? ((Instruction)((Object)this.invokeTarget)).iid : -1;
                int invokerMid = this.invokeTarget != null ? ((Instruction)((Object)this.invokeTarget)).mid : -1;
                ThreadTracer.this.emit(new CallEvent(invokerIid, this.method, invokerMid, begin, begin.getObject()));
                ThreadTracer.this.handlers.push(new TraceEventGeneratingHandler(begin, this.depth + 1));
            } else {
                ThreadTracer.this.handlers.push(new MatchingNullHandler());
            }
            super.visitMETHOD_BEGIN(begin);
        }

        @Override
        public void visitINVOKEMETHOD_EXCEPTION(INVOKEMETHOD_EXCEPTION ins) {
            if (this.invokeTarget == null) {
                throw new InstrumentationException("Unexpected INVOKEMETHOD_EXCEPTION", ins.getException());
            }
            this.invokeTarget = null;
            if (this.invokingSuperOrThis) {
                TraceEventGeneratingHandler traceEventGeneratingHandler;
                do {
                    ThreadTracer.this.emit(new ReturnEvent(-1, this.method, -1));
                    ThreadTracer.this.handlers.pop();
                    IVisitor handler = (IVisitor)ThreadTracer.this.handlers.peek();
                    assert (handler instanceof TraceEventGeneratingHandler);
                    traceEventGeneratingHandler = (TraceEventGeneratingHandler)handler;
                } while (traceEventGeneratingHandler.invokingSuperOrThis);
                assert (traceEventGeneratingHandler.invokeTarget.getName().startsWith("<init>"));
                ins.visit(traceEventGeneratingHandler);
            }
            super.visitINVOKEMETHOD_EXCEPTION(ins);
        }

        @Override
        public void visitINVOKEMETHOD_END(INVOKEMETHOD_END ins) {
            if (this.invokeTarget == null) {
                throw new InstrumentationException("Unexpected INVOKEMETHOD_END");
            }
            this.invokeTarget = null;
            if (this.invokingSuperOrThis) {
                this.invokingSuperOrThis = false;
            }
            super.visitINVOKEMETHOD_END(ins);
        }

        @Override
        public void visitSPECIAL(SPECIAL special) {
            if (special.i == 2) {
                this.invokingSuperOrThis = true;
            }
        }

        @Override
        public void visitInvokeInstruction(InvokeInstruction ins) {
            this.invokeTarget = ins;
            super.visitInvokeInstruction(ins);
        }

        @Override
        public void visitGETVALUE_int(GETVALUE_int gv) {
            ThreadTracer.this.values.intValue = gv.v;
            super.visitGETVALUE_int(gv);
        }

        @Override
        public void visitGETVALUE_boolean(GETVALUE_boolean gv) {
            ThreadTracer.this.values.booleanValue = gv.v;
            super.visitGETVALUE_boolean(gv);
        }

        @Override
        public void visitConditionalBranch(Instruction ins) {
            int iid = ins.iid;
            int lineNum = ins.mid;
            boolean taken = ThreadTracer.this.values.booleanValue;
            ThreadTracer.this.emit(new BranchEvent(iid, this.method, lineNum, taken ? 1 : 0));
            super.visitConditionalBranch(ins);
        }

        @Override
        public void visitTABLESWITCH(TABLESWITCH tableSwitch) {
            int iid = tableSwitch.iid;
            int lineNum = tableSwitch.mid;
            int value = ThreadTracer.this.values.intValue;
            int numCases = tableSwitch.labels.length;
            int arm = -1;
            if (value >= 0 && value < numCases) {
                arm = value;
            }
            ThreadTracer.this.emit(new BranchEvent(iid, this.method, lineNum, arm));
            super.visitTABLESWITCH(tableSwitch);
        }

        @Override
        public void visitLOOKUPSWITCH(LOOKUPSWITCH lookupSwitch) {
            int iid = lookupSwitch.iid;
            int lineNum = lookupSwitch.mid;
            int value = ThreadTracer.this.values.intValue;
            int[] cases = lookupSwitch.keys;
            int arm = -1;
            for (int i = 0; i < cases.length; ++i) {
                if (value != cases[i]) continue;
                arm = i;
                break;
            }
            ThreadTracer.this.emit(new BranchEvent(iid, this.method, lineNum, arm));
            super.visitLOOKUPSWITCH(lookupSwitch);
        }

        @Override
        public void visitHEAPLOAD(HEAPLOAD heapload) {
            int iid = heapload.iid;
            int lineNum = heapload.mid;
            int objectId = heapload.objectId;
            String field = heapload.field;
            if (objectId != 0) {
                ThreadTracer.this.emit(new ReadEvent(iid, this.method, lineNum, objectId, field));
            }
            super.visitHEAPLOAD(heapload);
        }

        @Override
        public void visitNEW(NEW newInst) {
            int iid = newInst.iid;
            int lineNum = newInst.mid;
            ThreadTracer.this.emit(new AllocEvent(iid, this.method, lineNum, 1));
            super.visitNEW(newInst);
        }

        @Override
        public void visitNEWARRAY(NEWARRAY newArray) {
            int iid = newArray.iid;
            int lineNum = newArray.mid;
            int size = ThreadTracer.this.values.intValue;
            ThreadTracer.this.emit(new AllocEvent(iid, this.method, lineNum, size));
            super.visitNEWARRAY(newArray);
        }

        @Override
        public void visitReturnOrMethodThrow(Instruction ins) {
            ThreadTracer.this.emit(new ReturnEvent(ins.iid, this.method, ins.mid));
            ThreadTracer.this.handlers.pop();
            super.visitReturnOrMethodThrow(ins);
        }
    }
}

