/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument.tracing;

import edu.berkeley.cs.jqf.instrument.tracing.ThreadTracer;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import janala.logger.AbstractLogger;
import janala.logger.inst.Instruction;

public class TraceLogger
extends AbstractLogger {
    private static final TraceLogger singleton = new TraceLogger();
    private final ThreadLocal<ThreadTracer> threadLocalTracer = ThreadLocal.withInitial(() -> ThreadTracer.spawn(Thread.currentThread()));
    private Thread firstThread = null;
    private ThreadTracer firstTracer;

    private TraceLogger() {
    }

    private ThreadTracer getTracer() {
        if (Thread.currentThread() == this.firstThread) {
            return this.firstTracer;
        }
        if (this.firstThread == null) {
            assert (this.firstTracer == null);
            this.firstThread = Thread.currentThread();
            this.firstTracer = ThreadTracer.spawn(this.firstThread);
            return this.firstTracer;
        }
        return this.threadLocalTracer.get();
    }

    public static TraceLogger get() {
        return singleton;
    }

    @Override
    protected void log(Instruction instruction) {
        this.getTracer().consume(instruction);
    }

    public void emit(TraceEvent event) {
        this.getTracer().emit(event);
    }

    public void remove() {
        if (Thread.currentThread() == this.firstThread) {
            this.firstTracer = null;
            this.firstThread = null;
        } else {
            this.threadLocalTracer.remove();
        }
    }
}

