/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument.tracing.events;

import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEventVisitor;
import janala.logger.inst.MemberRef;

public class CallEvent
extends TraceEvent {
    protected final MemberRef invokedMethod;
    private String str;
    private final Object obj;

    public CallEvent(int iid, MemberRef containingMethod, int lineNumber, MemberRef invokedMethod) {
        super(iid, containingMethod, lineNumber);
        this.invokedMethod = invokedMethod;
        this.obj = null;
    }

    public CallEvent(int iid, MemberRef containingMethod, int lineNumber, MemberRef invokedMethod, Object callingObject) {
        super(iid, containingMethod, lineNumber);
        this.invokedMethod = invokedMethod;
        this.obj = callingObject;
    }

    public String getInvokedMethodName() {
        if (this.str == null) {
            this.str = this.invokedMethod.getOwner() + "#" + this.invokedMethod.getName() + this.invokedMethod.getDesc();
        }
        return this.str;
    }

    public Object getCallingObject() {
        return this.obj;
    }

    public String toString() {
        return String.format("CALL(%d,%d,%s)", this.iid, this.lineNumber, this.getInvokedMethodName());
    }

    @Override
    public void applyVisitor(TraceEventVisitor v) {
        v.visitCallEvent(this);
    }
}

