/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument.util;

import edu.berkeley.cs.jqf.instrument.util.Stack;
import java.util.Iterator;

public class DoublyLinkedList<T>
implements Iterable<T>,
Stack<T> {
    private Node<T> head = null;
    private Node<T> tail = null;
    private int length = 0;

    public void addFirst(T value) {
        Node<T> node = new Node<T>(value);
        if (this.head != null) {
            this.head.prev = node;
            node.next = this.head;
        }
        this.head = node;
        if (this.tail == null) {
            this.tail = node;
        }
        ++this.length;
    }

    public void addLast(T value) {
        Node<T> node = new Node<T>(value);
        if (this.tail != null) {
            this.tail.next = node;
            node.prev = this.tail;
        }
        this.tail = node;
        if (this.head == null) {
            this.head = node;
        }
        ++this.length;
    }

    public T removeFirst() {
        if (this.length == 0) {
            throw new IllegalStateException("Cannot remove from empty list");
        }
        Object value = this.head.value;
        if (this.length == 1) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = this.head.next;
            this.head.prev = null;
        }
        --this.length;
        return value;
    }

    public T removeLast() {
        if (this.length == 0) {
            throw new IllegalStateException("Cannot remove from empty list");
        }
        Object value = this.head.value;
        if (this.length == 1) {
            this.head = null;
            this.tail = null;
        } else {
            this.tail = this.tail.prev;
            this.tail.next = null;
        }
        --this.length;
        return value;
    }

    private T removeNode(Node<T> node) {
        if (node == this.head) {
            return this.removeFirst();
        }
        if (node == this.tail) {
            return this.removeLast();
        }
        Object value = node.value;
        assert (node.prev != null);
        assert (node.next != null);
        node.prev.next = node.next;
        node.next.prev = node.prev;
        node.prev = null;
        node.next = null;
        node.value = null;
        --this.length;
        return value;
    }

    public boolean remove(T item) {
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (!item.equals(it.next())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public int size() {
        return this.length;
    }

    @Override
    public void push(T item) {
        this.addLast(item);
    }

    @Override
    public T peek() {
        if (this.length == 0) {
            throw new IllegalStateException("Cannot peek at empty stack");
        }
        return this.tail.value;
    }

    @Override
    public T pop() {
        return this.removeLast();
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.length = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedListIterator(this);
    }

    public synchronized void synchronizedAddFirst(T item) {
        this.addFirst(item);
    }

    public synchronized void synchronizedAddLast(T item) {
        this.addLast(item);
    }

    public synchronized boolean synchronizedRemove(T item) {
        return this.remove(item);
    }

    public synchronized T synchronizedRemoveFirst() {
        return this.removeFirst();
    }

    public synchronized T synchronizedRemoveLast() {
        return this.removeLast();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (T item : this) {
            sb.append(item.toString());
            sb.append(", ");
        }
        sb.replace(sb.length() - 2, sb.length(), "]");
        return sb.toString();
    }

    static class Node<T> {
        T value;
        Node<T> next;
        Node<T> prev;

        Node(T value) {
            this.value = value;
        }
    }

    static class LinkedListIterator<T>
    implements Iterator<T> {
        DoublyLinkedList<T> list;
        Node<T> node;
        Node<T> lastReturnedNode;

        LinkedListIterator(DoublyLinkedList<T> list) {
            this.list = list;
            this.node = ((DoublyLinkedList)list).head;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public T next() {
            Object val = this.node.value;
            this.lastReturnedNode = this.node;
            this.node = this.node.next;
            return val;
        }

        @Override
        public void remove() {
            ((DoublyLinkedList)this.list).removeNode(this.lastReturnedNode);
        }
    }
}

