/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.instrument.util;

public final class FastBlockingQueue<T> {
    private final int size;
    private final Object[] buffer;
    private volatile int producer = 0;
    private volatile int consumer = 0;

    public FastBlockingQueue(int size) {
        this.size = size;
        this.buffer = new Object[size];
    }

    private int increment(int idx) {
        return (idx + 1) % this.size;
    }

    public final boolean isEmpty() {
        return this.producer == this.consumer;
    }

    public final boolean isFull() {
        return this.increment(this.producer) == this.consumer;
    }

    public final void put(T item) {
        while (this.isFull()) {
        }
        this.buffer[this.producer] = item;
        this.producer = this.increment(this.producer);
    }

    public final T remove(long timeout) {
        long ticks = 0L;
        while (this.isEmpty()) {
            if (++ticks <= timeout) continue;
            return null;
        }
        Object item = this.buffer[this.consumer];
        this.consumer = this.increment(this.consumer);
        return (T)item;
    }
}

