/*
 * Decompiled with CFR 0.152.
 */
package janala.instrument;

import janala.instrument.Config;
import janala.instrument.GlobalStateForInstrumentation;
import janala.instrument.Utils;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class FastCoverageMethodAdapter
extends MethodVisitor
implements Opcodes {
    boolean isInit;
    boolean isSuperInitCalled;
    int newStack = 0;
    private final String className;
    private final String superName;
    private final GlobalStateForInstrumentation instrumentationState;
    private final int methodIID;
    private Integer lastLineNumber = 0;

    public FastCoverageMethodAdapter(MethodVisitor mv, String className, String methodName, String descriptor, String superName, GlobalStateForInstrumentation instrumentationState) {
        super(524288, mv);
        this.isInit = methodName.equals("<init>");
        this.isSuperInitCalled = false;
        this.className = className;
        this.superName = superName;
        this.instrumentationState = instrumentationState;
        this.methodIID = instrumentationState.incAndGetFastCoverageId();
    }

    private static void addBipushInsn(MethodVisitor mv, int val) {
        Utils.addBipushInsn(mv, val);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        int iid = this.instrumentationState.incAndGetFastCoverageId();
        FastCoverageMethodAdapter.addBipushInsn(this.mv, iid);
        this.mv.visitInsn(3);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "LOGJUMP", "(II)V", false);
        if (opcode == 183 && name.equals("<init>")) {
            if (this.isInit && !this.isSuperInitCalled && this.newStack == 0 && (owner.equals(this.className) || owner.equals(this.superName))) {
                this.isSuperInitCalled = true;
            } else if (this.isInit) {
                --this.newStack;
                assert (this.newStack >= 0);
            }
        }
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitCode() {
        super.visitCode();
        FastCoverageMethodAdapter.addBipushInsn(this.mv, this.methodIID);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "LOGMETHODBEGIN", "(I)V", false);
    }

    private void addConditionalJumpInstrumentation(int opcode, Label finalBranchTarget, String instMethodName, String instMethodDesc) {
        int iid = this.instrumentationState.incAndGetFastCoverageId();
        this.instrumentationState.incAndGetFastCoverageId();
        Label intermediateBranchTarget = new Label();
        Label fallthrough = new Label();
        this.mv.visitJumpInsn(opcode, intermediateBranchTarget);
        this.mv.visitJumpInsn(167, fallthrough);
        this.mv.visitLabel(intermediateBranchTarget);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, iid);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, 1);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, instMethodName, instMethodDesc, false);
        this.mv.visitJumpInsn(167, finalBranchTarget);
        this.mv.visitLabel(fallthrough);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, iid);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, 0);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, instMethodName, instMethodDesc, false);
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this.isInit && !this.isSuperInitCalled) {
            throw new RuntimeException("Cannot handle jumps before super/this");
        }
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                this.addConditionalJumpInstrumentation(opcode, label, "LOGJUMP", "(II)V");
                break;
            }
            case 167: 
            case 168: {
                this.mv.visitJumpInsn(opcode, label);
                break;
            }
            default: {
                throw new RuntimeException("Unknown jump opcode " + opcode);
            }
        }
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                FastCoverageMethodAdapter.addBipushInsn(this.mv, this.methodIID);
                this.mv.visitMethodInsn(184, Config.instance.analysisClass, "LOGMETHODEND", "(I)V", false);
            }
        }
        super.visitInsn(opcode);
    }

    public void visitLineNumber(int lineNumber, Label label) {
        this.lastLineNumber = lineNumber;
        this.mv.visitLineNumber(lineNumber, label);
    }

    private int getLabelNum(Label label) {
        return System.identityHashCode(label);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.mv.visitInsn(89);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetFastCoverageId());
        FastCoverageMethodAdapter.addBipushInsn(this.mv, min);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, max);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(dflt));
        for (int i = 0; i < labels.length; ++i) {
            this.instrumentationState.incAndGetFastCoverageId();
        }
        this.instrumentationState.incAndGetFastCoverageId();
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "LOGTABLESWITCH", "(IIIII)V", false);
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.mv.visitInsn(89);
        FastCoverageMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetFastCoverageId());
        FastCoverageMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(dflt));
        FastCoverageMethodAdapter.addBipushInsn(this.mv, keys.length);
        this.mv.visitIntInsn(188, 10);
        for (int i = 0; i < keys.length; ++i) {
            this.mv.visitInsn(89);
            FastCoverageMethodAdapter.addBipushInsn(this.mv, i);
            FastCoverageMethodAdapter.addBipushInsn(this.mv, keys[i]);
            this.mv.visitInsn(79);
            this.instrumentationState.incAndGetFastCoverageId();
        }
        this.instrumentationState.incAndGetFastCoverageId();
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "LOGLOOKUPSWITCH", "(III[I)V", false);
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(0, maxLocals);
    }
}

