/*
 * Decompiled with CFR 0.152.
 */
package janala.instrument;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class SafeClassWriter
extends ClassWriter {
    private final ClassLoader loader;

    public SafeClassWriter(ClassReader cr, ClassLoader loader, int flags) {
        super(cr, flags);
        this.loader = loader != null ? loader : ClassLoader.getSystemClassLoader();
    }

    protected String getCommonSuperClass(String type1, String type2) {
        try {
            String result;
            block7: {
                ClassReader info1 = this.typeInfo(type1);
                ClassReader info2 = this.typeInfo(type2);
                if ((info1.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type2, info2, type1)) {
                        return type1;
                    }
                    return "java/lang/Object";
                }
                if ((info2.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                StringBuilder b1 = this.typeAncestors(type1, info1);
                StringBuilder b2 = this.typeAncestors(type2, info2);
                result = "java/lang/Object";
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(";", end1 - 1);
                    int start2 = b2.lastIndexOf(";", end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block7;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    end1 = start1;
                    end2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return b;
    }

    private boolean typeImplements(String type, ClassReader info, String itf) throws IOException {
        while (!"java/lang/Object".equals(type)) {
            int i;
            String[] itfs = info.getInterfaces();
            for (i = 0; i < itfs.length; ++i) {
                if (!itfs[i].equals(itf)) continue;
                return true;
            }
            for (i = 0; i < itfs.length; ++i) {
                if (!this.typeImplements(itfs[i], this.typeInfo(itfs[i]), itf)) continue;
                return true;
            }
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReader typeInfo(String type) throws IOException {
        String resource = type + ".class";
        InputStream is = this.loader.getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("Cannot create ClassReader for type " + type);
        }
        try {
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
        finally {
            is.close();
        }
    }
}

