/*
 * Decompiled with CFR 0.152.
 */
package janala.instrument;

import janala.instrument.Config;
import janala.instrument.GlobalStateForInstrumentation;
import janala.instrument.TryCatchBlock;
import janala.instrument.Utils;
import java.util.LinkedList;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class SnoopInstructionMethodAdapter
extends MethodVisitor
implements Opcodes {
    boolean isInit;
    boolean isStatic;
    boolean isSuperInitCalled;
    int newStack = 0;
    LinkedList<TryCatchBlock> tryCatchBlocks;
    Label methodBeginLabel = new Label();
    Label methodEndLabel = new Label();
    private final String className;
    private final String methodName;
    private final String descriptor;
    private final String superName;
    private final GlobalStateForInstrumentation instrumentationState;
    private Integer lastLineNumber = 0;

    public SnoopInstructionMethodAdapter(MethodVisitor mv, String className, String methodName, String descriptor, String superName, GlobalStateForInstrumentation instrumentationState, boolean isStatic) {
        super(524288, mv);
        this.isInit = methodName.equals("<init>");
        this.isSuperInitCalled = false;
        this.className = className;
        this.methodName = methodName;
        this.descriptor = descriptor;
        this.superName = superName;
        this.tryCatchBlocks = new LinkedList();
        this.instrumentationState = instrumentationState;
        this.isStatic = isStatic;
    }

    public void visitCode() {
        this.instrumentationState.incMid();
        this.mv.visitLdcInsn((Object)this.className);
        this.mv.visitLdcInsn((Object)this.methodName);
        this.mv.visitLdcInsn((Object)this.descriptor);
        if (this.isInit || this.isStatic) {
            this.mv.visitMethodInsn(184, Config.instance.analysisClass, "METHOD_BEGIN", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
        } else {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, Config.instance.analysisClass, "METHOD_BEGIN", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", false);
        }
        if (!this.isInit) {
            this.mv.visitLabel(this.methodBeginLabel);
        }
        this.mv.visitCode();
    }

    private static void addBipushInsn(MethodVisitor mv, int val) {
        Utils.addBipushInsn(mv, val);
    }

    private void addValueReadInsn(MethodVisitor mv, String desc, String methodNamePrefix) {
        Utils.addValueReadInsn(mv, desc, methodNamePrefix);
    }

    private void addSpecialInsn(MethodVisitor mv, int val) {
        Utils.addSpecialInsn(mv, val);
    }

    private void addInsn(MethodVisitor mv, String insn, int opcode) {
        SnoopInstructionMethodAdapter.addBipushInsn(mv, this.instrumentationState.incAndGetId());
        SnoopInstructionMethodAdapter.addBipushInsn(mv, this.lastLineNumber);
        mv.visitMethodInsn(184, Config.instance.analysisClass, insn, "(II)V", false);
        mv.visitInsn(opcode);
    }

    private void addVarInsn(MethodVisitor mv, int var, String insn, int opcode) {
        SnoopInstructionMethodAdapter.addBipushInsn(mv, this.instrumentationState.incAndGetId());
        SnoopInstructionMethodAdapter.addBipushInsn(mv, this.lastLineNumber);
        SnoopInstructionMethodAdapter.addBipushInsn(mv, var);
        mv.visitMethodInsn(184, Config.instance.analysisClass, insn, "(III)V", false);
        mv.visitVarInsn(opcode, var);
    }

    private void addTypeInsn(MethodVisitor mv, String type, int opcode, String name) {
        SnoopInstructionMethodAdapter.addBipushInsn(mv, this.instrumentationState.incAndGetId());
        SnoopInstructionMethodAdapter.addBipushInsn(mv, this.lastLineNumber);
        mv.visitLdcInsn((Object)type);
        mv.visitMethodInsn(184, Config.instance.analysisClass, name, "(IILjava/lang/String;)V", false);
        mv.visitTypeInsn(opcode, type);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: {
                this.addInsn(this.mv, "IRETURN", opcode);
                break;
            }
            case 173: {
                this.addInsn(this.mv, "LRETURN", opcode);
                break;
            }
            case 174: {
                this.addInsn(this.mv, "FRETURN", opcode);
                break;
            }
            case 175: {
                this.addInsn(this.mv, "DRETURN", opcode);
                break;
            }
            case 176: {
                this.addInsn(this.mv, "ARETURN", opcode);
                break;
            }
            case 177: {
                this.addInsn(this.mv, "RETURN", opcode);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                if (Config.instance.instrumentHeapLoad) {
                    this.mv.visitInsn(92);
                    SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
                    SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
                    this.mv.visitMethodInsn(184, Config.instance.analysisClass, "HEAPLOAD2", "(Ljava/lang/Object;III)V", false);
                }
                this.mv.visitInsn(opcode);
                break;
            }
            default: {
                this.mv.visitInsn(opcode);
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        switch (opcode) {
            case 188: {
                if (!Config.instance.instrumentAlloc) break;
                this.addValueReadInsn(this.mv, "I", "GETVALUE_");
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
                this.mv.visitMethodInsn(184, Config.instance.analysisClass, "NEWARRAY", "(II)V", false);
                break;
            }
        }
        this.mv.visitIntInsn(opcode, operand);
    }

    public void visitTypeInsn(int opcode, String type) {
        switch (opcode) {
            case 187: {
                if (Config.instance.instrumentAlloc) {
                    SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
                    SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
                    this.mv.visitLdcInsn((Object)type);
                    this.mv.visitMethodInsn(184, Config.instance.analysisClass, "NEW", "(IILjava/lang/String;)V", false);
                }
                if (!this.isInit) break;
                ++this.newStack;
                break;
            }
            case 189: {
                if (!Config.instance.instrumentAlloc) break;
                this.addValueReadInsn(this.mv, "I", "GETVALUE_");
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
                this.mv.visitLdcInsn((Object)type);
                this.mv.visitMethodInsn(184, Config.instance.analysisClass, "ANEWARRAY", "(IILjava/lang/String;)V", false);
                break;
            }
        }
        this.mv.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 180 && Config.instance.instrumentHeapLoad) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)(owner + "#" + name));
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
            this.mv.visitMethodInsn(184, Config.instance.analysisClass, "HEAPLOAD1", "(Ljava/lang/Object;Ljava/lang/String;II)V", false);
        }
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    private String getMethodName(int opcode) {
        switch (opcode) {
            case 183: {
                return "INVOKESPECIAL";
            }
            case 184: {
                return "INVOKESTATIC";
            }
            case 185: {
                return "INVOKEINTERFACE";
            }
            case 182: {
                return "INVOKEVIRTUAL";
            }
        }
        throw new RuntimeException("Unknown opcode for method");
    }

    private void addMethodWithTryCatch(int opcode, String owner, String name, String desc, boolean itf) {
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
        this.mv.visitLdcInsn((Object)owner);
        this.mv.visitLdcInsn((Object)name);
        this.mv.visitLdcInsn((Object)desc);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, this.getMethodName(opcode), "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
        Label begin = new Label();
        Label handler = new Label();
        Label end = new Label();
        this.tryCatchBlocks.addFirst(new TryCatchBlock(begin, handler, handler, null));
        this.mv.visitLabel(begin);
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        this.mv.visitJumpInsn(167, end);
        this.mv.visitLabel(handler);
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "INVOKEMETHOD_EXCEPTION", "(Ljava/lang/Throwable;)V", false);
        if (this.isInit && !this.isSuperInitCalled) {
            this.mv.visitMethodInsn(184, Config.instance.analysisClass, "METHOD_THROW", "()V", false);
        }
        this.mv.visitInsn(191);
        this.mv.visitLabel(end);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "INVOKEMETHOD_END", "()V", false);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 183 && name.equals("<init>")) {
            if (this.isInit && !this.isSuperInitCalled && this.newStack == 0 && (owner.equals(this.className) || owner.equals(this.superName))) {
                this.isSuperInitCalled = true;
                this.addSpecialInsn(this.mv, 2);
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
                this.mv.visitLdcInsn((Object)owner);
                this.mv.visitLdcInsn((Object)name);
                this.mv.visitLdcInsn((Object)desc);
                this.mv.visitMethodInsn(184, Config.instance.analysisClass, this.getMethodName(opcode), "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
                this.mv.visitMethodInsn(184, Config.instance.analysisClass, "INVOKEMETHOD_END", "()V", false);
                if (owner.equals("java/lang/Thread")) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitMethodInsn(184, Config.instance.analysisClass, "REGISTER_THREAD", "(Ljava/lang/Thread;)V", false);
                }
                this.mv.visitLabel(this.methodBeginLabel);
            } else {
                this.addMethodWithTryCatch(opcode, owner, name, desc, itf);
                if (this.isInit) {
                    --this.newStack;
                    assert (this.newStack >= 0);
                }
                if (owner.equals("java/lang/Thread")) {
                    this.mv.visitInsn(89);
                    this.mv.visitMethodInsn(184, Config.instance.analysisClass, "REGISTER_THREAD", "(Ljava/lang/Thread;)V", false);
                }
            }
        } else {
            if (Config.instance.instrumentHeapLoad && (name.equals("charAt") || name.equals("codePointAt")) && (owner.equals("java/lang/String") || owner.equals("java/lang/CharSequence"))) {
                this.mv.visitInsn(92);
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
                SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
                this.mv.visitMethodInsn(184, Config.instance.analysisClass, "HEAPLOAD2", "(Ljava/lang/Object;III)V", false);
            }
            this.addMethodWithTryCatch(opcode, owner, name, desc, itf);
        }
    }

    private void addConditionalJumpInstrumentation(int opcode, Label finalBranchTarget, String instMethodName, String instMethodDesc) {
        int iid = this.instrumentationState.incAndGetId();
        Label intermediateBranchTarget = new Label();
        Label fallthrough = new Label();
        this.mv.visitJumpInsn(opcode, intermediateBranchTarget);
        this.mv.visitJumpInsn(167, fallthrough);
        this.mv.visitLabel(intermediateBranchTarget);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, 1);
        this.addValueReadInsn(this.mv, "Z", "GETVALUE_");
        this.mv.visitInsn(87);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, iid);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(finalBranchTarget));
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, instMethodName, instMethodDesc, false);
        this.mv.visitJumpInsn(167, finalBranchTarget);
        this.mv.visitLabel(fallthrough);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, 0);
        this.addValueReadInsn(this.mv, "Z", "GETVALUE_");
        this.mv.visitInsn(87);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, iid);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(finalBranchTarget));
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, instMethodName, instMethodDesc, false);
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this.isInit && !this.isSuperInitCalled) {
            throw new RuntimeException("Cannot handle jumps before super/this");
        }
        switch (opcode) {
            case 153: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFEQ", "(III)V");
                break;
            }
            case 154: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFNE", "(III)V");
                break;
            }
            case 155: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFLT", "(III)V");
                break;
            }
            case 156: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFGE", "(III)V");
                break;
            }
            case 157: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFGT", "(III)V");
                break;
            }
            case 158: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFLE", "(III)V");
                break;
            }
            case 159: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ICMPEQ", "(III)V");
                break;
            }
            case 160: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ICMPNE", "(III)V");
                break;
            }
            case 161: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ICMPLT", "(III)V");
                break;
            }
            case 162: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ICMPGE", "(III)V");
                break;
            }
            case 163: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ICMPGT", "(III)V");
                break;
            }
            case 164: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ICMPLE", "(III)V");
                break;
            }
            case 165: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ACMPEQ", "(III)V");
                break;
            }
            case 166: {
                this.addConditionalJumpInstrumentation(opcode, label, "IF_ACMPNE", "(III)V");
                break;
            }
            case 167: {
                this.mv.visitJumpInsn(opcode, label);
                break;
            }
            case 168: {
                this.mv.visitJumpInsn(opcode, label);
                break;
            }
            case 198: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFNULL", "(III)V");
                break;
            }
            case 199: {
                this.addConditionalJumpInstrumentation(opcode, label, "IFNONNULL", "(III)V");
                break;
            }
            default: {
                throw new RuntimeException("Unknown jump opcode " + opcode);
            }
        }
    }

    public void visitLineNumber(int lineNumber, Label label) {
        this.lastLineNumber = lineNumber;
        super.visitLineNumber(lineNumber, label);
    }

    private int getLabelNum(Label label) {
        return System.identityHashCode(label);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.addValueReadInsn(this.mv, "I", "GETVALUE_");
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, min);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, max);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(dflt));
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, labels.length);
        this.mv.visitIntInsn(188, 10);
        for (int i = 0; i < labels.length; ++i) {
            this.mv.visitInsn(89);
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, i);
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(labels[i]));
            this.mv.visitInsn(79);
        }
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "TABLESWITCH", "(IIIII[I)V", false);
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        int i;
        this.addValueReadInsn(this.mv, "I", "GETVALUE_");
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.instrumentationState.incAndGetId());
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.lastLineNumber);
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(dflt));
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, keys.length);
        this.mv.visitIntInsn(188, 10);
        for (i = 0; i < keys.length; ++i) {
            this.mv.visitInsn(89);
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, i);
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, keys[i]);
            this.mv.visitInsn(79);
        }
        SnoopInstructionMethodAdapter.addBipushInsn(this.mv, labels.length);
        this.mv.visitIntInsn(188, 10);
        for (i = 0; i < labels.length; ++i) {
            this.mv.visitInsn(89);
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, i);
            SnoopInstructionMethodAdapter.addBipushInsn(this.mv, this.getLabelNum(labels[i]));
            this.mv.visitInsn(79);
        }
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "LOOKUPSWITCH", "(III[I[I)V", false);
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.tryCatchBlocks.addLast(new TryCatchBlock(this.methodBeginLabel, this.methodEndLabel, this.methodEndLabel, null));
        this.mv.visitLabel(this.methodEndLabel);
        this.mv.visitMethodInsn(184, Config.instance.analysisClass, "METHOD_THROW", "()V", false);
        this.mv.visitInsn(191);
        for (TryCatchBlock b : this.tryCatchBlocks) {
            b.visit(this.mv);
        }
        this.mv.visitMaxs(maxStack + 8, maxLocals);
    }

    public void visitTryCatchBlock(Label label, Label label1, Label label2, String s) {
        this.tryCatchBlocks.addLast(new TryCatchBlock(label, label1, label2, s));
    }
}

