/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.plugin;

import edu.berkeley.cs.jqf.fuzz.ei.ExecutionIndexingGuidance;
import edu.berkeley.cs.jqf.fuzz.ei.ZestGuidance;
import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import edu.berkeley.cs.jqf.instrument.InstrumentingClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Random;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

@Mojo(name="fuzz", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VERIFY)
public class FuzzGoal
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="target", defaultValue="${project.build.directory}", readonly=true)
    private File target;
    @Parameter(property="class", required=true)
    private String testClassName;
    @Parameter(property="method", required=true)
    private String testMethod;
    @Parameter(property="excludes")
    private String excludes;
    @Parameter(property="includes")
    private String includes;
    @Parameter(property="time")
    private String time;
    @Parameter(property="trials")
    private Long trials;
    @Parameter(property="randomSeed")
    private Long randomSeed;
    @Parameter(property="blind")
    private boolean blind;
    @Parameter(property="engine", defaultValue="zest")
    private String engine;
    @Parameter(property="noCov")
    private boolean disableCoverage;
    @Parameter(property="in")
    private String inputDirectory;
    @Parameter(property="out")
    private String outputDirectory;
    @Parameter(property="saveAll")
    private boolean saveAll;
    @Parameter(property="libFuzzerCompatOutput")
    private String libFuzzerCompatOutput;
    @Parameter(property="quiet")
    private boolean quiet;
    @Parameter(property="exitOnCrash")
    private String exitOnCrash;
    @Parameter(property="runTimeout")
    private int runTimeout;
    @Parameter(property="fixedSize")
    private boolean fixedSizeInputs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Result result;
        ZestGuidance guidance;
        Object loader;
        PrintStream out;
        Log log = this.getLog();
        PrintStream printStream = out = log.isDebugEnabled() ? System.out : null;
        if (this.excludes != null) {
            System.setProperty("janala.excludes", this.excludes);
        }
        if (this.includes != null) {
            System.setProperty("janala.includes", this.includes);
        }
        if (this.saveAll) {
            System.setProperty("jqf.ei.SAVE_ALL_INPUTS", "true");
        }
        if (this.libFuzzerCompatOutput != null) {
            System.setProperty("jqf.ei.LIBFUZZER_COMPAT_OUTPUT", this.libFuzzerCompatOutput);
        }
        if (this.quiet) {
            System.setProperty("jqf.ei.QUIET_MODE", "true");
        }
        if (this.exitOnCrash != null) {
            System.setProperty("jqf.ei.EXIT_ON_CRASH", this.exitOnCrash);
        }
        if (this.runTimeout > 0) {
            System.setProperty("jqf.ei.TIMEOUT", String.valueOf(this.runTimeout));
        }
        if (this.fixedSizeInputs) {
            System.setProperty("jqf.ei.GENERATE_EOF_WHEN_OUT", String.valueOf(true));
        }
        Duration duration = null;
        if (this.time != null && !this.time.isEmpty()) {
            try {
                duration = Duration.parse("PT" + this.time);
            }
            catch (DateTimeParseException e) {
                throw new MojoExecutionException("Invalid time duration: " + this.time);
            }
        }
        if (this.outputDirectory == null || this.outputDirectory.isEmpty()) {
            this.outputDirectory = "fuzz-results" + File.separator + this.testClassName + File.separator + this.testMethod;
        }
        try {
            List classpathElements = this.project.getTestClasspathElements();
            loader = this.disableCoverage ? new URLClassLoader(InstrumentingClassLoader.stringsToUrls((String[])classpathElements.toArray(new String[0])), ((Object)((Object)this)).getClass().getClassLoader()) : new InstrumentingClassLoader(classpathElements.toArray(new String[0]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get project classpath", (Exception)e);
        }
        File resultsDir = new File(this.target, this.outputDirectory);
        String targetName = this.testClassName + "#" + this.testMethod;
        File seedsDir = this.inputDirectory == null ? null : new File(this.inputDirectory);
        Random rnd = this.randomSeed != null ? new Random(this.randomSeed) : new Random();
        try {
            switch (this.engine) {
                case "zest": {
                    guidance = new ZestGuidance(targetName, duration, this.trials, resultsDir, seedsDir, rnd);
                    break;
                }
                case "zeal": {
                    System.setProperty("jqf.tracing.TRACE_GENERATORS", "true");
                    System.setProperty("jqf.tracing.MATCH_CALLEE_NAMES", "true");
                    guidance = new ExecutionIndexingGuidance(targetName, duration, this.trials, resultsDir, seedsDir, rnd);
                    break;
                }
                default: {
                    throw new MojoExecutionException("Unknown fuzzing engine: " + this.engine);
                }
            }
            guidance.setBlind(this.blind);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error", (Exception)e);
        }
        try {
            result = GuidedFuzzing.run((String)this.testClassName, (String)this.testMethod, (ClassLoader)loader, (Guidance)guidance, (PrintStream)out);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load test class", (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Bad request", (Exception)e);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Internal error", (Exception)e);
        }
        if (!result.wasSuccessful()) {
            Throwable e = ((Failure)result.getFailures().get(0)).getException();
            if (result.getFailureCount() == 1 && e instanceof GuidanceException) {
                throw new MojoExecutionException("Internal error", e);
            }
            throw new MojoFailureException(String.format("Fuzzing resulted in the test failing on %d input(s). Possible bugs found. Use mvn jqf:repro to reproduce failing test cases from %s/failures. ", result.getFailureCount(), resultsDir) + "Sample exception included with this message.", e);
        }
    }
}

