/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.MapFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryCounterTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<BinaryRule, double[][][]> entries;
    short[] numSubStates;
    BinaryRule searchKey;

    public Set<BinaryRule> keySet() {
        return this.entries.keySet();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(BinaryRule key) {
        return this.entries.containsKey(key);
    }

    public double[][][] getCount(BinaryRule key) {
        double[][][] value = this.entries.get(key);
        return value;
    }

    public double[][][] getCount(short pState, short lState, short rState) {
        this.searchKey.setNodes(pState, lState, rState);
        double[][][] value = this.entries.get(this.searchKey);
        return value;
    }

    public void setCount(BinaryRule key, double[][][] counts) {
        this.entries.put(key, counts);
    }

    public void incrementCount(BinaryRule key, double[][][] increment) {
        double[][][] current = this.getCount(key);
        if (current == null) {
            this.setCount(key, increment);
            return;
        }
        for (int i = 0; i < current.length; ++i) {
            for (int j = 0; j < current[i].length; ++j) {
                if (increment[i][j] == null) continue;
                if (current[i][j] == null) {
                    current[i][j] = new double[increment[i][j].length];
                }
                for (int k = 0; k < current[i][j].length; ++k) {
                    double[] dArray = current[i][j];
                    int n = k;
                    dArray[n] = dArray[n] + increment[i][j][k];
                }
            }
        }
        this.setCount(key, current);
    }

    public void incrementCount(BinaryRule key, double increment) {
        double[][][] current = this.getCount(key);
        if (current == null) {
            double[][][] tmp = key.getScores2();
            current = new double[tmp.length][tmp[0].length][tmp[0][0].length];
            ArrayUtil.fill(current, increment);
            this.setCount(key, current);
            return;
        }
        for (int i = 0; i < current.length; ++i) {
            for (int j = 0; j < current[i].length; ++j) {
                if (current[i][j] == null) {
                    current[i][j] = new double[this.numSubStates[key.getParentState()]];
                }
                int k = 0;
                while (k < current[i][j].length) {
                    double[] dArray = current[i][j];
                    int n = k++;
                    dArray[n] = dArray[n] + increment;
                }
            }
        }
        this.setCount(key, current);
    }

    public BinaryCounterTable(short[] numSubStates) {
        this(new MapFactory.HashMapFactory<BinaryRule, double[][][]>(), numSubStates);
    }

    public BinaryCounterTable(MapFactory<BinaryRule, double[][][]> mf, short[] numSubStates) {
        this.entries = mf.buildMap();
        this.searchKey = new BinaryRule(0, 0, 0);
        this.numSubStates = numSubStates;
    }

    public static void main(String[] args) {
        Counter<String> counter = new Counter<String>();
        System.out.println(counter);
        counter.incrementCount("planets", 7.0);
        System.out.println(counter);
        counter.incrementCount("planets", 1.0);
        System.out.println(counter);
        counter.setCount("suns", 1.0);
        System.out.println(counter);
        counter.setCount("aliens", 0.0);
        System.out.println(counter);
        System.out.println(counter.toString(2));
        System.out.println("Total: " + counter.totalCount());
    }
}

