/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ScalingTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseToFineMaxRuleDerivationParser
extends CoarseToFineMaxRuleParser {
    protected double[][][][] maxcScore;
    protected double[][][][] maxsScore;
    protected int[][][][] maxcSplit;
    protected int[][][][] maxcChild;
    protected int[][][][] maxcChildSub;
    protected int[][][][] maxcLeftChild;
    protected int[][][][] maxcRightChild;
    protected int[][][][] maxcLeftChildSub;
    protected int[][][][] maxcRightChildSub;

    public CoarseToFineMaxRuleDerivationParser(Grammar gr, Lexicon lex, double unaryPenalty, int endL, boolean viterbi, boolean sub, boolean score, boolean accurate, boolean variational, boolean useGoldPOS, boolean initializeCascade) {
        super(gr, lex, unaryPenalty, endL, viterbi, sub, score, accurate, variational, useGoldPOS, initializeCascade);
    }

    @Override
    void doConstrainedMaxCScores(List<String> sentence, Grammar grammar, Lexicon lexicon, boolean scale) {
        this.numSubStatesArray = grammar.numSubStates;
        this.maxcScore = new double[this.length][this.length + 1][this.numStates][];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates][];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates][];
        this.maxcChildSub = new int[this.length][this.length + 1][this.numStates][];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates][];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates][];
        this.maxcLeftChildSub = new int[this.length][this.length + 1][this.numStates][];
        this.maxcRightChildSub = new int[this.length][this.length + 1][this.numStates][];
        double initVal = Double.NEGATIVE_INFINITY;
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                for (int state = 0; state < this.numSubStatesArray.length; ++state) {
                    if (!this.allowedStates[start][end][state]) continue;
                    this.maxcSplit[start][end][state] = new int[this.numSubStatesArray[state]];
                    this.maxcChild[start][end][state] = new int[this.numSubStatesArray[state]];
                    this.maxcChildSub[start][end][state] = new int[this.numSubStatesArray[state]];
                    this.maxcLeftChild[start][end][state] = new int[this.numSubStatesArray[state]];
                    this.maxcRightChild[start][end][state] = new int[this.numSubStatesArray[state]];
                    this.maxcLeftChildSub[start][end][state] = new int[this.numSubStatesArray[state]];
                    this.maxcRightChildSub[start][end][state] = new int[this.numSubStatesArray[state]];
                    this.maxcScore[start][end][state] = new double[this.numSubStatesArray[state]];
                    Arrays.fill(this.maxcSplit[start][end][state], -1);
                    Arrays.fill(this.maxcChild[start][end][state], -1);
                    Arrays.fill(this.maxcChildSub[start][end][state], -1);
                    Arrays.fill(this.maxcLeftChild[start][end][state], -1);
                    Arrays.fill(this.maxcRightChild[start][end][state], -1);
                    Arrays.fill(this.maxcLeftChildSub[start][end][state], -1);
                    Arrays.fill(this.maxcRightChildSub[start][end][state], -1);
                    Arrays.fill(this.maxcScore[start][end][state], initVal);
                }
            }
        }
        double logNormalizer = this.iScore[0][this.length][0][0];
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                if (diff > 1) {
                    for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                        if (!this.allowedStates[start][end][pState]) continue;
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        int nParentStates = this.numSubStatesArray[pState];
                        for (int i = 0; i < parentRules.length; ++i) {
                            int max;
                            int min;
                            boolean iPossibleR;
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (!iPossibleL) continue;
                            int narrowL = this.narrowLExtent[end][rState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (!iPossibleR) continue;
                            int min1 = narrowR;
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (min > narrowL) continue;
                            int max1 = this.wideRExtent[start][lState];
                            int max2 = narrowL;
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (min > max) continue;
                            double[][][] scores = r.getScores2();
                            int nLeftChildStates = this.numSubStatesArray[lState];
                            int nRightChildStates = this.numSubStatesArray[rState];
                            for (int split = min; split <= max; ++split) {
                                double ruleScore = 0.0;
                                if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                                double scalingFactor = 0.0;
                                if (scale) {
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - this.iScale[0][this.length][0]));
                                }
                                for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                    double lIS = this.iScore[start][split][lState][lp];
                                    if (lIS == 0.0) continue;
                                    for (int rp = 0; rp < nRightChildStates; ++rp) {
                                        double rIS;
                                        if (scores[lp][rp] == null || (rIS = this.iScore[split][end][rState][rp]) == 0.0) continue;
                                        double leftChildScore = this.maxcScore[start][split][lState][lp];
                                        double rightChildScore = this.maxcScore[split][end][rState][rp];
                                        if (leftChildScore == initVal || rightChildScore == initVal) continue;
                                        double gScore = leftChildScore + scalingFactor + rightChildScore;
                                        for (int np = 0; np < nParentStates; ++np) {
                                            double ruleS;
                                            double scoreToBeat;
                                            double pOS = this.oScore[start][end][pState][np];
                                            if (pOS == 0.0 || gScore < (scoreToBeat = this.maxcScore[start][end][pState][np]) || (ruleS = scores[lp][rp][np]) == 0.0 || (ruleScore = pOS * ruleS * lIS * rIS / logNormalizer) == 0.0) continue;
                                            if (this.doVariational) {
                                                ruleScore /= this.oScore[start][end][pState][np] / logNormalizer * this.iScore[start][end][pState][np];
                                            }
                                            if (!((ruleScore = gScore + Math.log(ruleScore)) > scoreToBeat)) continue;
                                            this.maxcScore[start][end][pState][np] = ruleScore;
                                            this.maxcSplit[start][end][pState][np] = split;
                                            this.maxcLeftChild[start][end][pState][np] = lState;
                                            this.maxcRightChild[start][end][pState][np] = rState;
                                            this.maxcLeftChildSub[start][end][pState][np] = lp;
                                            this.maxcRightChildSub[start][end][pState][np] = rp;
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    for (int tag = 0; tag < this.numSubStatesArray.length; ++tag) {
                        if (!this.allowedStates[start][end][tag]) continue;
                        int nTagStates = this.numSubStatesArray[tag];
                        String word = sentence.get(start);
                        if (grammar.isGrammarTag(tag)) continue;
                        double[] lexiconScoreArray = lexicon.score(word, (short)tag, start, false, false);
                        double lexiconScores = 0.0;
                        for (int tp = 0; tp < nTagStates; ++tp) {
                            double pOS = this.oScore[start][end][tag][tp];
                            double ruleS = lexiconScoreArray[tp];
                            lexiconScores = pOS * ruleS / logNormalizer;
                            double scalingFactor = 0.0;
                            if (this.doVariational) {
                                lexiconScores = 1.0;
                            } else if (scale) {
                                scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][tag] - this.iScale[0][this.length][0]));
                            }
                            this.maxcScore[start][end][tag][tp] = Math.log(lexiconScores) + scalingFactor;
                        }
                    }
                }
                double[][] maxcScoreStartEnd = new double[this.numStates][];
                for (int i = 0; i < this.numStates; ++i) {
                    if (!this.allowedStates[start][end][i]) continue;
                    maxcScoreStartEnd[i] = new double[this.numSubStatesArray[i]];
                    for (int j = 0; j < this.numSubStatesArray[i]; ++j) {
                        maxcScoreStartEnd[i][j] = this.maxcScore[start][end][i][j];
                    }
                }
                double[][] ruleScores = null;
                if (this.doVariational) {
                    ruleScores = new double[this.numStates][this.numStates];
                }
                boolean foundOne = false;
                for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (!this.allowedStates[start][end][pState]) continue;
                    int nParentStates = this.numSubStatesArray[pState];
                    UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                    if (this.doVariational) {
                        unaries = grammar.getUnaryRulesByParent(pState).toArray(new UnaryRule[0]);
                    }
                    for (int r = 0; r < unaries.length; ++r) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.iScore[start][end][cState] == null) continue;
                        double scalingFactor = 0.0;
                        if (scale) {
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - this.iScale[0][this.length][0]));
                        }
                        double[][] scores = ur.getScores2();
                        int nChildStates = this.numSubStatesArray[cState];
                        double ruleScore = 0.0;
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double childScore;
                            double cIS = this.iScore[start][end][cState][cp];
                            if (cIS == 0.0 || (childScore = this.maxcScore[start][end][cState][cp]) == initVal || scores[cp] == null) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double ruleS;
                                double gScore;
                                double pOS = this.oScore[start][end][pState][np];
                                if (pOS < 0.0 || (gScore = scalingFactor + childScore) < maxcScoreStartEnd[pState][np] || (ruleS = scores[cp][np]) == 0.0) continue;
                                ruleScore = pOS * ruleS * cIS / logNormalizer;
                                foundOne = true;
                                if (ruleScore == 0.0) continue;
                                if (this.doVariational) {
                                    ruleScore /= this.oScore[start][end][pState][np] / logNormalizer * this.iScore[start][end][pState][np];
                                }
                                if (!((ruleScore = gScore + Math.log(ruleScore)) > maxcScoreStartEnd[pState][np])) continue;
                                maxcScoreStartEnd[pState][np] = ruleScore;
                                this.maxcChild[start][end][pState][np] = cState;
                                this.maxcChildSub[start][end][pState][np] = cp;
                            }
                        }
                    }
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
            }
        }
    }

    @Override
    public Tree<String> extractBestMaxRuleParse(int start, int end, List<String> sentence) {
        return this.extractBestMaxRuleParse1(start, end, 0, 0, sentence);
    }

    public Tree<String> extractBestMaxRuleParse1(int start, int end, int state, int substate, List<String> sentence) {
        int cState = this.maxcChild[start][end][state][substate];
        int cSubState = this.maxcChildSub[start][end][state][substate];
        if (cState == -1) {
            return this.extractBestMaxRuleParse2(start, end, state, substate, sentence);
        }
        ArrayList child = new ArrayList();
        child.add(this.extractBestMaxRuleParse2(start, end, cState, cSubState, sentence));
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        ++this.totalUsedUnaries;
        int intermediateNode = this.grammar.getUnaryIntermediate((short)state, (short)cState);
        if (intermediateNode > 0) {
            ArrayList restoredChild = new ArrayList();
            ++this.nTimesRestoredUnaries;
            String stateStr2 = (String)this.tagNumberer.object(intermediateNode);
            if (stateStr2.endsWith("^g")) {
                stateStr2 = stateStr2.substring(0, stateStr2.length() - 2);
            }
            restoredChild.add(new Tree<String>(stateStr2, child));
            return new Tree<String>(stateStr, restoredChild);
        }
        return new Tree<String>(stateStr, child);
    }

    public Tree<String> extractBestMaxRuleParse2(int start, int end, int state, int substate, List<String> sentence) {
        boolean posLevel;
        ArrayList children = new ArrayList();
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        boolean bl = posLevel = end - start == 1;
        if (posLevel) {
            if (this.grammar.isGrammarTag(state)) {
                ArrayList childs = new ArrayList();
                childs.add(new Tree<String>(sentence.get(start)));
                String stateStr2 = (String)this.tagNumberer.object(this.maxcChild[start][end][state][substate]);
                children.add(new Tree<String>(stateStr2, childs));
            } else {
                children.add(new Tree<String>(sentence.get(start)));
            }
        } else {
            int split = this.maxcSplit[start][end][state][substate];
            if (split == -1) {
                System.err.println("Warning: no symbol can generate the span from " + start + " to " + end + ".");
                System.err.println("The score is " + this.maxcScore[start][end][state] + " and the state is supposed to be " + stateStr);
                System.err.println("The insideScores are " + Arrays.toString(this.iScore[start][end][state]) + " and the outsideScores are " + Arrays.toString(this.oScore[start][end][state]));
                System.err.println("The maxcScore is " + this.maxcScore[start][end][state]);
                return new Tree<String>("ROOT");
            }
            int lState = this.maxcLeftChild[start][end][state][substate];
            int lSubState = this.maxcLeftChildSub[start][end][state][substate];
            int rState = this.maxcRightChild[start][end][state][substate];
            int rSubState = this.maxcRightChildSub[start][end][state][substate];
            Tree<String> leftChildTree = this.extractBestMaxRuleParse1(start, split, lState, lSubState, sentence);
            Tree<String> rightChildTree = this.extractBestMaxRuleParse1(split, end, rState, rSubState, sentence);
            children.add(leftChildTree);
            children.add(rightChildTree);
        }
        return new Tree<String>(stateStr, children);
    }
}

