/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Posterior;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseToFineMaxRuleProductParser
extends CoarseToFineMaxRuleParser {
    boolean[][][][] allowedSubStates;
    boolean[][][] allowedStates;
    boolean[][] vAllowedStates;
    double[][] spanMass;
    Grammar[][] grammarCascade;
    Lexicon[][] lexiconCascade;
    int[][][][] lChildMap;
    int[][][][] rChildMap;
    int startLevel;
    int endLevel;
    double[] maxThresholds;
    double logLikelihood;
    Tree<String> bestTree;
    boolean isBaseline;
    protected final boolean doVariational;
    protected double[][][] viScore;
    protected double[][][] voScore;
    protected double savedScore;
    protected double[][][] maxcScore;
    protected double[][][] maxsScore;
    protected int[][][] maxcSplit;
    protected int[][][] maxcChild;
    protected int[][][] maxcLeftChild;
    protected int[][][] maxcRightChild;
    protected double unaryPenalty;
    int nLevels;
    final boolean[] grammarTags;
    final boolean viterbiParse;
    final boolean outputSub;
    final boolean outputScore;
    Numberer wordNumberer = Numberer.getGlobalNumberer("words");
    final boolean accurate;
    final boolean useGoldPOS;
    double[] unscaledScoresToAdd;
    ArrayParser llParser;
    List<Posterior> posteriorsToDump;
    int nGrammars;
    protected short[][] numSubStates;
    List<double[][][][]> all_iScores;
    List<double[][][][]> all_oScores;
    List<int[][][]> all_iScales;
    List<int[][][]> all_oScales;
    Grammar[] grammars;
    Lexicon[] lexicons;
    int level;
    int nThBlock = 0;

    public CoarseToFineMaxRuleProductParser(Grammar[] gr, Lexicon[] lex, double unaryPenalty, int endL, boolean viterbi, boolean sub, boolean score, boolean accurate, boolean variational, boolean useGoldPOS, boolean initializeCascade) {
        this.nGrammars = gr.length;
        this.unaryPenalty = unaryPenalty;
        this.accurate = accurate;
        this.viterbiParse = viterbi;
        this.outputScore = score;
        this.outputSub = sub;
        this.doVariational = variational;
        this.useGoldPOS = useGoldPOS;
        this.totalUsedUnaries = 0L;
        this.nTimesRestoredUnaries = 0;
        this.nRules = 0L;
        this.nRulesInf = 0L;
        this.tagNumberer = Numberer.getGlobalNumberer("tags");
        this.numStates = gr[0].numStates;
        this.maxNSubStates = this.maxSubStates(gr);
        this.idxC = new int[this.maxNSubStates];
        this.scoresToAdd = new double[this.maxNSubStates];
        this.unscaledScoresToAdd = new double[this.maxNSubStates];
        this.grammarTags = new boolean[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            this.grammarTags[i] = gr[0].isGrammarTag(i);
        }
        this.grammarTags[0] = true;
        this.nLevels = (int)Math.ceil(Math.log(ArrayUtil.max(gr[0].numSubStates)) / Math.log(2.0));
        this.grammarCascade = new Grammar[this.nGrammars][this.nLevels + 3];
        this.lexiconCascade = new Lexicon[this.nGrammars][this.nLevels + 3];
        this.maxThresholds = new double[this.nLevels + 3];
        this.lChildMap = new int[this.nGrammars][this.nLevels][][];
        this.rChildMap = new int[this.nGrammars][this.nLevels][][];
        this.startLevel = -1;
        this.endLevel = endL;
        if (this.endLevel == -1) {
            this.endLevel = this.nLevels;
        }
        boolean bl = this.isBaseline = this.endLevel == 0;
        if (initializeCascade) {
            this.grammars = new Grammar[this.nGrammars];
            this.lexicons = new Lexicon[this.nGrammars];
            this.numSubStates = new short[this.nGrammars][];
            for (int nGr = 0; nGr < this.nGrammars; ++nGr) {
                this.grammars[nGr] = gr[nGr];
                this.lexicons[nGr] = lex[nGr];
                this.numSubStates[nGr] = gr[nGr].numSubStates;
                if (this.grammars[nGr].numStates != this.numStates) {
                    System.out.println("Grammars are not compatible!");
                    System.out.println("numStates don't match");
                    System.exit(-1);
                }
                this.initCascade(gr[nGr], lex[nGr], nGr);
            }
        }
    }

    public int maxSubStates(Grammar[] grammars) {
        short max = 0;
        for (int g = 0; g < grammars.length; ++g) {
            for (int i = 0; i < this.numStates; ++i) {
                if (grammars[g].numSubStates[i] <= max) continue;
                max = grammars[g].numSubStates[i];
            }
        }
        return max;
    }

    public void initCascade(CoarseToFineMaxRuleProductParser otherParser) {
        this.lChildMap = otherParser.lChildMap;
        this.rChildMap = otherParser.rChildMap;
        this.grammarCascade = otherParser.grammarCascade;
        this.lexiconCascade = otherParser.lexiconCascade;
        this.binarization = otherParser.binarization;
    }

    public void initCascade(Grammar gr, Lexicon lex, int nGr) {
        for (int level = this.startLevel; level <= this.endLevel + 1; ++level) {
            if (level == -1) continue;
            Grammar tmpGrammar = null;
            Lexicon tmpLexicon = null;
            if (level == this.endLevel) {
                tmpGrammar = gr.copyGrammar(false);
                tmpLexicon = lex.copyLexicon();
            } else if (level > this.endLevel) {
                tmpGrammar = gr;
                tmpLexicon = lex;
            } else {
                int[][] fromMapping = gr.computeMapping(1);
                int[][] toSubstateMapping = gr.computeSubstateMapping(level);
                int[][] toMapping = gr.computeToMapping(level, toSubstateMapping);
                int[][] curLChildMap = new int[toSubstateMapping.length][];
                int[][] curRChildMap = new int[toSubstateMapping.length][];
                double[] condProbs = gr.computeConditionalProbabilities(fromMapping, toMapping);
                tmpGrammar = level == -1 ? gr.projectTo0LevelGrammar(condProbs, fromMapping, toMapping) : gr.projectGrammar(condProbs, fromMapping, toSubstateMapping);
                tmpLexicon = lex.projectLexicon(condProbs, fromMapping, toSubstateMapping);
                if (level > 0) {
                    this.lChildMap[nGr][level + this.startLevel] = curLChildMap;
                    this.rChildMap[nGr][level + this.startLevel] = curRChildMap;
                    gr.computeReverseSubstateMapping(level, curLChildMap, curRChildMap);
                }
            }
            tmpGrammar.splitRules();
            double filter = 1.0E-4;
            double exponent = 0.9;
            if (level >= 0 && level < this.endLevel) {
                tmpGrammar.removeUnlikelyRules(filter, exponent);
                tmpLexicon.removeUnlikelyTags(filter, exponent);
            } else if (level >= this.endLevel) {
                tmpGrammar.removeUnlikelyRules(1.0E-10, 1.0);
                tmpLexicon.removeUnlikelyTags(1.0E-10, 1.0);
            }
            if (level <= this.endLevel || this.viterbiParse) {
                tmpGrammar.logarithmMode();
                tmpLexicon.logarithmMode();
            }
            this.grammarCascade[nGr][level - this.startLevel] = tmpGrammar;
            this.lexiconCascade[nGr][level - this.startLevel] = tmpLexicon;
        }
    }

    @Override
    void doConstrainedInsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        if (!viterbi && logScores) {
            throw new Error("This would require logAdds and is slow. Exponentiate the scores instead.");
        }
        short[] numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int pState;
                int np;
                int end = start + diff;
                for (int pState2 = 0; pState2 < this.numStates; ++pState2) {
                    if (diff == 1 || !this.allowedStates[start][end][pState2]) continue;
                    BinaryRule[] parentRules = grammar.splitRulesWithP(pState2);
                    int nParentStates = numSubStatesArray[pState2];
                    Arrays.fill(this.scoresToAdd, initVal);
                    boolean somethingChanged = false;
                    for (BinaryRule r : parentRules) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        double[][][] scores = r.getScores2();
                        int nLeftChildStates = numSubStatesArray[lState];
                        int nRightChildStates = numSubStatesArray[rState];
                        for (int split = min; split <= max; ++split) {
                            if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                            for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                double lS = this.iScore[start][split][lState][lp];
                                if (lS == initVal) continue;
                                for (int rp = 0; rp < nRightChildStates; ++rp) {
                                    double rS;
                                    if (scores[lp][rp] == null || (rS = this.iScore[split][end][rState][rp]) == initVal) continue;
                                    for (int np2 = 0; np2 < nParentStates; ++np2) {
                                        double thisRound;
                                        double pS;
                                        if (!this.allowedSubStates[start][end][pState2][np2] || (pS = scores[lp][rp][np2]) == initVal) continue;
                                        double d = thisRound = logScores ? pS + lS + rS : pS * lS * rS;
                                        if (viterbi) {
                                            this.scoresToAdd[np2] = Math.max(thisRound, this.scoresToAdd[np2]);
                                        } else {
                                            int n3 = np2;
                                            this.scoresToAdd[n3] = this.scoresToAdd[n3] + thisRound;
                                        }
                                        somethingChanged = true;
                                    }
                                }
                            }
                        }
                    }
                    if (!somethingChanged) continue;
                    for (np = 0; np < nParentStates; ++np) {
                        if (!(this.scoresToAdd[np] > initVal)) continue;
                        this.iScore[start][end][pState2][np] = this.scoresToAdd[np];
                    }
                    if (start > this.narrowLExtent[end][pState2]) {
                        this.narrowLExtent[end][pState2] = start;
                        this.wideLExtent[end][pState2] = start;
                    } else if (start < this.wideLExtent[end][pState2]) {
                        this.wideLExtent[end][pState2] = start;
                    }
                    if (end < this.narrowRExtent[start][pState2]) {
                        this.narrowRExtent[start][pState2] = end;
                        this.wideRExtent[start][pState2] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState2]) continue;
                    this.wideRExtent[start][pState2] = end;
                }
                double[][] scoresAfterUnaries = new double[this.numStates][];
                boolean somethingChanged = false;
                for (pState = 0; pState < this.numStates; ++pState) {
                    if (!this.allowedStates[start][end][pState]) continue;
                    UnaryRule[] unaries = null;
                    unaries = viterbi ? grammar.getClosedViterbiUnaryRulesByParent(pState) : grammar.getClosedSumUnaryRulesByParent(pState);
                    int nParentStates = numSubStatesArray[pState];
                    boolean firstTime = true;
                    for (UnaryRule ur : unaries) {
                        short cState = ur.childState;
                        if (pState == cState || this.iScore[start][end][cState] == null) continue;
                        double[][] scores = ur.getScores2();
                        int nChildStates = numSubStatesArray[cState];
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            if (scores[cp] == null) continue;
                            for (int np3 = 0; np3 < nParentStates; ++np3) {
                                double thisRound;
                                double iS;
                                double pS;
                                if (!this.allowedSubStates[start][end][pState][np3] || (pS = scores[cp][np3]) == initVal || (iS = this.iScore[start][end][cState][cp]) == initVal) continue;
                                if (firstTime) {
                                    firstTime = false;
                                    scoresAfterUnaries[pState] = new double[nParentStates];
                                    Arrays.fill(scoresAfterUnaries[pState], initVal);
                                }
                                double d = thisRound = logScores ? iS + pS : iS * pS;
                                if (viterbi) {
                                    scoresAfterUnaries[pState][np3] = Math.max(thisRound, scoresAfterUnaries[pState][np3]);
                                } else {
                                    double[] dArray = scoresAfterUnaries[pState];
                                    int n = np3;
                                    dArray[n] = dArray[n] + thisRound;
                                }
                                somethingChanged = true;
                            }
                        }
                    }
                }
                if (!somethingChanged) continue;
                for (pState = 0; pState < this.numStates; ++pState) {
                    int nParentStates = numSubStatesArray[pState];
                    double[] thisCell = scoresAfterUnaries[pState];
                    if (thisCell == null) continue;
                    for (np = 0; np < nParentStates; ++np) {
                        if (!(thisCell[np] > initVal)) continue;
                        this.iScore[start][end][pState][np] = viterbi ? Math.max(this.iScore[start][end][pState][np], thisCell[np]) : this.iScore[start][end][pState][np] + thisCell[np];
                    }
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
            }
        }
    }

    @Override
    void doConstrainedOutsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        short[] numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        for (int diff = this.length; diff >= 1; --diff) {
            int start = 0;
            while (start + diff <= this.length) {
                int cState;
                int end = start + diff;
                double[][] scoresAfterUnaries = new double[this.numStates][];
                boolean somethingChanged = false;
                for (cState = 0; cState < this.numStates; ++cState) {
                    if (diff > 1 && !grammar.isGrammarTag[cState] || !this.allowedStates[start][end][cState]) continue;
                    UnaryRule[] rules = null;
                    rules = viterbi ? grammar.getClosedViterbiUnaryRulesByChild(cState) : grammar.getClosedSumUnaryRulesByChild(cState);
                    int nChildStates = numSubStatesArray[cState];
                    for (UnaryRule ur : rules) {
                        short pState = ur.parentState;
                        if (pState == cState || !this.allowedStates[start][end][pState]) continue;
                        double[][] scores = ur.getScores2();
                        int nParentStates = numSubStatesArray[pState];
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            if (scores[cp] == null || !this.allowedSubStates[start][end][cState][cp]) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double thisRound;
                                double oS;
                                double pS = scores[cp][np];
                                if (pS == initVal || (oS = this.oScore[start][end][pState][np]) == initVal) continue;
                                double d = thisRound = logScores ? oS + pS : oS * pS;
                                if (scoresAfterUnaries[cState] == null) {
                                    scoresAfterUnaries[cState] = new double[numSubStatesArray[cState]];
                                    if (viterbi) {
                                        Arrays.fill(scoresAfterUnaries[cState], initVal);
                                    }
                                }
                                if (viterbi) {
                                    scoresAfterUnaries[cState][cp] = Math.max(thisRound, scoresAfterUnaries[cState][cp]);
                                } else {
                                    double[] dArray = scoresAfterUnaries[cState];
                                    int n = cp;
                                    dArray[n] = dArray[n] + thisRound;
                                }
                                somethingChanged = true;
                            }
                        }
                    }
                }
                if (somethingChanged) {
                    for (cState = 0; cState < this.numStates; ++cState) {
                        double[] thisCell = scoresAfterUnaries[cState];
                        if (thisCell == null) continue;
                        for (int cp = 0; cp < numSubStatesArray[cState]; ++cp) {
                            if (!(thisCell[cp] > initVal)) continue;
                            if (viterbi) {
                                this.oScore[start][end][cState][cp] = Math.max(this.oScore[start][end][cState][cp], thisCell[cp]);
                                continue;
                            }
                            double[] dArray = this.oScore[start][end][cState];
                            int n = cp;
                            dArray[n] = dArray[n] + thisCell[cp];
                        }
                    }
                }
                for (int pState = 0; pState < numSubStatesArray.length; ++pState) {
                    if (!this.allowedStates[start][end][pState]) continue;
                    int nParentChildStates = numSubStatesArray[pState];
                    for (BinaryRule br : grammar.splitRulesWithP(pState)) {
                        short rState;
                        int max1;
                        short lState = br.leftChildState;
                        int min1 = this.narrowRExtent[start][lState];
                        if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) continue;
                        int max = max1;
                        int min = min1;
                        if (max - min > 2) {
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (max1 < min) continue;
                            int max2 = this.wideRExtent[start][lState];
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (max < min) continue;
                        }
                        double[][][] scores = br.getScores2();
                        int nLeftChildStates = numSubStatesArray[lState];
                        int nRightChildStates = numSubStatesArray[rState];
                        for (int split = min; split <= max; ++split) {
                            int cp;
                            if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                            double[] rightScores = new double[nRightChildStates];
                            if (viterbi) {
                                Arrays.fill(rightScores, initVal);
                            }
                            Arrays.fill(this.scoresToAdd, initVal);
                            somethingChanged = false;
                            for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                double lS = this.iScore[start][split][lState][lp];
                                if (lS == initVal) continue;
                                for (int rp = 0; rp < nRightChildStates; ++rp) {
                                    double rS;
                                    if (scores[lp][rp] == null || (rS = this.iScore[split][end][rState][rp]) == initVal) continue;
                                    for (int np = 0; np < nParentChildStates; ++np) {
                                        double thisRoundR;
                                        double oS;
                                        double pS = scores[lp][rp][np];
                                        if (pS == initVal || (oS = this.oScore[start][end][pState][np]) == initVal) continue;
                                        double thisRoundL = logScores ? pS + rS + oS : pS * rS * oS;
                                        double d = thisRoundR = logScores ? pS + lS + oS : pS * lS * oS;
                                        if (viterbi) {
                                            this.scoresToAdd[lp] = Math.max(thisRoundL, this.scoresToAdd[lp]);
                                            rightScores[rp] = Math.max(thisRoundR, rightScores[rp]);
                                        } else {
                                            int n = lp;
                                            this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                            int n3 = rp;
                                            rightScores[n3] = rightScores[n3] + thisRoundR;
                                        }
                                        somethingChanged = true;
                                    }
                                }
                            }
                            if (!somethingChanged) continue;
                            for (cp = 0; cp < nLeftChildStates; ++cp) {
                                if (!(this.scoresToAdd[cp] > initVal)) continue;
                                if (viterbi) {
                                    this.oScore[start][split][lState][cp] = Math.max(this.oScore[start][split][lState][cp], this.scoresToAdd[cp]);
                                    continue;
                                }
                                double[] dArray = this.oScore[start][split][lState];
                                int n = cp;
                                dArray[n] = dArray[n] + this.scoresToAdd[cp];
                            }
                            for (cp = 0; cp < nRightChildStates; ++cp) {
                                if (!(rightScores[cp] > initVal)) continue;
                                if (viterbi) {
                                    this.oScore[split][end][rState][cp] = Math.max(this.oScore[split][end][rState][cp], rightScores[cp]);
                                    continue;
                                }
                                double[] dArray = this.oScore[split][end][rState];
                                int n = cp;
                                dArray[n] = dArray[n] + rightScores[cp];
                            }
                        }
                    }
                }
                ++start;
            }
        }
    }

    @Override
    void initializeChart(List<String> sentence, Lexicon lexicon, boolean noSubstates, boolean noSmoothing, List<String> posTags, boolean scale) {
        int start = 0;
        int end = start + 1;
        for (String word : sentence) {
            end = start + 1;
            int goldTag = -1;
            if (this.useGoldPOS && posTags != null) {
                goldTag = this.tagNumberer.number(posTags.get(start));
            }
            for (int tag = 0; tag < this.numStates; ++tag) {
                if (!this.allowedStates[start][end][tag] || this.grammarTags[tag] || this.useGoldPOS && posTags != null && tag != goldTag) continue;
                this.narrowRExtent[start][tag] = end;
                this.narrowLExtent[end][tag] = start;
                this.wideRExtent[start][tag] = end;
                this.wideLExtent[end][tag] = start;
                double[] lexiconScores = lexicon.score(word, (short)tag, start, noSmoothing, false);
                if (scale) {
                    this.iScale[start][end][tag] = 0;
                }
                for (int n = 0; n < lexiconScores.length; n = (int)((short)(n + 1))) {
                    if (!noSubstates && !this.allowedSubStates[start][end][tag][n]) continue;
                    double prob = lexiconScores[n];
                    if (noSubstates) {
                        this.viScore[start][end][tag] = prob;
                        continue;
                    }
                    this.iScore[start][end][tag][n] = prob;
                }
            }
            ++start;
        }
    }

    protected void createArrays(boolean firstTime, int numStates, short[] numSubStatesArray, int level, double initVal, boolean justInit, int nGr) {
        int state;
        int end;
        int start;
        if (firstTime) {
            this.viScore = new double[this.length][this.length + 1][];
            this.voScore = new double[this.length][this.length + 1][];
            this.iScore = new double[this.length][this.length + 1][][];
            this.oScore = new double[this.length][this.length + 1][][];
            this.allowedSubStates = new boolean[this.length][this.length + 1][][];
            if (nGr == 0) {
                this.allowedStates = new boolean[this.length][this.length + 1][];
                this.vAllowedStates = new boolean[this.length][this.length + 1];
            }
        }
        for (start = 0; start < this.length; ++start) {
            for (end = start + 1; end <= this.length; ++end) {
                if (firstTime) {
                    this.viScore[start][end] = new double[numStates];
                    this.voScore[start][end] = new double[numStates];
                    this.iScore[start][end] = new double[numStates][];
                    this.oScore[start][end] = new double[numStates][];
                    this.allowedSubStates[start][end] = new boolean[numStates][];
                    if (nGr == 0) {
                        this.allowedStates[start][end] = (boolean[])this.grammarTags.clone();
                        if (end - start == 1) {
                            Arrays.fill(this.allowedStates[start][end], true);
                        }
                        this.vAllowedStates[start][end] = true;
                    }
                }
                for (state = 0; state < numSubStatesArray.length; ++state) {
                    if (firstTime || this.allowedStates[start][end][state]) {
                        if (level < 1) {
                            this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                            this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                            continue;
                        }
                        this.iScore[start][end][state] = new double[numSubStatesArray[state]];
                        this.oScore[start][end][state] = new double[numSubStatesArray[state]];
                        Arrays.fill(this.iScore[start][end][state], initVal);
                        Arrays.fill(this.oScore[start][end][state], initVal);
                        boolean[] newAllowedSubStates = new boolean[numSubStatesArray[state]];
                        if (this.allowedSubStates[start][end][state] == null) {
                            Arrays.fill(newAllowedSubStates, true);
                            this.allowedSubStates[start][end][state] = newAllowedSubStates;
                            continue;
                        }
                        if (justInit) continue;
                        int[][] curLChildMap = this.lChildMap[nGr][level - 2];
                        int[][] curRChildMap = this.rChildMap[nGr][level - 2];
                        for (int i = 0; i < this.allowedSubStates[start][end][state].length; ++i) {
                            boolean val;
                            newAllowedSubStates[curLChildMap[state][i]] = val = this.allowedSubStates[start][end][state][i];
                            newAllowedSubStates[curRChildMap[state][i]] = val;
                        }
                        this.allowedSubStates[start][end][state] = newAllowedSubStates;
                        continue;
                    }
                    if (level < 1) {
                        this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        continue;
                    }
                    this.iScore[start][end][state] = null;
                    this.oScore[start][end][state] = null;
                }
                if (level <= 0 || start != 0 || end != this.length || this.iScore[start][end][0] != null) continue;
                System.out.println("ROOT does not span the entire tree!");
            }
        }
        this.narrowRExtent = new int[this.length + 1][numStates];
        this.wideRExtent = new int[this.length + 1][numStates];
        this.narrowLExtent = new int[this.length + 1][numStates];
        this.wideLExtent = new int[this.length + 1][numStates];
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
        this.iScale = null;
        this.oScale = null;
        if (level > 0) {
            for (start = 0; start < this.length; ++start) {
                for (end = start + 1; end <= this.length; ++end) {
                    for (state = 1; state < numSubStatesArray.length; ++state) {
                        if (!this.allowedStates[start][end][state]) continue;
                        if (this.iScore[start][end][state] == null) {
                            System.err.println("iScore array not initialized correctly");
                        }
                        if (this.oScore[start][end][state] != null) continue;
                        System.err.println("oScore array not initialized correctly");
                    }
                }
            }
        }
    }

    @Override
    protected void clearArrays() {
        this.oScore = null;
        this.iScore = this.oScore;
        this.voScore = null;
        this.viScore = this.voScore;
        this.allowedSubStates = null;
        this.vAllowedStates = null;
        this.wideLExtent = null;
        this.narrowLExtent = this.wideLExtent;
        this.wideRExtent = this.wideLExtent;
        this.narrowRExtent = this.wideLExtent;
    }

    @Override
    protected void pruneChart(double threshold, short[] numSubStatesArray, int level) {
        int startDiff;
        double sentenceProb;
        int totalStates = 0;
        int previouslyPossible = 0;
        int nowPossible = 0;
        double d = sentenceProb = level < 1 ? this.viScore[0][this.length][0] : this.iScore[0][this.length][0][0];
        if (level < 1) {
            totalStates = previouslyPossible = this.length;
            nowPossible = previouslyPossible;
        }
        for (int diff = startDiff = level < 0 ? 2 : 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                int lastState = level < 0 ? 1 : numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    if (diff > 1 && !this.grammarTags[state]) continue;
                    if (state == 0) {
                        this.allowedStates[start][end][state] = true;
                        continue;
                    }
                    if (level == 0) {
                        if (!this.vAllowedStates[start][end]) {
                            this.allowedStates[start][end][state] = false;
                            ++totalStates;
                            continue;
                        }
                    } else if (level > 0 && !this.allowedStates[start][end][state]) {
                        totalStates += numSubStatesArray[state];
                        continue;
                    }
                    if (level < 1) {
                        ++totalStates;
                        ++previouslyPossible;
                        double iS = this.viScore[start][end][state];
                        double oS = this.voScore[start][end][state];
                        if (iS == Double.NEGATIVE_INFINITY || oS == Double.NEGATIVE_INFINITY) {
                            if (level == 0) {
                                this.allowedStates[start][end][state] = false;
                                continue;
                            }
                            this.vAllowedStates[start][end] = false;
                            continue;
                        }
                        double posterior = iS + oS - sentenceProb;
                        if (posterior > threshold) {
                            if (level == 0) {
                                this.allowedStates[start][end][state] = true;
                            } else {
                                this.vAllowedStates[start][end] = true;
                            }
                            ++nowPossible;
                            continue;
                        }
                        if (level == 0) {
                            this.allowedStates[start][end][state] = false;
                            continue;
                        }
                        this.vAllowedStates[start][end] = false;
                        continue;
                    }
                    boolean nonePossible = true;
                    for (int substate = 0; substate < numSubStatesArray[state]; ++substate) {
                        ++totalStates;
                        if (!this.allowedSubStates[start][end][state][substate]) continue;
                        ++previouslyPossible;
                        double iS = this.iScore[start][end][state][substate];
                        double oS = this.oScore[start][end][state][substate];
                        if (iS == Double.NEGATIVE_INFINITY || oS == Double.NEGATIVE_INFINITY) {
                            this.allowedSubStates[start][end][state][substate] = false;
                            continue;
                        }
                        double posterior = iS + oS - sentenceProb;
                        if (posterior > threshold) {
                            this.allowedSubStates[start][end][state][substate] = true;
                            ++nowPossible;
                            nonePossible = false;
                            continue;
                        }
                        this.allowedSubStates[start][end][state][substate] = false;
                    }
                    if (!nonePossible) continue;
                    this.allowedStates[start][end][state] = false;
                }
            }
        }
    }

    @Override
    public void doPreParses(List<String> sentence, Tree<StateSet> tree, boolean noSmoothing, List<String> posTags) {
        boolean keepGoldAlive = tree != null;
        this.clearArrays();
        this.all_iScales = new ArrayList<int[][][]>();
        this.all_oScales = new ArrayList<int[][][]>();
        this.all_iScores = new ArrayList<double[][][][]>();
        this.all_oScores = new ArrayList<double[][][][]>();
        this.length = (short)sentence.size();
        double score = 0.0;
        Grammar curGrammar = null;
        Lexicon curLexicon = null;
        double[] accurateThresholds = new double[]{-8.0, -12.0, -12.0, -11.0, -12.0, -12.0, -14.0, -14.0};
        double[] fastThresholds = new double[]{-8.0, -9.75, -10.0, -9.6, -9.66, -8.01, -7.4, -10.0, -10.0};
        double[] pruningThreshold = null;
        pruningThreshold = this.accurate ? accurateThresholds : fastThresholds;
        for (int nGr = 0; nGr < this.nGrammars; ++nGr) {
            boolean firstTime = true;
            this.level = this.startLevel;
            while (this.level <= this.endLevel) {
                if (!(this.level == -1 || nGr > 0 && this.level < 1 || !this.isBaseline && this.level == this.endLevel)) {
                    curGrammar = this.grammarCascade[nGr][this.level - this.startLevel];
                    curLexicon = this.lexiconCascade[nGr][this.level - this.startLevel];
                    this.createArrays(firstTime, curGrammar.numStates, curGrammar.numSubStates, this.level, Double.NEGATIVE_INFINITY, false, nGr);
                    firstTime = false;
                    this.initializeChart(sentence, curLexicon, this.level < 1, noSmoothing, posTags, false);
                    boolean viterbi = true;
                    boolean logScores = true;
                    if (this.level < 1) {
                        this.doConstrainedViterbiInsideScores(curGrammar, this.level == this.startLevel);
                        score = this.viScore[0][this.length][0];
                    } else {
                        this.doConstrainedInsideScores(curGrammar, true, true);
                        score = this.iScore[0][this.length][0][0];
                    }
                    if (score != Double.NEGATIVE_INFINITY) {
                        if (this.level < 1) {
                            this.voScore[0][this.length][0] = 0.0;
                            this.doConstrainedViterbiOutsideScores(curGrammar, this.level == this.startLevel);
                        } else {
                            this.oScore[0][this.length][0][0] = 0.0;
                            this.doConstrainedOutsideScores(curGrammar, true, true);
                        }
                        this.pruneChart(pruningThreshold[this.level + 1], curGrammar.numSubStates, this.level);
                        if (keepGoldAlive) {
                            this.ensureGoldTreeSurvives(tree, this.level);
                        }
                    }
                }
                ++this.level;
            }
            curGrammar = this.grammarCascade[nGr][this.endLevel - this.startLevel + 1];
            curLexicon = this.lexiconCascade[nGr][this.endLevel - this.startLevel + 1];
            double initVal = this.viterbiParse ? Double.NEGATIVE_INFINITY : 0.0;
            int level = this.isBaseline ? 1 : this.endLevel;
            this.createArrays(false, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false, nGr);
            this.initializeChart(sentence, curLexicon, false, false, posTags, false);
            this.doConstrainedInsideScores(curGrammar, this.viterbiParse, this.viterbiParse);
            score = this.iScore[0][this.length][0][0];
            if (!this.viterbiParse) {
                score = Math.log(score);
            }
            this.logLikelihood = score;
            if (score != Double.NEGATIVE_INFINITY) {
                if (!this.viterbiParse) {
                    this.oScore[0][this.length][0][0] = 1.0;
                    this.doConstrainedOutsideScores(curGrammar, this.viterbiParse, false);
                    this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, false);
                }
            } else {
                this.setupScaling();
                this.initializeChart(sentence, curLexicon, false, false, posTags, true);
                this.doScaledConstrainedInsideScores(curGrammar);
                score = this.iScore[0][this.length][0][0];
                if (!this.viterbiParse) {
                    score = Math.log(score) + (double)(100 * this.iScale[0][this.length][0]);
                }
                this.oScore[0][this.length][0][0] = 1.0;
                this.oScale[0][this.length][0] = 0;
                this.doScaledConstrainedOutsideScores(curGrammar);
                this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, true);
                score = this.iScore[0][this.length][0][0];
                if (!this.viterbiParse) {
                    score = Math.log(score);
                }
            }
            this.all_iScales.add(this.iScale);
            this.all_oScales.add(this.oScale);
            this.all_iScores.add(this.iScore);
            this.all_oScores.add(this.oScore);
        }
    }

    @Override
    protected void ensureGoldTreeSurvives(Tree<StateSet> tree, int level) {
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (child.isLeaf()) continue;
            this.ensureGoldTreeSurvives(child, level);
        }
        StateSet node = tree.getLabel();
        short state = node.getState();
        if (level < 0) {
            this.vAllowedStates[node.from][node.to] = true;
        } else {
            short start = node.from;
            short end = node.to;
            this.allowedStates[start][end][state] = true;
            if (this.allowedSubStates[start][end] == null) {
                this.allowedSubStates[start][end] = new boolean[this.numStates][];
            }
            this.allowedSubStates[start][end][state] = null;
        }
    }

    private void setGoldTreeCountsToOne(Tree<StateSet> tree) {
        StateSet node = tree.getLabel();
        short state = node.getState();
        this.iScore[node.from][node.to][state][0] = 1.0;
        this.oScore[node.from][node.to][state][0] = 1.0;
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (child.isLeaf()) continue;
            this.setGoldTreeCountsToOne(child);
        }
    }

    @Override
    public Tree<String> getBestParse(List<String> sentence) {
        return this.getBestConstrainedParse(sentence, null, false);
    }

    @Override
    public double getLogInsideScore() {
        return this.logLikelihood;
    }

    @Override
    public Tree<String> getBestConstrainedParse(List<String> sentence, List<String> posTags, boolean noPreparse) {
        if (sentence.size() == 0) {
            return new Tree<String>("ROOT");
        }
        if (!noPreparse) {
            this.doPreParses(sentence, null, false, posTags);
        }
        this.bestTree = new Tree<String>("ROOT");
        boolean scale = false;
        for (int nGr = 0; nGr < this.nGrammars; ++nGr) {
            scale = scale || this.all_iScales.get(nGr) != null;
        }
        this.doCombinedMaxCScores(sentence, scale);
        if (this.maxcScore[0][sentence.size()][0] == Double.NEGATIVE_INFINITY) {
            System.err.println("MaxCscore for ROOT was -Inf. Using single grammar.");
            this.nGrammars = 1;
            this.doCombinedMaxCScores(sentence, scale);
            this.nGrammars = this.all_iScores.size();
        }
        if (this.maxcScore[0][sentence.size()][0] != Double.NEGATIVE_INFINITY) {
            this.bestTree = this.extractBestMaxRuleParse(0, sentence.size(), sentence);
        } else {
            System.err.println("Still couldn't parse this sentence!");
        }
        return this.bestTree;
    }

    @Override
    public double getModelScore(Tree<String> parsedTree) {
        if (this.viterbiParse) {
            return this.logLikelihood;
        }
        return this.savedScore;
    }

    @Override
    public double getConfidence(Tree<String> tree) {
        if (this.logLikelihood == Double.NEGATIVE_INFINITY) {
            return this.logLikelihood;
        }
        double treeLL = this.getLogLikelihood(tree);
        double sentenceLL = this.getLogLikelihood();
        return treeLL - sentenceLL;
    }

    @Override
    public double getLogLikelihood(Tree<String> tree) {
        System.out.println("Not implemented (getLogLikelihood)");
        System.exit(-1);
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getLogLikelihood() {
        if (this.logLikelihood == Double.NEGATIVE_INFINITY) {
            return this.logLikelihood;
        }
        if (this.viterbiParse) {
            return this.logLikelihood;
        }
        this.logLikelihood = Math.log(this.iScore[0][this.length][0][0]);
        if (this.iScale != null) {
            this.logLikelihood += (double)(100 * this.iScale[0][this.length][0]);
        }
        return this.logLikelihood;
    }

    @Override
    void doConstrainedMaxCScores(List<String> sentence, Grammar grammar, Lexicon lexicon, boolean scale) {
        short[] numSubStatesArray = grammar.numSubStates;
        double initVal = Double.NEGATIVE_INFINITY;
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        ArrayUtil.fill(this.maxcScore, Double.NEGATIVE_INFINITY);
        double logNormalizer = this.iScore[0][this.length][0][0];
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    for (int pState = 0; pState < numSubStatesArray.length; ++pState) {
                        if (!this.allowedStates[start][end][pState]) continue;
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        int nParentStates = numSubStatesArray[pState];
                        for (int i = 0; i < parentRules.length; ++i) {
                            int max;
                            int min;
                            boolean iPossibleR;
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (!iPossibleL) continue;
                            int narrowL = this.narrowLExtent[end][rState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (!iPossibleR) continue;
                            int min1 = narrowR;
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (min > narrowL) continue;
                            int max1 = this.wideRExtent[start][lState];
                            int max2 = narrowL;
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (min > max) continue;
                            double[][][] scores = r.getScores2();
                            int nLeftChildStates = numSubStatesArray[lState];
                            int nRightChildStates = numSubStatesArray[rState];
                            double scoreToBeat = this.maxcScore[start][end][pState];
                            for (int split = min; split <= max; ++split) {
                                double gScore;
                                double ruleScore = 0.0;
                                if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                                double leftChildScore = this.maxcScore[start][split][lState];
                                double rightChildScore = this.maxcScore[split][end][rState];
                                if (leftChildScore == initVal || rightChildScore == initVal) continue;
                                double scalingFactor = 0.0;
                                if (scale) {
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - this.iScale[0][this.length][0]));
                                }
                                if ((gScore = leftChildScore + scalingFactor + rightChildScore) < scoreToBeat) continue;
                                for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                    double lIS = this.iScore[start][split][lState][lp];
                                    if (lIS == 0.0) continue;
                                    for (int rp = 0; rp < nRightChildStates; ++rp) {
                                        double rIS;
                                        if (scores[lp][rp] == null || (rIS = this.iScore[split][end][rState][rp]) == 0.0) continue;
                                        for (int np = 0; np < nParentStates; ++np) {
                                            double ruleS;
                                            double pOS = this.oScore[start][end][pState][np];
                                            if (pOS == 0.0 || (ruleS = scores[lp][rp][np]) == 0.0) continue;
                                            ruleScore += pOS * ruleS * lIS * rIS / logNormalizer;
                                        }
                                    }
                                }
                                if (ruleScore == 0.0) continue;
                                if (this.doVariational) {
                                    double norm = 0.0;
                                    for (int np = 0; np < nParentStates; ++np) {
                                        norm += this.oScore[start][end][pState][np] / logNormalizer * this.iScore[start][end][pState][np];
                                    }
                                    ruleScore /= norm;
                                }
                                if (!((gScore += Math.log(ruleScore)) > scoreToBeat)) continue;
                                scoreToBeat = gScore;
                                this.maxcScore[start][end][pState] = gScore;
                                this.maxcSplit[start][end][pState] = split;
                                this.maxcLeftChild[start][end][pState] = lState;
                                this.maxcRightChild[start][end][pState] = rState;
                            }
                        }
                    }
                } else {
                    for (int tag = 0; tag < numSubStatesArray.length; ++tag) {
                        if (!this.allowedStates[start][end][tag]) continue;
                        int nTagStates = numSubStatesArray[tag];
                        String word = sentence.get(start);
                        if (grammar.isGrammarTag(tag)) continue;
                        double[] lexiconScoreArray = lexicon.score(word, (short)tag, start, false, false);
                        double lexiconScores = 0.0;
                        for (int tp = 0; tp < nTagStates; ++tp) {
                            double pOS = this.oScore[start][end][tag][tp];
                            double ruleS = lexiconScoreArray[tp];
                            lexiconScores += pOS * ruleS / logNormalizer;
                        }
                        double scalingFactor = 0.0;
                        if (this.doVariational) {
                            lexiconScores = 1.0;
                        } else if (scale) {
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][tag] - this.iScale[0][this.length][0]));
                        }
                        this.maxcScore[start][end][tag] = Math.log(lexiconScores) + scalingFactor;
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                for (int i = 0; i < this.numStates; ++i) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                }
                double[][] ruleScores = null;
                if (this.doVariational) {
                    ruleScores = new double[this.numStates][this.numStates];
                }
                boolean foundOne = false;
                for (int pState = 0; pState < numSubStatesArray.length; ++pState) {
                    if (!this.allowedStates[start][end][pState]) continue;
                    int nParentStates = numSubStatesArray[pState];
                    UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                    if (this.doVariational) {
                        unaries = grammar.getUnaryRulesByParent(pState).toArray(new UnaryRule[0]);
                    }
                    for (int r = 0; r < unaries.length; ++r) {
                        double gScore;
                        double childScore;
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.iScore[start][end][cState] == null || (childScore = this.maxcScore[start][end][cState]) == initVal) continue;
                        double scalingFactor = 0.0;
                        if (scale) {
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - this.iScale[0][this.length][0]));
                        }
                        if ((gScore = scalingFactor + childScore) < maxcScoreStartEnd[pState]) continue;
                        double[][] scores = ur.getScores2();
                        int nChildStates = numSubStatesArray[cState];
                        double ruleScore = 0.0;
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double cIS = this.iScore[start][end][cState][cp];
                            if (cIS == 0.0 || scores[cp] == null) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double ruleS;
                                double pOS = this.oScore[start][end][pState][np];
                                if (pOS < 0.0 || (ruleS = scores[cp][np]) == 0.0) continue;
                                ruleScore += pOS * ruleS * cIS / logNormalizer;
                                foundOne = true;
                            }
                        }
                        if (ruleScore == 0.0) continue;
                        if (this.doVariational) {
                            double norm = 0.0;
                            for (int np = 0; np < nParentStates; ++np) {
                                norm += this.oScore[start][end][pState][np] / logNormalizer * this.iScore[start][end][pState][np];
                            }
                            ruleScores[pState][cState] = Math.max(ruleScore /= norm, ruleScores[pState][cState]);
                        }
                        if (!((gScore += Math.log(ruleScore)) > maxcScoreStartEnd[pState])) continue;
                        maxcScoreStartEnd[pState] = gScore;
                        this.maxcChild[start][end][pState] = cState;
                    }
                }
                if (foundOne && this.doVariational) {
                    maxcScoreStartEnd = this.closeVariationalRules(ruleScores, start, end);
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
            }
        }
    }

    @Override
    public Tree<String> extractBestMaxRuleParse(int start, int end, List<String> sentence) {
        return this.extractBestMaxRuleParse1(start, end, 0, sentence);
    }

    @Override
    public Tree<String> extractBestMaxRuleParse1(int start, int end, int state, List<String> sentence) {
        int cState = this.maxcChild[start][end][state];
        if (cState == -1) {
            return this.extractBestMaxRuleParse2(start, end, state, sentence);
        }
        ArrayList child = new ArrayList();
        child.add(this.extractBestMaxRuleParse2(start, end, cState, sentence));
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        ++this.totalUsedUnaries;
        int intermediateNode = this.grammars[0].getUnaryIntermediate((short)state, (short)cState);
        if (intermediateNode > 0) {
            ArrayList restoredChild = new ArrayList();
            ++this.nTimesRestoredUnaries;
            String stateStr2 = (String)this.tagNumberer.object(intermediateNode);
            if (stateStr2.endsWith("^g")) {
                stateStr2 = stateStr2.substring(0, stateStr2.length() - 2);
            }
            restoredChild.add(new Tree<String>(stateStr2, child));
            return new Tree<String>(stateStr, restoredChild);
        }
        return new Tree<String>(stateStr, child);
    }

    @Override
    public Tree<String> extractBestMaxRuleParse2(int start, int end, int state, List<String> sentence) {
        boolean posLevel;
        ArrayList children = new ArrayList();
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        boolean bl = posLevel = end - start == 1;
        if (posLevel) {
            if (this.grammars[0].isGrammarTag(state)) {
                ArrayList childs = new ArrayList();
                childs.add(new Tree<String>(sentence.get(start)));
                String stateStr2 = (String)this.tagNumberer.object(this.maxcChild[start][end][state]);
                children.add(new Tree<String>(stateStr2, childs));
            } else {
                children.add(new Tree<String>(sentence.get(start)));
            }
        } else {
            int split = this.maxcSplit[start][end][state];
            if (split == -1) {
                System.err.println("Warning: no symbol can generate the span from " + start + " to " + end + ".");
                System.err.println("The score is " + this.maxcScore[start][end][state] + " and the state is supposed to be " + stateStr);
                System.err.println("The insideScores are " + Arrays.toString(this.iScore[start][end][state]) + " and the outsideScores are " + Arrays.toString(this.oScore[start][end][state]));
                System.err.println("The maxcScore is " + this.maxcScore[start][end][state]);
                return new Tree<String>("ROOT");
            }
            int lState = this.maxcLeftChild[start][end][state];
            int rState = this.maxcRightChild[start][end][state];
            Tree<String> leftChildTree = this.extractBestMaxRuleParse1(start, split, lState, sentence);
            Tree<String> rightChildTree = this.extractBestMaxRuleParse1(split, end, rState, sentence);
            children.add(leftChildTree);
            children.add(rightChildTree);
        }
        return new Tree<String>(stateStr, children);
    }

    @Override
    void doConstrainedViterbiInsideScores(Grammar grammar, boolean level0grammar) {
        short[] numSubStatesArray = grammar.numSubStates;
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                int lastState = level0grammar ? 1 : numSubStatesArray.length;
                for (int pState = 0; pState < lastState; ++pState) {
                    double oldIScore;
                    if (diff == 1 || !this.grammarTags[pState] || !this.vAllowedStates[start][end]) continue;
                    double bestIScore = oldIScore = this.viScore[start][end][pState];
                    BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                    for (int i = 0; i < parentRules.length; ++i) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        BinaryRule r = parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        double[][][] scores = r.getScores2();
                        double pS = Double.NEGATIVE_INFINITY;
                        if (scores[0][0] != null) {
                            pS = scores[0][0][0];
                        }
                        if (pS == Double.NEGATIVE_INFINITY) continue;
                        for (int split = min; split <= max; ++split) {
                            double tot;
                            double rS;
                            double lS;
                            if (!this.vAllowedStates[start][split] || !this.vAllowedStates[split][end] || (lS = this.viScore[start][split][lState]) == Double.NEGATIVE_INFINITY || (rS = this.viScore[split][end][rState]) == Double.NEGATIVE_INFINITY || !((tot = pS + lS + rS) >= bestIScore)) continue;
                            bestIScore = tot;
                        }
                    }
                    if (!(bestIScore > oldIScore)) continue;
                    this.viScore[start][end][pState] = bestIScore;
                    if (oldIScore != Double.NEGATIVE_INFINITY) continue;
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
                int lastStateU = level0grammar && diff > 1 ? 1 : numSubStatesArray.length;
                for (int pState = 0; pState < lastStateU; ++pState) {
                    double oldIScore;
                    if (!this.grammarTags[pState] || diff != 1 && !this.vAllowedStates[start][end]) continue;
                    UnaryRule[] unaries = grammar.getClosedViterbiUnaryRulesByParent(pState);
                    double bestIScore = oldIScore = this.viScore[start][end][pState];
                    for (int r = 0; r < unaries.length; ++r) {
                        double tot;
                        double iS;
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || (iS = this.viScore[start][end][cState]) == Double.NEGATIVE_INFINITY) continue;
                        double[][] scores = ur.getScores2();
                        double pS = Double.NEGATIVE_INFINITY;
                        if (scores[0] != null) {
                            pS = scores[0][0];
                        }
                        if (pS == Double.NEGATIVE_INFINITY || !((tot = iS + pS) >= bestIScore)) continue;
                        bestIScore = tot;
                    }
                    if (!(bestIScore > oldIScore)) continue;
                    this.viScore[start][end][pState] = bestIScore;
                    if (oldIScore != Double.NEGATIVE_INFINITY) continue;
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
            }
        }
    }

    @Override
    void doConstrainedViterbiOutsideScores(Grammar grammar, boolean level0grammar) {
        for (int diff = this.length; diff >= 1; --diff) {
            int start = 0;
            while (start + diff <= this.length) {
                int end = start + diff;
                int lastState = level0grammar ? 1 : grammar.numSubStates.length;
                for (int cState = 0; cState < lastState; ++cState) {
                    double oldOScore;
                    double iS;
                    if (!this.vAllowedStates[start][end] || (iS = this.viScore[start][end][cState]) == Double.NEGATIVE_INFINITY) continue;
                    double bestOScore = oldOScore = this.voScore[start][end][cState];
                    UnaryRule[] rules = grammar.getClosedViterbiUnaryRulesByChild(cState);
                    for (int r = 0; r < rules.length; ++r) {
                        double[][] scores;
                        double pS;
                        double tot;
                        double oS;
                        UnaryRule ur = rules[r];
                        short pState = ur.parentState;
                        if (cState == pState || (oS = this.voScore[start][end][pState]) == Double.NEGATIVE_INFINITY || !((tot = oS + (pS = (scores = ur.getScores2())[0][0])) > bestOScore)) continue;
                        bestOScore = tot;
                    }
                    if (!(bestOScore > oldOScore)) continue;
                    this.voScore[start][end][cState] = bestOScore;
                }
                for (int pState = 0; pState < lastState; ++pState) {
                    double oS;
                    if (!this.grammarTags[pState] || (oS = this.voScore[start][end][pState]) == Double.NEGATIVE_INFINITY) continue;
                    BinaryRule[] rules = grammar.splitRulesWithP(pState);
                    for (int r = 0; r < rules.length; ++r) {
                        short rState;
                        int max1;
                        BinaryRule br = rules[r];
                        short lState = br.leftChildState;
                        int min1 = this.narrowRExtent[start][lState];
                        if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) continue;
                        int max = max1;
                        int min = min1;
                        if (max - min > 2) {
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (max1 < min) continue;
                            int max2 = this.wideRExtent[start][lState];
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (max < min) continue;
                        }
                        double[][][] scores = br.getScores2();
                        double pS = Double.NEGATIVE_INFINITY;
                        if (scores[0][0] != null) {
                            pS = scores[0][0][0];
                        }
                        if (pS == Double.NEGATIVE_INFINITY) continue;
                        for (int split = min; split <= max; ++split) {
                            double totR;
                            double rS;
                            double lS;
                            if (!this.vAllowedStates[start][split] || !this.vAllowedStates[split][end] || (lS = this.viScore[start][split][lState]) == Double.NEGATIVE_INFINITY || (rS = this.viScore[split][end][rState]) == Double.NEGATIVE_INFINITY) continue;
                            double totL = pS + rS + oS;
                            if (totL > this.voScore[start][split][lState]) {
                                this.voScore[start][split][lState] = totL;
                            }
                            if (!((totR = pS + lS + oS) > this.voScore[split][end][rState])) continue;
                            this.voScore[split][end][rState] = totR;
                        }
                    }
                }
                ++start;
            }
        }
    }

    @Override
    public void printUnaryStats() {
        System.out.println("Touched " + this.touchedRules + " rules.");
        System.out.println("Used a total of " + this.totalUsedUnaries + " unaries.");
        System.out.println("Restored " + this.nTimesRestoredUnaries + " unary chains.");
    }

    @Override
    public Tree<String> extractBestViterbiParse(int gState, int gp, int start, int end, List<String> sentence) {
        double bestScore = this.iScore[start][end][gState][gp];
        String goalStr = (String)this.tagNumberer.object(gState);
        if (goalStr.endsWith("^g")) {
            goalStr = goalStr.substring(0, goalStr.length() - 2);
        }
        if (this.outputSub) {
            goalStr = goalStr + "-" + gp;
        }
        if (this.outputScore) {
            goalStr = goalStr + " " + bestScore;
        }
        if (end - start == 1) {
            if (!this.grammarTags[gState]) {
                ArrayList child = new ArrayList();
                child.add(new Tree<String>(sentence.get(start)));
                return new Tree<String>(goalStr, child);
            }
            double veryBestScore = Double.NEGATIVE_INFINITY;
            int newIndex = -1;
            int newCp = -1;
            UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
            double childScore = bestScore;
            for (int r = 0; r < unaries.length; ++r) {
                UnaryRule ur = unaries[r];
                short cState = ur.childState;
                if (cState == gState || this.grammarTags[cState] || !this.allowedStates[start][end][cState]) continue;
                double[][] scores = ur.getScores2();
                for (int cp = 0; cp < scores.length; ++cp) {
                    double ruleScore;
                    if (scores[cp] == null || !((ruleScore = this.iScore[start][end][cState][cp] + scores[cp][gp]) >= veryBestScore)) continue;
                    childScore = this.iScore[start][end][cState][cp];
                    veryBestScore = ruleScore;
                    newIndex = cState;
                    newCp = cp;
                }
            }
            ArrayList child1 = new ArrayList();
            child1.add(new Tree<String>(sentence.get(start)));
            String goalStr1 = (String)this.tagNumberer.object(newIndex);
            if (this.outputSub) {
                goalStr1 = goalStr1 + "-" + newCp;
            }
            if (this.outputScore) {
                goalStr1 = goalStr1 + " " + childScore;
            }
            if (goalStr1 == null) {
                System.out.println("goalStr1==null with newIndex==" + newIndex + " goalStr==" + goalStr);
            }
            ArrayList child = new ArrayList();
            child.add(new Tree<String>(goalStr1, child1));
            return new Tree<String>(goalStr, child);
        }
        BinaryRule[] parentRules = this.grammar.splitRulesWithP(gState);
        for (int split = start + 1; split < end; ++split) {
            for (int i = 0; i < parentRules.length; ++i) {
                short rState;
                BinaryRule br = parentRules[i];
                short lState = br.leftChildState;
                if (this.iScore[start][split][lState] == null || this.iScore[split][end][rState = br.rightChildState] == null) continue;
                double[][][] scores = br.getScores2();
                for (int lp = 0; lp < scores.length; ++lp) {
                    for (int rp = 0; rp < scores[lp].length; ++rp) {
                        double score;
                        if (scores[lp][rp] == null || !this.matches(score = scores[lp][rp][gp] + this.iScore[start][split][lState][lp] + this.iScore[split][end][rState][rp], bestScore)) continue;
                        Tree<String> leftChildTree = this.extractBestViterbiParse(lState, lp, start, split, sentence);
                        Tree<String> rightChildTree = this.extractBestViterbiParse(rState, rp, split, end, sentence);
                        ArrayList children = new ArrayList();
                        children.add(leftChildTree);
                        children.add(rightChildTree);
                        Tree<String> result = new Tree<String>(goalStr, children);
                        return result;
                    }
                }
            }
        }
        UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
        for (int r = 0; r < unaries.length; ++r) {
            UnaryRule ur = unaries[r];
            short cState = ur.childState;
            if (cState == gState || this.iScore[start][end][cState] == null) continue;
            double[][] scores = ur.getScores2();
            for (int cp = 0; cp < scores.length; ++cp) {
                double score;
                if (scores[cp] == null || !this.matches(score = scores[cp][gp] + this.iScore[start][end][cState][cp], bestScore)) continue;
                Tree<String> childTree = this.extractBestViterbiParse(cState, cp, start, end, sentence);
                ArrayList children = new ArrayList();
                children.add(childTree);
                Tree<String> result = new Tree<String>(goalStr, children);
                return result;
            }
        }
        System.err.println("Warning: could not find the optimal way to build state " + goalStr + " spanning from " + start + " to " + end + ".");
        return new Tree<String>("ROOT");
    }

    private double[] closeVariationalRules(double[][] ruleScores, int start, int end) {
        double[] closedScores = new double[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            closedScores[i] = this.maxcScore[start][end][i];
        }
        for (int length = 1; length < 10; ++length) {
            for (int startState = 0; startState < this.numStates; ++startState) {
                for (int endState = 0; endState < this.numStates; ++endState) {
                    for (int interState = 0; interState < this.numStates; ++interState) {
                        ruleScores[startState][endState] = Math.max(ruleScores[startState][endState], ruleScores[startState][interState] * ruleScores[interState][endState]);
                    }
                }
            }
        }
        for (int childState = 0; childState < this.numStates; ++childState) {
            double childScore = this.maxcScore[start][end][childState];
            if (childScore == 0.0) continue;
            for (int parentState = 0; parentState < this.numStates; ++parentState) {
                double newScore = childScore * ruleScores[parentState][childState];
                if (!(newScore > closedScores[parentState])) continue;
                closedScores[parentState] = newScore;
                this.maxcChild[start][end][parentState] = childState;
            }
        }
        return closedScores;
    }

    @Override
    void doScaledConstrainedInsideScores(Grammar grammar) {
        double initVal = 0.0;
        short[] numSubStatesArray = grammar.numSubStates;
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                for (int pState = 0; pState < numSubStatesArray.length; ++pState) {
                    if (diff == 1 || !this.allowedStates[start][end][pState]) continue;
                    BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                    int nParentStates = numSubStatesArray[pState];
                    boolean somethingChanged = false;
                    for (int i = 0; i < parentRules.length; ++i) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        BinaryRule r = parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        double[][][] scores = r.getScores2();
                        int nLeftChildStates = numSubStatesArray[lState];
                        int nRightChildStates = numSubStatesArray[rState];
                        for (int split = min; split <= max; ++split) {
                            boolean changeThisRound = false;
                            if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                            for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                double lS = this.iScore[start][split][lState][lp];
                                if (lS == initVal) continue;
                                for (int rp = 0; rp < nRightChildStates; ++rp) {
                                    double rS;
                                    if (scores[lp][rp] == null || (rS = this.iScore[split][end][rState][rp]) == initVal) continue;
                                    for (int np = 0; np < nParentStates; ++np) {
                                        double pS;
                                        if (!this.allowedSubStates[start][end][pState][np] || (pS = scores[lp][rp][np]) == initVal) continue;
                                        double thisRound = pS * lS * rS;
                                        int n3 = np;
                                        this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + thisRound;
                                        somethingChanged = true;
                                        changeThisRound = true;
                                    }
                                }
                            }
                            if (!changeThisRound) continue;
                            int parentScale = this.iScale[start][end][pState];
                            int currentScale = this.iScale[start][split][lState] + this.iScale[split][end][rState];
                            if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                if (parentScale == Integer.MIN_VALUE) {
                                    this.iScale[start][end][pState] = currentScale;
                                } else {
                                    int newScale = Math.max(currentScale, parentScale);
                                    ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                    ScalingTools.scaleArrayToScale(this.iScore[start][end][pState], parentScale, newScale);
                                    this.iScale[start][end][pState] = newScale;
                                }
                            }
                            for (int np = 0; np < nParentStates; ++np) {
                                double[] dArray = this.iScore[start][end][pState];
                                int n4 = np;
                                dArray[n4] = dArray[n4] + this.unscaledScoresToAdd[np];
                            }
                            Arrays.fill(this.unscaledScoresToAdd, 0.0);
                        }
                    }
                    if (!somethingChanged) continue;
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
                double[][] scoresAfterUnaries = new double[this.numStates][];
                for (int pState = 0; pState < numSubStatesArray.length; ++pState) {
                    int parentScale;
                    if (!this.allowedStates[start][end][pState]) continue;
                    UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                    int nParentStates = numSubStatesArray[pState];
                    int scaleBeforeUnaries = parentScale = this.iScale[start][end][pState];
                    boolean somethingChanged = false;
                    for (int r = 0; r < unaries.length; ++r) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.iScore[start][end][cState] == null) continue;
                        double[][] scores = ur.getScores2();
                        boolean changeThisRound = false;
                        int nChildStates = numSubStatesArray[cState];
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double iS;
                            if (scores[cp] == null || (iS = this.iScore[start][end][cState][cp]) == initVal) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double pS;
                                if (!this.allowedSubStates[start][end][pState][np] || (pS = scores[cp][np]) == initVal) continue;
                                double thisRound = iS * pS;
                                int n = np;
                                this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + thisRound;
                                somethingChanged = true;
                                changeThisRound = true;
                            }
                        }
                        if (!changeThisRound) continue;
                        if (scoresAfterUnaries[pState] == null) {
                            scoresAfterUnaries[pState] = new double[numSubStatesArray[pState]];
                        }
                        int currentScale = this.iScale[start][end][cState];
                        if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                            if (parentScale == Integer.MIN_VALUE) {
                                parentScale = currentScale;
                            } else {
                                int newScale = Math.max(currentScale, parentScale);
                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                ScalingTools.scaleArrayToScale(scoresAfterUnaries[pState], parentScale, newScale);
                                parentScale = newScale;
                            }
                        }
                        for (int np = 0; np < nParentStates; ++np) {
                            double[] dArray = scoresAfterUnaries[pState];
                            int n = np;
                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[np];
                        }
                        Arrays.fill(this.unscaledScoresToAdd, 0.0);
                    }
                    if (somethingChanged) {
                        int newScale = Math.max(scaleBeforeUnaries, parentScale);
                        ScalingTools.scaleArrayToScale(this.iScore[start][end][pState], scaleBeforeUnaries, newScale);
                        ScalingTools.scaleArrayToScale(scoresAfterUnaries[pState], parentScale, newScale);
                        this.iScale[start][end][pState] = newScale;
                        if (start > this.narrowLExtent[end][pState]) {
                            this.narrowLExtent[end][pState] = start;
                            this.wideLExtent[end][pState] = start;
                        } else if (start < this.wideLExtent[end][pState]) {
                            this.wideLExtent[end][pState] = start;
                        }
                        if (end < this.narrowRExtent[start][pState]) {
                            this.narrowRExtent[start][pState] = end;
                            this.wideRExtent[start][pState] = end;
                        } else if (end > this.wideRExtent[start][pState]) {
                            this.wideRExtent[start][pState] = end;
                        }
                    }
                    for (int np = 0; np < nParentStates; ++np) {
                        double val;
                        if (scoresAfterUnaries[pState] == null || !((val = scoresAfterUnaries[pState][np]) > 0.0)) continue;
                        double[] dArray = this.iScore[start][end][pState];
                        int n = np;
                        dArray[n] = dArray[n] + val;
                    }
                }
            }
        }
    }

    @Override
    void doScaledConstrainedOutsideScores(Grammar grammar) {
        double initVal = 0.0;
        short[] numSubStatesArray = grammar.numSubStates;
        for (int diff = this.length; diff >= 1; --diff) {
            int start = 0;
            while (start + diff <= this.length) {
                int end = start + diff;
                double[][] scoresAfterUnaries = new double[this.numStates][];
                for (int cState = 0; cState < numSubStatesArray.length; ++cState) {
                    int childScale;
                    if (!this.allowedStates[start][end][cState]) continue;
                    UnaryRule[] rules = grammar.getClosedSumUnaryRulesByChild(cState);
                    int nChildStates = numSubStatesArray[cState];
                    boolean somethingChanged = false;
                    int scaleBeforeUnaries = childScale = this.oScale[start][end][cState];
                    for (int r = 0; r < rules.length; ++r) {
                        UnaryRule ur = rules[r];
                        short pState = ur.parentState;
                        if (pState == cState || !this.allowedStates[start][end][pState]) continue;
                        int nParentStates = numSubStatesArray[pState];
                        double[][] scores = ur.getScores2();
                        boolean changeThisRound = false;
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            if (scores[cp] == null || !this.allowedSubStates[start][end][cState][cp]) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double oS;
                                double pS;
                                if (!this.allowedSubStates[start][end][pState][np] || (pS = scores[cp][np]) == initVal || (oS = this.oScore[start][end][pState][np]) == initVal) continue;
                                double thisRound = oS * pS;
                                int n = cp;
                                this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + thisRound;
                                somethingChanged = true;
                                changeThisRound = true;
                            }
                        }
                        if (!changeThisRound) continue;
                        if (scoresAfterUnaries[cState] == null) {
                            scoresAfterUnaries[cState] = new double[numSubStatesArray[cState]];
                        }
                        int currentScale = this.oScale[start][end][pState];
                        if (childScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                            if (childScale == Integer.MIN_VALUE) {
                                childScale = currentScale;
                            } else {
                                int newScale = Math.max(currentScale, childScale);
                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                ScalingTools.scaleArrayToScale(scoresAfterUnaries[cState], childScale, newScale);
                                childScale = newScale;
                            }
                        }
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double[] dArray = scoresAfterUnaries[cState];
                            int n = cp;
                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                        }
                        Arrays.fill(this.unscaledScoresToAdd, initVal);
                    }
                    if (somethingChanged) {
                        int newScale = Math.max(scaleBeforeUnaries, childScale);
                        ScalingTools.scaleArrayToScale(this.oScore[start][end][cState], scaleBeforeUnaries, newScale);
                        ScalingTools.scaleArrayToScale(scoresAfterUnaries[cState], childScale, newScale);
                        this.oScale[start][end][cState] = newScale;
                    }
                    for (int cp = 0; cp < nChildStates; ++cp) {
                        double val;
                        if (scoresAfterUnaries[cState] == null || !((val = scoresAfterUnaries[cState][cp]) > 0.0)) continue;
                        double[] dArray = this.oScore[start][end][cState];
                        int n = cp;
                        dArray[n] = dArray[n] + val;
                    }
                }
                if (diff != 1) {
                    for (int pState = 0; pState < numSubStatesArray.length; ++pState) {
                        if (!this.allowedStates[start][end][pState]) continue;
                        int nParentChildStates = numSubStatesArray[pState];
                        BinaryRule[] rules = grammar.splitRulesWithP(pState);
                        for (int r = 0; r < rules.length; ++r) {
                            short rState;
                            int max1;
                            BinaryRule br = rules[r];
                            short lState = br.leftChildState;
                            int min1 = this.narrowRExtent[start][lState];
                            if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) continue;
                            int max = max1;
                            int min = min1;
                            if (max - min > 2) {
                                int min2 = this.wideLExtent[end][rState];
                                int n = min = min1 > min2 ? min1 : min2;
                                if (max1 < min) continue;
                                int max2 = this.wideRExtent[start][lState];
                                int n2 = max = max1 < max2 ? max1 : max2;
                                if (max < min) continue;
                            }
                            double[][][] scores = br.getScores2();
                            int nLeftChildStates = numSubStatesArray[lState];
                            int nRightChildStates = numSubStatesArray[rState];
                            for (int split = min; split <= max; ++split) {
                                int cp;
                                int newScale;
                                if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                                boolean somethingChanged = false;
                                for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                    double lS = this.iScore[start][split][lState][lp];
                                    for (int rp = 0; rp < nRightChildStates; ++rp) {
                                        if (scores[lp][rp] == null) continue;
                                        double rS = this.iScore[split][end][rState][rp];
                                        for (int np = 0; np < nParentChildStates; ++np) {
                                            double oS;
                                            double pS = scores[lp][rp][np];
                                            if (pS == initVal || (oS = this.oScore[start][end][pState][np]) == initVal) continue;
                                            double thisRoundL = pS * rS * oS;
                                            double thisRoundR = pS * lS * oS;
                                            int n = lp;
                                            this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                            int n3 = rp;
                                            this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + thisRoundR;
                                            somethingChanged = true;
                                        }
                                    }
                                }
                                if (!somethingChanged) continue;
                                if (DoubleArrays.max(this.scoresToAdd) != 0.0) {
                                    int leftScale = this.oScale[start][split][lState];
                                    int currentScale = this.oScale[start][end][pState] + this.iScale[split][end][rState];
                                    if (leftScale != (currentScale = ScalingTools.scaleArray(this.scoresToAdd, currentScale))) {
                                        if (leftScale == Integer.MIN_VALUE) {
                                            this.oScale[start][split][lState] = currentScale;
                                        } else {
                                            newScale = Math.max(currentScale, leftScale);
                                            ScalingTools.scaleArrayToScale(this.scoresToAdd, currentScale, newScale);
                                            ScalingTools.scaleArrayToScale(this.oScore[start][split][lState], leftScale, newScale);
                                            this.oScale[start][split][lState] = newScale;
                                        }
                                    }
                                    for (cp = 0; cp < nLeftChildStates; ++cp) {
                                        if (!(this.scoresToAdd[cp] > initVal)) continue;
                                        double[] dArray = this.oScore[start][split][lState];
                                        int n = cp;
                                        dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                    }
                                    Arrays.fill(this.scoresToAdd, 0.0);
                                }
                                if (DoubleArrays.max(this.unscaledScoresToAdd) == 0.0) continue;
                                int rightScale = this.oScale[split][end][rState];
                                int currentScale = this.oScale[start][end][pState] + this.iScale[start][split][lState];
                                if (rightScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                    if (rightScale == Integer.MIN_VALUE) {
                                        this.oScale[split][end][rState] = currentScale;
                                    } else {
                                        newScale = Math.max(currentScale, rightScale);
                                        ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                        ScalingTools.scaleArrayToScale(this.oScore[split][end][rState], rightScale, newScale);
                                        this.oScale[split][end][rState] = newScale;
                                    }
                                }
                                for (cp = 0; cp < nRightChildStates; ++cp) {
                                    if (!(this.unscaledScoresToAdd[cp] > initVal)) continue;
                                    double[] dArray = this.oScore[split][end][rState];
                                    int n = cp;
                                    dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                                }
                                Arrays.fill(this.unscaledScoresToAdd, 0.0);
                            }
                        }
                    }
                }
                ++start;
            }
        }
    }

    @Override
    protected void setupScaling() {
        int end;
        int start;
        this.iScale = new int[this.length][this.length + 1][];
        this.oScale = new int[this.length][this.length + 1][];
        for (start = 0; start < this.length; ++start) {
            for (end = start + 1; end <= this.length; ++end) {
                this.iScale[start][end] = new int[this.numStates];
                this.oScale[start][end] = new int[this.numStates];
                Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
            }
        }
        for (start = 0; start < this.length; ++start) {
            for (end = start + 1; end <= this.length; ++end) {
                for (int state = 0; state < this.numStates; ++state) {
                    if (!this.allowedStates[start][end][state]) continue;
                    Arrays.fill(this.iScore[start][end][state], 0.0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object call() {
        Tree<String> parse = this.getBestParse(this.nextSentence);
        this.nextSentence = null;
        ArrayList<Tree<String>> result = new ArrayList<Tree<String>>();
        result.add(parse);
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.add(result, -this.nextSentenceID);
            this.queue.notifyAll();
        }
        return null;
    }

    @Override
    public double getSentenceProbability(int start, int end, boolean sumScores) {
        double score = 0.0;
        if (sumScores) {
            System.err.println("Not implemented (getSentenceProbability).");
            System.exit(-1);
        } else {
            score = this.iScore[start][end + 1][0][0];
        }
        return Math.log(score);
    }

    @Override
    public boolean[][][] getAllowedStates() {
        return this.allowedStates;
    }

    @Override
    public boolean[][][][] getAllowedSubStates() {
        return this.allowedSubStates;
    }

    @Override
    public void dumpPosteriors(String fileName, int blockSize) {
        if (this.posteriorsToDump == null && blockSize > 0) {
            this.posteriorsToDump = new ArrayList<Posterior>(blockSize);
        }
        if (this.posteriorsToDump.size() == blockSize || blockSize == -1) {
            fileName = fileName + "." + this.nThBlock++;
            try {
                ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(fileName)));
                out.writeObject(this.posteriorsToDump);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                System.out.println("IOException: " + e);
            }
            if (blockSize == -1) {
                return;
            }
            this.posteriorsToDump = new ArrayList<Posterior>(blockSize);
        }
        Posterior posterior = new Posterior(this.iScore, this.oScore, this.iScale, this.oScale, this.allowedStates);
        this.posteriorsToDump.add(posterior);
    }

    private void doCombinedMaxCScores(List<String> sentence, boolean scale) {
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        ArrayUtil.fill(this.maxcScore, Double.NEGATIVE_INFINITY);
        if (scale) {
            System.out.println("Using scaling code");
        }
        double[] logNormalizer = new double[this.nGrammars];
        for (int i = 0; i < this.nGrammars; ++i) {
            logNormalizer[i] = this.all_iScores.get(i)[0][this.length][0][0];
        }
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    for (short pState = 0; pState < this.numStates; pState = (short)((short)(pState + 1))) {
                        if (!this.allowedStates[start][end][pState]) continue;
                        BinaryRule[] parentRules = this.grammars[0].splitRulesWithP(pState);
                        for (int i = 0; i < parentRules.length; ++i) {
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            double scoreToBeat = this.maxcScore[start][end][pState];
                            for (int split = start + 1; split <= end - 1; ++split) {
                                double gScore;
                                if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                                double leftChildScore = this.maxcScore[start][split][lState];
                                double rightChildScore = this.maxcScore[split][end][rState];
                                if (leftChildScore == Double.NEGATIVE_INFINITY || rightChildScore == Double.NEGATIVE_INFINITY) continue;
                                double scalingFactor = 0.0;
                                if (scale) {
                                    for (int gr = 0; gr < this.nGrammars; ++gr) {
                                        if (this.all_oScales.get(gr) == null) continue;
                                        scalingFactor += (double)(this.all_oScales.get(gr)[start][end][pState] + this.all_iScales.get(gr)[start][split][lState] + this.all_iScales.get(gr)[split][end][rState] - this.all_iScales.get(gr)[0][this.length][0]);
                                    }
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(scalingFactor));
                                }
                                if ((gScore = leftChildScore + scalingFactor + rightChildScore) < scoreToBeat) continue;
                                for (int gr = 0; gr < this.nGrammars; ++gr) {
                                    double ruleScore = 0.0;
                                    BinaryRule rule = this.grammars[gr].getBinaryRule(pState, lState, rState);
                                    if (rule == null) {
                                        System.err.println("Dont have rule " + (String)this.tagNumberer.object(pState) + " -> " + (String)this.tagNumberer.object(lState) + " " + (String)this.tagNumberer.object(rState) + " in grammar " + gr);
                                        continue;
                                    }
                                    double[][][] scores = rule.getScores2();
                                    int nParentStates = this.numSubStates[gr][pState];
                                    int nLeftChildStates = this.numSubStates[gr][lState];
                                    int nRightChildStates = this.numSubStates[gr][rState];
                                    for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                        double lIS = this.all_iScores.get(gr)[start][split][lState][lp];
                                        if (lIS == 0.0) continue;
                                        for (int rp = 0; rp < nRightChildStates; ++rp) {
                                            double rIS;
                                            if (scores[lp][rp] == null || (rIS = this.all_iScores.get(gr)[split][end][rState][rp]) == 0.0) continue;
                                            for (int np = 0; np < nParentStates; ++np) {
                                                double ruleS;
                                                double pOS = this.all_oScores.get(gr)[start][end][pState][np];
                                                if (pOS == 0.0 || (ruleS = scores[lp][rp][np]) == 0.0) continue;
                                                ruleScore += pOS * ruleS * lIS * rIS / logNormalizer[gr];
                                            }
                                        }
                                    }
                                    gScore += Math.log(ruleScore);
                                }
                                if (!(gScore > scoreToBeat)) continue;
                                scoreToBeat = gScore;
                                this.maxcScore[start][end][pState] = gScore;
                                this.maxcSplit[start][end][pState] = split;
                                this.maxcLeftChild[start][end][pState] = lState;
                                this.maxcRightChild[start][end][pState] = rState;
                            }
                        }
                    }
                } else {
                    for (int tag = 0; tag < this.numStates; ++tag) {
                        if (!this.allowedStates[start][end][tag]) continue;
                        String word = sentence.get(start);
                        if (this.grammarTags[tag]) continue;
                        double lexiconScores = 0.0;
                        for (int gr = 0; gr < this.nGrammars; ++gr) {
                            if (this.all_oScores.get(gr)[start][end][tag] == null) {
                                System.err.println("Grammar " + gr + " is missing scores for tag " + tag + " " + this.tagNumberer.object(tag));
                                System.err.println("Start " + start);
                                System.err.println("End " + end);
                                System.err.println("Tag " + tag);
                                continue;
                            }
                            double ruleScore = 0.0;
                            double[] lexiconScoreArray = this.lexicons[gr].score(word, (short)tag, start, false, false);
                            for (int tp = 0; tp < this.numSubStates[gr][tag]; ++tp) {
                                double pOS = this.all_oScores.get(gr)[start][end][tag][tp];
                                double ruleS = lexiconScoreArray[tp];
                                ruleScore += pOS * ruleS / logNormalizer[gr];
                            }
                            lexiconScores += Math.log(ruleScore);
                        }
                        double scalingFactor = 0.0;
                        if (scale) {
                            for (int gr = 0; gr < this.nGrammars; ++gr) {
                                try {
                                    if (this.all_oScales.get(gr) == null) continue;
                                    scalingFactor += (double)(this.all_oScales.get(gr)[start][end][tag] - this.all_iScales.get(gr)[0][this.length][0]);
                                    continue;
                                }
                                catch (Exception e) {
                                    System.err.println("Start " + start);
                                    System.err.println("End " + end);
                                    System.err.println("Length " + this.length);
                                    System.err.println("Tag " + tag);
                                    System.err.println("Grammar " + gr);
                                }
                            }
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(scalingFactor));
                        }
                        this.maxcScore[start][end][tag] = lexiconScores + scalingFactor;
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                for (int i = 0; i < this.numStates; ++i) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                }
                for (short pState = 0; pState < this.numStates; pState = (short)((short)(pState + 1))) {
                    if (!this.allowedStates[start][end][pState]) continue;
                    UnaryRule[] unaries = this.grammars[0].getClosedSumUnaryRulesByParent(pState);
                    for (int r = 0; r < unaries.length; ++r) {
                        double gScore;
                        double childScore;
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || !this.allowedStates[start][end][cState] || (childScore = this.maxcScore[start][end][cState]) == Double.NEGATIVE_INFINITY) continue;
                        double scalingFactor = 0.0;
                        if (scale) {
                            for (int gr = 0; gr < this.nGrammars; ++gr) {
                                if (this.all_oScales.get(gr) == null) continue;
                                scalingFactor += (double)(this.all_oScales.get(gr)[start][end][pState] + this.all_iScales.get(gr)[start][end][cState] - this.all_iScales.get(gr)[0][this.length][0]);
                            }
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(scalingFactor));
                        }
                        if ((gScore = scalingFactor + childScore) < maxcScoreStartEnd[pState]) continue;
                        for (int gr = 0; gr < this.nGrammars; ++gr) {
                            double ruleScore = 0.0;
                            UnaryRule rule = this.grammars[gr].getUnaryRule(pState, cState);
                            if (rule == null) {
                                System.err.println("Dont have rule " + (String)this.tagNumberer.object(pState) + " -> " + (String)this.tagNumberer.object(cState) + " in grammar " + gr);
                                continue;
                            }
                            double[][] scores = rule.getScores2();
                            int nChildStates = this.numSubStates[gr][cState];
                            int nParentStates = this.numSubStates[gr][pState];
                            for (int cp = 0; cp < nChildStates; ++cp) {
                                double cIS = this.all_iScores.get(gr)[start][end][cState][cp];
                                if (cIS == 0.0 || scores[cp] == null) continue;
                                if (this.all_oScores.get(gr)[start][end][pState] == null) {
                                    System.err.println("Missing oScore for grammar " + gr + " " + this.tagNumberer.object(pState));
                                    System.err.println("Start " + start);
                                    System.err.println("End " + end);
                                    System.err.println("Tag " + pState);
                                    System.err.println("allowed: " + this.allowedStates[start][end][pState]);
                                    if (this.all_iScores.get(gr)[start][end][pState] == null) continue;
                                    System.err.println("Have iScore");
                                    continue;
                                }
                                for (int np = 0; np < nParentStates; ++np) {
                                    double ruleS;
                                    double pOS = this.all_oScores.get(gr)[start][end][pState][np];
                                    if (pOS < 0.0 || (ruleS = scores[cp][np]) == 0.0) continue;
                                    ruleScore += pOS * ruleS * cIS / logNormalizer[gr];
                                }
                            }
                            gScore += Math.log(ruleScore);
                        }
                        if (!(gScore > maxcScoreStartEnd[pState])) continue;
                        maxcScoreStartEnd[pState] = gScore;
                        this.maxcChild[start][end][pState] = cState;
                    }
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
            }
        }
    }
}

