/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseToFineTwoChartsParser
extends CoarseToFineMaxRuleParser {
    protected double[][][][] iScorePreU;
    protected double[][][][] iScorePostU;
    protected double[][][][] oScorePreU;
    protected double[][][][] oScorePostU;

    public CoarseToFineTwoChartsParser(Grammar gr, Lexicon lex, double unaryPenalty, int endL, boolean viterbi, boolean sub, boolean score, boolean accurate) {
        super(gr, lex, unaryPenalty, endL, viterbi, sub, score, accurate, false, false, true);
    }

    @Override
    void doConstrainedInsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        if (!viterbi && logScores) {
            throw new Error("This would require logAdds and is slow. Exponentiate the scores instead.");
        }
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int nParentStates;
                int pState;
                int end = start + diff;
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (diff == 1 || this.allowedSubStates[start][end][pState] == null) continue;
                    BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                    nParentStates = this.numSubStatesArray[pState];
                    Arrays.fill(this.scoresToAdd, initVal);
                    boolean somethingChanged = false;
                    for (int i = 0; i < parentRules.length; ++i) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        BinaryRule r = parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        double[][][] scores = r.getScores2();
                        int nLeftChildStates = this.numSubStatesArray[lState];
                        int nRightChildStates = this.numSubStatesArray[rState];
                        for (int split = min; split <= max; ++split) {
                            if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null) continue;
                            for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                double lS = this.iScorePostU[start][split][lState][lp];
                                if (lS == initVal) continue;
                                for (int rp = 0; rp < nRightChildStates; ++rp) {
                                    double rS;
                                    if (scores[lp][rp] == null || (rS = this.iScorePostU[split][end][rState][rp]) == initVal) continue;
                                    for (int np = 0; np < nParentStates; ++np) {
                                        double thisRound;
                                        double pS;
                                        if (!this.allowedSubStates[start][end][pState][np] || (pS = scores[lp][rp][np]) == initVal) continue;
                                        double d = thisRound = logScores ? pS + lS + rS : pS * lS * rS;
                                        if (viterbi) {
                                            this.scoresToAdd[np] = Math.max(thisRound, this.scoresToAdd[np]);
                                        } else {
                                            int n3 = np;
                                            this.scoresToAdd[n3] = this.scoresToAdd[n3] + thisRound;
                                        }
                                        somethingChanged = true;
                                    }
                                }
                            }
                        }
                    }
                    if (!somethingChanged) continue;
                    for (int np = 0; np < nParentStates; ++np) {
                        if (!(this.scoresToAdd[np] > initVal)) continue;
                        this.iScorePreU[start][end][pState][np] = this.scoresToAdd[np];
                    }
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (this.allowedSubStates[start][end][pState] == null) continue;
                    UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                    nParentStates = this.numSubStatesArray[pState];
                    boolean firstTime = true;
                    boolean somethingChanged = false;
                    for (int r = 0; r < unaries.length; ++r) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.iScorePreU[start][end][cState] == null) continue;
                        double[][] scores = ur.getScores2();
                        int nChildStates = this.numSubStatesArray[cState];
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double iS;
                            if (scores[cp] == null || (iS = this.iScorePreU[start][end][cState][cp]) == initVal) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double thisRound;
                                double pS;
                                if (!this.allowedSubStates[start][end][pState][np] || (pS = scores[cp][np]) == initVal) continue;
                                if (firstTime) {
                                    firstTime = false;
                                    Arrays.fill(this.scoresToAdd, initVal);
                                }
                                double d = thisRound = logScores ? iS + pS : iS * pS;
                                if (viterbi) {
                                    this.scoresToAdd[np] = Math.max(thisRound, this.scoresToAdd[np]);
                                } else {
                                    int n = np;
                                    this.scoresToAdd[n] = this.scoresToAdd[n] + thisRound;
                                }
                                somethingChanged = true;
                            }
                        }
                    }
                    if (!somethingChanged) {
                        this.iScorePostU[start][end][pState] = (double[])this.iScorePreU[start][end][pState].clone();
                        continue;
                    }
                    for (int np = 0; np < nParentStates; ++np) {
                        if (this.scoresToAdd[np] > initVal) {
                            if (viterbi) {
                                this.iScorePostU[start][end][pState][np] = Math.max(this.iScorePreU[start][end][pState][np], this.scoresToAdd[np]);
                                continue;
                            }
                            this.iScorePostU[start][end][pState][np] = this.iScorePreU[start][end][pState][np] + this.scoresToAdd[np];
                            continue;
                        }
                        this.iScorePostU[start][end][pState][np] = this.iScorePreU[start][end][pState][np];
                    }
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
            }
        }
    }

    @Override
    void doConstrainedOutsideScores(Grammar grammar, boolean viterbi, boolean logScores) {
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = logScores ? Double.NEGATIVE_INFINITY : 0.0;
        for (int diff = this.length; diff >= 1; --diff) {
            int start = 0;
            while (start + diff <= this.length) {
                int pState;
                int end = start + diff;
                boolean somethingChanged = false;
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (this.oScorePreU[start][end][pState] == null) continue;
                    UnaryRule[] rules = grammar.getClosedSumUnaryRulesByParent(pState);
                    for (int r = 0; r < rules.length; ++r) {
                        int cp;
                        UnaryRule ur = rules[r];
                        short cState = ur.childState;
                        if (pState == cState || this.oScorePreU[start][end][cState] == null) continue;
                        double[][] scores = ur.getScores2();
                        int nParentStates = this.numSubStatesArray[pState];
                        int nChildStates = scores.length;
                        boolean firstTime = true;
                        for (cp = 0; cp < nChildStates; ++cp) {
                            if (scores[cp] == null || !this.allowedSubStates[start][end][cState][cp]) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double thisRound;
                                double oS;
                                double pS = scores[cp][np];
                                if (pS == initVal || (oS = this.oScorePreU[start][end][pState][np]) == initVal) continue;
                                double d = thisRound = logScores ? oS + pS : oS * pS;
                                if (firstTime) {
                                    firstTime = false;
                                    Arrays.fill(this.scoresToAdd, initVal);
                                }
                                if (viterbi) {
                                    this.scoresToAdd[cp] = Math.max(thisRound, this.scoresToAdd[cp]);
                                } else {
                                    int n = cp;
                                    this.scoresToAdd[n] = this.scoresToAdd[n] + thisRound;
                                }
                                somethingChanged = true;
                            }
                        }
                        if (!somethingChanged) continue;
                        for (cp = 0; cp < nChildStates; ++cp) {
                            if (!(this.scoresToAdd[cp] > initVal)) continue;
                            if (viterbi) {
                                this.oScorePostU[start][end][cState][cp] = Math.max(this.oScorePostU[start][end][cState][cp], this.scoresToAdd[cp]);
                                continue;
                            }
                            double[] dArray = this.oScorePostU[start][end][cState];
                            int n = cp;
                            dArray[n] = dArray[n] + this.scoresToAdd[cp];
                        }
                    }
                }
                for (int cState = 0; cState < this.numSubStatesArray.length; ++cState) {
                    if (this.oScorePostU[start][end][cState] == null) continue;
                    for (int cp = 0; cp < this.numSubStatesArray[cState]; ++cp) {
                        if (viterbi) {
                            this.oScorePostU[start][end][cState][cp] = Math.max(this.oScorePostU[start][end][cState][cp], this.oScorePreU[start][end][cState][cp]);
                            continue;
                        }
                        double[] dArray = this.oScorePostU[start][end][cState];
                        int n = cp;
                        dArray[n] = dArray[n] + this.oScorePreU[start][end][cState][cp];
                    }
                }
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (this.oScorePostU[start][end][pState] == null) continue;
                    int nParentChildStates = this.numSubStatesArray[pState];
                    BinaryRule[] rules = grammar.splitRulesWithP(pState);
                    for (int r = 0; r < rules.length; ++r) {
                        short rState;
                        int max1;
                        BinaryRule br = rules[r];
                        short lState = br.leftChildState;
                        int min1 = this.narrowRExtent[start][lState];
                        if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) continue;
                        int max = max1;
                        int min = min1;
                        if (max - min > 2) {
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (max1 < min) continue;
                            int max2 = this.wideRExtent[start][lState];
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (max < min) continue;
                        }
                        double[][][] scores = br.getScores2();
                        int nLeftChildStates = this.numSubStatesArray[lState];
                        int nRightChildStates = this.numSubStatesArray[rState];
                        for (int split = min; split <= max; ++split) {
                            int cp;
                            if (this.oScorePreU[start][split][lState] == null || this.oScorePreU[split][end][rState] == null) continue;
                            double[] rightScores = new double[nRightChildStates];
                            Arrays.fill(this.scoresToAdd, initVal);
                            Arrays.fill(rightScores, initVal);
                            somethingChanged = false;
                            for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                double lS = this.iScorePostU[start][split][lState][lp];
                                if (lS == initVal) continue;
                                for (int rp = 0; rp < nRightChildStates; ++rp) {
                                    double rS;
                                    if (scores[lp][rp] == null || (rS = this.iScorePostU[split][end][rState][rp]) == initVal) continue;
                                    for (int np = 0; np < nParentChildStates; ++np) {
                                        double thisRoundR;
                                        double oS;
                                        double pS = scores[lp][rp][np];
                                        if (pS == initVal || (oS = this.oScorePostU[start][end][pState][np]) == initVal) continue;
                                        double thisRoundL = logScores ? pS + rS + oS : pS * rS * oS;
                                        double d = thisRoundR = logScores ? pS + lS + oS : pS * lS * oS;
                                        if (viterbi) {
                                            this.scoresToAdd[lp] = Math.max(thisRoundL, this.scoresToAdd[lp]);
                                            rightScores[rp] = Math.max(thisRoundR, rightScores[rp]);
                                        } else {
                                            int n = lp;
                                            this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                            int n3 = rp;
                                            rightScores[n3] = rightScores[n3] + thisRoundR;
                                        }
                                        somethingChanged = true;
                                    }
                                }
                            }
                            if (!somethingChanged) continue;
                            for (cp = 0; cp < nLeftChildStates; ++cp) {
                                if (!(this.scoresToAdd[cp] > initVal)) continue;
                                if (viterbi) {
                                    this.oScorePreU[start][split][lState][cp] = Math.max(this.oScorePreU[start][split][lState][cp], this.scoresToAdd[cp]);
                                    continue;
                                }
                                double[] dArray = this.oScorePreU[start][split][lState];
                                int n = cp;
                                dArray[n] = dArray[n] + this.scoresToAdd[cp];
                            }
                            for (cp = 0; cp < nRightChildStates; ++cp) {
                                if (!(rightScores[cp] > initVal)) continue;
                                if (viterbi) {
                                    this.oScorePreU[split][end][rState][cp] = Math.max(this.oScorePreU[split][end][rState][cp], rightScores[cp]);
                                    continue;
                                }
                                double[] dArray = this.oScorePreU[split][end][rState];
                                int n = cp;
                                dArray[n] = dArray[n] + rightScores[cp];
                            }
                        }
                    }
                }
                ++start;
            }
        }
    }

    void initializeChart(List<String> sentence, Lexicon lexicon, boolean noSubstates, boolean noSmoothing) {
        int start = 0;
        int end = start + 1;
        for (String word : sentence) {
            end = start + 1;
            for (int tag = 0; tag < this.numSubStatesArray.length; ++tag) {
                if (!noSubstates && this.allowedSubStates[start][end][tag] == null || this.grammarTags[tag]) continue;
                this.narrowRExtent[start][tag] = end;
                this.narrowLExtent[end][tag] = start;
                this.wideRExtent[start][tag] = end;
                this.wideLExtent[end][tag] = start;
                double[] lexiconScores = lexicon.score(word, (short)tag, start, noSmoothing, false);
                for (int n = 0; n < lexiconScores.length; n = (int)((short)(n + 1))) {
                    double prob = lexiconScores[n];
                    if (noSubstates) {
                        this.viScore[start][end][tag] = prob;
                        continue;
                    }
                    this.iScorePreU[start][end][tag][n] = prob;
                }
            }
            ++start;
        }
    }

    @Override
    protected void createArrays(boolean firstTime, int numStates, short[] numSubStatesArray, int level, double initVal, boolean justInit) {
        if (firstTime) {
            this.viScore = new double[this.length][this.length + 1][];
            this.voScore = new double[this.length][this.length + 1][];
            this.iScorePreU = new double[this.length][this.length + 1][][];
            this.iScorePostU = new double[this.length][this.length + 1][][];
            this.oScorePreU = new double[this.length][this.length + 1][][];
            this.oScorePostU = new double[this.length][this.length + 1][][];
            this.allowedSubStates = new boolean[this.length][this.length + 1][][];
            this.allowedStates = new boolean[this.length][this.length + 1][];
            this.vAllowedStates = new boolean[this.length][this.length + 1];
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                if (firstTime) {
                    this.viScore[start][end] = new double[numStates];
                    this.voScore[start][end] = new double[numStates];
                    this.iScorePreU[start][end] = new double[numStates][];
                    this.iScorePostU[start][end] = new double[numStates][];
                    this.oScorePreU[start][end] = new double[numStates][];
                    this.oScorePostU[start][end] = new double[numStates][];
                    this.allowedSubStates[start][end] = new boolean[numStates][];
                    this.allowedStates[start][end] = (boolean[])this.grammarTags.clone();
                    if (level == 1 && end - start == 1) {
                        Arrays.fill(this.allowedStates[start][end], true);
                    }
                    this.vAllowedStates[start][end] = true;
                }
                for (int state = 0; state < numSubStatesArray.length; ++state) {
                    if (this.allowedSubStates[start][end][state] != null) {
                        if (level < 1) {
                            this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                            this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                            continue;
                        }
                        this.iScorePreU[start][end][state] = new double[numSubStatesArray[state]];
                        this.iScorePostU[start][end][state] = new double[numSubStatesArray[state]];
                        this.oScorePreU[start][end][state] = new double[numSubStatesArray[state]];
                        this.oScorePostU[start][end][state] = new double[numSubStatesArray[state]];
                        Arrays.fill(this.iScorePreU[start][end][state], initVal);
                        Arrays.fill(this.iScorePostU[start][end][state], initVal);
                        Arrays.fill(this.oScorePreU[start][end][state], initVal);
                        Arrays.fill(this.oScorePostU[start][end][state], initVal);
                        continue;
                    }
                    if (level < 1) {
                        this.viScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        this.voScore[start][end][state] = Double.NEGATIVE_INFINITY;
                        continue;
                    }
                    this.iScorePreU[start][end][state] = null;
                    this.iScorePostU[start][end][state] = null;
                    this.oScorePreU[start][end][state] = null;
                    this.oScorePostU[start][end][state] = null;
                }
                if (level <= 0 || start != 0 || end != this.length || this.iScorePostU[start][end][0] != null) continue;
                System.out.println("ROOT does not span the entire tree!");
            }
        }
        this.narrowRExtent = new int[this.length + 1][numStates];
        this.wideRExtent = new int[this.length + 1][numStates];
        this.narrowLExtent = new int[this.length + 1][numStates];
        this.wideLExtent = new int[this.length + 1][numStates];
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
    }

    @Override
    protected void clearArrays() {
        this.oScorePostU = null;
        this.oScorePreU = this.oScorePostU;
        this.iScorePostU = this.oScorePostU;
        this.iScorePreU = this.oScorePostU;
        this.voScore = null;
        this.viScore = this.voScore;
        this.allowedSubStates = null;
        this.vAllowedStates = null;
        this.wideLExtent = null;
        this.narrowLExtent = this.wideLExtent;
        this.wideRExtent = this.wideLExtent;
        this.narrowRExtent = this.wideLExtent;
    }

    public void doPreParses(List<String> sentence, Tree<StateSet> tree, boolean noSmoothing) {
        boolean keepGoldAlive = tree != null;
        this.clearArrays();
        this.length = (short)sentence.size();
        double score = 0.0;
        Grammar curGrammar = null;
        Lexicon curLexicon = null;
        double[] accurateThresholds = new double[]{-8.0, -12.0, -12.0, -11.0, -12.0, -12.0, -14.0};
        double[] fastThresholds = new double[]{-8.0, -9.75, -10.0, -9.6, -9.66, -8.01, -7.4, -10.0};
        double[] pruningThreshold = null;
        pruningThreshold = this.accurate ? accurateThresholds : fastThresholds;
        for (int level = this.startLevel; level < this.endLevel; ++level) {
            if (level == -1 || !this.isBaseline && level == this.endLevel) continue;
            curGrammar = this.grammarCascade[level - this.startLevel];
            curLexicon = this.lexiconCascade[level - this.startLevel];
            this.createArrays(level == 0, curGrammar.numStates, curGrammar.numSubStates, level, Double.NEGATIVE_INFINITY, false);
            this.initializeChart(sentence, curLexicon, level < 1, noSmoothing);
            boolean viterbi = true;
            boolean logScores = true;
            if (level < 1) {
                this.doConstrainedViterbiInsideScores(curGrammar, level == this.startLevel);
                score = this.viScore[0][this.length][0];
            } else {
                this.doConstrainedInsideScores(curGrammar, true, true);
                score = this.iScorePostU[0][this.length][0][0];
            }
            if (score == Double.NEGATIVE_INFINITY) continue;
            if (level < 1) {
                this.voScore[0][this.length][0] = 0.0;
                this.doConstrainedViterbiOutsideScores(curGrammar, level == this.startLevel);
            } else {
                this.oScorePreU[0][this.length][0][0] = 0.0;
                this.doConstrainedOutsideScores(curGrammar, true, true);
            }
            this.pruneChart(Double.NEGATIVE_INFINITY, curGrammar.numSubStates, level);
        }
    }

    public Tree<String> getBestConstrainedParse(List<String> sentence, List<Integer>[][] pStates) {
        this.doPreParses(sentence, null, false);
        this.bestTree = new Tree<String>("ROOT");
        double score = 0.0;
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        this.grammar = curGrammar;
        this.lexicon = curLexicon;
        double initVal = this.viterbiParse ? Double.NEGATIVE_INFINITY : 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(false, curGrammar.numStates, curGrammar.numSubStates, level, initVal, !this.isBaseline);
        this.initializeChart(sentence, curLexicon, false, false);
        this.doConstrainedInsideScores(curGrammar, this.viterbiParse, false);
        score = this.iScorePostU[0][this.length][0][0];
        if (!this.viterbiParse) {
            score = Math.log(score);
        }
        this.logLikelihood = score;
        if (score != Double.NEGATIVE_INFINITY) {
            if (!this.viterbiParse) {
                this.oScorePreU[0][this.length][0][0] = 1.0;
                this.doConstrainedOutsideScores(curGrammar, this.viterbiParse, false);
                this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, false);
            }
            this.bestTree = this.viterbiParse ? this.extractBestViterbiParse(0, 0, 0, this.length, sentence) : this.extractBestMaxRuleParse(0, this.length, sentence);
        }
        this.maxcScore = null;
        this.maxcSplit = null;
        this.maxcChild = null;
        this.maxcLeftChild = null;
        this.maxcRightChild = null;
        return this.bestTree;
    }

    void doConstrainedMaxCScores(List<String> sentence, Grammar grammar, SophisticatedLexicon lexicon) {
        this.numSubStatesArray = grammar.numSubStates;
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        double threshold = 0.01;
        double logNormalizer = this.iScorePostU[0][this.length][0][0];
        double thresh2 = threshold * logNormalizer;
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                        if (this.oScorePostU[start][end][pState] == null) continue;
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        int nParentStates = this.numSubStatesArray[pState];
                        for (int i = 0; i < parentRules.length; ++i) {
                            int max;
                            int min;
                            boolean iPossibleR;
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (!iPossibleL) continue;
                            int narrowL = this.narrowLExtent[end][rState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (!iPossibleR) continue;
                            int min1 = narrowR;
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (min > narrowL) continue;
                            int max1 = this.wideRExtent[start][lState];
                            int max2 = narrowL;
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (min > max) continue;
                            double[][][] scores = r.getScores2();
                            int nLeftChildStates = this.numSubStatesArray[lState];
                            int nRightChildStates = this.numSubStatesArray[rState];
                            for (int split = min; split <= max; ++split) {
                                double ruleScore = 0.0;
                                if (this.iScorePostU[start][split][lState] == null || this.iScorePostU[split][end][rState] == null) continue;
                                for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                    double lIS = this.iScorePostU[start][split][lState][lp];
                                    if (lIS < thresh2) continue;
                                    for (int rp = 0; rp < nRightChildStates; ++rp) {
                                        double rIS;
                                        if (scores[lp][rp] == null || (rIS = this.iScorePostU[split][end][rState][rp]) < thresh2) continue;
                                        for (int np = 0; np < nParentStates; ++np) {
                                            double ruleS;
                                            double pOS = this.oScorePostU[start][end][pState][np];
                                            if (pOS < thresh2 || (ruleS = scores[lp][rp][np]) == 0.0) continue;
                                            ruleScore += pOS * ruleS * lIS * rIS / logNormalizer;
                                        }
                                    }
                                }
                                double leftChildScore = this.maxcScore[start][split][lState];
                                double rightChildScore = this.maxcScore[split][end][rState];
                                double scale = 1.0;
                                double gScore = ruleScore * leftChildScore * rightChildScore * scale;
                                if (!(gScore > this.maxcScore[start][end][pState])) continue;
                                this.maxcScore[start][end][pState] = gScore;
                                this.maxcSplit[start][end][pState] = split;
                                this.maxcLeftChild[start][end][pState] = lState;
                                this.maxcRightChild[start][end][pState] = rState;
                            }
                        }
                    }
                } else {
                    for (int tag = 0; tag < this.numSubStatesArray.length; ++tag) {
                        if (this.allowedSubStates[start][end][tag] == null) continue;
                        int nTagStates = this.numSubStatesArray[tag];
                        String word = sentence.get(start);
                        if (grammar.isGrammarTag(tag)) continue;
                        double[] lexiconScoreArray = lexicon.score(word, (short)tag, start, false, false);
                        double lexiconScores = 0.0;
                        for (int tp = 0; tp < nTagStates; ++tp) {
                            double pOS = this.oScorePostU[start][end][tag][tp];
                            if (pOS < thresh2) continue;
                            double ruleS = lexiconScoreArray[tp];
                            lexiconScores += pOS * ruleS / logNormalizer;
                        }
                        double scale = 1.0;
                        this.maxcScore[start][end][tag] = lexiconScores * scale;
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                for (int i = 0; i < this.numStates; ++i) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                }
                for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (this.oScorePostU[start][end][pState] == null) continue;
                    UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                    int nParentStates = this.numSubStatesArray[pState];
                    for (int r = 0; r < unaries.length; ++r) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.iScorePostU[start][end][cState] == null) continue;
                        double[][] scores = ur.getScores2();
                        int nChildStates = this.numSubStatesArray[cState];
                        double ruleScore = 0.0;
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double cIS = this.iScorePreU[start][end][cState][cp];
                            if (cIS < thresh2 || scores[cp] == null) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double ruleS;
                                double pOS = this.oScorePreU[start][end][pState][np];
                                if (pOS < thresh2 || (ruleS = scores[cp][np]) == 0.0) continue;
                                ruleScore += pOS * ruleS * cIS / logNormalizer;
                            }
                        }
                        double childScore = this.maxcScore[start][end][cState];
                        double scale = 1.0;
                        double gScore = ruleScore / this.unaryPenalty * childScore * scale;
                        if (!(gScore > maxcScoreStartEnd[pState])) continue;
                        maxcScoreStartEnd[pState] = gScore;
                        this.maxcChild[start][end][pState] = cState;
                    }
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
            }
        }
    }

    public double doInsideOutsideScores(List<String> sentence, Tree<StateSet> tree) {
        boolean noSmoothing = true;
        this.doPreParses(sentence, tree, true);
        this.length = (short)sentence.size();
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        double initVal = 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(this.isBaseline, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.initializeChart(sentence, curLexicon, false, true);
        this.doConstrainedInsideScores(curGrammar, false, false);
        this.logLikelihood = Math.log(this.iScorePostU[0][this.length][0][0]);
        this.oScorePreU[0][this.length][0][0] = 1.0;
        this.doConstrainedOutsideScores(curGrammar, false, false);
        return this.logLikelihood;
    }

    public double doConstrainedInsideOutsideScores(List<String> sentence, boolean[][][][] cons) {
        boolean noSmoothing = true;
        this.clearArrays();
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        this.numSubStatesArray = curGrammar.numSubStates;
        this.length = (short)sentence.size();
        this.setConstraints(cons);
        double initVal = 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(true, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.initializeChart(sentence, curLexicon, false, true);
        this.doConstrainedInsideScores(curGrammar, false, false);
        this.logLikelihood = Math.log(this.iScorePostU[0][this.length][0][0]);
        this.oScorePreU[0][this.length][0][0] = 1.0;
        this.doConstrainedOutsideScores(curGrammar, false, false);
        return this.logLikelihood;
    }

    @Override
    protected void pruneChart(double threshold, short[] numSubStatesArray, int level) {
        int startDiff;
        double sentenceProb;
        int totalStates = 0;
        int previouslyPossible = 0;
        int nowPossible = 0;
        double d = sentenceProb = level < 1 ? this.viScore[0][this.length][0] : this.iScorePostU[0][this.length][0][0];
        if (level < 1) {
            totalStates = previouslyPossible = this.length;
            nowPossible = previouslyPossible;
        }
        for (int diff = startDiff = level < 0 ? 2 : 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                int lastState = level < 0 ? 1 : numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    if (diff > 1 && !this.grammarTags[state]) continue;
                    if (level == 0) {
                        if (!this.vAllowedStates[start][end]) {
                            this.allowedSubStates[start][end][state] = null;
                            ++totalStates;
                            continue;
                        }
                    } else if (level > 0) {
                        // empty if block
                    }
                    if (level < 1) {
                        ++totalStates;
                        ++previouslyPossible;
                        double iS = this.viScore[start][end][state];
                        double oS = this.voScore[start][end][state];
                        if (iS == Double.NEGATIVE_INFINITY || oS == Double.NEGATIVE_INFINITY) {
                            if (level == 0) {
                                this.allowedSubStates[start][end][state] = null;
                                continue;
                            }
                            this.vAllowedStates[start][end] = false;
                            continue;
                        }
                        double posterior = iS + oS - sentenceProb;
                        if (posterior > threshold) {
                            boolean[] tmp = new boolean[numSubStatesArray[state]];
                            Arrays.fill(tmp, true);
                            if (level == 0) {
                                this.allowedSubStates[start][end][state] = tmp;
                            } else {
                                this.vAllowedStates[start][end] = true;
                            }
                            ++nowPossible;
                            continue;
                        }
                        if (level == 0) {
                            this.allowedSubStates[start][end][state] = null;
                            continue;
                        }
                        this.vAllowedStates[start][end] = false;
                        continue;
                    }
                    boolean nonePossible = true;
                    for (int substate = 0; substate < numSubStatesArray[state]; ++substate) {
                        ++totalStates;
                        if (!this.allowedSubStates[start][end][state][substate]) continue;
                        ++previouslyPossible;
                        double iS = this.iScorePostU[start][end][state][substate];
                        double oS = this.oScorePostU[start][end][state][substate];
                        if (iS == Double.NEGATIVE_INFINITY || oS == Double.NEGATIVE_INFINITY) {
                            this.allowedSubStates[start][end][state][substate] = false;
                            continue;
                        }
                        double posterior = iS + oS - sentenceProb;
                        if (posterior > threshold) {
                            this.allowedSubStates[start][end][state][substate] = true;
                            ++nowPossible;
                            nonePossible = false;
                            continue;
                        }
                        this.allowedSubStates[start][end][state][substate] = false;
                    }
                    if (!nonePossible) continue;
                    this.allowedSubStates[start][end][state] = null;
                }
            }
        }
        String parse = "";
        parse = level == -1 ? "Pre-Parse" : (level == 0 ? "X-Bar" : (int)Math.pow(2.0, level) + "-Substates");
    }

    public void incrementExpectedCounts(Linearizer linearizer, double[] probs, Grammar grammar, Lexicon lexicon, List<StateSet> sentence, boolean hardCounts, int lexiconOffset) {
        throw new Error("Currently disabled");
    }

    private void setConstraints(boolean[][][][] allowedSubStates2) {
        this.allowedSubStates = new boolean[this.length][this.length + 1][][];
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                this.allowedSubStates[start][end] = new boolean[this.numStates][];
                for (int state = 0; state < this.numStates; ++state) {
                    if (allowedSubStates2 == null) {
                        boolean[] tmp = new boolean[this.numSubStatesArray[state]];
                        Arrays.fill(tmp, true);
                        this.allowedSubStates[start][end][state] = tmp;
                        continue;
                    }
                    if (allowedSubStates2[start][end][state] == null) continue;
                    this.allowedSubStates[start][end][state] = new boolean[this.numSubStatesArray[state]];
                    for (int substate = 0; substate < allowedSubStates2[start][end][state].length; ++substate) {
                        if (!allowedSubStates2[start][end][state][substate]) continue;
                        this.allowedSubStates[start][end][state][2 * substate] = true;
                        if (state == 0) continue;
                        this.allowedSubStates[start][end][state][2 * substate + 1] = true;
                    }
                }
            }
        }
    }

    public double[][][][] getPreUnaryInsideScores() {
        return this.iScorePreU;
    }

    public double[][][][] getPostUnaryInsideScores() {
        return this.iScorePostU;
    }

    public double[][][][] getPreUnaryOutsideScores() {
        return this.oScorePreU;
    }

    public double[][][][] getPostUnaryOutsideScores() {
        return this.oScorePostU;
    }
}

