/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryCounterTable;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.UnaryCounterTable;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.CounterMap;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grammar
implements Serializable {
    public int finalLevel;
    public boolean[] isGrammarTag;
    public boolean useEntropicPrior = false;
    private List<BinaryRule>[] binaryRulesWithParent;
    private List<BinaryRule>[] binaryRulesWithLC;
    private List<BinaryRule>[] binaryRulesWithRC;
    private BinaryRule[][] splitRulesWithLC;
    private BinaryRule[][] splitRulesWithRC;
    private BinaryRule[][] splitRulesWithP;
    public List<UnaryRule>[] unaryRulesWithParent;
    public List<UnaryRule>[] unaryRulesWithC;
    private List<UnaryRule>[] sumProductClosedUnaryRulesWithParent;
    public short numStates;
    public short[] numSubStates;
    public Map<BinaryRule, BinaryRule> binaryRuleMap;
    BinaryRule bSearchRule;
    public Map<UnaryRule, UnaryRule> unaryRuleMap;
    UnaryRule uSearchRule;
    UnaryCounterTable unaryRuleCounter = null;
    BinaryCounterTable binaryRuleCounter = null;
    CounterMap<Integer, Integer> symbolCounter = new CounterMap();
    private static final long serialVersionUID = 1L;
    protected Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    public List<UnaryRule>[] closedSumRulesWithParent = null;
    public List<UnaryRule>[] closedSumRulesWithChild = null;
    public List<UnaryRule>[] closedViterbiRulesWithParent = null;
    public List<UnaryRule>[] closedViterbiRulesWithChild = null;
    public UnaryRule[][] closedSumRulesWithP = null;
    public UnaryRule[][] closedSumRulesWithC = null;
    public UnaryRule[][] closedViterbiRulesWithP = null;
    public UnaryRule[][] closedViterbiRulesWithC = null;
    private Map bestSumRulesUnderMax = null;
    private Map bestViterbiRulesUnderMax = null;
    public double threshold;
    public Smoother smoother = null;
    private int[][] closedViterbiPaths = null;
    private int[][] closedSumPaths = null;
    public boolean findClosedPaths;
    boolean logarithmMode;
    public Tree<Short>[] splitTrees;

    public void clearUnaryIntermediates() {
        ArrayUtil.fill(this.closedSumPaths, 0);
        ArrayUtil.fill(this.closedViterbiPaths, 0);
    }

    public void addBinary(BinaryRule br) {
        this.binaryRulesWithParent[br.parentState].add(br);
        this.binaryRulesWithLC[br.leftChildState].add(br);
        this.binaryRulesWithRC[br.rightChildState].add(br);
        this.binaryRuleMap.put(br, br);
    }

    public void addUnary(UnaryRule ur) {
        if (!this.unaryRulesWithParent[ur.parentState].contains(ur)) {
            this.unaryRulesWithParent[ur.parentState].add(ur);
            this.unaryRulesWithC[ur.childState].add(ur);
            this.unaryRuleMap.put(ur, ur);
        }
    }

    public Numberer getTagNumberer() {
        return this.tagNumberer;
    }

    public List<UnaryRule> getUnaryRulesByParent(int state) {
        if (state >= this.unaryRulesWithParent.length) {
            return Collections.EMPTY_LIST;
        }
        return this.unaryRulesWithParent[state];
    }

    public List<UnaryRule>[] getSumProductClosedUnaryRulesByParent() {
        return this.sumProductClosedUnaryRulesWithParent;
    }

    public List<BinaryRule> getBinaryRulesByLeftChild(int state) {
        if (state >= this.binaryRulesWithLC.length) {
            return Collections.EMPTY_LIST;
        }
        return this.binaryRulesWithLC[state];
    }

    public List<BinaryRule> getBinaryRulesByRightChild(int state) {
        if (state >= this.binaryRulesWithRC.length) {
            return Collections.EMPTY_LIST;
        }
        return this.binaryRulesWithRC[state];
    }

    public List<UnaryRule> getUnaryRulesByChild(int state) {
        if (state >= this.unaryRulesWithC.length) {
            return Collections.EMPTY_LIST;
        }
        return this.unaryRulesWithC[state];
    }

    public String toString_old() {
        return null;
    }

    public void writeData(Writer w) throws IOException {
        int state;
        this.finalLevel = (short)(Math.log(this.numSubStates[1]) / Math.log(2.0));
        PrintWriter out = new PrintWriter(w);
        for (state = 0; state < this.numStates; ++state) {
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            for (int i = 0; i < parentRules.length; ++i) {
                BinaryRule r = parentRules[i];
                out.print(r.toString());
            }
        }
        for (state = 0; state < this.numStates; ++state) {
            UnaryRule[] unaries = this.getClosedViterbiUnaryRulesByParent(state);
            for (int r = 0; r < unaries.length; ++r) {
                UnaryRule ur = unaries[r];
                out.print(ur.toString());
            }
        }
        out.flush();
    }

    public String toString() {
        int state;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> ruleStrings = new ArrayList<String>();
        for (state = 0; state < this.numStates; ++state) {
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            for (int i = 0; i < parentRules.length; ++i) {
                BinaryRule r = parentRules[i];
                ruleStrings.add(r.toString());
            }
        }
        for (state = 0; state < this.numStates; ++state) {
            UnaryRule[] unaries = this.getClosedSumUnaryRulesByParent(state);
            for (int r = 0; r < unaries.length; ++r) {
                UnaryRule ur = unaries[r];
                ruleStrings.add(ur.toString());
            }
        }
        for (String ruleString : CollectionUtils.sort(ruleStrings)) {
            sb.append(ruleString);
        }
        return sb.toString();
    }

    public int getNumberOfRules() {
        int nRules = 0;
        for (int state = 0; state < this.numStates; ++state) {
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            for (int i = 0; i < parentRules.length; ++i) {
                BinaryRule bRule = parentRules[i];
                double[][][] scores = bRule.getScores2();
                for (int j = 0; j < scores.length; ++j) {
                    for (int k = 0; k < scores[j].length; ++k) {
                        if (scores[j][k] == null) continue;
                        nRules += scores[j][k].length;
                    }
                }
            }
            UnaryRule[] unaries = this.getClosedSumUnaryRulesByParent(state);
            for (int r = 0; r < unaries.length; ++r) {
                UnaryRule uRule = unaries[r];
                if (uRule.childState == uRule.parentState) continue;
                double[][] scores = uRule.getScores2();
                for (int j = 0; j < scores.length; ++j) {
                    if (scores[j] == null) continue;
                    nRules += scores[j].length;
                }
            }
        }
        return nRules;
    }

    public void printUnaryRules() {
        UnaryRule uRule2;
        UnaryRule[] unaries;
        int state1;
        for (state1 = 0; state1 < this.numStates; ++state1) {
            unaries = this.getUnaryRulesByParent(state1);
            for (UnaryRule uRule : unaries) {
                uRule2 = this.unaryRuleMap.get(uRule);
                if (uRule.getScores2().equals(uRule2.getScores2())) continue;
                System.out.print("BY PARENT:\n" + uRule + "" + uRule2 + "\n");
            }
        }
        for (state1 = 0; state1 < this.numStates; ++state1) {
            unaries = this.getClosedViterbiUnaryRulesByParent(state1);
            for (int r = 0; r < unaries.length; ++r) {
                UnaryRule uRule;
                uRule = unaries[r];
                uRule2 = this.unaryRuleMap.get(uRule);
                if (!this.unariesAreNotEqual(uRule, uRule2)) continue;
                System.out.print("VITERBI CLOSED:\n" + uRule + "" + uRule2 + "\n");
            }
        }
        for (state1 = 0; state1 < this.numStates; ++state1) {
            BinaryRule[] parentRules = this.splitRulesWithP(state1);
            for (int i = 0; i < parentRules.length; ++i) {
                BinaryRule bRule = parentRules[i];
                BinaryRule bRule2 = this.binaryRuleMap.get(bRule);
                if (bRule.getScores2().equals(bRule2.getScores2())) continue;
                System.out.print("BINARY: " + bRule + "" + bRule2 + "\n");
            }
        }
    }

    public boolean unariesAreNotEqual(UnaryRule u1, UnaryRule u2) {
        if (u2 == null) {
            return false;
        }
        double[][] s1 = u1.getScores2();
        double[][] s2 = u2.getScores2();
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == null || s2[i] == null) continue;
            for (int j = 0; j < s1[i].length; ++j) {
                if (s1[i][j] == s2[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void init() {
        this.binaryRuleMap = new HashMap<BinaryRule, BinaryRule>();
        this.unaryRuleMap = new HashMap<UnaryRule, UnaryRule>();
        this.bestSumRulesUnderMax = new HashMap();
        this.bestViterbiRulesUnderMax = new HashMap();
        this.binaryRulesWithParent = new List[this.numStates];
        this.binaryRulesWithLC = new List[this.numStates];
        this.binaryRulesWithRC = new List[this.numStates];
        this.unaryRulesWithParent = new List[this.numStates];
        this.unaryRulesWithC = new List[this.numStates];
        this.closedSumRulesWithParent = new List[this.numStates];
        this.closedSumRulesWithChild = new List[this.numStates];
        this.closedViterbiRulesWithParent = new List[this.numStates];
        this.closedViterbiRulesWithChild = new List[this.numStates];
        this.isGrammarTag = new boolean[this.numStates];
        this.closedViterbiPaths = new int[this.numStates][this.numStates];
        this.closedSumPaths = new int[this.numStates][this.numStates];
        for (short s = 0; s < this.numStates; s = (short)(s + 1)) {
            this.binaryRulesWithParent[s] = new ArrayList<BinaryRule>();
            this.binaryRulesWithLC[s] = new ArrayList<BinaryRule>();
            this.binaryRulesWithRC[s] = new ArrayList<BinaryRule>();
            this.unaryRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.unaryRulesWithC[s] = new ArrayList<UnaryRule>();
            this.closedSumRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.closedSumRulesWithChild[s] = new ArrayList<UnaryRule>();
            this.closedViterbiRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.closedViterbiRulesWithChild[s] = new ArrayList<UnaryRule>();
            double[][] scores = new double[this.numSubStates[s]][this.numSubStates[s]];
            for (int i = 0; i < scores.length; ++i) {
                scores[i][i] = 1.0;
            }
            UnaryRule selfR = new UnaryRule(s, s, scores);
            this.relaxViterbiRule(selfR);
        }
    }

    public Grammar(short[] nSubStates, boolean findClosedPaths, Smoother smoother, Grammar oldGrammar, double thresh) {
        this.findClosedPaths = findClosedPaths;
        this.smoother = smoother;
        this.threshold = thresh;
        this.unaryRuleCounter = new UnaryCounterTable(nSubStates);
        this.binaryRuleCounter = new BinaryCounterTable(nSubStates);
        this.symbolCounter = new CounterMap();
        this.numStates = (short)nSubStates.length;
        this.numSubStates = nSubStates;
        this.bSearchRule = new BinaryRule(0, 0, 0);
        this.uSearchRule = new UnaryRule(0, 0);
        this.logarithmMode = false;
        if (oldGrammar != null) {
            this.splitTrees = oldGrammar.splitTrees;
        } else {
            int tag;
            this.splitTrees = new Tree[this.numStates];
            boolean hasAnySplits = false;
            for (tag = 0; !hasAnySplits && tag < this.numStates; ++tag) {
                hasAnySplits = hasAnySplits || this.numSubStates[tag] > 1;
            }
            for (tag = 0; tag < this.numStates; ++tag) {
                ArrayList children = new ArrayList(this.numSubStates[tag]);
                if (hasAnySplits) {
                    for (short substate = 0; substate < this.numSubStates[tag]; substate = (short)(substate + 1)) {
                        children.add(substate, new Tree<Short>(substate));
                    }
                }
                this.splitTrees[tag] = new Tree<Short>((short)0, children);
            }
        }
        this.init();
    }

    public void setSmoother(Smoother smoother) {
        this.smoother = smoother;
    }

    public static double generateMMTRandomNumber(Random r) {
        double f = r.nextDouble();
        f = f * 2.0 - 1.0;
        return Math.exp(f *= Math.log(3.0));
    }

    public void optimize(double randomness) {
        this.init();
        if (randomness > 0.0) {
            int j;
            int i;
            Random random = GrammarTrainer.RANDOM;
            for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
                double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
                for (i = 0; i < unaryCounts.length; ++i) {
                    if (unaryCounts[i] == null) {
                        unaryCounts[i] = new double[this.numSubStates[unaryRule.getParentState()]];
                    }
                    j = 0;
                    while (j < unaryCounts[i].length) {
                        double r = random.nextDouble() * randomness;
                        double[] dArray = unaryCounts[i];
                        int n = j++;
                        dArray[n] = dArray[n] + r;
                    }
                }
                this.unaryRuleCounter.setCount(unaryRule, unaryCounts);
            }
            for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
                double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
                for (i = 0; i < binaryCounts.length; ++i) {
                    for (j = 0; j < binaryCounts[i].length; ++j) {
                        if (binaryCounts[i][j] == null) {
                            binaryCounts[i][j] = new double[this.numSubStates[binaryRule.getParentState()]];
                        }
                        int k = 0;
                        while (k < binaryCounts[i][j].length) {
                            double r = random.nextDouble() * randomness;
                            double[] dArray = binaryCounts[i][j];
                            int n = k++;
                            dArray[n] = dArray[n] + r;
                        }
                    }
                }
                this.binaryRuleCounter.setCount(binaryRule, binaryCounts);
            }
        }
        this.normalize();
        this.smooth(false);
    }

    public void removeUnlikelyRules(double thresh, double power) {
        if (this.isLogarithmMode()) {
            power = Math.log(power);
        }
        int total = 0;
        int removed = 0;
        for (int state = 0; state < this.numStates; ++state) {
            for (int r = 0; r < this.splitRulesWithP[state].length; ++r) {
                BinaryRule binaryRule = this.splitRulesWithP[state][r];
                for (int lC = 0; lC < binaryRule.scores.length; ++lC) {
                    for (int rC = 0; rC < binaryRule.scores[lC].length; ++rC) {
                        if (binaryRule.scores[lC][rC] == null) continue;
                        boolean isNull = true;
                        for (int p = 0; p < binaryRule.scores[lC][rC].length; ++p) {
                            ++total;
                            if (binaryRule.scores[lC][rC][p] < thresh) {
                                binaryRule.scores[lC][rC][p] = 0.0;
                                ++removed;
                                continue;
                            }
                            if (power != 1.0) {
                                binaryRule.scores[lC][rC][p] = Math.pow(binaryRule.scores[lC][rC][p], power);
                            }
                            isNull = false;
                        }
                        if (!isNull) continue;
                        binaryRule.scores[lC][rC] = null;
                    }
                }
                this.splitRulesWithP[state][r] = binaryRule;
            }
            for (UnaryRule unaryRule : this.unaryRulesWithParent[state]) {
                for (int c = 0; c < unaryRule.scores.length; ++c) {
                    if (unaryRule.scores[c] == null) continue;
                    boolean isNull = true;
                    for (int p = 0; p < unaryRule.scores[c].length; ++p) {
                        ++total;
                        if (unaryRule.scores[c][p] <= thresh) {
                            ++removed;
                            unaryRule.scores[c][p] = 0.0;
                            continue;
                        }
                        if (power != 1.0) {
                            unaryRule.scores[c][p] = Math.pow(unaryRule.scores[c][p], power);
                        }
                        isNull = false;
                    }
                    if (!isNull) continue;
                    unaryRule.scores[c] = null;
                }
            }
        }
    }

    public void smooth(boolean noNormalize) {
        int i;
        this.smoother.smooth(this.unaryRuleCounter, this.binaryRuleCounter);
        if (!noNormalize) {
            this.normalize();
        }
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            for (i = 0; i < unaryCounts.length; ++i) {
                double allZero;
                if (unaryCounts[i] == null) continue;
                int j = 0;
                for (allZero = 0.0; allZero == 0.0 && j < unaryCounts[i].length; allZero += unaryCounts[i][j++]) {
                }
                if (allZero != 0.0) continue;
                unaryCounts[i] = null;
            }
            unaryRule.setScores2(unaryCounts);
            this.addUnary(unaryRule);
        }
        this.computePairsOfUnaries();
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            for (i = 0; i < binaryCounts.length; ++i) {
                for (int j = 0; j < binaryCounts[i].length; ++j) {
                    double allZero;
                    if (binaryCounts[i][j] == null) continue;
                    int k = 0;
                    for (allZero = 0.0; allZero == 0.0 && k < binaryCounts[i][j].length; allZero += binaryCounts[i][j][k++]) {
                    }
                    if (allZero != 0.0) continue;
                    binaryCounts[i][j] = null;
                }
            }
            binaryRule.setScores2(binaryCounts);
            this.addBinary(binaryRule);
        }
        this.unaryRuleCounter = new UnaryCounterTable(this.numSubStates);
        this.binaryRuleCounter = new BinaryCounterTable(this.numSubStates);
        this.symbolCounter = new CounterMap();
    }

    public void clearCounts() {
        this.unaryRuleCounter = new UnaryCounterTable(this.numSubStates);
        this.binaryRuleCounter = new BinaryCounterTable(this.numSubStates);
        this.symbolCounter = new CounterMap();
    }

    public void normalize() {
        int nParentSubStates;
        short parentState;
        this.tallyParentCounts();
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            parentState = unaryRule.getParentState();
            nParentSubStates = this.numSubStates[parentState];
            int nChildStates = this.numSubStates[unaryRule.childState];
            double[] parentCount = new double[nParentSubStates];
            for (int i = 0; i < nParentSubStates; ++i) {
                parentCount[i] = this.symbolCounter.getCount(Integer.valueOf(parentState), i);
            }
            boolean allZero = true;
            for (int j = 0; j < nChildStates; ++j) {
                if (unaryCounts[j] == null) continue;
                for (int i = 0; i < nParentSubStates; ++i) {
                    if (parentCount[i] != 0.0) {
                        double nVal = unaryCounts[j][i] / parentCount[i];
                        if (nVal < this.threshold || SloppyMath.isVeryDangerous(nVal)) {
                            nVal = 0.0;
                        }
                        unaryCounts[j][i] = nVal;
                    }
                    allZero = allZero && unaryCounts[j][i] == 0.0;
                }
            }
            if (allZero) {
                System.out.println("Maybe an underflow? Rule: " + unaryRule + "\n" + ArrayUtil.toString(unaryCounts));
            }
            this.unaryRuleCounter.setCount(unaryRule, unaryCounts);
        }
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            parentState = binaryRule.parentState;
            nParentSubStates = this.numSubStates[parentState];
            double[] parentCount = new double[nParentSubStates];
            for (int i = 0; i < nParentSubStates; ++i) {
                parentCount[i] = this.symbolCounter.getCount(Integer.valueOf(parentState), i);
            }
            for (int j = 0; j < binaryCounts.length; ++j) {
                for (int k = 0; k < binaryCounts[j].length; ++k) {
                    if (binaryCounts[j][k] == null) continue;
                    for (int i = 0; i < nParentSubStates; ++i) {
                        if (parentCount[i] == 0.0) continue;
                        double nVal = binaryCounts[j][k][i] / parentCount[i];
                        if (nVal < this.threshold || SloppyMath.isVeryDangerous(nVal)) {
                            nVal = 0.0;
                        }
                        binaryCounts[j][k][i] = nVal;
                    }
                }
            }
            this.binaryRuleCounter.setCount(binaryRule, binaryCounts);
        }
    }

    public void checkNumberOfSubstates() {
        short nParentSubStates;
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            nParentSubStates = this.numSubStates[unaryRule.parentState];
            short nChildSubStates = this.numSubStates[unaryRule.childState];
            if (unaryCounts.length != nChildSubStates) {
                System.out.println("Unary Rule " + unaryRule + " should have " + nChildSubStates + " childsubstates.");
            }
            if (unaryCounts[0] == null || unaryCounts[0].length == nParentSubStates) continue;
            System.out.println("Unary Rule " + unaryRule + " should have " + nParentSubStates + " parentsubstates.");
        }
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            nParentSubStates = this.numSubStates[binaryRule.parentState];
            short nLeftChildSubStates = this.numSubStates[binaryRule.leftChildState];
            short nRightChildSubStates = this.numSubStates[binaryRule.rightChildState];
            if (binaryCounts.length != nLeftChildSubStates) {
                System.out.println("Unary Rule " + binaryRule + " should have " + nLeftChildSubStates + " left childsubstates.");
            }
            if (binaryCounts[0].length != nRightChildSubStates) {
                System.out.println("Unary Rule " + binaryRule + " should have " + nRightChildSubStates + " right childsubstates.");
            }
            if (binaryCounts[0][0] == null || binaryCounts[0][0].length == nParentSubStates) continue;
            System.out.println("Unary Rule " + binaryRule + " should have " + nParentSubStates + " parentsubstates.");
        }
        System.out.println("Done with checks.");
    }

    private void tallyParentCounts() {
        int i;
        int j;
        double[] sum;
        int nParentSubStates;
        short parentState;
        this.symbolCounter = new CounterMap();
        for (UnaryRule unaryRule : this.unaryRuleCounter.keySet()) {
            double[][] unaryCounts = this.unaryRuleCounter.getCount(unaryRule);
            parentState = unaryRule.getParentState();
            this.isGrammarTag[parentState] = true;
            if (unaryRule.childState == parentState) continue;
            nParentSubStates = this.numSubStates[parentState];
            sum = new double[nParentSubStates];
            for (j = 0; j < unaryCounts.length; ++j) {
                if (unaryCounts[j] == null) continue;
                int i2 = 0;
                while (i2 < nParentSubStates) {
                    double val = unaryCounts[j][i2];
                    int n = i2++;
                    sum[n] = sum[n] + val;
                }
            }
            for (i = 0; i < nParentSubStates; ++i) {
                this.symbolCounter.incrementCount(Integer.valueOf(parentState), i, sum[i]);
            }
        }
        for (BinaryRule binaryRule : this.binaryRuleCounter.keySet()) {
            double[][][] binaryCounts = this.binaryRuleCounter.getCount(binaryRule);
            parentState = binaryRule.parentState;
            this.isGrammarTag[parentState] = true;
            nParentSubStates = this.numSubStates[parentState];
            sum = new double[nParentSubStates];
            for (j = 0; j < binaryCounts.length; ++j) {
                for (int k = 0; k < binaryCounts[j].length; ++k) {
                    if (binaryCounts[j][k] == null) continue;
                    int i3 = 0;
                    while (i3 < nParentSubStates) {
                        double val = binaryCounts[j][k][i3];
                        int n = i3++;
                        sum[n] = sum[n] + val;
                    }
                }
            }
            for (i = 0; i < nParentSubStates; ++i) {
                this.symbolCounter.incrementCount(Integer.valueOf(parentState), i, sum[i]);
            }
        }
    }

    public void tallyStateSetTree(Tree<StateSet> tree, Grammar old_grammar) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            return;
        }
        StateSet node = tree.getLabel();
        if (node.numSubStates() != 1) {
            System.err.println("The top symbol is split!");
            System.out.println(tree);
            System.exit(1);
        }
        double tree_score = node.getIScore(0);
        int tree_scale = node.getIScale();
        if (tree_score == 0.0) {
            System.out.println("Something is wrong with this tree. I will skip it.");
            return;
        }
        this.tallyStateSetTree(tree, tree_score, tree_scale, old_grammar);
    }

    public void tallyStateSetTree(Tree<StateSet> tree, double tree_score, double tree_scale, Grammar old_grammar) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short parentState = parent.getState();
        short nParentSubStates = this.numSubStates[parentState];
        switch (children.size()) {
            case 0: {
                break;
            }
            case 1: {
                StateSet child = children.get(0).getLabel();
                short childState = child.getState();
                short nChildSubStates = this.numSubStates[childState];
                UnaryRule urule = new UnaryRule(parentState, childState);
                double[][] oldUScores = old_grammar.getUnaryScore(urule);
                Object ucounts = this.unaryRuleCounter.getCount(urule);
                if (ucounts == null) {
                    ucounts = new double[nChildSubStates][];
                }
                double scalingFactor = ScalingTools.calcScaleFactor((double)(parent.getOScale() + child.getIScale()) - tree_scale);
                for (short i = 0; i < nChildSubStates; i = (short)(i + 1)) {
                    double cIS;
                    if (oldUScores[i] == null || (cIS = child.getIScore(i)) == 0.0) continue;
                    if (ucounts[i] == null) {
                        ucounts[i] = new double[nParentSubStates];
                    }
                    for (short j = 0; j < nParentSubStates; j = (short)(j + 1)) {
                        double rS;
                        double pOS = parent.getOScore(j);
                        if (pOS == 0.0 || (rS = oldUScores[i][j]) == 0.0) continue;
                        if (tree_score == 0.0) {
                            tree_score = 1.0;
                        }
                        double logRuleCount = rS * cIS / tree_score * scalingFactor * pOS;
                        double[] dArray = ucounts[i];
                        short s = j;
                        dArray[s] = dArray[s] + logRuleCount;
                    }
                }
                this.unaryRuleCounter.setCount(urule, (double[][])ucounts);
                break;
            }
            case 2: {
                double[][][] bcounts;
                StateSet leftChild = children.get(0).getLabel();
                short lChildState = leftChild.getState();
                StateSet rightChild = children.get(1).getLabel();
                short rChildState = rightChild.getState();
                short nLeftChildSubStates = this.numSubStates[lChildState];
                short nRightChildSubStates = this.numSubStates[rChildState];
                BinaryRule brule = new BinaryRule(parentState, lChildState, rChildState);
                double[][][] oldBScores = old_grammar.getBinaryScore(brule);
                if (oldBScores == null) {
                    oldBScores = new double[nLeftChildSubStates][nRightChildSubStates][nParentSubStates];
                    ArrayUtil.fill(oldBScores, 1.0);
                }
                if ((bcounts = this.binaryRuleCounter.getCount(brule)) == null) {
                    bcounts = new double[nLeftChildSubStates][nRightChildSubStates][];
                }
                double scalingFactor = ScalingTools.calcScaleFactor((double)(parent.getOScale() + leftChild.getIScale() + rightChild.getIScale()) - tree_scale);
                for (short i = 0; i < nLeftChildSubStates; i = (short)(i + 1)) {
                    double lcIS = leftChild.getIScore(i);
                    if (lcIS == 0.0) continue;
                    for (short j = 0; j < nRightChildSubStates; j = (short)(j + 1)) {
                        double rcIS;
                        if (oldBScores[i][j] == null || (rcIS = rightChild.getIScore(j)) == 0.0) continue;
                        if (bcounts[i][j] == null) {
                            bcounts[i][j] = new double[nParentSubStates];
                        }
                        for (short k = 0; k < nParentSubStates; k = (short)(k + 1)) {
                            double rS;
                            double pOS = parent.getOScore(k);
                            if (pOS == 0.0 || (rS = oldBScores[i][j][k]) == 0.0) continue;
                            if (tree_score == 0.0) {
                                tree_score = 1.0;
                            }
                            double logRuleCount = rS * lcIS / tree_score * rcIS * scalingFactor * pOS;
                            double[] dArray = bcounts[i][j];
                            short s = k;
                            dArray[s] = dArray[s] + logRuleCount;
                        }
                    }
                }
                this.binaryRuleCounter.setCount(brule, bcounts);
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        for (Tree<StateSet> child : children) {
            this.tallyStateSetTree(child, tree_score, tree_scale, old_grammar);
        }
    }

    public void tallyUninitializedStateSetTree(Tree<StateSet> tree) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short parentState = parent.getState();
        int nParentSubStates = parent.numSubStates();
        switch (children.size()) {
            case 0: {
                break;
            }
            case 1: {
                StateSet child = children.get(0).getLabel();
                short childState = child.getState();
                int nChildSubStates = child.numSubStates();
                double[][] counts = new double[nChildSubStates][nParentSubStates];
                UnaryRule urule = new UnaryRule(parentState, childState, counts);
                this.unaryRuleCounter.incrementCount(urule, 1.0);
                break;
            }
            case 2: {
                StateSet leftChild = children.get(0).getLabel();
                short lChildState = leftChild.getState();
                StateSet rightChild = children.get(1).getLabel();
                short rChildState = rightChild.getState();
                int nLeftChildSubStates = leftChild.numSubStates();
                int nRightChildSubStates = rightChild.numSubStates();
                double[][][] bcounts = new double[nLeftChildSubStates][nRightChildSubStates][nParentSubStates];
                BinaryRule brule = new BinaryRule(parentState, lChildState, rChildState, bcounts);
                this.binaryRuleCounter.incrementCount(brule, 1.0);
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        for (Tree<StateSet> child : children) {
            this.tallyUninitializedStateSetTree(child);
        }
    }

    public void makeCRArrays() {
        this.closedSumRulesWithP = new UnaryRule[this.numStates][];
        this.closedSumRulesWithC = new UnaryRule[this.numStates][];
        this.closedViterbiRulesWithP = new UnaryRule[this.numStates][];
        this.closedViterbiRulesWithC = new UnaryRule[this.numStates][];
        for (int i = 0; i < this.numStates; ++i) {
            this.closedSumRulesWithP[i] = this.closedSumRulesWithParent[i].toArray(new UnaryRule[0]);
            this.closedSumRulesWithC[i] = this.closedSumRulesWithChild[i].toArray(new UnaryRule[0]);
            this.closedViterbiRulesWithP[i] = this.closedViterbiRulesWithParent[i].toArray(new UnaryRule[0]);
            this.closedViterbiRulesWithC[i] = this.closedViterbiRulesWithChild[i].toArray(new UnaryRule[0]);
        }
    }

    public UnaryRule[] getClosedSumUnaryRulesByParent(int state) {
        if (this.closedSumRulesWithP == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedSumRulesWithP.length) {
            return new UnaryRule[0];
        }
        return this.closedSumRulesWithP[state];
    }

    public UnaryRule[] getClosedSumUnaryRulesByChild(int state) {
        if (this.closedSumRulesWithC == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedSumRulesWithC.length) {
            return new UnaryRule[0];
        }
        return this.closedSumRulesWithC[state];
    }

    public UnaryRule[] getClosedViterbiUnaryRulesByParent(int state) {
        if (this.closedViterbiRulesWithP == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedViterbiRulesWithP.length) {
            return new UnaryRule[0];
        }
        return this.closedViterbiRulesWithP[state];
    }

    public UnaryRule[] getClosedViterbiUnaryRulesByChild(int state) {
        if (this.closedViterbiRulesWithC == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedViterbiRulesWithC.length) {
            return new UnaryRule[0];
        }
        return this.closedViterbiRulesWithC[state];
    }

    public void purgeRules() {
        HashMap<UnaryRule, UnaryRule> bR = new HashMap<UnaryRule, UnaryRule>();
        HashMap<UnaryRule, UnaryRule> bR2 = new HashMap<UnaryRule, UnaryRule>();
        for (UnaryRule ur : this.bestSumRulesUnderMax.keySet()) {
            if (ur.parentState == ur.childState) continue;
            bR.put(ur, ur);
            bR2.put(ur, ur);
        }
        this.bestSumRulesUnderMax = bR;
        this.bestViterbiRulesUnderMax = bR2;
    }

    public List<short[]> getBestViterbiPath(short pState, short np, short cState, short cp) {
        ArrayList<short[]> path = new ArrayList<short[]>();
        short[] state = new short[]{pState, np};
        if (!this.findClosedPaths) {
            path.add(state);
            state = new short[]{cState, cp};
            path.add(state);
            return path;
        }
        if (pState == cState && np == cp) {
            path.add(state);
            path.add(state);
            return path;
        }
        while (state[0] != cState || state[1] != cp) {
            path.add(state);
            state[0] = (short)this.closedViterbiPaths[state[0]][state[1]];
        }
        path.add(state);
        return path;
    }

    private void closeRulesUnderMax(UnaryRule ur) {
        double[][] scores;
        UnaryRule resultR;
        int j;
        UnaryRule pr;
        int i;
        short pState = ur.parentState;
        int nPSubStates = this.numSubStates[pState];
        short cState = ur.childState;
        double[][] uScores = ur.getScores2();
        for (i = 0; i < this.closedSumRulesWithChild[pState].size(); ++i) {
            pr = this.closedSumRulesWithChild[pState].get(i);
            for (j = 0; j < this.closedSumRulesWithParent[cState].size(); ++j) {
                short parentState = pr.parentState;
                short nParentSubStates = this.numSubStates[parentState];
                UnaryRule cr = this.closedSumRulesWithParent[cState].get(j);
                resultR = new UnaryRule(parentState, cr.getChildState());
                scores = new double[this.numSubStates[cr.getChildState()]][nParentSubStates];
                for (int np = 0; np < scores[0].length; ++np) {
                    for (int cp = 0; cp < scores.length; ++cp) {
                        double sum = 0.0;
                        for (int unp = 0; unp < nPSubStates; ++unp) {
                            for (int ucp = 0; ucp < uScores.length; ++ucp) {
                                sum += pr.getScore(np, unp) * cr.getScore(ucp, cp) * ur.getScore(unp, ucp);
                            }
                        }
                        scores[cp][np] = sum;
                    }
                }
                resultR.setScores2(scores);
                this.relaxSumRule(resultR, pState, cState);
            }
        }
        for (i = 0; i < this.closedViterbiRulesWithChild[pState].size(); i = (int)((short)(i + 1))) {
            pr = this.closedViterbiRulesWithChild[pState].get(i);
            for (j = 0; j < this.closedViterbiRulesWithParent[cState].size(); j = (int)((short)(j + 1))) {
                UnaryRule cr = this.closedViterbiRulesWithParent[cState].get(j);
                short parentState = pr.parentState;
                short nParentSubStates = this.numSubStates[parentState];
                resultR = new UnaryRule(parentState, cr.getChildState());
                scores = new double[this.numSubStates[cr.getChildState()]][nParentSubStates];
                short[][] intermediateSubState1 = new short[nParentSubStates][this.numSubStates[cr.getChildState()]];
                short[][] intermediateSubState2 = new short[nParentSubStates][this.numSubStates[cr.getChildState()]];
                for (int np = 0; np < scores[0].length; ++np) {
                    for (int cp = 0; cp < scores.length; ++cp) {
                        double max = 0.0;
                        for (int unp = 0; unp < nPSubStates; unp = (int)((short)(unp + 1))) {
                            for (int ucp = 0; ucp < uScores.length; ucp = (int)((short)(ucp + 1))) {
                                double score = pr.getScore(np, unp) * cr.getScore(ucp, cp) * ur.getScore(unp, ucp);
                                if (!(score > max)) continue;
                                max = score;
                                intermediateSubState1[np][cp] = unp;
                                intermediateSubState2[np][cp] = ucp;
                            }
                        }
                        scores[cp][np] = max;
                    }
                }
                resultR.setScores2(scores);
                this.relaxViterbiRule(resultR, pState, intermediateSubState1, cState, intermediateSubState2);
            }
        }
    }

    public int getUnaryIntermediate(short start, short end) {
        return this.closedSumPaths[start][end];
    }

    private boolean relaxSumRule(UnaryRule ur, int intState1, int intState2) {
        UnaryRule bestR = (UnaryRule)this.bestSumRulesUnderMax.get(ur);
        if (bestR == null) {
            this.bestSumRulesUnderMax.put(ur, ur);
            this.closedSumRulesWithParent[ur.parentState].add(ur);
            this.closedSumRulesWithChild[ur.childState].add(ur);
            return true;
        }
        boolean change = false;
        for (int i = 0; i < ur.scores[0].length; ++i) {
            for (int j = 0; j < ur.scores.length; ++j) {
                if (!(bestR.scores[j][i] < ur.scores[j][i])) continue;
                bestR.scores[j][i] = ur.scores[j][i];
                change = true;
            }
        }
        return change;
    }

    public void computePairsOfUnaries() {
        for (short parentState = 0; parentState < this.numStates; parentState = (short)(parentState + 1)) {
            for (short childState = 0; childState < this.numStates; childState = (short)(childState + 1)) {
                if (parentState == childState) continue;
                int nParentSubStates = this.numSubStates[parentState];
                int nChildSubStates = this.numSubStates[childState];
                UnaryRule resultRsum = new UnaryRule(parentState, childState);
                UnaryRule resultRmax = new UnaryRule(parentState, childState);
                double[][] scoresSum = new double[nChildSubStates][nParentSubStates];
                double[][] scoresMax = new double[nChildSubStates][nParentSubStates];
                double maxSumScore = -1.0;
                int bestSumIntermed = -1;
                int bestMaxIntermed = -2;
                for (int i = 0; i < this.unaryRulesWithParent[parentState].size(); ++i) {
                    UnaryRule pr = this.unaryRulesWithParent[parentState].get(i);
                    short state = pr.getChildState();
                    if (state == childState) {
                        double total = 0.0;
                        double[][] scores = pr.getScores2();
                        for (int cp = 0; cp < nChildSubStates; ++cp) {
                            if (scores[cp] == null) continue;
                            for (int np = 0; np < nParentSubStates; ++np) {
                                double sum = scores[cp][np];
                                double[] dArray = scoresSum[cp];
                                int n = np;
                                dArray[n] = dArray[n] + sum;
                                total += sum;
                                if (!(sum > scoresMax[cp][np])) continue;
                                scoresMax[cp][np] = sum;
                                bestMaxIntermed = -1;
                            }
                        }
                        if (!(total > maxSumScore)) continue;
                        bestSumIntermed = -1;
                        maxSumScore = total;
                        continue;
                    }
                    for (int j = 0; j < this.unaryRulesWithC[childState].size(); ++j) {
                        UnaryRule cr = this.unaryRulesWithC[childState].get(j);
                        if (state != cr.getParentState()) continue;
                        int nMySubStates = this.numSubStates[state];
                        double total = 0.0;
                        for (int np = 0; np < nParentSubStates; ++np) {
                            for (int cp = 0; cp < nChildSubStates; ++cp) {
                                double sum = 0.0;
                                double max = 0.0;
                                for (int unp = 0; unp < nMySubStates; ++unp) {
                                    double val = pr.getScore(np, unp) * cr.getScore(unp, cp);
                                    sum += val;
                                    max = Math.max(max, val);
                                }
                                double[] dArray = scoresSum[cp];
                                int n = np;
                                dArray[n] = dArray[n] + sum;
                                total += sum;
                                if (!(max > scoresMax[cp][np])) continue;
                                scoresMax[cp][np] = max;
                                bestMaxIntermed = state;
                            }
                        }
                        if (!(total > maxSumScore)) continue;
                        maxSumScore = total;
                        bestSumIntermed = state;
                    }
                }
                if (maxSumScore > -1.0) {
                    resultRsum.setScores2(scoresSum);
                    this.addUnary(resultRsum);
                    this.closedSumRulesWithParent[parentState].add(resultRsum);
                    this.closedSumRulesWithChild[childState].add(resultRsum);
                    this.closedSumPaths[parentState][childState] = bestSumIntermed;
                }
                if (bestMaxIntermed <= -2) continue;
                resultRmax.setScores2(scoresMax);
                this.closedViterbiRulesWithParent[parentState].add(resultRmax);
                this.closedViterbiRulesWithChild[childState].add(resultRmax);
                this.closedViterbiPaths[parentState][childState] = bestMaxIntermed;
            }
        }
    }

    private void relaxViterbiRule(UnaryRule ur, short intState1, short[][] intSubStates1, short intState2, short[][] intSubStates2) {
        throw new Error("Viterbi closure is broken!");
    }

    private void relaxViterbiRule(UnaryRule rule) {
        this.bestViterbiRulesUnderMax.put(rule, rule);
        this.closedViterbiRulesWithParent[rule.parentState].add(rule);
        this.closedViterbiRulesWithChild[rule.childState].add(rule);
        if (this.findClosedPaths) {
            for (int i = 0; i < rule.scores.length; i = (int)((short)(i + 1))) {
                for (short j = 0; j < rule.scores[i].length; j = (short)((short)(j + 1))) {
                    short[] pair = new short[]{rule.childState, j};
                }
            }
        }
    }

    private List<UnaryRule>[] matrixMultiply(List<UnaryRule>[] parentRules, List<UnaryRule>[] childRules) {
        throw new Error("I'm broken by parent first");
    }

    private void matrixAdd(List<UnaryRule>[] rules1, List<UnaryRule>[] rules2) {
        throw new Error("I'm broken by parent first");
    }

    private List<UnaryRule>[] matrixUnity() {
        throw new Error("I'm broken by parent first");
    }

    private List<UnaryRule>[] sumProductUnaryClosure(List<UnaryRule>[] P) {
        throw new Error("I'm broken by parent first");
    }

    public double[][] matrixVectorPreMultiply(double[][] V, List<UnaryRule>[] M, List<Integer> possibleSt) {
        throw new Error("I'm broken by parent first");
    }

    public double[][] matrixVectorPostMultiply(List<UnaryRule>[] M, double[][] V, List<Integer> possibleSt) {
        throw new Error("I'm broken by parent first");
    }

    public void splitRules() {
        if (this.binaryRulesWithParent == null) {
            return;
        }
        this.splitRulesWithP = new BinaryRule[this.numStates][];
        this.splitRulesWithLC = new BinaryRule[this.numStates][];
        this.splitRulesWithRC = new BinaryRule[this.numStates][];
        for (int state = 0; state < this.numStates; ++state) {
            this.splitRulesWithLC[state] = this.toBRArray(this.binaryRulesWithLC[state]);
            this.splitRulesWithRC[state] = this.toBRArray(this.binaryRulesWithRC[state]);
            this.splitRulesWithP[state] = this.toBRArray(this.binaryRulesWithParent[state]);
        }
        this.binaryRulesWithParent = null;
        this.binaryRulesWithLC = null;
        this.binaryRulesWithRC = null;
        this.makeCRArrays();
    }

    public BinaryRule[] splitRulesWithLC(int state) {
        if (state >= this.splitRulesWithLC.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithLC[state];
    }

    public BinaryRule[] splitRulesWithRC(int state) {
        if (state >= this.splitRulesWithRC.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithRC[state];
    }

    public BinaryRule[] splitRulesWithP(int state) {
        if (this.splitRulesWithP == null) {
            this.splitRules();
        }
        if (state >= this.splitRulesWithP.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithP[state];
    }

    private BinaryRule[] toBRArray(List<BinaryRule> list) {
        BinaryRule[] array = new BinaryRule[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public double[][] getUnaryScore(short pState, short cState) {
        UnaryRule r = this.getUnaryRule(pState, cState);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.out.println("The requested rule (" + this.uSearchRule + ") is not in the grammar!");
        }
        double[][] uscores = new double[this.numSubStates[cState]][this.numSubStates[pState]];
        ArrayUtil.fill(uscores, 0.0);
        return uscores;
    }

    public UnaryRule getUnaryRule(short pState, short cState) {
        UnaryRule uRule = new UnaryRule(pState, cState);
        UnaryRule r = this.unaryRuleMap.get(uRule);
        return r;
    }

    public double[][] getUnaryScore(UnaryRule rule) {
        UnaryRule r = this.unaryRuleMap.get(rule);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.err.println("The requested rule (" + rule + ") is not in the grammar!");
        }
        double[][] uscores = new double[this.numSubStates[rule.getChildState()]][this.numSubStates[rule.getParentState()]];
        ArrayUtil.fill(uscores, 0.0);
        return uscores;
    }

    public double[][][] getBinaryScore(short pState, short lState, short rState) {
        BinaryRule r = this.getBinaryRule(pState, lState, rState);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.err.println(this.tagNumberer.object(pState) + "\t" + pState);
            System.err.println(this.tagNumberer.object(lState) + "\t" + lState);
            System.err.println(this.tagNumberer.object(rState) + "\t" + rState);
            System.err.println("numSubStates.length:\t" + this.numSubStates.length);
        }
        double[][][] bscores = new double[this.numSubStates[lState]][this.numSubStates[rState]][this.numSubStates[pState]];
        ArrayUtil.fill(bscores, 0.0);
        return bscores;
    }

    public BinaryRule getBinaryRule(short pState, short lState, short rState) {
        BinaryRule bRule = new BinaryRule(pState, lState, rState);
        BinaryRule r = this.binaryRuleMap.get(bRule);
        return r;
    }

    public double[][][] getBinaryScore(BinaryRule rule) {
        BinaryRule r = this.binaryRuleMap.get(rule);
        if (r != null) {
            return r.getScores2();
        }
        if (GrammarTrainer.VERBOSE) {
            System.out.println("The requested rule (" + rule + ") is not in the grammar!");
        }
        double[][][] bscores = new double[this.numSubStates[rule.getLeftChildState()]][this.numSubStates[rule.getRightChildState()]][this.numSubStates[rule.getParentState()]];
        ArrayUtil.fill(bscores, 0.0);
        return bscores;
    }

    public void printSymbolCounter(Numberer tagNumberer) {
        Set<Integer> set = this.symbolCounter.keySet();
        PriorityQueue<String> pq = new PriorityQueue<String>(set.size());
        for (Integer i : set) {
            pq.add((String)tagNumberer.object(i), this.symbolCounter.getCount(i, 0));
        }
        int i = 0;
        while (pq.hasNext()) {
            int p = (int)pq.getPriority();
            System.out.println(++i + ". " + (String)pq.next() + "\t " + p);
        }
    }

    public int getSymbolCount(Integer i) {
        return (int)this.symbolCounter.getCount(i, 0);
    }

    private void makeRulesAccessibleByChild() {
    }

    public Grammar splitAllStates(double randomness, int[] counts, boolean moreSubstatesThanCounts, int mode) {
        Rule newRule;
        if (this.logarithmMode) {
            throw new Error("Do not split states when Grammar is in logarithm mode");
        }
        short[] newNumSubStates = new short[this.numSubStates.length];
        for (int i = 0; i < this.numSubStates.length; i = (int)((short)(i + 1))) {
            newNumSubStates[i] = (short)(this.numSubStates[i] * 2);
        }
        boolean doNotNormalize = mode == 1;
        newNumSubStates[0] = 1;
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        Random random = GrammarTrainer.RANDOM;
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            newRule = binaryRule.splitRule(this.numSubStates, newNumSubStates, random, randomness, doNotNormalize, mode);
            grammar.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            newRule = unaryRule.splitRule(this.numSubStates, newNumSubStates, random, randomness, doNotNormalize, mode);
            grammar.addUnary((UnaryRule)newRule);
        }
        grammar.isGrammarTag = this.isGrammarTag;
        grammar.extendSplitTrees(this.splitTrees, this.numSubStates);
        grammar.computePairsOfUnaries();
        return grammar;
    }

    public void extendSplitTrees(Tree<Short>[] trees, short[] oldNumSubStates) {
        this.splitTrees = new Tree[this.numStates];
        for (int tag = 0; tag < this.splitTrees.length; ++tag) {
            Tree<Short> splitTree = trees[tag].shallowClone();
            for (Tree<Short> leaf : splitTree.getTerminals()) {
                List<Tree<Short>> children = leaf.getChildren();
                if (this.numSubStates[tag] > oldNumSubStates[tag]) {
                    children.add(new Tree<Short>((short)(2 * leaf.getLabel())));
                    children.add(new Tree<Short>((short)(2 * leaf.getLabel() + 1)));
                    continue;
                }
                children.add(new Tree<Short>(leaf.getLabel()));
            }
            this.splitTrees[tag] = splitTree;
        }
    }

    public int totalSubStates() {
        int count = 0;
        for (int i = 0; i < this.numStates; ++i) {
            count += this.numSubStates[i];
        }
        return count;
    }

    public void tallyMergeWeights(Tree<StateSet> tree, double[][] mergeWeights) {
        int i;
        if (tree.isLeaf()) {
            return;
        }
        StateSet label = tree.getLabel();
        short state = label.getState();
        double[] probs = new double[label.numSubStates()];
        double total = 0.0;
        for (i = 0; i < label.numSubStates(); i = (int)((short)(i + 1))) {
            double tmp;
            probs[i] = tmp = label.getIScore(i) * label.getOScore(i);
            total += tmp;
        }
        if (total == 0.0) {
            total = 1.0;
        }
        for (i = 0; i < label.numSubStates(); i = (int)((short)(i + 1))) {
            double[] dArray = mergeWeights[state];
            int n = i;
            dArray[n] = dArray[n] + probs[i] / total;
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            this.tallyMergeWeights(child, mergeWeights);
        }
    }

    public void normalizeMergeWeights(double[][] mergeWeights) {
        for (int state = 0; state < mergeWeights.length; ++state) {
            int subState;
            double sum = 0.0;
            for (subState = 0; subState < this.numSubStates[state]; ++subState) {
                sum += mergeWeights[state][subState];
            }
            if (sum == 0.0) {
                sum = 1.0;
            }
            subState = 0;
            while (subState < this.numSubStates[state]) {
                double[] dArray = mergeWeights[state];
                int n = subState++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    public void tallyMergeScores(Tree<StateSet> tree, double[][][] deltas, double[][] mergeWeights) {
        short i;
        if (tree.isLeaf()) {
            return;
        }
        StateSet label = tree.getLabel();
        short state = label.getState();
        double[] separatedScores = new double[label.numSubStates()];
        double[] combinedScores = new double[label.numSubStates()];
        double separatedScoreSum = 0.0;
        for (i = 0; i < label.numSubStates(); ++i) {
            double tmp;
            combinedScores[i] = separatedScores[i] = (tmp = label.getIScore(i) * label.getOScore(i));
            separatedScoreSum += tmp;
        }
        for (i = 0; i < this.numSubStates[state]; i = (short)((short)(i + 1))) {
            for (short j = (short)(i + 1); j < this.numSubStates[state]; j = (short)(j + 1)) {
                double combinedScore;
                int k;
                short[] map = new short[]{i, j};
                double[] tmp1 = new double[2];
                double[] tmp2 = new double[2];
                double mergeWeightSum = 0.0;
                for (k = 0; k < 2; ++k) {
                    mergeWeightSum += mergeWeights[state][map[k]];
                }
                if (mergeWeightSum == 0.0) {
                    mergeWeightSum = 1.0;
                }
                for (k = 0; k < 2; ++k) {
                    tmp1[k] = label.getIScore(map[k]) * mergeWeights[state][map[k]] / mergeWeightSum;
                    tmp2[k] = label.getOScore(map[k]);
                }
                combinedScores[i] = combinedScore = (tmp1[0] + tmp1[1]) * (tmp2[0] + tmp2[1]);
                combinedScores[j] = 0.0;
                if (combinedScore != 0.0 && separatedScoreSum != 0.0) {
                    double[] dArray = deltas[state][i];
                    short s = j;
                    dArray[s] = dArray[s] + Math.log(separatedScoreSum / ArrayUtil.sum(combinedScores));
                }
                for (k = 0; k < 2; ++k) {
                    combinedScores[map[k]] = separatedScores[map[k]];
                }
                if (!Double.isNaN(deltas[state][i][j])) continue;
                System.out.println(" deltas[" + this.tagNumberer.object(state) + "][" + i + "][" + j + "] = NaN");
                System.out.println(Arrays.toString(separatedScores) + " " + Arrays.toString(tmp1) + " " + Arrays.toString(tmp2) + " " + combinedScore + " " + Arrays.toString(mergeWeights[state]));
            }
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            this.tallyMergeScores(child, deltas, mergeWeights);
        }
    }

    public Grammar mergeStates(boolean[][][] mergeThesePairs, double[][] mergeWeights) {
        Rule newRule;
        int j;
        int parentSplit;
        Object oldScores;
        short pS;
        if (this.logarithmMode) {
            throw new Error("Do not merge grammars in logarithm mode!");
        }
        short[] newNumSubStates = new short[this.numSubStates.length];
        short[][] mapping = new short[this.numSubStates.length][];
        short[][][] partners = new short[this.numSubStates.length][][];
        Grammar.calculateMergeArrays(mergeThesePairs, newNumSubStates, mapping, partners, this.numSubStates);
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            pS = binaryRule.getParentState();
            short lcS = binaryRule.getLeftChildState();
            short rcS = binaryRule.getRightChildState();
            oldScores = binaryRule.getScores2();
            double[][][] newScores = new double[newNumSubStates[lcS]][newNumSubStates[rcS]][newNumSubStates[pS]];
            for (int i = 0; i < this.numSubStates[pS]; ++i) {
                if (partners[pS][i][0] != i) continue;
                parentSplit = partners[pS][i].length;
                for (j = 0; j < this.numSubStates[lcS]; ++j) {
                    if (partners[lcS][j][0] != j) continue;
                    int leftSplit = partners[lcS][j].length;
                    for (int k = 0; k < this.numSubStates[rcS]; ++k) {
                        int js;
                        int is;
                        int ks;
                        if (partners[rcS][k][0] != k) continue;
                        int rightSplit = partners[rcS][k].length;
                        double[][][] scores = new double[leftSplit][rightSplit][parentSplit];
                        for (int js2 = 0; js2 < leftSplit; ++js2) {
                            for (ks = 0; ks < rightSplit; ++ks) {
                                if (oldScores[partners[lcS][j][js2]][partners[rcS][k][ks]] == null) continue;
                                for (int is2 = 0; is2 < parentSplit; ++is2) {
                                    scores[js2][ks][is2] = oldScores[partners[lcS][j][js2]][partners[rcS][k][ks]][partners[pS][i][is2]];
                                }
                            }
                        }
                        if (rightSplit == 2) {
                            for (is = 0; is < parentSplit; ++is) {
                                for (js = 0; js < leftSplit; ++js) {
                                    double d = scores[js][0][is] + scores[js][1][is];
                                    scores[js][1][is] = d;
                                    scores[js][0][is] = d;
                                }
                            }
                        }
                        if (leftSplit == 2) {
                            for (is = 0; is < parentSplit; ++is) {
                                for (ks = 0; ks < rightSplit; ++ks) {
                                    double d = scores[0][ks][is] + scores[1][ks][is];
                                    scores[1][ks][is] = d;
                                    scores[0][ks][is] = d;
                                }
                            }
                        }
                        if (parentSplit == 2) {
                            for (int js2 = 0; js2 < leftSplit; ++js2) {
                                for (ks = 0; ks < rightSplit; ++ks) {
                                    double mergeWeightSum = mergeWeights[pS][partners[pS][i][0]] + mergeWeights[pS][partners[pS][i][1]];
                                    if (SloppyMath.isDangerous(mergeWeightSum)) {
                                        mergeWeightSum = 1.0;
                                    }
                                    double d = (scores[js2][ks][0] * mergeWeights[pS][partners[pS][i][0]] + scores[js2][ks][1] * mergeWeights[pS][partners[pS][i][1]]) / mergeWeightSum;
                                    scores[js2][ks][1] = d;
                                    scores[js2][ks][0] = d;
                                }
                            }
                        }
                        for (is = 0; is < parentSplit; ++is) {
                            for (js = 0; js < leftSplit; ++js) {
                                for (int ks2 = 0; ks2 < rightSplit; ++ks2) {
                                    newScores[mapping[lcS][partners[lcS][j][js]]][mapping[rcS][partners[rcS][k][ks2]]][mapping[pS][partners[pS][i][is]]] = scores[js][ks2][is];
                                }
                            }
                        }
                    }
                }
            }
            newRule = new BinaryRule(binaryRule);
            ((BinaryRule)newRule).setScores2(newScores);
            grammar.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            pS = unaryRule.getParentState();
            short cS = unaryRule.getChildState();
            double[][] newScores = new double[newNumSubStates[cS]][newNumSubStates[pS]];
            oldScores = unaryRule.getScores2();
            boolean allZero = true;
            for (int i = 0; i < this.numSubStates[pS]; ++i) {
                if (partners[pS][i][0] != i) continue;
                parentSplit = partners[pS][i].length;
                for (j = 0; j < this.numSubStates[cS]; ++j) {
                    int is;
                    int js;
                    if (partners[cS][j][0] != j) continue;
                    int childSplit = partners[cS][j].length;
                    double[][] scores = new double[childSplit][parentSplit];
                    for (js = 0; js < childSplit; ++js) {
                        if (oldScores[partners[cS][j][js]] == null) continue;
                        for (int is3 = 0; is3 < parentSplit; ++is3) {
                            scores[js][is3] = (double)oldScores[partners[cS][j][js]][partners[pS][i][is3]];
                        }
                    }
                    if (childSplit == 2) {
                        for (is = 0; is < parentSplit; ++is) {
                            double d = scores[0][is] + scores[1][is];
                            scores[1][is] = d;
                            scores[0][is] = d;
                        }
                    }
                    if (parentSplit == 2) {
                        for (js = 0; js < childSplit; ++js) {
                            double mergeWeightSum = mergeWeights[pS][partners[pS][i][0]] + mergeWeights[pS][partners[pS][i][1]];
                            if (SloppyMath.isDangerous(mergeWeightSum)) {
                                mergeWeightSum = 1.0;
                            }
                            double d = (scores[js][0] * mergeWeights[pS][partners[pS][i][0]] + scores[js][1] * mergeWeights[pS][partners[pS][i][1]]) / mergeWeightSum;
                            scores[js][1] = d;
                            scores[js][0] = d;
                        }
                    }
                    for (is = 0; is < parentSplit; ++is) {
                        for (int js3 = 0; js3 < childSplit; ++js3) {
                            newScores[mapping[cS][partners[cS][j][js3]]][mapping[pS][partners[pS][i][is]]] = scores[js3][is];
                            allZero = allZero && scores[js3][is] == 0.0;
                        }
                    }
                }
            }
            newRule = new UnaryRule(unaryRule);
            ((UnaryRule)newRule).setScores2(newScores);
            grammar.addUnary((UnaryRule)newRule);
        }
        grammar.pruneSplitTree(partners, mapping);
        grammar.isGrammarTag = this.isGrammarTag;
        grammar.closedViterbiRulesWithParent = grammar.unaryRulesWithParent;
        grammar.closedSumRulesWithParent = grammar.unaryRulesWithParent;
        grammar.closedViterbiRulesWithChild = grammar.unaryRulesWithC;
        grammar.closedSumRulesWithChild = grammar.unaryRulesWithC;
        return grammar;
    }

    private void pruneSplitTree(short[][][] partners, short[][] mapping) {
        for (int tag = 0; tag < this.splitTrees.length; ++tag) {
            Tree<Short> splitTree = this.splitTrees[tag];
            int maxDepth = splitTree.getDepth();
            for (Tree<Short> preTerminal : splitTree.getAtDepth(maxDepth - 2)) {
                List<Tree<Short>> children = preTerminal.getChildren();
                ArrayList newChildren = new ArrayList(2);
                for (int i = 0; i < children.size(); ++i) {
                    Tree<Short> child = children.get(i);
                    short curLoc = child.getLabel();
                    if (partners[tag][curLoc][0] != curLoc) continue;
                    newChildren.add(new Tree<Short>(mapping[tag][curLoc]));
                }
                preTerminal.setChildren(newChildren);
            }
        }
    }

    public static void checkNormalization(Grammar grammar) {
        short pS;
        double[][] psum = new double[grammar.numSubStates.length][];
        for (int pS2 = 0; pS2 < grammar.numSubStates.length; ++pS2) {
            psum[pS2] = new double[grammar.numSubStates[pS2]];
        }
        boolean[] sawPS = new boolean[grammar.numSubStates.length];
        for (UnaryRule ur : grammar.unaryRuleMap.values()) {
            pS = ur.getParentState();
            sawPS[pS] = true;
            short cS = ur.getChildState();
            double[][] scores = ur.getScores2();
            for (int ci = 0; ci < grammar.numSubStates[cS]; ++ci) {
                if (scores[ci] == null) continue;
                for (int pi = 0; pi < grammar.numSubStates[pS]; ++pi) {
                    double[] dArray = psum[pS];
                    int n = pi;
                    dArray[n] = dArray[n] + scores[ci][pi];
                }
            }
        }
        for (BinaryRule br : grammar.binaryRuleMap.values()) {
            pS = br.getParentState();
            sawPS[pS] = true;
            short lcS = br.getLeftChildState();
            short rcS = br.getRightChildState();
            double[][][] scores = br.getScores2();
            for (int lci = 0; lci < grammar.numSubStates[lcS]; ++lci) {
                for (int rci = 0; rci < grammar.numSubStates[rcS]; ++rci) {
                    if (scores[lci][rci] == null) continue;
                    for (int pi = 0; pi < grammar.numSubStates[pS]; ++pi) {
                        double[] dArray = psum[pS];
                        int n = pi;
                        dArray[n] = dArray[n] + scores[lci][rci][pi];
                    }
                }
            }
        }
        System.out.println();
        System.out.println("Checking for substates whose probs don't sum to 1");
        for (int pS3 = 0; pS3 < grammar.numSubStates.length; ++pS3) {
            if (!sawPS[pS3]) continue;
            for (int pi = 0; pi < grammar.numSubStates[pS3]; ++pi) {
                if (!(Math.abs(1.0 - psum[pS3][pi]) > 0.001)) continue;
                System.out.println(" state " + pS3 + " substate " + pi + " gives bad psum: " + psum[pS3][pi]);
            }
        }
    }

    public static void calculateMergeArrays(boolean[][][] mergeThesePairs, short[] newNumSubStates, short[][] mapping, short[][][] partners, short[] numSubStates) {
        for (int state = 0; state < numSubStates.length; state = (int)((short)(state + 1))) {
            short[] mergeTarget = new short[mergeThesePairs[state].length];
            Arrays.fill(mergeTarget, (short)-1);
            short count = 0;
            mapping[state] = new short[numSubStates[state]];
            partners[state] = new short[numSubStates[state]][];
            for (short j = 0; j < numSubStates[state]; j = (short)(j + 1)) {
                if (mergeTarget[j] != -1) {
                    mapping[state][j] = mergeTarget[j];
                    continue;
                }
                partners[state][j] = new short[1];
                partners[state][j][0] = j;
                mapping[state][j] = count;
                count = (short)(count + 1);
                for (short k = (short)(j + 1); k < numSubStates[state]; k = (short)(k + 1)) {
                    if (!mergeThesePairs[state][j][k]) continue;
                    mergeTarget[k] = mapping[state][j];
                    partners[state][j] = new short[2];
                    partners[state][j][0] = j;
                    partners[state][j][1] = k;
                    partners[state][k] = partners[state][j];
                }
            }
            newNumSubStates[state] = count;
        }
        newNumSubStates[0] = 1;
    }

    public void fixMergeWeightsEtc(boolean[][][] mergeThesePairs, double[][] mergeWeights, boolean[][][] complexMergePairs) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        short[][] mapping = new short[this.numSubStates.length][];
        short[][][] partners = new short[this.numSubStates.length][][];
        Grammar.calculateMergeArrays(mergeThesePairs, newNumSubStates, mapping, partners, this.numSubStates);
        for (int tag = 0; tag < this.numSubStates.length; ++tag) {
            double[] newMergeWeights = new double[newNumSubStates[tag]];
            for (int i = 0; i < this.numSubStates[tag]; ++i) {
                short s = mapping[tag][i];
                newMergeWeights[s] = newMergeWeights[s] + mergeWeights[tag][i];
            }
            mergeWeights[tag] = newMergeWeights;
            boolean[][] newComplexMergePairs = new boolean[newNumSubStates[tag]][newNumSubStates[tag]];
            boolean[][] newMergeThesePairs = new boolean[newNumSubStates[tag]][newNumSubStates[tag]];
            for (int i = 0; i < complexMergePairs[tag].length; ++i) {
                for (int j = 0; j < complexMergePairs[tag].length; ++j) {
                    newComplexMergePairs[mapping[tag][i]][mapping[tag][j]] = newComplexMergePairs[mapping[tag][i]][mapping[tag][j]] || complexMergePairs[tag][i][j];
                    newMergeThesePairs[mapping[tag][i]][mapping[tag][j]] = newMergeThesePairs[mapping[tag][i]][mapping[tag][j]] || mergeThesePairs[tag][i][j];
                }
            }
            complexMergePairs[tag] = newComplexMergePairs;
            mergeThesePairs[tag] = newMergeThesePairs;
        }
    }

    public void logarithmMode() {
        if (this.logarithmMode) {
            return;
        }
        this.logarithmMode = true;
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            Grammar.logarithmModeRule(this.unaryRuleMap.get(unaryRule));
        }
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            Grammar.logarithmModeRule(this.binaryRuleMap.get(binaryRule));
        }
        this.logarithmModeBRuleListArray(this.binaryRulesWithParent);
        this.logarithmModeBRuleListArray(this.binaryRulesWithLC);
        this.logarithmModeBRuleListArray(this.binaryRulesWithRC);
        this.logarithmModeBRuleArrayArray(this.splitRulesWithLC);
        this.logarithmModeBRuleArrayArray(this.splitRulesWithRC);
        this.logarithmModeBRuleArrayArray(this.splitRulesWithP);
        this.logarithmModeURuleListArray(this.unaryRulesWithParent);
        this.logarithmModeURuleListArray(this.unaryRulesWithC);
        this.logarithmModeURuleListArray(this.sumProductClosedUnaryRulesWithParent);
        this.logarithmModeURuleListArray(this.closedSumRulesWithParent);
        this.logarithmModeURuleListArray(this.closedSumRulesWithChild);
        this.logarithmModeURuleListArray(this.closedViterbiRulesWithParent);
        this.logarithmModeURuleListArray(this.closedViterbiRulesWithChild);
        this.logarithmModeURuleArrayArray(this.closedSumRulesWithP);
        this.logarithmModeURuleArrayArray(this.closedSumRulesWithC);
        this.logarithmModeURuleArrayArray(this.closedViterbiRulesWithP);
        this.logarithmModeURuleArrayArray(this.closedViterbiRulesWithC);
    }

    private void logarithmModeBRuleListArray(List<BinaryRule>[] a) {
        if (a != null) {
            for (List<BinaryRule> l : a) {
                if (l == null) continue;
                for (BinaryRule r : l) {
                    Grammar.logarithmModeRule(r);
                }
            }
        }
    }

    private void logarithmModeURuleListArray(List<UnaryRule>[] a) {
        if (a != null) {
            for (List<UnaryRule> l : a) {
                if (l == null) continue;
                for (UnaryRule r : l) {
                    Grammar.logarithmModeRule(r);
                }
            }
        }
    }

    private void logarithmModeBRuleArrayArray(BinaryRule[][] a) {
        if (a != null) {
            for (BinaryRule[] l : a) {
                if (l == null) continue;
                for (BinaryRule r : l) {
                    Grammar.logarithmModeRule(r);
                }
            }
        }
    }

    private void logarithmModeURuleArrayArray(UnaryRule[][] a) {
        if (a != null) {
            for (UnaryRule[] l : a) {
                if (l == null) continue;
                for (UnaryRule r : l) {
                    Grammar.logarithmModeRule(r);
                }
            }
        }
    }

    private static void logarithmModeRule(BinaryRule r) {
        if (r == null || r.logarithmMode) {
            return;
        }
        r.logarithmMode = true;
        double[][][] scores = r.getScores2();
        for (int i = 0; i < scores.length; ++i) {
            for (int j = 0; j < scores[i].length; ++j) {
                if (scores[i][j] == null) continue;
                for (int k = 0; k < scores[i][j].length; ++k) {
                    scores[i][j][k] = Math.log(scores[i][j][k]);
                }
            }
        }
        r.setScores2(scores);
    }

    private static void logarithmModeRule(UnaryRule r) {
        if (r == null || r.logarithmMode) {
            return;
        }
        r.logarithmMode = true;
        double[][] scores = r.getScores2();
        for (int j = 0; j < scores.length; ++j) {
            if (scores[j] == null) continue;
            for (int k = 0; k < scores[j].length; ++k) {
                scores[j][k] = Math.log(scores[j][k]);
            }
        }
        r.setScores2(scores);
    }

    public boolean isLogarithmMode() {
        return this.logarithmMode;
    }

    public final boolean isGrammarTag(int n) {
        return this.isGrammarTag[n];
    }

    public Grammar projectGrammar(double[] condProbs, int[][] fromMapping, int[][] toSubstateMapping) {
        short pcS;
        short[] newNumSubStates = new short[this.numSubStates.length];
        for (int state = 0; state < this.numSubStates.length; ++state) {
            newNumSubStates[state] = (short)toSubstateMapping[state][0];
        }
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            pcS = binaryRule.getParentState();
            short lcS = binaryRule.getLeftChildState();
            short rcS = binaryRule.getRightChildState();
            double[][][] oldScores = binaryRule.getScores2();
            double[][][] newScores = new double[newNumSubStates[lcS]][newNumSubStates[rcS]][newNumSubStates[pcS]];
            for (int lS = 0; lS < this.numSubStates[lcS]; ++lS) {
                for (int rS = 0; rS < this.numSubStates[rcS]; ++rS) {
                    if (oldScores[lS][rS] == null) continue;
                    for (int pS = 0; pS < this.numSubStates[pcS]; ++pS) {
                        double[] dArray = newScores[toSubstateMapping[lcS][lS + 1]][toSubstateMapping[rcS][rS + 1]];
                        int n = toSubstateMapping[pcS][pS + 1];
                        dArray[n] = dArray[n] + condProbs[fromMapping[pcS][pS]] * oldScores[lS][rS][pS];
                    }
                }
            }
            BinaryRule newRule = new BinaryRule(binaryRule, newScores);
            grammar.addBinary(newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            pcS = unaryRule.getParentState();
            short ccS = unaryRule.getChildState();
            double[][] oldScores = unaryRule.getScores2();
            double[][] newScores = new double[newNumSubStates[ccS]][newNumSubStates[pcS]];
            for (int cS = 0; cS < this.numSubStates[ccS]; ++cS) {
                if (oldScores[cS] == null) continue;
                for (int pS = 0; pS < this.numSubStates[pcS]; ++pS) {
                    double[] dArray = newScores[toSubstateMapping[ccS][cS + 1]];
                    int n = toSubstateMapping[pcS][pS + 1];
                    dArray[n] = dArray[n] + condProbs[fromMapping[pcS][pS]] * oldScores[cS][pS];
                }
            }
            UnaryRule newRule = new UnaryRule(unaryRule, newScores);
            grammar.addUnary(newRule);
        }
        grammar.computePairsOfUnaries();
        grammar.makeCRArrays();
        grammar.isGrammarTag = this.isGrammarTag;
        return grammar;
    }

    public Grammar copyGrammar(boolean noUnaryChains) {
        Rule newRule;
        short[] newNumSubStates = (short[])this.numSubStates.clone();
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            newRule = new BinaryRule(binaryRule);
            grammar.addBinary((BinaryRule)newRule);
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            newRule = new UnaryRule(unaryRule);
            grammar.addUnary((UnaryRule)newRule);
        }
        if (noUnaryChains) {
            this.closedViterbiRulesWithParent = this.unaryRulesWithParent;
            this.closedSumRulesWithParent = this.unaryRulesWithParent;
            this.closedViterbiRulesWithChild = this.unaryRulesWithC;
            this.closedSumRulesWithChild = this.unaryRulesWithC;
        } else {
            grammar.computePairsOfUnaries();
        }
        grammar.makeCRArrays();
        grammar.isGrammarTag = this.isGrammarTag;
        return grammar;
    }

    public Grammar projectTo0LevelGrammar(double[] condProbs, int[][] fromMapping, int[][] toMapping) {
        short pcS;
        int newNumStates = fromMapping[fromMapping.length - 1][0];
        double[][] newBinaryProbs = new double[newNumStates][newNumStates];
        double[] newUnaryProbs = new double[newNumStates];
        short[] newNumSubStates = new short[this.numSubStates.length];
        Arrays.fill(newNumSubStates, (short)1);
        Grammar grammar = new Grammar(newNumSubStates, this.findClosedPaths, this.smoother, this, this.threshold);
        for (BinaryRule binaryRule : this.binaryRuleMap.keySet()) {
            pcS = binaryRule.getParentState();
            short lcS = binaryRule.getLeftChildState();
            short rcS = binaryRule.getRightChildState();
            double[][][] oldScores = binaryRule.getScores2();
            for (int lS = 0; lS < this.numSubStates[lcS]; ++lS) {
                for (int rS = 0; rS < this.numSubStates[rcS]; ++rS) {
                    if (oldScores[lS][rS] == null) continue;
                    for (int pS = 0; pS < this.numSubStates[pcS]; ++pS) {
                        double[] dArray = newBinaryProbs[toMapping[lcS][lS]];
                        int n = toMapping[rcS][rS];
                        dArray[n] = dArray[n] + condProbs[fromMapping[pcS][pS]] * oldScores[lS][rS][pS];
                    }
                }
            }
        }
        for (UnaryRule unaryRule : this.unaryRuleMap.keySet()) {
            pcS = unaryRule.getParentState();
            short ccS = unaryRule.getChildState();
            double[][] oldScores = unaryRule.getScores2();
            for (int cS = 0; cS < this.numSubStates[ccS]; ++cS) {
                if (oldScores[cS] == null) continue;
                for (int pS = 0; pS < this.numSubStates[pcS]; ++pS) {
                    int n = toMapping[ccS][cS];
                    newUnaryProbs[n] = newUnaryProbs[n] + condProbs[fromMapping[pcS][pS]] * oldScores[cS][pS];
                }
            }
        }
        for (short lS = 0; lS < newBinaryProbs.length; lS = (short)((short)(lS + 1))) {
            short s;
            boolean bl = false;
            while (s < newBinaryProbs.length) {
                if (newBinaryProbs[lS][s] > 0.0) {
                    double[][][] newScores = new double[1][1][1];
                    newScores[0][0][0] = newBinaryProbs[lS][s];
                    BinaryRule newRule = new BinaryRule(0, lS, s, newScores);
                    grammar.addBinary(newRule);
                }
                s = (short)(s + true);
            }
        }
        for (short cS = 0; cS < newUnaryProbs.length; cS = (short)((short)(cS + 1))) {
            if (!(newUnaryProbs[cS] > 0.0)) continue;
            double[][] dArray = new double[1][1];
            dArray[0][0] = newUnaryProbs[cS];
            UnaryRule newRule = new UnaryRule(0, cS, dArray);
            grammar.addUnary(newRule);
        }
        grammar.computePairsOfUnaries();
        grammar.makeCRArrays();
        grammar.isGrammarTag = this.isGrammarTag;
        return grammar;
    }

    public double[] computeConditionalProbabilities(int[][] fromMapping, int[][] toMapping) {
        double[][] transitionProbs = this.computeProductionProbabilities(fromMapping);
        double[] expectedCounts = this.computeExpectedCounts(transitionProbs);
        double[] condProbs = new double[expectedCounts.length];
        for (int projectedState = 0; projectedState < toMapping[toMapping.length - 1][0]; ++projectedState) {
            int substate;
            int state;
            double sum = 0.0;
            for (state = 0; state < fromMapping.length - 1; ++state) {
                for (substate = 0; substate < fromMapping[state].length; ++substate) {
                    if (toMapping[state][substate] != projectedState) continue;
                    sum += expectedCounts[fromMapping[state][substate]];
                }
            }
            for (state = 0; state < fromMapping.length - 1; ++state) {
                for (substate = 0; substate < fromMapping[state].length; ++substate) {
                    if (toMapping[state][substate] != projectedState) continue;
                    condProbs[fromMapping[state][substate]] = expectedCounts[fromMapping[state][substate]] / sum;
                }
            }
        }
        return condProbs;
    }

    public int[][] computeToMapping(int level, int[][] toSubstateMapping) {
        if (level == -1) {
            return this.computeMapping(-1);
        }
        short[] numSubStates = this.numSubStates;
        int[][] mapping = new int[numSubStates.length + 1][];
        int k = 0;
        for (int state = 0; state < numSubStates.length; ++state) {
            mapping[state] = new int[numSubStates[state]];
            int oldVal = -1;
            for (int substate = 0; substate < numSubStates[state]; ++substate) {
                if (substate == 0 || oldVal != toSubstateMapping[state][substate + 1]) {
                    // empty if block
                }
                mapping[state][substate] = ++k;
                oldVal = toSubstateMapping[state][substate + 1];
            }
            ++k;
        }
        mapping[numSubStates.length] = new int[1];
        mapping[numSubStates.length][0] = k;
        return mapping;
    }

    public int[][] computeMapping(int level) {
        short[] numSubStates = this.numSubStates;
        int[][] mapping = new int[numSubStates.length + 1][];
        int k = 0;
        for (int state = 0; state < numSubStates.length; ++state) {
            mapping[state] = new int[numSubStates[state]];
            Arrays.fill(mapping[state], -1);
            for (int substate = 0; substate < numSubStates[state]; ++substate) {
                if (level >= 1) {
                    mapping[state][substate] = k++;
                    continue;
                }
                if (level == -1) {
                    if (this.isGrammarTag(state)) {
                        mapping[state][substate] = 0;
                        continue;
                    }
                    mapping[state][substate] = state;
                    continue;
                }
                mapping[state][substate] = state;
            }
        }
        mapping[numSubStates.length] = new int[1];
        mapping[numSubStates.length][0] = level < 1 ? numSubStates.length : k;
        return mapping;
    }

    public int[][] computeSubstateMapping(int level) {
        short[] numSubStates = this.numSubStates;
        int[][] mapping = new int[numSubStates.length][];
        for (int state = 0; state < numSubStates.length; ++state) {
            mapping[state] = new int[numSubStates[state] + 1];
            int k = 0;
            if (level >= 0) {
                Arrays.fill(mapping[state], -1);
                Tree<Short> hierarchy = this.splitTrees[state];
                List<Tree<Short>> subTrees = hierarchy.getAtDepth(level);
                for (Tree<Short> subTree : subTrees) {
                    List<Short> leaves = subTree.getYield();
                    for (Short substate : leaves) {
                        if (substate == numSubStates[state]) {
                            System.out.print("Will crash.");
                        }
                        mapping[state][substate.shortValue() + 1] = k;
                    }
                    ++k;
                }
            } else {
                k = 1;
            }
            mapping[state][0] = k;
        }
        return mapping;
    }

    public void computeReverseSubstateMapping(int level, int[][] lChildMap, int[][] rChildMap) {
        for (int state = 0; state < this.numSubStates.length; ++state) {
            Tree<Short> hierarchy = this.splitTrees[state];
            List<Tree<Short>> subTrees = hierarchy.getAtDepth(level);
            lChildMap[state] = new int[subTrees.size()];
            rChildMap[state] = new int[subTrees.size()];
            for (Tree<Short> subTree : subTrees) {
                short substate = subTree.getLabel();
                if (subTree.isLeaf()) {
                    lChildMap[state][substate] = substate;
                    rChildMap[state][substate] = substate;
                    continue;
                }
                boolean first = true;
                int nChildren = subTree.getChildren().size();
                for (Tree<Short> child : subTree.getChildren()) {
                    if (first) {
                        lChildMap[state][substate] = child.getLabel().shortValue();
                        first = false;
                    } else {
                        rChildMap[state][substate] = child.getLabel().shortValue();
                    }
                    if (nChildren != 1) continue;
                    rChildMap[state][substate] = child.getLabel().shortValue();
                }
            }
        }
    }

    private double[] computeExpectedCounts(double[][] transitionProbs) {
        double[] expectedCounts = new double[transitionProbs.length];
        double[] tmpCounts = new double[transitionProbs.length];
        expectedCounts[0] = 1.0;
        tmpCounts[0] = 1.0;
        int iter = 0;
        double diff = 1.0;
        double sum = 1.0;
        while (diff > 1.0E-10 && iter < 50) {
            int state;
            ++iter;
            for (state = 1; state < expectedCounts.length; ++state) {
                for (int pState = 0; pState < expectedCounts.length; ++pState) {
                    int n = state;
                    tmpCounts[n] = tmpCounts[n] + expectedCounts[pState] * transitionProbs[pState][state];
                }
            }
            diff = 0.0;
            sum = 1.0;
            for (state = 1; state < expectedCounts.length; ++state) {
                diff += Math.abs(expectedCounts[state] - tmpCounts[state]);
                expectedCounts[state] = tmpCounts[state];
                sum += tmpCounts[state];
                tmpCounts[state] = 0.0;
            }
            expectedCounts[0] = 1.0;
            tmpCounts[0] = 1.0;
        }
        return expectedCounts;
    }

    private double[][] computeProductionProbabilities(int[][] mapping) {
        short[] numSubStates = this.numSubStates;
        int totalStates = mapping[numSubStates.length][0];
        double[][] W = new double[totalStates][totalStates];
        for (int state = 0; state < numSubStates.length; ++state) {
            Object scores;
            BinaryRule[] parentRules = this.splitRulesWithP(state);
            for (int i = 0; i < parentRules.length; ++i) {
                BinaryRule r = parentRules[i];
                short lState = r.leftChildState;
                short rState = r.rightChildState;
                scores = r.getScores2();
                for (int lS = 0; lS < numSubStates[lState]; ++lS) {
                    for (int rS = 0; rS < numSubStates[rState]; ++rS) {
                        if (scores[lS][rS] == null) continue;
                        for (int pS = 0; pS < numSubStates[state]; ++pS) {
                            double[] dArray = W[mapping[state][pS]];
                            int n = mapping[lState][lS];
                            dArray[n] = dArray[n] + scores[lS][rS][pS];
                            double[] dArray2 = W[mapping[state][pS]];
                            int n2 = mapping[rState][rS];
                            dArray2[n2] = dArray2[n2] + scores[lS][rS][pS];
                        }
                    }
                }
            }
            List<UnaryRule> uRules = this.getUnaryRulesByParent(state);
            for (UnaryRule r : uRules) {
                short cState = r.childState;
                if (cState == state) continue;
                scores = r.getScores2();
                for (int cS = 0; cS < numSubStates[cState]; ++cS) {
                    if (scores[cS] == null) continue;
                    for (int pS = 0; pS < numSubStates[state]; ++pS) {
                        double[] dArray = W[mapping[state][pS]];
                        int n = mapping[cState][cS];
                        dArray[n] = dArray[n] + scores[cS][pS];
                    }
                }
            }
        }
        return W;
    }

    public void computeProperClosures() {
        short startState;
        double[][] scores;
        int i;
        int[][] map = new int[this.numStates][];
        int index = 0;
        for (int state = 0; state < this.numStates; ++state) {
            map[state] = new int[this.numSubStates[state]];
            for (int substate = 0; substate < this.numSubStates[state]; ++substate) {
                map[state][substate] = index++;
            }
        }
        double[][][] sumClosureMatrix = new double[10][index][index];
        for (int parentState = 0; parentState < this.numStates; ++parentState) {
            for (i = 0; i < this.unaryRulesWithParent[parentState].size(); ++i) {
                UnaryRule rule = this.unaryRulesWithParent[parentState].get(i);
                short childState = rule.getChildState();
                scores = rule.getScores2();
                for (int childSubState = 0; childSubState < this.numSubStates[childState]; ++childSubState) {
                    if (scores[childSubState] == null) continue;
                    for (int parentSubState = 0; parentSubState < this.numSubStates[parentState]; ++parentSubState) {
                        sumClosureMatrix[0][map[parentState][parentSubState]][map[childState][childSubState]] = scores[childSubState][parentSubState];
                    }
                }
            }
        }
        for (int length = 1; length < 10; ++length) {
            for (short interState = 0; interState < this.numStates; interState = (short)(interState + 1)) {
                for (int i2 = 0; i2 < this.unaryRulesWithParent[interState].size(); ++i2) {
                    UnaryRule rule = this.unaryRulesWithParent[interState].get(i2);
                    short endState = rule.getChildState();
                    double[][] scores2 = rule.getScores2();
                    for (int startState2 = 0; startState2 < this.numStates; ++startState2) {
                        for (int startSubState = 0; startSubState < this.numSubStates[startState2]; ++startSubState) {
                            for (int endSubState = 0; endSubState < this.numSubStates[endState]; ++endSubState) {
                                double ruleScore = 0.0;
                                if (scores2[endSubState] == null) continue;
                                for (int interSubState = 0; interSubState < this.numSubStates[interState]; ++interSubState) {
                                    ruleScore += sumClosureMatrix[length - 1][map[startState2][startSubState]][map[interState][interSubState]] * scores2[endSubState][interSubState];
                                }
                                double[] dArray = sumClosureMatrix[length][map[startState2][startSubState]];
                                int n = map[endState][endSubState];
                                dArray[n] = dArray[n] + ruleScore;
                            }
                        }
                    }
                }
            }
        }
        double[][] sumClosureScores = new double[index][index];
        for (int length = 0; length < 10; ++length) {
            for (int startState3 = 0; startState3 < index; ++startState3) {
                for (int endState = 0; endState < index; ++endState) {
                    double[] dArray = sumClosureScores[startState3];
                    int n = endState;
                    dArray[n] = dArray[n] + sumClosureMatrix[length][startState3][endState];
                }
            }
        }
        this.closedSumRulesWithParent = new List[this.numStates];
        this.closedSumRulesWithChild = new List[this.numStates];
        for (startState = 0; startState < this.numStates; startState = (short)(startState + 1)) {
            this.closedSumRulesWithParent[startState] = new ArrayList<UnaryRule>();
            this.closedSumRulesWithChild[startState] = new ArrayList<UnaryRule>();
        }
        for (startState = 0; startState < this.numStates; startState = (short)(startState + 1)) {
            for (short endState = 0; endState < this.numStates; endState = (short)(endState + 1)) {
                if (startState == endState) continue;
                boolean atLeastOneNonZero = false;
                scores = new double[this.numSubStates[endState]][this.numSubStates[startState]];
                for (int startSubState = 0; startSubState < this.numSubStates[startState]; ++startSubState) {
                    for (int endSubState = 0; endSubState < this.numSubStates[endState]; ++endSubState) {
                        double score = sumClosureScores[map[startState][startSubState]][map[endState][endSubState]];
                        if (!(score > 0.0)) continue;
                        scores[endSubState][startSubState] = score;
                        atLeastOneNonZero = true;
                    }
                }
                if (!atLeastOneNonZero) continue;
                UnaryRule newUnary = new UnaryRule(startState, endState, scores);
                this.addUnary(newUnary);
                this.closedSumRulesWithParent[startState].add(newUnary);
                this.closedSumRulesWithChild[endState].add(newUnary);
            }
        }
        if (this.closedSumRulesWithP == null) {
            this.closedSumRulesWithP = new UnaryRule[this.numStates][];
            this.closedSumRulesWithC = new UnaryRule[this.numStates][];
        }
        for (i = 0; i < this.numStates; ++i) {
            this.closedSumRulesWithP[i] = this.closedSumRulesWithParent[i].toArray(new UnaryRule[0]);
            this.closedSumRulesWithC[i] = this.closedSumRulesWithChild[i].toArray(new UnaryRule[0]);
        }
    }

    public void writeSplitTrees(Writer w) {
        PrintWriter out = new PrintWriter(w);
        for (int state = 1; state < this.numStates; ++state) {
            String tag = (String)this.tagNumberer.object(state);
            if (this.isGrammarTag[state] && tag.endsWith("^g")) {
                tag = tag.substring(0, tag.length() - 2);
            }
            out.write(tag + "\t" + this.splitTrees[state].toString() + "\n");
        }
        out.flush();
        out.close();
    }

    public int[][] getClosedSumPaths() {
        return this.closedSumPaths;
    }

    public static class RuleNotFoundException
    extends Exception {
        private static final long serialVersionUID = 2L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RandomInitializationType {
        INITIALIZE_WITH_SMALL_RANDOMIZATION,
        INITIALIZE_LIKE_MMT;

    }
}

