/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import java.util.HashMap;

public class GrammarAnalyzer {
    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        String inFileName = opts.grFileName;
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        Lexicon lexicon = pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        if (opts.threshold > -1.0) {
            System.out.println("Remving rules with probability below " + opts.threshold + ".");
            grammar.splitRules();
            grammar.removeUnlikelyRules(opts.threshold, 1.0);
            lexicon.removeUnlikelyTags(opts.threshold, 1.0);
        }
        int[] tagTotal = new int[grammar.numSubStates.length];
        int[] tagOne = new int[grammar.numSubStates.length];
        int[] gr = GrammarAnalyzer.computeAndPrintCounts(grammar, tagTotal, tagOne);
        GrammarAnalyzer.printStats("Grammar", gr);
        int[] lex = GrammarAnalyzer.computeAndPrintCounts(lexicon, tagTotal, tagOne);
        GrammarAnalyzer.printStats("Lexicon", lex);
        ArrayUtil.addInPlace(gr, lex);
        GrammarAnalyzer.printStats("Together", gr);
        System.out.println("\nTag specific statistics (x=1):");
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        for (int i = 0; i < tagTotal.length; ++i) {
            System.out.println(tagNumberer.object(i) + ": " + tagOne[i] + "/" + tagTotal[i]);
        }
        System.exit(0);
    }

    public static int[] computeAndPrintCounts(Grammar gr, int[] tagTotal, int[] tagOne) {
        int nulledOut = 0;
        int zero = 0;
        int belowOne = 0;
        int one = 0;
        int aboveOne = 0;
        int total = 0;
        int unaryEqualSlices = 0;
        int binaryEqualSlices = 0;
        int unarySlices = 0;
        int binarySlices = 0;
        int unaryEqual = 0;
        int binaryEqual = 0;
        int unary = 0;
        int binary = 0;
        for (int state = 0; state < gr.numStates; ++state) {
            int nParentSubStates = gr.numSubStates[state];
            for (UnaryRule uRule : gr.getUnaryRulesByParent(state)) {
                int nChildSubStates = gr.numSubStates[uRule.childState];
                total += nChildSubStates * nParentSubStates;
                ++unary;
                double[][] scores = uRule.getScores2();
                for (int j = 0; j < nChildSubStates; ++j) {
                    ++unarySlices;
                    if (scores[j] == null) {
                        nulledOut += nParentSubStates;
                        continue;
                    }
                    boolean sliceTheSame = true;
                    double first = scores[j][0];
                    for (int i = 0; i < nParentSubStates; ++i) {
                        double p = scores[j][i];
                        if (p == 0.0) {
                            ++zero;
                        } else if (p == 1.0) {
                            ++one;
                        } else if (p > 1.0) {
                            ++aboveOne;
                        } else {
                            ++belowOne;
                        }
                        if (sliceTheSame && p != first) {
                            sliceTheSame = false;
                        }
                        int n = state;
                        tagTotal[n] = tagTotal[n] + 1;
                        if (p != 1.0) continue;
                        int n2 = state;
                        tagOne[n2] = tagOne[n2] + 1;
                    }
                    if (!sliceTheSame) continue;
                    ++unaryEqualSlices;
                }
            }
            for (BinaryRule bRule : gr.splitRulesWithP(state)) {
                double[][][] scores = bRule.getScores2();
                ++binary;
                for (int j = 0; j < scores.length; ++j) {
                    for (int k = 0; k < scores[j].length; ++k) {
                        total += nParentSubStates;
                        ++binarySlices;
                        if (scores[j][k] == null) {
                            nulledOut += nParentSubStates;
                            continue;
                        }
                        boolean sliceTheSame = true;
                        double first = scores[j][k][0];
                        for (int i = 0; i < nParentSubStates; ++i) {
                            double p = scores[j][k][i];
                            if (p == 0.0) {
                                ++zero;
                            } else if (p == 1.0) {
                                ++one;
                            } else if (p > 1.0) {
                                ++aboveOne;
                            } else {
                                ++belowOne;
                            }
                            if (sliceTheSame && p != first) {
                                sliceTheSame = false;
                            }
                            int n = state;
                            tagTotal[n] = tagTotal[n] + 1;
                            if (p != 1.0) continue;
                            int n3 = state;
                            tagOne[n3] = tagOne[n3] + 1;
                        }
                        if (!sliceTheSame) continue;
                        ++binaryEqualSlices;
                    }
                }
            }
        }
        System.out.println("Same across parent: " + unaryEqualSlices + "/" + unarySlices + " (unary), " + binaryEqualSlices + "/" + binarySlices + " (binary)");
        System.out.println("All the same: " + unaryEqual + "/" + unary + " (unary), " + binaryEqual + "/" + binary + " (binary)");
        return new int[]{nulledOut, zero, belowOne, one, aboveOne, total};
    }

    public static int[] computeAndPrintCounts(Lexicon lexicon, int[] tagTotal, int[] tagOne) {
        int zero = 0;
        int belowOne = 0;
        int one = 0;
        int aboveOne = 0;
        int total = 0;
        int equal = 0;
        int pairs = 0;
        if (lexicon instanceof SophisticatedLexicon) {
            SophisticatedLexicon lex = (SophisticatedLexicon)lexicon;
            for (short tag = 0; tag < lex.numSubStates.length; tag = (short)((short)(tag + 1))) {
                HashMap<String, double[]> tagMap = lex.wordToTagCounters[tag];
                if (tagMap == null) continue;
                for (String word : tagMap.keySet()) {
                    double[] lexiconScores = lex.score(word, tag, 0, false, false);
                    for (int i = 0; i < lexiconScores.length; ++i) {
                        ++total;
                        double p = lexiconScores[i];
                        if (p == 0.0) {
                            ++zero;
                        } else if (p == 1.0) {
                            ++one;
                        } else if (p > 1.0) {
                            ++aboveOne;
                        } else {
                            ++belowOne;
                        }
                        short s = tag;
                        tagTotal[s] = tagTotal[s] + 1;
                        if (p != 1.0) continue;
                        short s2 = tag;
                        tagOne[s2] = tagOne[s2] + 1;
                    }
                }
            }
        } else {
            SimpleLexicon lex = (SimpleLexicon)lexicon;
            for (int tag = 0; tag < lex.scores.length; ++tag) {
                if (lex.tagWordIndexer[tag].size() == 0) continue;
                for (int word = 0; word < lex.scores[tag][0].length; ++word) {
                    boolean allTheSame = true;
                    double first = lex.scores[tag][0][word];
                    ++pairs;
                    for (int substate = 0; substate < lex.numSubStates[tag]; ++substate) {
                        ++total;
                        double p = lex.scores[tag][substate][word];
                        if (p == 0.0) {
                            ++zero;
                        } else if (p == 1.0) {
                            ++one;
                        } else if (p > 1.0) {
                            ++aboveOne;
                        } else {
                            ++belowOne;
                        }
                        if (allTheSame && p != first) {
                            allTheSame = false;
                        }
                        int n = tag;
                        tagTotal[n] = tagTotal[n] + 1;
                        if (p != 1.0) continue;
                        int n2 = tag;
                        tagOne[n2] = tagOne[n2] + 1;
                    }
                    if (!allTheSame) continue;
                    ++equal;
                }
            }
            System.out.println("Same across parent: " + equal + "/" + pairs);
        }
        return new int[]{0, zero, belowOne, one, aboveOne, total};
    }

    public static void printStats(String title, int[] vals) {
        int nulledOut = vals[0];
        int zero = vals[1];
        int belowOne = vals[2];
        int one = vals[3];
        int aboveOne = vals[4];
        int total = vals[5];
        System.out.println(title + " statistics:");
        System.out.println("Total rules:\t" + total);
        System.out.println("Total non-zero:\t" + (belowOne + one + aboveOne) + "\n");
        System.out.println("Nulled out:\t" + nulledOut);
        System.out.println("x = 0:\t\t" + zero);
        System.out.println("0 < x < 1:\t" + belowOne);
        System.out.println("x = 1:\t\t" + one);
        System.out.println("x > 1:\t\t" + aboveOne + "\n");
    }

    public static class Options {
        @Option(name="-in", required=true, usage="Grammarfile")
        public String grFileName;
        @Option(name="-t", usage="Threshold for pruning unlikely rules")
        public double threshold = -1.0;
    }
}

