/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConstrainedHierarchicalTwoChartParser;
import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.FullState;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.SearchState;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarStatistics {
    private static int topN = 10;
    public Grammar grammar;
    public Numberer tagNumberer;
    public int nScores;
    static NumberFormat f = NumberFormat.getInstance();

    public GrammarStatistics(Grammar grammar, Numberer tagNumberer, int nScores) {
        this.grammar = grammar;
        this.tagNumberer = tagNumberer;
        this.nScores = nScores;
    }

    PriorityQueue<SearchState> getTopProductions(FullState p) {
        PriorityQueue<SearchState> results = new PriorityQueue<SearchState>(this.nScores + 1);
        PriorityQueue<SearchState> unExpanded = new PriorityQueue<SearchState>();
        unExpanded.add(new SearchState(p, 0.0), 0.0);
        while (unExpanded.size() != 0 && (results.size() < this.nScores || ((SearchState)unExpanded.peek()).score > -results.peek().score)) {
            SearchState state = (SearchState)unExpanded.next();
            if (state.danglingState == null || state.produced.size() != 0 && !this.continues(state.danglingState.state)) {
                if (state.danglingState != null) {
                    state = state.extend(state.danglingState, null, 0.0, false);
                }
                results.add(state, -state.score);
                if (results.size() <= this.nScores) continue;
                results.next();
                continue;
            }
            for (UnaryRule rule : this.grammar.getUnaryRulesByParent(state.danglingState.state)) {
                double[][] scores = rule.getScores2();
                for (short cSubState = 0; cSubState < this.grammar.numSubStates[rule.getChildState()]; cSubState = (short)(cSubState + 1)) {
                    if (scores[cSubState] == null) continue;
                    double rscore = scores[cSubState][state.danglingState.substate];
                    FullState s = new FullState(rule.getChildState(), cSubState);
                    SearchState newState = state.extend(s, null, rscore, false);
                    unExpanded.add(newState, newState.score);
                }
            }
            for (BinaryRule rule : this.grammar.splitRulesWithP(state.danglingState.state)) {
                double[][][] scores = rule.getScores2();
                for (short lSubState = 0; lSubState < this.grammar.numSubStates[rule.getLeftChildState()]; lSubState = (short)(lSubState + 1)) {
                    FullState ls = new FullState(rule.getLeftChildState(), lSubState);
                    for (short rSubState = 0; rSubState < this.grammar.numSubStates[rule.getRightChildState()]; rSubState = (short)(rSubState + 1)) {
                        if (scores[lSubState][rSubState] == null) continue;
                        FullState rs = new FullState(rule.getRightChildState(), rSubState);
                        double rscore = scores[lSubState][rSubState][state.danglingState.substate];
                        SearchState newState = this.continues(ls.state) ? state.extend(rs, ls, rscore, true) : state.extend(ls, rs, rscore, false);
                        unExpanded.add(newState, newState.score);
                    }
                }
            }
        }
        return results;
    }

    PriorityQueue<SearchState> getTopParentRuleProductions(FullState c, double[] probState, double[][] probSubGivenState) {
        PriorityQueue<SearchState> results = new PriorityQueue<SearchState>(this.nScores + 1);
        PriorityQueue<SearchState> unExpanded = new PriorityQueue<SearchState>();
        double score = -(probState[c.state] + probSubGivenState[c.state][c.substate]);
        unExpanded.add(new SearchState(c, c, score), -score);
        int maxSize = 10000;
        while (unExpanded.size() != 0 && unExpanded.size() < maxSize && (results.size() < this.nScores || ((SearchState)unExpanded.peek()).score > -results.peek().score)) {
            SearchState newState;
            double rscore;
            FullState rs;
            FullState ps;
            short pSubState;
            SearchState state = (SearchState)unExpanded.next();
            if (state.danglingState == null || state.extended && !this.continues(state.danglingState.state)) {
                if (state.danglingState != null) {
                    state.parent = state.danglingState;
                }
                state.score += probState[state.parent.state] + probSubGivenState[state.parent.state][state.parent.substate];
                results.add(state, -state.score);
                if (results.size() <= this.nScores) continue;
                results.next();
                continue;
            }
            for (UnaryRule rule : this.grammar.getUnaryRulesByChild(state.danglingState.state)) {
                double[][] scores = rule.getScores2();
                if (scores[state.danglingState.substate] == null) continue;
                for (short pSubState2 = 0; pSubState2 < this.grammar.numSubStates[rule.getParentState()]; pSubState2 = (short)(pSubState2 + 1)) {
                    double rscore2 = scores[state.danglingState.substate][pSubState2];
                    FullState s = new FullState(rule.getParentState(), pSubState2);
                    SearchState newState2 = state.extendUp(null, s, rscore2, false);
                    unExpanded.add(newState2, newState2.score);
                }
            }
            for (BinaryRule rule : this.grammar.splitRulesWithLC(state.danglingState.state)) {
                double[][][] scores = rule.getScores2();
                for (pSubState = 0; pSubState < this.grammar.numSubStates[rule.getParentState()]; pSubState = (short)(pSubState + 1)) {
                    ps = new FullState(rule.getParentState(), pSubState);
                    for (short rSubState = 0; rSubState < this.grammar.numSubStates[rule.getRightChildState()]; rSubState = (short)(rSubState + 1)) {
                        if (scores[state.danglingState.substate][rSubState] == null) continue;
                        rs = new FullState(rule.getRightChildState(), rSubState);
                        rscore = scores[state.danglingState.substate][rSubState][pSubState];
                        newState = state.extendUp(rs, ps, rscore, false);
                        unExpanded.add(newState, newState.score);
                    }
                }
            }
            for (BinaryRule rule : this.grammar.splitRulesWithRC(state.danglingState.state)) {
                double[][][] scores = rule.getScores2();
                for (pSubState = 0; pSubState < this.grammar.numSubStates[rule.getParentState()]; pSubState = (short)(pSubState + 1)) {
                    ps = new FullState(rule.getParentState(), pSubState);
                    for (short lSubState = 0; lSubState < this.grammar.numSubStates[rule.getLeftChildState()]; lSubState = (short)(lSubState + 1)) {
                        if (scores[lSubState][state.danglingState.substate] == null) continue;
                        rs = new FullState(rule.getLeftChildState(), lSubState);
                        rscore = scores[lSubState][state.danglingState.substate][pSubState];
                        newState = state.extendUp(rs, ps, rscore, true);
                        unExpanded.add(newState, newState.score);
                    }
                }
            }
        }
        return results;
    }

    public boolean continues(short state) {
        return ((String)this.tagNumberer.object(state)).charAt(0) == '@';
    }

    public static String pad(String s, int width, char c) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = s.length(); i < width; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int state;
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, false);
        System.out.println("Calling GrammarStatistics with " + optParser.getPassedInOptions());
        f.setMaximumFractionDigits(5);
        System.out.println("<html><body>");
        System.out.println("<h1>Links</h1><ul>");
        System.out.println("<li><a href=\"#lexicon\">Lexicon</a></li>");
        System.out.println("<li><a href=\"#grammar\">Grammar</a></li>");
        System.out.println("<li><a href=\"#trunks\">Trunks</a></li>");
        System.out.println("<li><a href=\"#parents\">Parents</a></li>");
        System.out.println("<li><a href=\"#parentrules\">Parent Rules</a></li>");
        System.out.println("</ul>");
        System.out.println("<!--");
        String inFileName = opts.in;
        String outName = opts.out;
        System.out.println("Loading grammar from " + inFileName + ".");
        String wsjLoc = opts.path;
        boolean columnOutput = true;
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        Lexicon lexicon = pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        grammar.splitRules();
        pData.Save(outName + ".gr");
        System.out.println("Writing grammar to file grammar.data...");
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(outName + ".grammar"));
            grammar.writeData(output);
            if (output != null) {
                ((Writer)output).close();
            }
            output = new BufferedWriter(new FileWriter(outName + ".lexicon"));
            output.write(lexicon.toString());
            if (output != null) {
                ((Writer)output).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        grammar = pData.getGrammar();
        grammar.splitRules();
        lexicon = pData.getLexicon();
        ParserData pDataNoLog = ParserData.Load(inFileName);
        if (pDataNoLog == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar nonLogGrammar = pDataNoLog.getGrammar();
        Lexicon nonLogLexicon = pDataNoLog.getLexicon();
        SpanPredictor spanPredictor = pDataNoLog.getSpanPredictor();
        ArrayParser parser = new ArrayParser(nonLogGrammar, nonLogLexicon);
        System.out.println("-->");
        Corpus corpus = new Corpus(wsjLoc, opts.treebank, 1.0, false);
        List<Tree<String>> trainTrees = Corpus.binarizeAndFilterTrees(corpus.getTrainTrees(), pData.getV_markov(), pData.getH_markov(), opts.maxL, pData.getBinarization(), false, false);
        trainTrees = Corpus.filterTreesForConditional(trainTrees, false, false, false);
        StateSetTreeList trainStateSetTrees = new StateSetTreeList(trainTrees, nonLogGrammar.numSubStates, false, tagNumberer);
        int padding = 3;
        topN = 30;
        GrammarStatistics.printLexiconStatistics(lexicon, tagNumberer, grammar.isGrammarTag, grammar, trainStateSetTrees, opts);
        GrammarStatistics gs = new GrammarStatistics(grammar, tagNumberer, topN);
        HashSet<Short> noContinueTags = new HashSet<Short>();
        HashSet<Short> continueTags = new HashSet<Short>();
        for (short i = 0; i < tagNumberer.total(); i = (short)(i + 1)) {
            if (!grammar.isGrammarTag[i]) continue;
            if (!gs.continues(i)) {
                noContinueTags.add(i);
                continue;
            }
            continueTags.add(i);
        }
        GrammarStatistics.printGrammarStatistics(columnOutput, pData, tagNumberer, topN, gs, noContinueTags);
        GrammarStatistics.printTrunkStatistics(columnOutput, tagNumberer, padding, topN, gs, continueTags);
        System.out.println("<!--");
        System.out.println("-->");
        HashSet<Short> allRealTags = new HashSet<Short>(noContinueTags);
        for (short i = 0; i < grammar.numSubStates.length; i = (short)(i + 1)) {
            if (grammar.isGrammarTag[i]) continue;
            allRealTags.add(i);
        }
        double[] probState = new double[grammar.numStates];
        double[][] probSubGivenState = new double[grammar.numStates][];
        for (int state2 = 0; state2 < grammar.numStates; ++state2) {
            probSubGivenState[state2] = new double[grammar.numSubStates[state2]];
        }
        for (Tree<StateSet> tree : trainStateSetTrees) {
            parser.doInsideOutsideScores(tree, false, true);
            GrammarStatistics.tallyProbState(tree, probState, allRealTags);
            GrammarStatistics.tallyProbSubState(tree, probSubGivenState, allRealTags);
        }
        for (int state3 = 0; state3 < grammar.numStates; ++state3) {
            int substate;
            double sum = 0.0;
            for (substate = 0; substate < grammar.numSubStates[state3]; ++substate) {
                sum += probSubGivenState[state3][substate];
            }
            for (substate = 0; substate < grammar.numSubStates[state3]; ++substate) {
                probSubGivenState[state3][substate] = Math.log(probSubGivenState[state3][substate] / sum);
            }
        }
        double sumState = 0.0;
        for (state = 0; state < grammar.numStates; ++state) {
            sumState += probState[state];
        }
        for (state = 0; state < grammar.numStates; ++state) {
            probState[state] = Math.log(probState[state] / sumState);
        }
        GrammarStatistics.printParentRuleStatistics(columnOutput, pData, tagNumberer, topN, gs, allRealTags, probState, probSubGivenState);
        GrammarStatistics.printParentStatistics(columnOutput, grammar, tagNumberer, nonLogGrammar, nonLogLexicon, topN, gs, trainTrees, parser);
        System.out.println("</body></html>");
    }

    private static void tallyProbSubState(Tree<StateSet> tree, double[][] probSubGivenState, Set<Short> noContinueTags) {
        GrammarStatistics.tallyProbSubStateHelper(tree, tree.getLabel().getIScore(0), probSubGivenState, noContinueTags);
    }

    private static void tallyProbSubStateHelper(Tree<StateSet> tree, double treeProb, double[][] probSubGivenState, Set<Short> tags) {
        if (tree.isLeaf()) {
            return;
        }
        StateSet label = tree.getLabel();
        short state = label.getState();
        if (tags.contains(state)) {
            int substate;
            double[] iScores = label.getIScores();
            double[] oScores = label.getOScores();
            double[] scores = new double[iScores.length];
            double sum = 0.0;
            for (substate = 0; substate < iScores.length; ++substate) {
                scores[substate] = iScores[substate] / treeProb * oScores[substate];
                sum += scores[substate];
            }
            for (substate = 0; substate < iScores.length; ++substate) {
                int n = substate;
                scores[n] = scores[n] / sum;
                double[] dArray = probSubGivenState[state];
                int n2 = substate;
                dArray[n2] = dArray[n2] + scores[substate];
            }
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            GrammarStatistics.tallyProbSubStateHelper(child, treeProb, probSubGivenState, tags);
        }
    }

    private static void tallyProbState(Tree<StateSet> tree, double[] probState, Set<Short> tags) {
        if (tree.isLeaf()) {
            return;
        }
        short state = tree.getLabel().getState();
        if (tags.contains(state)) {
            short s = state;
            probState[s] = probState[s] + 1.0;
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            GrammarStatistics.tallyProbState(child, probState, tags);
        }
    }

    private static FullState[][] printParentStatistics(boolean columnOutput, Grammar grammar, Numberer tagNumberer, Grammar nonLogGrammar, Lexicon nonLogLexicon, int topN, GrammarStatistics gs, List<Tree<String>> trainTrees, ArrayParser parser) {
        System.out.println("<a name=\"parents\"><h1>Parents</h1></a>");
        System.out.println("<!--");
        int nstates = grammar.numStates;
        double[][][][] parentProbs = new double[nstates][nstates][][];
        double[][] normFactors = new double[nstates][];
        FullState[][] parents = new FullState[grammar.numStates][];
        for (int state = 0; state < nstates; ++state) {
            normFactors[state] = new double[grammar.numSubStates[state]];
        }
        StateSetTreeList trainStateSetTrees = new StateSetTreeList(trainTrees, grammar.numSubStates, false, tagNumberer);
        int nTree = 0;
        System.out.print("Adding probabilities");
        for (Tree<StateSet> tree : trainStateSetTrees) {
            parser.doInsideOutsideScores(tree, false, true);
            GrammarStatistics.logarithmModeTree(tree);
            gs.addProbs(tree, grammar, parentProbs, normFactors, tree.getLabel().getIScore(0));
            if (nTree++ % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.print("done.\n");
        System.out.println("-->");
        for (int childState = 0; childState < nstates; childState = (int)((short)(childState + 1))) {
            String[][] outputMatrix = new String[topN + 1][grammar.numSubStates[childState]];
            String tagName = (String)tagNumberer.object(childState);
            for (short cS = 0; cS < grammar.numSubStates[childState]; cS = (short)(cS + 1)) {
                String string = tagName + "-" + cS;
                outputMatrix[0][cS] = string;
                String childFullName = string;
                PriorityQueue<FullState> results = new PriorityQueue<FullState>(topN + 1);
                for (int parentState = 0; parentState < nstates; parentState = (int)((short)(parentState + 1))) {
                    double[][] probs = parentProbs[parentState][childState];
                    if (probs == null) continue;
                    double normFactor = normFactors[childState][cS];
                    for (short pS = 0; pS < grammar.numSubStates[parentState]; pS = (short)(pS + 1)) {
                        double score = probs[pS][cS] / normFactor;
                        if (!results.isEmpty() && score < -results.getPriority()) continue;
                        FullState state = new FullState((short)parentState, pS);
                        state.score = score;
                        results.add(state, -state.score);
                        if (results.size() <= topN) continue;
                        results.next();
                    }
                }
                ArrayList resultsA = new ArrayList(topN);
                while (results.size() != 0) {
                    resultsA.add(0, results.next());
                }
                parents[childState] = new FullState[resultsA.size()];
                for (int j = 0; j < topN; j = (int)((short)(j + 1))) {
                    String o = "";
                    double p = -1.0;
                    if (resultsA.size() > j) {
                        parents[childState][j] = (FullState)resultsA.get(j);
                        p = ((FullState)resultsA.get((int)j)).score;
                        String w = ((FullState)resultsA.get(j)).toString(tagNumberer, childFullName);
                        o = f.format(p) + " " + w;
                    }
                    outputMatrix[j + 1][cS] = o;
                }
            }
            GrammarStatistics.printRules("Parent", "parent", columnOutput, outputMatrix);
        }
        return parents;
    }

    private static void printTrunkStatistics(boolean columnOutput, Numberer tagNumberer, int padding, int topN, GrammarStatistics gs, Set<Short> continueTags) {
        System.out.println("<a name=\"trunks\"><h1>Trunks</h1></a>");
        for (short tag : continueTags) {
            String tagS = ((String)tagNumberer.object(tag)).substring(1);
            short parentTag = (short)tagNumberer.number(tagS);
            gs.printTopRules(parentTag, topN, columnOutput, padding);
            gs.printTopRules(tag, topN, columnOutput, padding);
            System.out.println("");
        }
    }

    private static void printGrammarStatistics(boolean columnOutput, ParserData pData, Numberer tagNumberer, int topN, GrammarStatistics gs, Set<Short> noContinueTags) {
        System.out.println("<a name=\"grammar\"><h1>Grammar</h1></a>");
        System.out.println("<div id=\"grammar\">");
        for (short curTag : noContinueTags) {
            int nSubStates = pData.numSubStatesArray[curTag];
            ArrayList[] results = new ArrayList[nSubStates];
            for (int i = 0; i < nSubStates; i = (short)(i + 1)) {
                PriorityQueue<SearchState> pq = gs.getTopProductions(new FullState(curTag, (short)i));
                results[i] = new ArrayList(topN);
                while (pq.size() != 0) {
                    pq.peek().score = Math.exp(pq.peek().score);
                    results[i].add(0, pq.next());
                }
            }
            String[][] outputMatrix = new String[topN + 1][nSubStates];
            String tagName = (String)tagNumberer.object(curTag);
            for (int i = 0; i < nSubStates; ++i) {
                outputMatrix[0][i] = tagName + "-" + i;
            }
            for (int j = 0; j < topN; ++j) {
                for (int i = 0; i < nSubStates; ++i) {
                    String o = "";
                    double p = -1.0;
                    if (results[i].size() > j) {
                        p = ((SearchState)results[i].get((int)j)).score;
                        String w = ((SearchState)results[i].get(j)).toString(tagNumberer);
                        o = f.format(p) + " " + w;
                    }
                    outputMatrix[j + 1][i] = o;
                }
            }
            GrammarStatistics.printRules("Grammar", "productions", columnOutput, outputMatrix);
        }
        System.out.println("</div>");
    }

    private static void printParentRuleStatistics(boolean columnOutput, ParserData pData, Numberer tagNumberer, int topN, GrammarStatistics gs, Set<Short> noContinueTags, double[] probState, double[][] probSubGivenState) {
        System.out.println("<a name=\"parentrules\"><h1>Parent Rules</h1></a>");
        for (short curTag : noContinueTags) {
            int nSubStates = pData.numSubStatesArray[curTag];
            ArrayList[] results = new ArrayList[nSubStates];
            for (int i = 0; i < nSubStates; i = (short)(i + 1)) {
                PriorityQueue<SearchState> pq = gs.getTopParentRuleProductions(new FullState(curTag, (short)i), probState, probSubGivenState);
                results[i] = new ArrayList(topN);
                while (pq.size() != 0) {
                    pq.peek().score = Math.exp(pq.peek().score);
                    results[i].add(0, pq.next());
                }
            }
            String[][] outputMatrix = new String[topN + 1][nSubStates];
            String tagName = (String)tagNumberer.object(curTag);
            for (int i = 0; i < nSubStates; ++i) {
                outputMatrix[0][i] = tagName + "-" + i;
            }
            for (int j = 0; j < topN; ++j) {
                for (int i = 0; i < nSubStates; ++i) {
                    String o = "";
                    double p = -1.0;
                    if (results[i].size() > j) {
                        p = ((SearchState)results[i].get((int)j)).score;
                        String w = ((SearchState)results[i].get(j)).toString(tagNumberer);
                        o = f.format(p) + " " + w;
                    }
                    outputMatrix[j + 1][i] = o;
                }
            }
            GrammarStatistics.printRules("Parent Rules", "parentrules", columnOutput, outputMatrix);
        }
    }

    private static void logarithmModeTree(Tree<StateSet> tree) {
        if (tree.isLeaf()) {
            return;
        }
        double[] iScores = tree.getLabel().getIScores();
        int iScale = tree.getLabel().getIScale();
        double[] oScores = tree.getLabel().getOScores();
        int oScale = tree.getLabel().getOScale();
        for (int i = 0; i < iScores.length; ++i) {
            iScores[i] = Math.log(iScores[i]) + (double)(100 * iScale);
            oScores[i] = Math.log(oScores[i]) + (double)(100 * oScale);
        }
        tree.getLabel().setIScores(iScores);
        tree.getLabel().setOScores(oScores);
        for (Tree<StateSet> child : tree.getChildren()) {
            GrammarStatistics.logarithmModeTree(child);
        }
    }

    private void addProbs(Tree<StateSet> tree, Grammar g, double[][][][] parentProbs, double[][] normFactors, double treeScore) {
        int nSubStates = tree.getLabel().numSubStates();
        double[][] viterbiProbs = new double[nSubStates][nSubStates];
        for (int i = 0; i < viterbiProbs.length; ++i) {
            for (int j = 0; j < viterbiProbs[i].length; ++j) {
                viterbiProbs[i][j] = i != j ? Double.NEGATIVE_INFINITY : tree.getLabel().getOScore(i) - treeScore;
            }
        }
        this.addProbsHelper(tree.getLabel().getState(), tree, g, parentProbs, normFactors, viterbiProbs, treeScore);
    }

    private void addProbsHelper(short gpState, Tree<StateSet> tree, Grammar g, double[][][][] parentProbs, double[][] normFactor, double[][] viterbiProbs, double treeScore) {
        if (tree.isPreTerminal() || tree.isLeaf()) {
            return;
        }
        short pState = tree.getLabel().getState();
        int nParentStates = tree.getLabel().numSubStates();
        List<Tree<StateSet>> children = tree.getChildren();
        switch (children.size()) {
            case 1: {
                Tree<StateSet> child = children.get(0);
                short cState = child.getLabel().getState();
                double[][] scores = g.getUnaryScore(pState, cState);
                int nChildStates = child.getLabel().numSubStates();
                double[][] newViterbiProbs = new double[viterbiProbs.length][nChildStates];
                for (int gpS = 0; gpS < viterbiProbs.length; ++gpS) {
                    for (int cS = 0; cS < nChildStates; ++cS) {
                        if (scores[cS] == null) continue;
                        double[] scoresToSum = new double[nParentStates];
                        for (int pS = 0; pS < nParentStates; ++pS) {
                            scoresToSum[pS] = viterbiProbs[gpS][pS] + scores[cS][pS];
                        }
                        newViterbiProbs[gpS][cS] = SloppyMath.logAdd(scoresToSum);
                    }
                }
                if (this.continues(cState)) {
                    this.addProbsHelper(gpState, child, g, parentProbs, normFactor, newViterbiProbs, treeScore);
                    break;
                }
                this.addProbsFinal(child, gpState, cState, parentProbs, normFactor, newViterbiProbs);
                this.addProbs(child, g, parentProbs, normFactor, treeScore);
                break;
            }
            case 2: {
                Tree<StateSet> lChild = children.get(0);
                Tree<StateSet> rChild = children.get(1);
                short lcState = lChild.getLabel().getState();
                short rcState = rChild.getLabel().getState();
                double[][][] scoresB = g.getBinaryScore(pState, lcState, rcState);
                int nLChildStates = lChild.getLabel().numSubStates();
                int nRChildStates = rChild.getLabel().numSubStates();
                double[][] newLViterbiProbs = new double[viterbiProbs.length][nLChildStates];
                double[][] newRViterbiProbs = new double[viterbiProbs.length][nRChildStates];
                for (int gpS = 0; gpS < viterbiProbs.length; ++gpS) {
                    int lcS;
                    double[][] lScoresToSum = new double[nLChildStates][nParentStates * nRChildStates];
                    double[][] rScoresToSum = new double[nRChildStates][nParentStates * nLChildStates];
                    for (lcS = 0; lcS < nLChildStates; ++lcS) {
                        for (int rcS = 0; rcS < nRChildStates; ++rcS) {
                            if (scoresB[lcS][rcS] == null) continue;
                            for (int pS = 0; pS < nParentStates; ++pS) {
                                double vp = viterbiProbs[gpS][pS];
                                double sc = scoresB[lcS][rcS][pS];
                                lScoresToSum[lcS][pS * nRChildStates + rcS] = vp + sc + rChild.getLabel().getIScore(rcS);
                                rScoresToSum[rcS][pS * nLChildStates + lcS] = vp + sc + lChild.getLabel().getIScore(lcS);
                            }
                        }
                    }
                    for (lcS = 0; lcS < nLChildStates; ++lcS) {
                        newLViterbiProbs[gpS][lcS] = SloppyMath.logAdd(lScoresToSum[lcS]);
                    }
                    for (int rcS = 0; rcS < nRChildStates; ++rcS) {
                        newRViterbiProbs[gpS][rcS] = SloppyMath.logAdd(rScoresToSum[rcS]);
                    }
                }
                if (this.continues(lcState)) {
                    this.addProbsHelper(gpState, lChild, g, parentProbs, normFactor, newLViterbiProbs, treeScore);
                } else {
                    this.addProbsFinal(lChild, gpState, lcState, parentProbs, normFactor, newLViterbiProbs);
                    this.addProbs(lChild, g, parentProbs, normFactor, treeScore);
                }
                if (this.continues(rcState)) {
                    this.addProbsHelper(gpState, rChild, g, parentProbs, normFactor, newRViterbiProbs, treeScore);
                    break;
                }
                this.addProbsFinal(rChild, gpState, rcState, parentProbs, normFactor, newRViterbiProbs);
                this.addProbs(rChild, g, parentProbs, normFactor, treeScore);
            }
        }
    }

    private void addProbsFinal(Tree<StateSet> child, short gpState, short cState, double[][][][] parentProbs, double[][] normFactor, double[][] viterbiProbs) {
        for (int gpS = 0; gpS < viterbiProbs.length; ++gpS) {
            for (int cS = 0; cS < viterbiProbs[gpS].length; ++cS) {
                viterbiProbs[gpS][cS] = Math.exp(viterbiProbs[gpS][cS] + child.getLabel().getIScore(cS));
            }
        }
        if (parentProbs[gpState][cState] == null) {
            parentProbs[gpState][cState] = new double[viterbiProbs.length][viterbiProbs[0].length];
        }
        double[][] parentProbsCC = parentProbs[gpState][cState];
        for (int gpS = 0; gpS < viterbiProbs.length; ++gpS) {
            for (int cS = 0; cS < viterbiProbs[gpS].length; ++cS) {
                double[] dArray = parentProbsCC[gpS];
                int n = cS;
                dArray[n] = dArray[n] + viterbiProbs[gpS][cS];
                double[] dArray2 = normFactor[cState];
                int n2 = cS;
                dArray2[n2] = dArray2[n2] + viterbiProbs[gpS][cS];
            }
        }
    }

    private void printTopRules(short tag, int topN, boolean columnOutput, int padding) {
        String[][] outputMatrix = new String[topN + 1][this.grammar.numSubStates[tag]];
        for (int i = 0; i < outputMatrix.length; ++i) {
            for (int j = 0; j < outputMatrix[i].length; ++j) {
                outputMatrix[i][j] = "";
            }
        }
        for (int subState = 0; subState < this.grammar.numSubStates[tag]; ++subState) {
            outputMatrix[0][subState] = (String)this.tagNumberer.object(tag) + "-" + subState;
            PriorityQueue<RuleStruct> topRules = new PriorityQueue<RuleStruct>();
            for (BinaryRule r : this.grammar.splitRulesWithP(tag)) {
                for (int lSubState = 0; lSubState < this.grammar.numSubStates[r.getLeftChildState()]; ++lSubState) {
                    for (int rSubState = 0; rSubState < this.grammar.numSubStates[r.getRightChildState()]; ++rSubState) {
                        double score = r.getScore(subState, lSubState, rSubState);
                        topRules.add(new RuleStruct(r, score, subState, lSubState, rSubState), -score);
                        if (topRules.size() <= topN) continue;
                        topRules.next();
                    }
                }
            }
            for (UnaryRule r : this.grammar.getUnaryRulesByParent(tag)) {
                for (int cSubState = 0; cSubState < this.grammar.numSubStates[r.getChildState()]; ++cSubState) {
                    double score = r.getScore(subState, cSubState);
                    topRules.add(new RuleStruct(r, score, subState, cSubState), -score);
                    if (topRules.size() <= topN) continue;
                    topRules.next();
                }
            }
            ArrayList<RuleStruct> r = new ArrayList<RuleStruct>();
            while (topRules.hasNext()) {
                RuleStruct s = (RuleStruct)topRules.next();
                r.add(0, s);
            }
            for (int i = 0; i < r.size(); ++i) {
                outputMatrix[i + 1][subState] = this.ruleToString((RuleStruct)r.get(i));
            }
        }
        String tagName = (String)this.tagNumberer.object(tag);
        GrammarStatistics.printRules("Trunk", "topShortRules", columnOutput, outputMatrix);
    }

    public String ruleToString(RuleStruct r) {
        StringBuffer sB = new StringBuffer();
        sB.append(f.format(Math.exp(r.score)) + " ");
        if (r.binary) {
            BinaryRule b = (BinaryRule)r.r;
            String leftName = this.tagNumberer.object(b.leftChildState) + "-" + r.lS;
            String rightName = this.tagNumberer.object(b.rightChildState) + "-" + r.rS;
            sB.append("<a href=" + GrammarStatistics.reflabel("productions", leftName) + ">" + leftName + "</a> ");
            sB.append("<a href=" + GrammarStatistics.reflabel("productions", rightName) + ">" + rightName + "</a> ");
        } else {
            UnaryRule u = (UnaryRule)r.r;
            String childName = this.tagNumberer.object(u.childState) + "-" + r.lS;
            sB.append("<a href=" + GrammarStatistics.reflabel("productions", childName) + ">" + childName + "</a> ");
        }
        return sB.toString();
    }

    private static void printRules(String typeName, String ruleTypeName, boolean columnOutput, String[][] outputMatrix) {
        System.out.println("<h3>" + typeName + "</h3><table border=\"1\">");
        if (columnOutput) {
            for (int i = 0; i < outputMatrix.length; ++i) {
                System.out.println("<tr>");
                for (int j = 0; j < outputMatrix[0].length; ++j) {
                    if (i == 0) {
                        System.out.println("<th><a name=" + GrammarStatistics.label(ruleTypeName, outputMatrix[i][j]) + "> <a href=" + GrammarStatistics.parentRefLabel(outputMatrix[i][j]) + ">");
                        System.out.print(outputMatrix[i][j]);
                        System.out.println("</a></a> (<a href=" + GrammarStatistics.label("parent", outputMatrix[i][j]) + ">p</a>)</th>");
                        continue;
                    }
                    System.out.print("<td>" + GrammarStatistics.sanitize(outputMatrix[i][j]) + "</td>");
                }
                System.out.println("</tr>");
            }
        } else {
            for (int j = 0; j < outputMatrix[0].length; ++j) {
                System.out.println("<tr>");
                for (int i = 0; i < outputMatrix.length; ++i) {
                    if (j == 0) {
                        System.out.println("<th><a name=" + GrammarStatistics.label(ruleTypeName, outputMatrix[i][j]) + "> <a href=" + GrammarStatistics.parentRefLabel(outputMatrix[i][j]) + ">");
                        System.out.print(outputMatrix[i][j]);
                        System.out.println("</a></a></th>");
                        continue;
                    }
                    System.out.print("<td>" + GrammarStatistics.sanitize(outputMatrix[i][j]) + "</td>");
                }
                System.out.println("</tr>");
            }
        }
        System.out.println("</table><br/>");
    }

    public static int maxWidthInRow(String[][] m, int row) {
        int l = 0;
        for (int c = 0; c < m[row].length; ++c) {
            l = Math.max(l, m[row][c].length());
        }
        return l;
    }

    public static int maxWidthInCol(String[][] m, int col) {
        int l = 0;
        for (int r = 0; r < m.length; ++r) {
            l = Math.max(l, m[r][col].length());
        }
        return l;
    }

    public static void computeAndPrintCounts(Grammar gr) {
        int nUnaries = 0;
        int nBinaries = 0;
        int totalU = 0;
        int totalB = 0;
        int notInfU = 0;
        int notInfB = 0;
        int nulledOutU = 0;
        int nulledOutB = 0;
        int notNulledOutU = 0;
        int notNulledOutB = 0;
        for (int state = 0; state < gr.numStates; ++state) {
            int nParentSubStates = gr.numSubStates[state];
            for (UnaryRule uRule : gr.getUnaryRulesByParent(state)) {
                ++nUnaries;
                short nChildSubStates = gr.numSubStates[uRule.childState];
                double[][] scores = uRule.getScores2();
                for (int j = 0; j < scores.length; ++j) {
                    totalU += nChildSubStates;
                    ++notNulledOutU;
                    if (scores[j] == null) {
                        ++nulledOutU;
                        continue;
                    }
                    for (int i = 0; i < nParentSubStates; ++i) {
                        if (Double.isInfinite(scores[j][i])) continue;
                        ++notInfU;
                    }
                }
            }
            for (BinaryRule bRule : gr.splitRulesWithP(state)) {
                ++nBinaries;
                double[][][] scores = bRule.getScores2();
                for (int j = 0; j < scores.length; ++j) {
                    for (int k = 0; k < scores[j].length; ++k) {
                        totalB += nParentSubStates;
                        ++notNulledOutB;
                        if (scores[j][k] == null) {
                            ++nulledOutB;
                            continue;
                        }
                        for (int i = 0; i < scores[j][k].length; ++i) {
                            if (Double.isInfinite(scores[j][k][i])) continue;
                            ++notInfB;
                        }
                    }
                }
            }
        }
        int totalUS = 0;
        int totalBS = 0;
        int notInfUS = 0;
        int notInfBS = 0;
        for (int state = 0; state < gr.numStates; ++state) {
            for (UnaryRule uRule : gr.getUnaryRulesByParent(state)) {
                double[][] scores = uRule.getScores2();
                short nChildSubstates = gr.numSubStates[uRule.childState];
                for (int j = 0; j < scores.length; ++j) {
                    boolean okayInSomeSubstate = false;
                    if (scores[j] != null) {
                        for (int i = 0; i < scores[j].length; ++i) {
                            if (Double.isInfinite(scores[j][i])) continue;
                            okayInSomeSubstate = true;
                        }
                    }
                    totalUS += nChildSubstates;
                    if (!okayInSomeSubstate) continue;
                    notInfUS += nChildSubstates;
                }
            }
            for (BinaryRule bRule : gr.splitRulesWithP(state)) {
                double[][][] scores = bRule.getScores2();
                short nParentSubstates = gr.numSubStates[bRule.parentState];
                for (int j = 0; j < scores.length; ++j) {
                    for (int k = 0; k < scores[0].length; ++k) {
                        boolean okayInSomeSubstate = false;
                        if (scores[j][k] != null) {
                            for (int i = 0; i < scores[j][k].length; ++i) {
                                if (Double.isInfinite(scores[j][k][i])) continue;
                                okayInSomeSubstate = true;
                            }
                        }
                        totalBS += nParentSubstates;
                        if (!okayInSomeSubstate) continue;
                        notInfBS += nParentSubstates;
                    }
                }
            }
        }
        System.out.println("The baseline grammar has " + nUnaries + " unary and " + nBinaries + " binary rules.");
        System.out.println("When using substates there could be " + totalU + " unaries, but in fact there are only " + notInfU + ".");
        System.out.println("When using substates there could be " + totalB + " binaries, but in fact there are only " + notInfB + ".");
        System.out.println("Out of " + notNulledOutU + " slices " + nulledOutU + " are nulled out.");
        System.out.println("Out of " + notNulledOutB + " slices " + nulledOutB + " are nulled out.");
        System.out.println("Summed across substates, there could be " + totalUS + " unaries, but there are only " + notInfUS + ".");
        System.out.println("Summed across substates, there could be " + totalBS + " binaries, but there are only " + notInfBS + ".");
    }

    public static void printLexiconUnknownStatistics(Lexicon lexicon, Numberer tagNumberer) {
    }

    public static void printLexiconStatistics(Lexicon lexicon, Numberer tagNumberer, boolean[] grammarTags, Grammar grammar, StateSetTreeList trainStateSetTrees, Options opts) {
        System.out.println("<a name=\"lexicon\"><h1>Lexicon</h1></a>");
        System.out.println("<div id=\"lexicon\">");
        double[][][] counts = null;
        double[][] posteriors = new double[grammar.numStates][(int)ArrayUtil.max(grammar.numSubStates)];
        if (lexicon instanceof SimpleLexicon) {
            counts = new double[grammar.numStates][((SimpleLexicon)lexicon).nWords][grammar.numSubStates[1]];
            ParserData pDataNoLog = ParserData.Load(opts.in);
            if (pDataNoLog == null) {
                System.exit(1);
            }
            Grammar nonLogGrammar = pDataNoLog.getGrammar();
            nonLogGrammar.splitRules();
            SimpleLexicon nonLogLexicon = (SimpleLexicon)pDataNoLog.getLexicon();
            nonLogLexicon.explicitlyComputeScores(nonLogGrammar.finalLevel);
            SpanPredictor spanPredictor = pDataNoLog.getSpanPredictor();
            if (opts.unkT < 0) {
                System.out.println("Replacing rare words");
                Corpus.replaceRareWords(trainStateSetTrees, new SimpleLexicon(grammar.numSubStates, -1.0), Math.abs(opts.unkT));
            }
            nonLogLexicon.labelTrees(trainStateSetTrees);
            ConstrainedHierarchicalTwoChartParser parser = new ConstrainedHierarchicalTwoChartParser(nonLogGrammar, nonLogLexicon, spanPredictor, grammar.finalLevel);
            for (Tree<StateSet> stateSetTree : trainStateSetTrees) {
                boolean noSmoothing = true;
                boolean debugOutput = false;
                parser.doInsideOutsideScores(stateSetTree, false, false);
                grammar.tallyMergeWeights(stateSetTree, posteriors);
                double tree_score = stateSetTree.getLabel().getIScore(0);
                int tree_scale = stateSetTree.getLabel().getIScale();
                List<StateSet> yield = stateSetTree.getYield();
                int i = 0;
                for (StateSet stateSet : stateSetTree.getPreTerminalYield()) {
                    double scalingFactor = ScalingTools.calcScaleFactor(stateSet.getOScale() + stateSet.getIScale() - tree_scale);
                    StateSet child = yield.get(i++);
                    for (int substate = 0; substate < stateSet.numSubStates(); substate = (int)((short)(substate + 1))) {
                        double pOS;
                        double pIS = stateSet.getIScore(substate);
                        if (pIS == 0.0 || (pOS = stateSet.getOScore(substate)) == 0.0) continue;
                        double weight = 1.0;
                        weight = pIS / tree_score * scalingFactor * pOS;
                        double[] dArray = counts[stateSet.getState()][child.wordIndex];
                        int n = substate;
                        dArray[n] = dArray[n] + weight;
                    }
                }
            }
        }
        for (short curTag = 0; curTag < grammarTags.length; curTag = (short)((short)(curTag + 1))) {
            Lexicon lex;
            if (grammarTags[curTag]) continue;
            int nSubStates = grammar.numSubStates[curTag];
            PriorityQueue[] pQs = new PriorityQueue[nSubStates];
            for (int i = 0; i < nSubStates; ++i) {
                pQs[i] = new PriorityQueue();
            }
            double[] sum = new double[grammar.numSubStates[curTag]];
            if (lexicon instanceof SophisticatedLexicon) {
                sum = posteriors[curTag];
                lex = (SophisticatedLexicon)lexicon;
                HashMap<String, double[]> tagMap = lex.wordToTagCounters[curTag];
                for (String word : tagMap.keySet()) {
                    double[] lexiconScores = lexicon.score(word, curTag, 0, false, false);
                    for (int i = 0; i < nSubStates; ++i) {
                        pQs[i].add(word, lexiconScores[i]);
                    }
                }
            } else {
                sum = new double[grammar.numSubStates[curTag]];
                lex = (SimpleLexicon)lexicon;
                for (int w = 0; w < ((SimpleLexicon)lex).nWords; ++w) {
                    int i;
                    String word = ((SimpleLexicon)lex).wordIndexer.get(w);
                    double[] lexiconScores = counts[curTag][w];
                    boolean allZero = true;
                    for (i = 0; i < lexiconScores.length; ++i) {
                        allZero = allZero && lexiconScores[i] == 0.0;
                        int n = i;
                        sum[n] = sum[n] + lexiconScores[i];
                    }
                    if (allZero) continue;
                    for (i = 0; i < nSubStates; ++i) {
                        pQs[i].add(word, lexiconScores[i]);
                    }
                }
            }
            double s = 0.0;
            for (int i = 0; i < sum.length; ++i) {
                s += sum[i];
            }
            String tagName = (String)tagNumberer.object(curTag);
            System.out.println("<h3>Lexicon</h3>");
            System.out.println("<table border=\"1\">");
            System.out.println("<tr>");
            for (int i = 0; i < nSubStates; ++i) {
                System.out.println("<th>");
                System.out.println("<a name=" + GrammarStatistics.lexiconLabel(tagName + "-" + i) + "> <a href=" + GrammarStatistics.parentRefLabel(tagName + "-" + i) + ">");
                System.out.print(GrammarStatistics.sanitize(tagName) + "-" + i);
                System.out.println("</a></a> (<a href=" + GrammarStatistics.label("parent", tagName) + ">p</a>)");
                System.out.println("<br>" + sum[i] / s);
                System.out.println("</th>");
            }
            System.out.println("</tr>");
            for (int j = 0; j < topN; ++j) {
                System.out.println("<tr>");
                for (int i = 0; i < nSubStates; ++i) {
                    if (i == 0) {
                        System.out.print("\n");
                    }
                    String w = "";
                    double p = -1.0;
                    if (!pQs[i].hasNext()) continue;
                    p = pQs[i].getPriority();
                    w = (String)pQs[i].next();
                    String tmp = GrammarStatistics.sanitize(w) + " " + f.format(p);
                    if (tmp.length() < 8) {
                        tmp = tmp.concat("\t");
                    }
                    System.out.print("<td>" + tmp + "</td>");
                }
                System.out.println("</tr>");
            }
            System.out.println("</table><br/>");
        }
        System.out.println("</div>");
    }

    static String lexiconLabel(String tagName) {
        return "\"productions-" + tagName + "\"";
    }

    static String label(String ruleTypeName, String tagName) {
        return "\"" + ruleTypeName + "-" + tagName + "\"";
    }

    static String reflabel(String ruleTypeName, String tagName) {
        return "\"#" + ruleTypeName + "-" + tagName + "\"";
    }

    static String parentLabel(String tagName) {
        return GrammarStatistics.label("parentrules", tagName);
    }

    static String parentRefLabel(String tagName) {
        return GrammarStatistics.reflabel("parentrules", tagName);
    }

    static String sanitize(String s) {
        return s.replaceAll("&", "&amp;");
    }

    static class RuleStruct {
        public Rule r;
        public double score;
        public int pS;
        public int lS;
        public int rS;
        boolean binary;

        public RuleStruct(Rule r, double score, int pS, int lS, int rS) {
            this.r = r;
            this.score = score;
            this.pS = pS;
            this.lS = lS;
            this.rS = rS;
            this.binary = true;
        }

        public RuleStruct(Rule r, double score, int pS, int lS) {
            this.r = r;
            this.score = score;
            this.pS = pS;
            this.lS = lS;
            this.rS = -1;
            this.binary = false;
        }
    }

    public static class Options {
        @Option(name="-in", usage="Input File for Grammar")
        public String in;
        @Option(name="-out", usage="Output File")
        public String out;
        @Option(name="-path", usage="Path to Corpus")
        public String path = null;
        @Option(name="-treebank", usage="Language:  WSJ, CHNINESE, GERMAN, CONLL, SINGLEFILE (Default: ENGLISH)")
        public Corpus.TreeBankType treebank = Corpus.TreeBankType.WSJ;
        @Option(name="-unkT", usage="Unknown word threshold")
        public int unkT = 1;
        @Option(name="-maxL", usage="Maximum sentence length")
        public int maxL = 40;
    }
}

