/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.HierarchicalUnaryRule;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalAdaptiveUnaryRule
extends HierarchicalUnaryRule {
    private static final long serialVersionUID = 1L;
    public short[][] mapping;
    Tree<Double> hierarchy = new Tree<Double>(0.0);
    public int nParam;
    public SubRule[] subRuleList;

    public HierarchicalAdaptiveUnaryRule(UnaryRule b) {
        super(b);
        this.scores = new double[1][1];
        this.mapping = new short[1][1];
        this.nParam = 1;
    }

    public Pair<Integer, Integer> countParameters() {
        int maxDepth = this.hierarchy.getDepth();
        this.nParam = this.hierarchy.getYield().size();
        return new Pair<Integer, Integer>(maxDepth, this.nParam);
    }

    @Override
    public HierarchicalAdaptiveUnaryRule splitRule(short[] numSubStates, short[] newNumSubStates, Random random, double randomness, boolean doNotNormalize, int mode) {
        int splitFactor = 4;
        this.splitRuleHelper(this.hierarchy, random, splitFactor);
        return this;
    }

    @Override
    public int mergeRule() {
        int paramBefore = this.nParam;
        this.compactifyHierarchy(this.hierarchy);
        this.scores = null;
        this.mapping = null;
        this.subRuleList = null;
        this.scoreHierarchy = null;
        return paramBefore - this.nParam;
    }

    private void splitRuleHelper(Tree<Double> tree, Random random, int splitFactor) {
        if (tree.isLeaf()) {
            if (tree.getLabel() != 0.0 || this.nParam == 1) {
                ArrayList children = new ArrayList(splitFactor);
                for (int i = 0; i < splitFactor; ++i) {
                    Tree<Double> child = new Tree<Double>(random.nextDouble() / 100.0);
                    children.add(child);
                }
                tree.setChildren(children);
                this.nParam += splitFactor - 1;
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                this.splitRuleHelper(child, random, splitFactor);
            }
        }
    }

    @Override
    public void explicitlyComputeScores(int finalLevel, short[] newNumSubStates) {
        this.computeSubRuleList();
    }

    public void updateScores(double[] scores) {
        int nSubstates = this.updateHierarchy(this.hierarchy, 0, scores);
        if (nSubstates != this.nParam) {
            System.out.println("Didn't update all parameters");
        }
    }

    private int updateHierarchy(Tree<Double> tree, int nextSubstate, double[] scores) {
        if (tree.isLeaf()) {
            int n = nextSubstate++;
            double val = scores[this.identifier + n];
            if (val > 200.0) {
                val = 0.0;
                System.out.println("Ignored proposed unary value since it was danegrous");
            } else {
                tree.setLabel(val);
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                nextSubstate = this.updateHierarchy(child, nextSubstate, scores);
            }
        }
        return nextSubstate;
    }

    public List<Double> getFinalLevel() {
        return this.hierarchy.getYield();
    }

    private void compactifyHierarchy(Tree<Double> tree) {
        if (tree.getDepth() == 2) {
            boolean allZero = true;
            for (Tree<Double> child : tree.getChildren()) {
                allZero = allZero && child.getLabel() == 0.0;
            }
            if (allZero) {
                this.nParam -= tree.getChildren().size() - 1;
                tree.setChildren(Collections.EMPTY_LIST);
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                this.compactifyHierarchy(child);
            }
        }
    }

    public String toStringShort() {
        Numberer n = Numberer.getGlobalNumberer("tags");
        String cState = (String)n.object(this.childState);
        String pState = (String)n.object(this.parentState);
        return pState + " -> " + cState;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Numberer n = Numberer.getGlobalNumberer("tags");
        String cState = (String)n.object(this.childState);
        String pState = (String)n.object(this.parentState);
        sb.append(pState + " -> " + cState + "\n");
        if (this.subRuleList == null) {
            this.compactifyHierarchy(this.hierarchy);
            this.lastLevel = this.hierarchy.getDepth();
            this.computeSubRuleList();
        }
        for (SubRule rule : this.subRuleList) {
            if (rule == null) continue;
            sb.append(rule.toString(this.lastLevel - 1));
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int countNonZeroFeatures() {
        int total = 0;
        for (Tree<Double> d : this.hierarchy.getPreOrderTraversal()) {
            if (d.getLabel() == 0.0) continue;
            ++total;
        }
        return total;
    }

    public int countNonZeroFringeFeatures() {
        int total = 0;
        for (Tree<Double> d : this.hierarchy.getTerminals()) {
            if (d.getLabel() == 0.0) continue;
            ++total;
        }
        return total;
    }

    public void computeSubRuleList() {
        this.subRuleList = new SubRule[this.nParam];
        int nRules = this.computeSubRules(0, 0.0, 0, 0, 0, this.hierarchy);
        if (this.parentState != 0 && nRules != this.nParam) {
            System.out.println("A rule got lost");
        }
    }

    private int computeSubRules(int myID, double previousScore, int nextChildSubstate, int nextParentSubstate, int myDepth, Tree<Double> tree) {
        if (tree.isLeaf()) {
            SubRule rule;
            if (this.parentState == 0 && nextParentSubstate > 0) {
                return ++myID;
            }
            double myScore = Math.exp(previousScore + tree.getLabel());
            this.subRuleList[myID] = rule = new SubRule((short)nextChildSubstate, (short)nextParentSubstate, (short)myDepth, myScore);
            ++myID;
        } else {
            double myScore = previousScore + tree.getLabel();
            int i = 0;
            for (Tree<Double> child : tree.getChildren()) {
                myID = this.computeSubRules(myID, myScore, nextChildSubstate * 2 + i / 2, nextParentSubstate * 2 + i % 2, myDepth + 1, child);
                ++i;
            }
        }
        return myID;
    }

    class SubRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        short child;
        short parent;
        short level;
        double score;

        SubRule(short c, short p, short l, double s) {
            this.child = c;
            this.parent = p;
            this.level = l;
            this.score = s;
        }

        public String toString() {
            String s = "[" + this.parent + "] \t -> \t [" + this.child + "] \t " + this.score;
            return s;
        }

        public String toString(int finalLevel) {
            if (finalLevel == this.level) {
                return this.toString();
            }
            int k = (int)Math.pow(2.0, finalLevel - this.level);
            String s = "[" + k * this.parent + "-" + (k * this.parent + k - 1) + "] \t -> \t [" + k * this.child + "-" + (k * this.child + k - 1) + "] \t " + this.score + "\t level: " + this.level;
            return s;
        }
    }
}

