/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class HierarchicalLexicon
extends SimpleLexicon {
    private static final long serialVersionUID = 1L;
    public List<double[]>[][] hierarchicalScores;
    public int[][] finalLevels;

    public HierarchicalLexicon(short[] numSubStates, double threshold) {
        super(numSubStates, threshold);
        this.hierarchicalScores = new List[this.numStates][];
    }

    public HierarchicalLexicon(SimpleLexicon lex) {
        super(lex.numSubStates, lex.threshold);
        this.expectedCounts = new double[this.numStates][][];
        this.tagWordIndexer = new SimpleLexicon.IntegerIndexer[this.numStates];
        this.wordIndexer = lex.wordIndexer;
        this.wordCounter = lex.wordCounter;
        for (int tag = 0; tag < this.numStates; ++tag) {
            this.tagWordIndexer[tag] = lex.tagWordIndexer[tag].copy();
        }
        this.nWords = lex.nWords;
        this.smoother = lex.smoother;
        this.makeHiearchicalScores(lex.scores);
        this.scores = null;
    }

    private void makeHiearchicalScores(double[][][] scores) {
        this.hierarchicalScores = new List[this.numStates][];
        this.finalLevels = new int[this.numStates][];
        for (int tag = 0; tag < this.numStates; ++tag) {
            int words = this.tagWordIndexer[tag].size();
            this.hierarchicalScores[tag] = new List[words];
            this.finalLevels[tag] = new int[words];
            for (int word = 0; word < words; ++word) {
                this.hierarchicalScores[tag][word] = new ArrayList<double[]>();
                double[] score = new double[]{Math.log(scores[tag][0][word])};
                this.hierarchicalScores[tag][word].add(score);
            }
        }
    }

    public void explicitlyComputeScores(int finalLevel) {
        this.scores = new double[this.numStates][][];
        int nSubstates = (int)Math.pow(2.0, finalLevel);
        for (int tag = 0; tag < this.numStates; ++tag) {
            int words = this.hierarchicalScores[tag].length;
            this.scores[tag] = new double[nSubstates][words];
            for (int word = 0; word < words; ++word) {
                List<double[]> scoreHierarchy = this.hierarchicalScores[tag][word];
                for (int level = 0; level <= finalLevel; ++level) {
                    if (level > this.finalLevels[tag][word]) continue;
                    double[] scoresThisLevel = scoreHierarchy.get(level);
                    int divisor = nSubstates / scoresThisLevel.length;
                    for (int substate = 0; substate < nSubstates; ++substate) {
                        double[] dArray = this.scores[tag][substate];
                        int n = word;
                        dArray[n] = dArray[n] + scoresThisLevel[substate / divisor];
                    }
                }
                for (int substate = 0; substate < nSubstates; ++substate) {
                    this.scores[tag][substate][word] = Math.exp(this.scores[tag][substate][word]);
                }
            }
        }
    }

    public HierarchicalLexicon splitAllStates(int[] counts, boolean moreSubstatesThanCounts, int mode) {
        short[] newNumSubStates = new short[this.numSubStates.length];
        newNumSubStates[0] = 1;
        for (int i = 1; i < this.numSubStates.length; i = (int)((short)(i + 1))) {
            newNumSubStates[i] = !moreSubstatesThanCounts && this.numSubStates[i] >= counts[i] ? this.numSubStates[i] : (short)(this.numSubStates[i] * 2);
        }
        HierarchicalLexicon newLex = this.newInstance();
        newLex.numSubStates = newNumSubStates;
        Random random = GrammarTrainer.RANDOM;
        newLex.expectedCounts = new double[this.numStates][][];
        newLex.tagWordIndexer = new SimpleLexicon.IntegerIndexer[this.numStates];
        newLex.wordIndexer = this.wordIndexer;
        for (int tag = 0; tag < this.numStates; ++tag) {
            newLex.tagWordIndexer[tag] = this.tagWordIndexer[tag].copy();
        }
        newLex.nWords = this.nWords;
        newLex.smoother = this.smoother;
        List[][] hS = new List[this.numStates][];
        newLex.finalLevels = new int[this.numStates][];
        for (int tag = 0; tag < this.numStates; ++tag) {
            int words = this.tagWordIndexer[tag].size();
            hS[tag] = new List[words];
            newLex.finalLevels[tag] = new int[words];
            for (int word = 0; word < words; ++word) {
                hS[tag][word] = new ArrayList();
                for (double[] scores : this.hierarchicalScores[tag][word]) {
                    hS[tag][word].add(scores.clone());
                }
                int fLevel = this.finalLevels[tag][word] + 1;
                int nSub = (int)Math.pow(2.0, fLevel);
                if (nSub > newNumSubStates[tag]) continue;
                double[] newScores = new double[nSub];
                for (int i = 0; i < newScores.length; ++i) {
                    newScores[i] = random.nextDouble() / 100.0;
                }
                hS[tag][word].add(newScores);
                newLex.finalLevels[tag][word] = fLevel;
            }
        }
        newLex.scores = null;
        newLex.hierarchicalScores = hS;
        newLex.wordCounter = this.wordCounter;
        return newLex;
    }

    public HierarchicalLexicon newInstance() {
        return new HierarchicalLexicon(this.numSubStates, this.threshold);
    }

    public int getFinalLevel(int globalWordIndex, int tag) {
        int tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalWordIndex);
        return this.finalLevels[tag][tagSpecificWordIndex];
    }

    public void mergeLexicon() {
        int nRemovedParam = 0;
        int nRemovedArrays = 0;
        for (int tag = 0; tag < this.numStates; ++tag) {
            int words = this.hierarchicalScores[tag].length;
            for (int word = 0; word < words; ++word) {
                List<double[]> scoreHierarchy = this.hierarchicalScores[tag][word];
                int level = this.finalLevels[tag][word];
                double[] scoresThisLevel = scoreHierarchy.get(level);
                if (scoresThisLevel == null) continue;
                boolean allZero = true;
                for (int substate = 0; substate < scoresThisLevel.length; ++substate) {
                    allZero = allZero && scoresThisLevel[substate] == 0.0;
                }
                if (!allZero) continue;
                scoreHierarchy.remove(level);
                int[] nArray = this.finalLevels[tag];
                int n = word;
                nArray[n] = nArray[n] - 1;
                nRemovedParam += scoresThisLevel.length;
                ++nRemovedArrays;
            }
        }
        System.out.println("Removed " + nRemovedParam + " parameters in the lexicon by setting " + nRemovedArrays + " arrays to null.");
    }

    public double[] getLastLevel(int tag, int word) {
        return this.hierarchicalScores[tag][word].get(this.finalLevels[tag][word]);
    }

    public HierarchicalLexicon copyLexicon() {
        HierarchicalLexicon copy = this.newInstance();
        copy.expectedCounts = new double[this.numStates][][];
        copy.scores = ArrayUtil.clone(this.scores);
        copy.hierarchicalScores = this.hierarchicalScores;
        copy.tagWordIndexer = new SimpleLexicon.IntegerIndexer[this.numStates];
        copy.wordIndexer = this.wordIndexer;
        for (int tag = 0; tag < this.numStates; ++tag) {
            copy.tagWordIndexer[tag] = this.tagWordIndexer[tag].copy();
            copy.expectedCounts[tag] = new double[this.numSubStates[tag]][this.tagWordIndexer[tag].size()];
        }
        if (this.wordCounter != null) {
            copy.wordCounter = (int[])this.wordCounter.clone();
        }
        copy.nWords = this.nWords;
        copy.smoother = this.smoother;
        if (this.finalLevels != null) {
            copy.finalLevels = ArrayUtil.clone(this.finalLevels);
        }
        return copy;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        for (int tag = 0; tag < this.scores.length; ++tag) {
            int[] counts = new int[6];
            String tagS = (String)tagNumberer.object(tag);
            if (this.tagWordIndexer[tag].size() == 0) continue;
            for (int word = 0; word < this.scores[tag][0].length; ++word) {
                sb.append(tagS + " " + (String)this.wordIndexer.get(this.tagWordIndexer[tag].get(word)) + " ");
                for (int sub = 0; sub < this.numSubStates[tag]; ++sub) {
                    sb.append(" " + this.scores[tag][sub][word]);
                }
                for (double[] d : this.hierarchicalScores[tag][word]) {
                    sb.append("\n" + Arrays.toString(d));
                }
                int n = this.finalLevels[tag][word];
                counts[n] = counts[n] + 1;
                sb.append("\n\n");
            }
            System.out.print(tagNumberer.object(tag) + ", word,tag pairs per level: ");
            for (int i = 1; i < 6; ++i) {
                System.out.print(counts[i] + " ");
            }
            System.out.print("\n");
        }
        return sb.toString();
    }
}

