/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.ConstrainedHierarchicalTwoChartParser;
import edu.berkeley.nlp.PCFGLA.ConstrainedTwoChartsParser;
import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveGrammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.syntax.SpanTree;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Numberer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConstrainer
implements Callable {
    StateSetTreeList stateSetTrees;
    Grammar grammar;
    Lexicon lexicon;
    SpanPredictor spanPredictor;
    String outBaseName;
    double threshold;
    String consName;
    boolean keepGoldTreeAlive;
    boolean useHierarchicalParser;
    static int treesPerBlock;
    int myID;

    public ParserConstrainer(StateSetTreeList stateSetTrees, Grammar grammar, Lexicon lexicon, SpanPredictor spanPredictor, String outBaseName, double threshold, boolean keepGoldTreeAlive, int myID, String cons, boolean useHierarchicalParser) {
        this.stateSetTrees = stateSetTrees;
        this.grammar = grammar;
        this.lexicon = lexicon;
        this.spanPredictor = spanPredictor;
        this.outBaseName = outBaseName;
        this.threshold = threshold;
        this.consName = cons;
        this.keepGoldTreeAlive = keepGoldTreeAlive;
        this.myID = myID;
        this.useHierarchicalParser = useHierarchicalParser;
    }

    public static void main(String[] args) {
        int i;
        OptionParser optParser = new OptionParser(ConditionalTrainer.Options.class);
        ConditionalTrainer.Options opts = (ConditionalTrainer.Options)optParser.parse(args, false);
        System.out.println("Calling Constrainer with " + optParser.getPassedInOptions());
        String path = opts.path;
        System.out.println("Loading trees from " + path + " and using language " + (Object)((Object)opts.treebank));
        String testSetString = opts.section;
        boolean devTestSet = testSetString.equals("dev");
        boolean finalTestSet = testSetString.equals("final");
        boolean trainTestSet = testSetString.equals("train");
        System.out.println(" using " + testSetString + " test set");
        Corpus corpus = new Corpus(path, opts.treebank, opts.trainingFractionToKeep, !trainTestSet);
        List<Tree<String>> testTrees = null;
        if (devTestSet) {
            testTrees = corpus.getDevTestingTrees();
        }
        if (finalTestSet) {
            testTrees = corpus.getFinalTestingTrees();
        }
        if (trainTestSet) {
            testTrees = corpus.getTrainTrees();
        }
        boolean manualAnnotation = false;
        testTrees = Corpus.binarizeAndFilterTrees(testTrees, opts.verticalMarkovization, opts.horizontalMarkovization, opts.maxL, opts.binarization, manualAnnotation, GrammarTrainer.VERBOSE, opts.markUnaryParents);
        if (!devTestSet && opts.collapseUnaries) {
            System.out.println("Collpasing unary chains.");
        }
        testTrees = Corpus.filterTreesForConditional(testTrees, opts.filterAllUnaries, opts.filterStupidFrickinWHNP, !devTestSet && opts.collapseUnaries);
        boolean keepGoldAlive = opts.keepGoldTreeAlive || trainTestSet;
        String inFileName = opts.inFile;
        System.out.println("Loading grammar from " + inFileName + ".");
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file " + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        grammar.splitRules();
        Lexicon lexicon = pData.getLexicon();
        lexicon.explicitlyComputeScores(grammar.finalLevel);
        SpanPredictor spanPredictor = pData.getSpanPredictor();
        if (opts.flattenParameters != 1.0) {
            System.out.println("Flattening parameters with exponent " + opts.flattenParameters + " to reduce overconfidence.");
            grammar.removeUnlikelyRules(0.0, opts.flattenParameters);
            lexicon.removeUnlikelyTags(0.0, opts.flattenParameters);
        }
        Numberer.setNumberers(pData.getNumbs());
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        StateSetTreeList stateSetTrees = new StateSetTreeList(testTrees, grammar.numSubStates, false, tagNumberer);
        testTrees = null;
        String outBaseName = opts.outFileName;
        double threshold = Math.exp(opts.logT);
        int nChunks = opts.nChunks;
        int nTrees = stateSetTrees.size();
        System.out.println("There are " + nTrees + " trees in this set.");
        treesPerBlock = (int)Math.ceil((double)nTrees / (double)nChunks);
        System.out.println("Will store " + treesPerBlock + " constraints per file, in " + nChunks + " files.");
        System.out.println("All states with posterior probability below " + threshold + " will be pruned.");
        if (keepGoldAlive) {
            System.out.println("But the gold tree will survive!");
        }
        System.out.println("The constraints will be written to " + outBaseName + ".");
        StateSetTreeList[] trainingTrees = new StateSetTreeList[nChunks];
        for (int i2 = 0; i2 < nChunks; ++i2) {
            trainingTrees[i2] = new StateSetTreeList();
        }
        int block = -1;
        int inBlock = 0;
        for (i = 0; i < nTrees; ++i) {
            if (i % treesPerBlock == 0) {
                ++block;
                inBlock = 0;
            }
            trainingTrees[block].add(stateSetTrees.get(i));
            ++inBlock;
        }
        for (i = 0; i < nChunks; ++i) {
            System.out.println("Process " + i + " has " + trainingTrees[i].size() + " trees.");
        }
        stateSetTrees = null;
        ExecutorService pool = Executors.newFixedThreadPool(nChunks);
        Future[] submits = new Future[nChunks];
        ParserConstrainer thisThreadConstrainer = null;
        if (nChunks == 1) {
            thisThreadConstrainer = new ParserConstrainer(trainingTrees[0], grammar, lexicon, spanPredictor, outBaseName, threshold, keepGoldAlive, 0, opts.cons, ConditionalTrainer.Options.hierarchicalChart);
        } else {
            boolean done;
            for (int i3 = 0; i3 < nChunks; ++i3) {
                ParserConstrainer constrainer = new ParserConstrainer(trainingTrees[i3], grammar, lexicon, spanPredictor, outBaseName, threshold, keepGoldAlive, i3, opts.cons, ConditionalTrainer.Options.hierarchicalChart);
                submits[i3] = pool.submit(constrainer);
            }
            do {
                done = true;
                for (Future task : submits) {
                    done &= task.isDone();
                }
            } while (!done);
        }
        try {
            PrintWriter outputData = opts.outputLog == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputLog), "UTF-8"), true);
            for (int i4 = 0; i4 < nChunks; ++i4) {
                StringBuilder sb = null;
                sb = nChunks == 1 ? thisThreadConstrainer.call() : (StringBuilder)submits[i4].get();
                outputData.print(sb.toString());
            }
            if (opts.outputLog != null) {
                outputData.flush();
                outputData.close();
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        System.out.println("Done computing constraints.");
    }

    public StringBuilder call() {
        boolean useCons;
        ConstrainedTwoChartsParser parser = this.grammar instanceof HierarchicalAdaptiveGrammar ? new ConstrainedHierarchicalTwoChartParser(this.grammar, this.lexicon, this.spanPredictor, this.grammar.finalLevel) : new ConstrainedTwoChartsParser(this.grammar, this.lexicon, this.spanPredictor);
        StringBuilder sb = new StringBuilder();
        int recentHistoryIndex = 0;
        boolean[][][][][] recentHistory = new boolean[treesPerBlock][][][][];
        boolean[][][][][] myConstraints = null;
        boolean bl = useCons = this.consName != null;
        if (useCons) {
            myConstraints = ParserConstrainer.loadData(this.consName + "-" + this.myID + ".data");
        }
        boolean[][][][] cons = null;
        for (Tree<StateSet> testTree : this.stateSetTrees) {
            List<StateSet> yield = testTree.getYield();
            ArrayList<String> testSentence = new ArrayList<String>(yield.size());
            for (StateSet el : yield) {
                testSentence.add(el.getWord());
            }
            sb.append("\n" + (this.myID * treesPerBlock + recentHistoryIndex + 1) + ". Length " + testSentence.size());
            if (useCons) {
                parser.projectConstraints(myConstraints[recentHistoryIndex], false);
                cons = myConstraints[recentHistoryIndex];
            }
            Tree<StateSet> sTree = null;
            if (this.keepGoldTreeAlive) {
                sTree = testTree;
            }
            boolean[][][][] possibleStates = parser.getPossibleStates(testSentence, sTree, this.threshold, cons, sb);
            assert (sTree == null || this.contains(possibleStates, sTree));
            if (useCons) {
                myConstraints[recentHistoryIndex] = null;
            }
            recentHistory[recentHistoryIndex++] = possibleStates;
            if (recentHistoryIndex % 1000 != 0) continue;
            System.out.print(".");
        }
        String fileName = this.outBaseName + "-" + this.myID + ".data";
        ParserConstrainer.saveData(recentHistory, fileName);
        return sb;
    }

    private boolean contains(boolean[][][][] possibleStates, Tree<StateSet> tree) {
        boolean[] bs = possibleStates[tree.getLabel().from][tree.getLabel().to][tree.getLabel().getState()];
        if (tree.isLeaf()) {
            return true;
        }
        if (bs == null) {
            assert (false);
            return false;
        }
        boolean hasTrue = false;
        for (boolean b : bs) {
            hasTrue |= b;
        }
        if (!hasTrue) {
            assert (false);
            return false;
        }
        boolean allThere = true;
        for (Tree<StateSet> child : tree.getChildren()) {
            allThere &= this.contains(possibleStates, child);
        }
        return allThere;
    }

    public static boolean saveData(boolean[][][][][] data, String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            ObjectOutputStream out = new ObjectOutputStream(gzos);
            out.writeObject(data);
            out.flush();
            out.close();
            gzos.close();
            fos.close();
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
            return false;
        }
        return true;
    }

    public static boolean isGoldReachable(SpanTree<String> gold, List[][] possibleStates, Numberer tagNumberer) {
        boolean reachable = true;
        reachable = possibleStates[gold.getStart()][gold.getEnd()].contains(tagNumberer.number(gold.getLabel()));
        if (reachable && !gold.isLeaf()) {
            for (SpanTree<String> child : gold.getChildren()) {
                reachable = ParserConstrainer.isGoldReachable(child, possibleStates, tagNumberer);
                if (reachable) continue;
                return false;
            }
        }
        if (!reachable) {
            System.out.println("Cannot reach state " + gold.getLabel() + " spanning from " + gold.getStart() + " to " + gold.getEnd() + ".");
        }
        return reachable;
    }

    public static SpanTree<String> convertToSpanTree(Tree<String> tree) {
        if (tree.isPreTerminal()) {
            return new SpanTree<String>(tree.getLabel());
        }
        if (tree.getChildren().size() > 2) {
            System.out.println("Binarize properly first!");
        }
        SpanTree<String> spanTree = new SpanTree<String>(tree.getLabel());
        ArrayList spanChildren = new ArrayList();
        for (Tree<String> child : tree.getChildren()) {
            SpanTree<String> spanChild = ParserConstrainer.convertToSpanTree(child);
            spanChildren.add(spanChild);
        }
        spanTree.setChildren(spanChildren);
        return spanTree;
    }

    public static boolean[][][][][] loadData(String fileName) {
        boolean[][][][][] data = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            data = (boolean[][][][][])in.readObject();
            in.close();
            gzis.close();
            fis.close();
        }
        catch (IOException e) {
            System.out.println("IOException\n" + e);
            return null;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found!");
            return null;
        }
        return data;
    }
}

