/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.FullState;
import edu.berkeley.nlp.PCFGLA.GrammarStatistics;
import edu.berkeley.nlp.util.Numberer;
import java.util.ArrayList;

class SearchState {
    public ArrayList<FullState> produced = new ArrayList();
    public FullState danglingState;
    public double score;
    public int insertPosition = 0;
    FullState parent = null;
    public boolean extended = false;

    public SearchState(FullState danglingState, double score) {
        this.danglingState = danglingState;
        this.score = score;
    }

    public SearchState(FullState danglingState, FullState firstProduction, double score) {
        this.danglingState = danglingState;
        this.produced.add(firstProduction);
        this.score = score;
    }

    public SearchState extend(FullState newProd, FullState newDangling, double scorePenalty, boolean left) {
        SearchState s = new SearchState(newDangling, this.score + scorePenalty);
        s.produced = new ArrayList<FullState>(this.produced);
        s.produced.add(this.insertPosition, newProd);
        s.insertPosition = this.insertPosition + (left ? 0 : 1);
        return s;
    }

    public String toString(Numberer tagNumberer) {
        String w = "";
        if (this.parent != null) {
            String name = tagNumberer.object(this.parent.state) + "-" + this.parent.substate;
            w = w + "<a href=" + GrammarStatistics.reflabel("productions", name) + ">" + name + "</a> -&gt; ";
        }
        for (FullState s : this.produced) {
            String name = tagNumberer.object(s.state) + "-" + s.substate;
            w = w + "<a href=" + GrammarStatistics.reflabel("productions", name) + ">" + name + "</a> ";
        }
        return w;
    }

    public SearchState extendUp(FullState cs, FullState ps, double rscore, boolean thisChildOnLeft) {
        SearchState s = new SearchState(ps, this.score + rscore);
        s.produced = new ArrayList<FullState>(this.produced);
        if (cs != null) {
            if (thisChildOnLeft) {
                s.produced.add(0, cs);
            } else {
                s.produced.add(this.produced.size(), cs);
            }
        }
        s.extended = true;
        return s;
    }
}

