/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.PriorityQueue;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeReranker {
    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        System.err.println("Calling with " + optParser.getPassedInOptions());
        String inFileName = opts.inFileName;
        if (inFileName == null) {
            throw new Error("Did not provide a grammar.");
        }
        ArrayParser[] parsers = new ArrayParser[opts.nGrammars];
        short[][] numSubstates = new short[opts.nGrammars][];
        ParserData[] pData = new ParserData[opts.nGrammars];
        Numberer[] tagNumberer = new Numberer[opts.nGrammars];
        int v_markov = 1;
        int h_markov = 0;
        Binarization bin = Binarization.RIGHT;
        for (int i = 0; i < opts.nGrammars; ++i) {
            System.err.println("Loading grammar from " + inFileName + "." + (i + 1));
            pData[i] = ParserData.Load(inFileName + "." + (i + 1));
            if (pData == null) {
                System.out.println("Failed to load grammar from file" + inFileName + ".");
                System.exit(1);
            }
            Grammar grammar = pData[i].getGrammar();
            grammar.splitRules();
            SophisticatedLexicon lexicon = (SophisticatedLexicon)pData[i].getLexicon();
            parsers[i] = new ArrayParser(grammar, lexicon);
            numSubstates[i] = grammar.numSubStates;
            v_markov = pData[i].v_markov;
            h_markov = pData[i].h_markov;
            bin = pData[i].bin;
            Numberer.setNumberers(pData[i].getNumbs());
            tagNumberer[i] = Numberer.getGlobalNumberer("tags");
        }
        try {
            BufferedReader inputData = opts.inputFile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.inputFile), "UTF-8"));
            PrintWriter outputData = opts.outputFile == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputFile), "UTF-8"), true);
            Tree<String> tree = null;
            String line = "";
            double bestScore = Double.NEGATIVE_INFINITY;
            Tree<String> bestTree = null;
            PriorityQueue<Tree<String>> pQ = new PriorityQueue<Tree<String>>();
            int index = 1;
            while ((line = inputData.readLine()) != null) {
                tree = Trees.PennTreeReader.parseEasy(line);
                if (line.equals("\n") || tree == null || tree.getYield().get(0).equals("")) {
                    if (bestTree == null) {
                        outputData.write("(())\n");
                    } else if (opts.kbest == 1) {
                        outputData.write(bestTree + "\n");
                    } else {
                        int nTrees = Math.min(opts.kbest, pQ.size());
                        outputData.write(nTrees + "\t" + opts.inputFile + "-" + index++ + "\n");
                        for (int i = 0; i < nTrees; ++i) {
                            double p = pQ.getPriority();
                            outputData.write(p + "\n" + pQ.next() + "\n");
                        }
                        outputData.write("\n");
                    }
                    outputData.flush();
                    bestScore = Double.NEGATIVE_INFINITY;
                    bestTree = null;
                    pQ = new PriorityQueue();
                    System.err.println("Picked best tree.");
                    continue;
                }
                Tree<String> processedTree = TreeAnnotations.processTree(tree, v_markov, h_markov, bin, false);
                double[] logScores = new double[opts.nGrammars];
                for (int i = 0; i < opts.nGrammars; ++i) {
                    Tree<StateSet> stateSetTree = StateSetTreeList.stringTreeToStatesetTree(processedTree, numSubstates[i], false, tagNumberer[i]);
                    TreeReranker.allocate(stateSetTree);
                    parsers[i].doInsideScores(stateSetTree, false, false, null);
                    logScores[i] = Math.log(stateSetTree.getLabel().getIScore(0)) + (double)(stateSetTree.getLabel().getIScale() * 100);
                }
                double totalScore = DoubleArrays.add(logScores);
                if (opts.kbest > 1 && totalScore != Double.NEGATIVE_INFINITY) {
                    pQ.add(tree, totalScore);
                }
                if (!(totalScore > bestScore)) continue;
                bestScore = totalScore;
                bestTree = tree;
            }
            outputData.flush();
            outputData.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    static void allocate(Tree<StateSet> tree) {
        tree.getLabel().allocate();
        for (Tree<StateSet> child : tree.getChildren()) {
            TreeReranker.allocate(child);
        }
    }

    public static class Options {
        @Option(name="-grammar", required=true, usage="Input Files for Grammar")
        public String inFileName;
        @Option(name="-inputFile", usage="Input File for Parse Trees.")
        public String inputFile;
        @Option(name="-outputFile", usage="Store output in this file instead of printing it to STDOUT.")
        public String outputFile;
        @Option(name="-nGrammars", usage="Number of grammars")
        public int nGrammars;
        @Option(name="-kBest", usage="Print the k best trees")
        public int kbest = 1;
    }
}

