/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA.smoothing;

import edu.berkeley.nlp.PCFGLA.BinaryCounterTable;
import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.UnaryCounterTable;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.util.Numberer;
import java.io.Serializable;

public class SmoothAcrossParentSubstate
implements Smoother,
Serializable {
    private static final long serialVersionUID = 1L;
    double same;
    double different;

    public SmoothAcrossParentSubstate(double smooth) {
        this.different = smooth;
        this.same = 1.0 - this.different;
    }

    public void smooth(UnaryCounterTable unaryCounter, BinaryCounterTable binaryCounter) {
        int j;
        Object scopy;
        Object scores;
        for (UnaryRule unaryRule : unaryCounter.keySet()) {
            scores = unaryCounter.getCount(unaryRule);
            scopy = new double[((double[][])scores).length][];
            for (j = 0; j < ((double[][])scores).length; ++j) {
                if (scores[j] == null) continue;
                scopy[j] = new double[scores[j].length];
                double diff = this.different / (double)(scores[j].length - 1);
                for (int i = 0; i < scores[j].length; ++i) {
                    for (int k = 0; k < scores[j].length; ++k) {
                        double[] dArray = scopy[j];
                        int n = i;
                        dArray[n] = dArray[n] + (i == k ? this.same : diff) * scores[j][k];
                    }
                }
            }
            unaryCounter.setCount(unaryRule, (double[][])scopy);
        }
        for (BinaryRule binaryRule : binaryCounter.keySet()) {
            scores = binaryCounter.getCount(binaryRule);
            scopy = new double[((double[][])scores).length][scores[0].length][];
            for (j = 0; j < ((double[][])scores).length; ++j) {
                for (int l = 0; l < scores[0].length; ++l) {
                    if (scores[j][l] == null) continue;
                    scopy[j][l] = (double)new double[((double)scores[j][l]).length];
                    double diff = this.different / (double)(((double)scores[j][l]).length - 1);
                    for (int i = 0; i < ((double)scores[j][l]).length; ++i) {
                        for (int k = 0; k < ((double)scores[j][l]).length; ++k) {
                            double d = scopy[j][l];
                            int n = i;
                            d[n] = d[n] + (i == k ? this.same : diff) * scores[j][l][k];
                        }
                    }
                }
            }
            binaryCounter.setCount(binaryRule, (double[][][])scopy);
        }
    }

    public void smooth(short tag, double[] scores) {
        int i;
        double[] scopy = new double[scores.length];
        for (i = 0; i < scores.length; ++i) {
            double diff = this.different / (double)(scores.length - 1);
            for (int k = 0; k < scores.length; ++k) {
                int n = i;
                scopy[n] = scopy[n] + (i == k ? this.same : diff) * scores[k];
            }
        }
        for (i = 0; i < scores.length; ++i) {
            scores[i] = scopy[i];
        }
    }

    public void updateWeights(int[][] toSubstateMapping) {
    }

    public Smoother copy() {
        return new SmoothAcrossParentSubstate(this.different);
    }

    public Smoother remapStates(Numberer thisNumberer, Numberer newNumberer) {
        return this.copy();
    }
}

