/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.conll;

import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTBtoDep {
    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        String fileName = opts.inFileName;
        try {
            Trees.PennTreeReader treeReader = new Trees.PennTreeReader(new InputStreamReader((InputStream)new FileInputStream(fileName), Charset.forName("UTF-8")));
            while (treeReader.hasNext()) {
                Tree rootedTree = treeReader.next();
                if (((String)rootedTree.getLabel()).equals("ROOT")) {
                    rootedTree = rootedTree.getChildren().get(0);
                }
                PTBtoDep.printDependencies(rootedTree);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printDependencies(Tree<String> tree) {
        if (tree.getYield().size() <= 1) {
            System.out.println("0\t_\t_\t_");
            return;
        }
        int thisHead = PTBtoDep.findHead(tree);
        int nWords = tree.getYield().size();
        for (int nWordsFound = PTBtoDep.printDependencies(tree, thisHead, 0, 0); nWords < nWordsFound; ++nWordsFound) {
            System.out.println("0\t_\t_\t_");
            System.err.println("too short");
        }
        System.out.println("");
    }

    private static int printDependencies(Tree<String> tree, int parent, int previousWords, int parentOfParent) {
        for (Tree<String> child : tree.getChildren()) {
            if (previousWords == parent - 1) {
                System.out.println(parentOfParent + "\t_\t_\t_");
                if (child.getYield().size() > 1) {
                    System.err.println(child);
                }
                ++previousWords;
                continue;
            }
            if (child.isPreTerminal()) {
                System.out.println(parent + "\t_\t_\t_");
                ++previousWords;
                continue;
            }
            int thisHead = previousWords + PTBtoDep.findHead(child);
            PTBtoDep.printDependencies(child, thisHead, previousWords, parent);
            previousWords += child.getYield().size();
        }
        return previousWords;
    }

    private static int findHead(Tree<String> tree) {
        String headLabel = tree.getLabel();
        headLabel = headLabel.substring(0, headLabel.length() - 1);
        int headIndex = -2;
        int previousWords = 0;
        for (Tree<String> child : tree.getChildren()) {
            if (child.isPreTerminal() && child.getLabel().equals(headLabel)) {
                headIndex = previousWords++;
                continue;
            }
            previousWords += child.getYield().size();
        }
        return headIndex + 1;
    }

    public static class Options {
        @Option(name="-in", required=true, usage="Input File for Trees (Required)")
        public String inFileName;
    }
}

