/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.PCFGLA.ConstrainedTwoChartsParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarMerger;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.ParserConstrainer;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Numberer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;

public class ConditionalMerger {
    int nProcesses;
    String consBaseName;
    Grammar grammar;
    Lexicon lexicon;
    double mergingPercentage;
    String outFileName;
    StateSetTreeList[] trainingTrees;
    ExecutorService pool;
    Merger[] tasks;
    double[][] mergeWeights;

    public ConditionalMerger(int processes, String consBaseName, StateSetTreeList trainTrees, Grammar gr, Lexicon lex, double mergingPercentage, String outFileName) {
        int i;
        this.nProcesses = processes;
        this.consBaseName = consBaseName;
        this.grammar = gr;
        this.lexicon = lex;
        this.mergingPercentage = mergingPercentage;
        this.outFileName = outFileName;
        int nTreesPerBlock = trainTrees.size() / processes;
        this.consBaseName = consBaseName;
        boolean[][][][][] tmp = ParserConstrainer.loadData(consBaseName + "-0.data");
        if (tmp != null) {
            nTreesPerBlock = tmp.length;
        }
        this.mergeWeights = GrammarMerger.computeMergeWeights(this.grammar, this.lexicon, trainTrees);
        double[][][] deltas = GrammarMerger.computeDeltas(this.grammar, this.lexicon, this.mergeWeights, trainTrees);
        boolean[][][] mergeThesePairs = GrammarMerger.determineMergePairs(deltas, false, mergingPercentage, this.grammar);
        Grammar tmpGrammar = this.grammar.copyGrammar(true);
        Lexicon tmpLexicon = this.lexicon.copyLexicon();
        tmpGrammar = GrammarMerger.doTheMerges(tmpGrammar, tmpLexicon, mergeThesePairs, this.mergeWeights);
        System.out.println("Generative merging criterion gives:");
        GrammarMerger.printMergingStatistics(this.grammar, tmpGrammar);
        this.mergeWeights = GrammarMerger.computeMergeWeights(this.grammar, this.lexicon, trainTrees);
        this.trainingTrees = new StateSetTreeList[this.nProcesses];
        for (int i2 = 0; i2 < this.nProcesses; ++i2) {
            this.trainingTrees[i2] = new StateSetTreeList();
        }
        int block = -1;
        int inBlock = 0;
        for (i = 0; i < trainTrees.size(); ++i) {
            if (i % nTreesPerBlock == 0) {
                ++block;
                System.out.println(inBlock);
                inBlock = 0;
            }
            this.trainingTrees[block % this.nProcesses].add(trainTrees.get(i));
            ++inBlock;
        }
        trainTrees = null;
        this.pool = Executors.newFixedThreadPool(this.nProcesses);
        this.tasks = new Merger[this.nProcesses];
        for (i = 0; i < this.nProcesses; ++i) {
            this.tasks[i] = new Merger(this.trainingTrees[i], consBaseName, i, this.grammar, this.lexicon, this.mergeWeights);
        }
    }

    public void mergeGrammarAndLexicon() {
        boolean done;
        System.out.print("Task: ");
        Future[] submits = new Future[this.nProcesses];
        for (int i = 0; i < this.nProcesses; ++i) {
            Future submit;
            submits[i] = submit = this.pool.submit(this.tasks[i]);
        }
        do {
            done = true;
            for (Future task : submits) {
                done &= task.isDone();
            }
        } while (!done);
        double[][][] deltas = new double[this.grammar.numStates][this.mergeWeights[0].length][this.mergeWeights[0].length];
        for (int i = 0; i < this.nProcesses; ++i) {
            double[][][] counts = null;
            try {
                counts = (double[][][])submits[i].get();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int a = 0; a < deltas.length; ++a) {
                for (int b = 0; b < deltas[0].length; ++b) {
                    for (int c = 0; c < deltas[0][0].length; ++c) {
                        double[] dArray = deltas[a][b];
                        int n = c;
                        dArray[n] = dArray[n] + counts[a][b][c];
                    }
                }
            }
        }
        System.out.print(" done. ");
        System.out.println("Conditional merging criterion gives:");
        boolean[][][] mergeThesePairs = GrammarMerger.determineMergePairs(deltas, false, this.mergingPercentage, this.grammar);
        Grammar newGrammar = GrammarMerger.doTheMerges(this.grammar, this.lexicon, mergeThesePairs, this.mergeWeights);
        GrammarMerger.printMergingStatistics(this.grammar, newGrammar);
        ParserData pData = new ParserData(this.lexicon, newGrammar, null, Numberer.getNumberers(), newGrammar.numSubStates, 1, 0, Binarization.RIGHT);
        System.out.println("Saving grammar to " + this.outFileName + ".");
        if (pData.Save(this.outFileName + "-merged")) {
            System.out.println("Saving successful.");
        } else {
            System.out.println("Saving failed!");
        }
    }

    class Merger
    implements Callable {
        ArrayParser gParser;
        ConstrainedTwoChartsParser eParser;
        StateSetTreeList myTrees;
        String consName;
        int myID;
        int nCounts;
        boolean[][][][][] myConstraints;
        int unparsableTrees;
        int incorrectLLTrees;
        double[][] mergeWeights;

        Merger(StateSetTreeList myT, String consN, int i, Grammar gr, Lexicon lex, double[][] mergeWeights) {
            this.consName = consN;
            this.myTrees = myT;
            this.myID = i;
            this.mergeWeights = mergeWeights;
            this.gParser = new ArrayParser(gr, lex);
            this.eParser = new ConstrainedTwoChartsParser(gr, lex, null);
        }

        private void loadConstraints() {
            this.myConstraints = new boolean[this.myTrees.size()][][][][];
            boolean[][][][][] curBlock = null;
            int block = 0;
            int i = 0;
            if (this.consName == null) {
                return;
            }
            for (int tree = 0; tree < this.myTrees.size(); ++tree) {
                if (curBlock == null || i >= curBlock.length) {
                    int blockNumber = block * ConditionalMerger.this.nProcesses + this.myID;
                    curBlock = this.loadData(this.consName + "-" + blockNumber + ".data");
                    ++block;
                    i = 0;
                    System.out.print(".");
                }
                this.eParser.projectConstraints(curBlock[i], false);
                this.myConstraints[tree] = curBlock[i];
                ++i;
                if (this.myConstraints[tree].length == this.myTrees.get(tree).getYield().size()) continue;
                System.out.println("My ID: " + this.myID + ", block: " + block + ", sentence: " + i);
                System.out.println("Sentence length and constraints length do not match!");
                this.myConstraints[tree] = null;
            }
        }

        public double[][][] call() {
            if (this.myConstraints == null) {
                this.loadConstraints();
            }
            double[][][] deltas = new double[ConditionalMerger.this.grammar.numStates][this.mergeWeights[0].length][this.mergeWeights[0].length];
            int i = -1;
            int block = 0;
            for (Tree<StateSet> stateSetTree : this.myTrees) {
                ++i;
                boolean noSmoothing = true;
                boolean debugOutput = false;
                boolean hardCounts = false;
                this.gParser.doInsideOutsideScores(stateSetTree, noSmoothing, debugOutput);
                List<StateSet> yield = stateSetTree.getYield();
                ArrayList<String> sentence = new ArrayList<String>(yield.size());
                for (StateSet el : yield) {
                    sentence.add(el.getWord());
                }
                boolean[][][][] cons = null;
                if (this.consName != null && (cons = this.myConstraints[i]).length != sentence.size()) {
                    System.out.println("My ID: " + this.myID + ", block: " + block + ", sentence: " + i);
                    System.out.println("Sentence length (" + sentence.size() + ") and constraints length (" + cons.length + ") do not match!");
                    System.exit(-1);
                }
                this.eParser.doConstrainedInsideOutsideScores(yield, cons, noSmoothing, stateSetTree, null, false);
                this.eParser.tallyConditionalLoss(stateSetTree, deltas, this.mergeWeights);
                if (i % 100 != 0) continue;
                System.out.print(".");
            }
            System.out.print(" " + this.myID + " ");
            return deltas;
        }

        public boolean[][][][][] loadData(String fileName) {
            boolean[][][][][] data = null;
            try {
                FileInputStream fis = new FileInputStream(fileName);
                GZIPInputStream gzis = new GZIPInputStream(fis);
                ObjectInputStream in = new ObjectInputStream(gzis);
                data = (boolean[][][][][])in.readObject();
                in.close();
            }
            catch (IOException e) {
                System.out.println("IOException\n" + e);
                return null;
            }
            catch (ClassNotFoundException e) {
                System.out.println("Class not found!");
                return null;
            }
            return data;
        }
    }
}

