/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.util.ArrayUtil;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinearizer
implements Linearizer,
Serializable {
    Grammar grammar;
    SimpleLexicon lexicon;
    SpanPredictor spanPredictor;
    int[][] linearIndex;
    int nGrammarWeights;
    int nLexiconWeights;
    int nSpanWeights;
    int nWords;
    int startSpanWeights;
    int nSubstates;
    int nClasses;
    int startIndexPrevious;
    int startIndexNext;
    int startIndexFirst;
    int startIndexLast;
    int startIndexBeginPair;
    int startIndexEndPair;
    int startIndexPunctuation;
    double[] lastProbs;
    private static final long serialVersionUID = 2L;

    public DefaultLinearizer() {
    }

    public DefaultLinearizer(Grammar grammar, SimpleLexicon lexicon, SpanPredictor sp) {
        this.grammar = grammar;
        this.lexicon = lexicon;
        this.spanPredictor = sp;
        this.nSubstates = (int)ArrayUtil.max(grammar.numSubStates);
        this.init();
    }

    protected void init() {
        double[] tmp = null;
        if (!ConditionalTrainer.Options.lockGrammar) {
            tmp = this.getLinearizedGrammar(true);
            tmp = this.getLinearizedLexicon(true);
        }
        tmp = this.getLinearizedSpanPredictor(true);
    }

    public void delinearizeSpanPredictor(double[] probs) {
        double val;
        int c;
        int i;
        double[][] tmp;
        if (this.spanPredictor == null) {
            return;
        }
        int ind = this.startSpanWeights;
        int nDangerous = 0;
        if (this.spanPredictor.useFirstAndLast) {
            tmp = this.spanPredictor.firstWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                        continue;
                    }
                    tmp[i][c] = val = Math.exp(val);
                }
            }
            tmp = this.spanPredictor.lastWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                        continue;
                    }
                    tmp[i][c] = val = Math.exp(val);
                }
            }
        }
        if (this.spanPredictor.usePreviousAndNext) {
            tmp = this.spanPredictor.previousWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                        continue;
                    }
                    tmp[i][c] = val = Math.exp(val);
                }
            }
            tmp = this.spanPredictor.nextWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                        continue;
                    }
                    tmp[i][c] = val = Math.exp(val);
                }
            }
        }
        if (this.spanPredictor.useBeginAndEndPairs) {
            tmp = this.spanPredictor.beginPairScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                        continue;
                    }
                    tmp[i][c] = val = Math.exp(val);
                }
            }
            tmp = this.spanPredictor.endPairScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                        continue;
                    }
                    tmp[i][c] = val = Math.exp(val);
                }
            }
        }
        if (this.spanPredictor.usePunctuation) {
            tmp = this.spanPredictor.punctuationScores;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    int n = ind++;
                    val = probs[n];
                    if (Math.abs(val) > 300.0) {
                        ++nDangerous;
                        continue;
                    }
                    tmp[i][c] = val = Math.exp(val);
                }
            }
        }
        if (nDangerous > 0) {
            System.out.println("Ignored " + nDangerous + " proposed span feature weights since they were dangerous.");
        }
    }

    public void delinearizeGrammar(double[] probs) {
        int k;
        int j;
        Object scores;
        int ind;
        int nDangerous = 0;
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            ind = bRule.identifier;
            scores = bRule.getScores2();
            for (j = 0; j < ((double[][][])scores).length; ++j) {
                for (k = 0; k < scores[j].length; ++k) {
                    if (scores[j][k] == null) continue;
                    for (int l = 0; l < scores[j][k].length; ++l) {
                        double val;
                        if (SloppyMath.isVeryDangerous(val = Math.exp(probs[ind++]))) {
                            System.out.println("dangerous value for rule " + bRule + " " + probs[ind - 1]);
                            val = 0.0;
                            ++nDangerous;
                        }
                        scores[j][k][l] = val;
                    }
                }
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " binary rule weights unchanged since the proposed weight was dangerous.");
        }
        nDangerous = 0;
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            ind = uRule.identifier;
            if (uRule.childState == uRule.parentState) continue;
            scores = uRule.getScores2();
            for (j = 0; j < ((double[][][])scores).length; ++j) {
                if (scores[j] == null) continue;
                for (k = 0; k < scores[j].length; ++k) {
                    double val;
                    if (SloppyMath.isVeryDangerous(val = Math.exp(probs[ind++]))) {
                        System.out.println("dangerous value for rule " + uRule + " " + probs[ind - 1]);
                        val = 0.0;
                        ++nDangerous;
                    }
                    scores[j][k] = (double[])val;
                }
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " unary rule weights unchanged since the proposed weight was dangerous.");
        }
        this.grammar.closedViterbiRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedSumRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedViterbiRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.closedSumRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.clearUnaryIntermediates();
        this.grammar.makeCRArrays();
    }

    public double[] getLinearizedGrammar(boolean update) {
        int k;
        int j;
        int ind;
        if (update) {
            int j2;
            Object scores;
            this.nGrammarWeights = 0;
            for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
                if (!this.grammar.isGrammarTag[bRule.parentState]) {
                    System.out.println("Incorrect grammar tag");
                }
                bRule.identifier = this.nGrammarWeights;
                scores = bRule.getScores2();
                for (j2 = 0; j2 < ((double[][][])scores).length; ++j2) {
                    for (int k2 = 0; k2 < scores[j2].length; ++k2) {
                        if (scores[j2][k2] == null) continue;
                        this.nGrammarWeights += scores[j2][k2].length;
                    }
                }
            }
            for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
                uRule.identifier = this.nGrammarWeights;
                scores = uRule.getScores2();
                for (j2 = 0; j2 < ((double[][][])scores).length; ++j2) {
                    if (scores[j2] == null) continue;
                    this.nGrammarWeights += scores[j2].length;
                }
            }
        }
        double[] logProbs = new double[this.nGrammarWeights];
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            ind = bRule.identifier;
            double[][][] scores = bRule.getScores2();
            for (j = 0; j < scores.length; ++j) {
                for (k = 0; k < scores[j].length; ++k) {
                    if (scores[j][k] == null) continue;
                    for (int l = 0; l < scores[j][k].length; ++l) {
                        double val = Math.log(scores[j][k][l]);
                        if (val == Double.NEGATIVE_INFINITY) {
                            // empty if block
                        }
                        logProbs[ind++] = val;
                    }
                }
            }
        }
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            ind = uRule.identifier;
            if (uRule.childState == uRule.parentState) continue;
            double[][] scores = uRule.getScores2();
            for (j = 0; j < scores.length; ++j) {
                if (scores[j] == null) continue;
                for (k = 0; k < scores[j].length; ++k) {
                    double val = Math.log(scores[j][k]);
                    if (val == Double.NEGATIVE_INFINITY) {
                        // empty if block
                    }
                    logProbs[ind++] = val;
                }
            }
        }
        return logProbs;
    }

    public void delinearizeLexicon(double[] logProbs) {
        int nDangerous = 0;
        for (int tag = 0; tag < this.lexicon.scores.length; tag = (int)((short)(tag + 1))) {
            for (int word = 0; word < this.lexicon.scores[tag][0].length; ++word) {
                int index = this.linearIndex[tag][word];
                for (int substate = 0; substate < this.lexicon.numSubStates[tag]; ++substate) {
                    double val;
                    if (SloppyMath.isVeryDangerous(val = Math.exp(logProbs[index++]))) {
                        System.out.println("dangerous value when delinearizng lexicon " + this.lexicon.scores[tag][substate][word]);
                        System.out.println("Word " + this.lexicon.wordIndexer.get(this.lexicon.tagWordIndexer[tag].get(word)) + " tag " + logProbs[index - 1]);
                        val = 0.0;
                        ++nDangerous;
                    }
                    this.lexicon.scores[tag][substate][word] = val;
                }
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " lexicon weights unchanged since the proposed weight was dangerous.");
        }
    }

    @Override
    public double[] getLinearizedLexicon() {
        return this.getLinearizedLexicon(false);
    }

    public double[] getLinearizedLexicon(boolean update) {
        if (update) {
            this.nLexiconWeights = 0;
            for (int tag = 0; tag < this.lexicon.scores.length; tag = (int)((short)(tag + 1))) {
                for (int word = 0; word < this.lexicon.scores[tag][0].length; ++word) {
                    this.nLexiconWeights += this.lexicon.numSubStates[tag];
                }
            }
        }
        double[] logProbs = new double[this.nLexiconWeights];
        if (update) {
            this.linearIndex = new int[this.lexicon.expectedCounts.length][];
        }
        int index = 0;
        for (int tag = 0; tag < this.lexicon.scores.length; tag = (int)((short)(tag + 1))) {
            if (update) {
                this.linearIndex[tag] = new int[this.lexicon.scores[tag][0].length];
            }
            for (int word = 0; word < this.lexicon.scores[tag][0].length; ++word) {
                if (update) {
                    this.linearIndex[tag][word] = index + this.nGrammarWeights;
                }
                for (int substate = 0; substate < this.lexicon.numSubStates[tag]; ++substate) {
                    double val = Math.log(this.lexicon.scores[tag][substate][word]);
                    if (val == Double.NEGATIVE_INFINITY) {
                        // empty if block
                    }
                    logProbs[index++] = val;
                }
            }
        }
        return logProbs;
    }

    public int getLinearIndex(String word, int tag) {
        return this.getLinearIndex(this.lexicon.wordIndexer.indexOf(word), tag);
    }

    public int getLinearIndex(int globalWordIndex, int tag) {
        int tagSpecificWordIndex = this.lexicon.tagWordIndexer[tag].indexOf(globalWordIndex);
        if (tagSpecificWordIndex == -1) {
            return -1;
        }
        return this.linearIndex[tag][tagSpecificWordIndex];
    }

    @Override
    public int dimension() {
        return this.nGrammarWeights + this.nLexiconWeights + this.nSpanWeights;
    }

    @Override
    public void increment(double[] counts, StateSet stateSet, int tag, double[] weights, boolean isGold) {
        int i;
        int startIndexWord;
        int globalSigIndex = stateSet.sigIndex;
        if (globalSigIndex != -1 && (startIndexWord = this.getLinearIndex(globalSigIndex, tag)) >= 0) {
            for (i = 0; i < this.nSubstates; ++i) {
                if (isGold) {
                    int n = startIndexWord++;
                    counts[n] = counts[n] + weights[i];
                    continue;
                }
                int n = startIndexWord++;
                counts[n] = counts[n] - weights[i];
            }
        }
        if ((startIndexWord = this.getLinearIndex(stateSet.wordIndex, tag)) >= 0) {
            for (i = 0; i < this.nSubstates; ++i) {
                if (isGold) {
                    int n = startIndexWord++;
                    counts[n] = counts[n] + weights[i];
                } else {
                    int n = startIndexWord++;
                    counts[n] = counts[n] - weights[i];
                }
                weights[i] = 0.0;
            }
        } else {
            for (i = 0; i < this.nSubstates; ++i) {
                weights[i] = 0.0;
            }
        }
    }

    @Override
    public void increment(double[] counts, UnaryRule rule, double[] weights, boolean isGold) {
        int thisStartIndex = rule.identifier;
        int curInd = 0;
        int nSubstatesParent = rule.parentState == 0 ? 1 : this.nSubstates;
        for (int cp = 0; cp < this.nSubstates; ++cp) {
            for (int np = 0; np < nSubstatesParent; ++np) {
                if (isGold) {
                    int n = thisStartIndex++;
                    counts[n] = counts[n] + weights[curInd];
                } else {
                    int n = thisStartIndex++;
                    counts[n] = counts[n] - weights[curInd];
                }
                weights[curInd++] = 0.0;
            }
        }
    }

    @Override
    public void increment(double[] counts, BinaryRule rule, double[] weights, boolean isGold) {
        int thisStartIndex = rule.identifier;
        int curInd = 0;
        for (int lp = 0; lp < this.nSubstates; ++lp) {
            for (int rp = 0; rp < this.nSubstates; ++rp) {
                for (int np = 0; np < this.nSubstates; ++np) {
                    if (isGold) {
                        int n = thisStartIndex++;
                        counts[n] = counts[n] + weights[curInd];
                    } else {
                        int n = thisStartIndex++;
                        counts[n] = counts[n] - weights[curInd];
                    }
                    weights[curInd++] = 0.0;
                }
            }
        }
    }

    @Override
    public void delinearizeWeights(double[] logWeights) {
        double val;
        int i;
        int nGrZ = 0;
        int nLexZ = 0;
        int nSpZ = 0;
        int tmpI = 0;
        if (!ConditionalTrainer.Options.lockGrammar) {
            for (i = 0; i < this.nGrammarWeights; ++i) {
                if ((val = logWeights[tmpI++]) != 0.0) continue;
                ++nGrZ;
            }
            this.delinearizeGrammar(logWeights);
            for (i = 0; i < this.nLexiconWeights; ++i) {
                if ((val = logWeights[tmpI++]) != 0.0) continue;
                ++nLexZ;
            }
            this.delinearizeLexicon(logWeights);
        }
        for (i = 0; i < this.nSpanWeights; ++i) {
            if ((val = logWeights[tmpI++]) != 0.0) continue;
            ++nSpZ;
        }
        this.delinearizeSpanPredictor(logWeights);
        this.lastProbs = (double[])logWeights.clone();
        System.out.println("Proposed vector has " + (nGrZ + nLexZ + nSpZ) + "/" + (this.nGrammarWeights + this.nLexiconWeights + this.nSpanWeights) + " zeros [grammar: " + nGrZ + "/" + this.nGrammarWeights + ", lexicon: " + nLexZ + "/" + this.nLexiconWeights + ", span: " + nSpZ + "/" + this.nSpanWeights + "].");
    }

    public double[] getLinearizedSpanPredictor(boolean update) {
        int c;
        int i;
        double[][] tmp;
        if (this.spanPredictor == null) {
            this.nSpanWeights = 0;
            return new double[0];
        }
        this.nWords = this.spanPredictor.nWords;
        this.nSpanWeights = this.spanPredictor.nFeatures;
        this.startSpanWeights = this.nGrammarWeights + this.nLexiconWeights;
        this.nClasses = this.spanPredictor.getNClasses();
        double[] logProbs = new double[this.nSpanWeights];
        int ind = 0;
        if (update) {
            this.startIndexFirst = this.startSpanWeights;
            this.startIndexLast = this.startIndexFirst + this.nWords * this.nClasses;
            this.startIndexPrevious = this.spanPredictor.useFirstAndLast ? this.startIndexFirst + 2 * this.nWords * this.nClasses : this.startIndexFirst;
            this.startIndexNext = this.startIndexPrevious + this.nWords * this.nClasses;
            this.startIndexBeginPair = this.spanPredictor.usePreviousAndNext ? this.startIndexPrevious + 2 * this.nWords * this.nClasses : this.startIndexPrevious;
            this.startIndexEndPair = this.spanPredictor.useBeginAndEndPairs ? this.startIndexBeginPair + this.spanPredictor.beginPairScore.length * this.nClasses : this.startIndexBeginPair;
            int n = this.startIndexPunctuation = this.spanPredictor.useBeginAndEndPairs ? this.startIndexBeginPair + (this.spanPredictor.beginPairScore.length + this.spanPredictor.endPairScore.length) * this.nClasses : this.startIndexBeginPair;
        }
        if (this.spanPredictor.useFirstAndLast) {
            tmp = this.spanPredictor.firstWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                }
            }
            tmp = this.spanPredictor.lastWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                }
            }
        }
        if (this.spanPredictor.usePreviousAndNext) {
            tmp = this.spanPredictor.previousWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                }
            }
            tmp = this.spanPredictor.nextWordScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                }
            }
        }
        if (this.spanPredictor.useBeginAndEndPairs) {
            tmp = this.spanPredictor.beginPairScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                }
            }
            tmp = this.spanPredictor.endPairScore;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                }
            }
        }
        if (this.spanPredictor.usePunctuation) {
            tmp = this.spanPredictor.punctuationScores;
            for (i = 0; i < tmp.length; ++i) {
                for (c = 0; c < tmp[0].length; ++c) {
                    logProbs[ind++] = Math.log(tmp[i][c]);
                }
            }
        }
        return logProbs;
    }

    @Override
    public double[] getLinearizedWeights() {
        int i;
        double[] initialGrammarWeights = ConditionalTrainer.Options.lockGrammar ? new double[]{} : this.getLinearizedGrammar();
        double[] initialLexiconWeights = ConditionalTrainer.Options.lockGrammar ? new double[]{} : this.getLinearizedLexicon();
        double[] initialSpanWeights = this.getLinearizedSpanPredictor();
        double[] curWeights = new double[this.dimension()];
        int j = 0;
        for (i = 0; i < initialGrammarWeights.length; ++i) {
            curWeights[j++] = initialGrammarWeights[i];
        }
        for (i = 0; i < initialLexiconWeights.length; ++i) {
            curWeights[j++] = initialLexiconWeights[i];
        }
        for (i = 0; i < initialSpanWeights.length; ++i) {
            curWeights[j++] = initialSpanWeights[i];
        }
        return curWeights;
    }

    @Override
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public SimpleLexicon getLexicon() {
        return this.lexicon;
    }

    @Override
    public SpanPredictor getSpanPredictor() {
        return this.spanPredictor;
    }

    @Override
    public double[] getLinearizedGrammar() {
        return this.getLinearizedGrammar(false);
    }

    @Override
    public void increment(double[] counts, List<StateSet> sentence, double[][][] weights, boolean isGold) {
        int c;
        int c2;
        int length = sentence.size();
        int previousIndex = -1;
        int nextIndex = -1;
        if (this.spanPredictor.usePunctuation) {
            int[][] punctSignatures = this.spanPredictor.getPunctuationSignatures(sentence);
            for (int start = 0; start <= length - this.spanPredictor.minSpanLength; ++start) {
                for (int end = start + this.spanPredictor.minSpanLength; end <= length; ++end) {
                    int sig = punctSignatures[start][end];
                    if (sig == -1) continue;
                    sig *= this.nClasses;
                    for (c2 = 0; c2 < this.nClasses; ++c2) {
                        int n = this.startIndexPunctuation + sig + c2;
                        counts[n] = counts[n] - weights[start][end][c2];
                    }
                }
            }
        }
        for (int start = 0; start <= length - this.spanPredictor.minSpanLength; ++start) {
            int beginI;
            StateSet stateSet = sentence.get(start);
            int firstIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            this.spanPredictor.getClass();
            firstIndex = stateSet.wordIndex;
            double[] total = new double[this.nClasses];
            for (int end = start + this.spanPredictor.minSpanLength; end <= length; ++end) {
                for (c2 = 0; c2 < total.length; ++c2) {
                    int n = c2;
                    total[n] = total[n] + weights[start][end][c2];
                }
            }
            int firstI = this.startSpanWeights + firstIndex * this.nClasses;
            int prevI = this.startIndexPrevious + previousIndex * this.nClasses;
            for (c = 0; c < total.length; ++c) {
                double t = total[c];
                if (t == 0.0) continue;
                if (this.spanPredictor.useFirstAndLast) {
                    int n = firstI + c;
                    counts[n] = counts[n] - t;
                }
                if (!this.spanPredictor.usePreviousAndNext || previousIndex == -1) continue;
                int n = prevI + c;
                counts[n] = counts[n] - t;
            }
            if (this.spanPredictor.useBeginAndEndPairs && previousIndex != -1 && (beginI = this.spanPredictor.getBeginIndex(previousIndex, firstIndex) * this.nClasses) >= 0) {
                beginI += this.startIndexBeginPair;
                for (int c3 = 0; c3 < total.length; ++c3) {
                    double t = total[c3];
                    if (t == 0.0) continue;
                    int n = beginI + c3;
                    counts[n] = counts[n] - t;
                }
            }
            previousIndex = firstIndex;
        }
        for (int end = length; end >= this.spanPredictor.minSpanLength; --end) {
            int endI;
            StateSet stateSet = sentence.get(end - 1);
            int lastIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            this.spanPredictor.getClass();
            lastIndex = stateSet.wordIndex;
            double[] total = new double[this.spanPredictor.getNClasses()];
            for (int start = 0; start <= end - this.spanPredictor.minSpanLength; ++start) {
                for (c2 = 0; c2 < total.length; ++c2) {
                    int n = c2;
                    total[n] = total[n] + weights[start][end][c2];
                }
            }
            int lastI = this.startIndexLast + lastIndex * this.nClasses;
            int nextI = this.startIndexNext + nextIndex * this.nClasses;
            for (c = 0; c < total.length; ++c) {
                if (this.spanPredictor.useFirstAndLast) {
                    int n = lastI + c;
                    counts[n] = counts[n] - total[c];
                }
                if (!this.spanPredictor.usePreviousAndNext || nextIndex == -1) continue;
                int n = nextI + c;
                counts[n] = counts[n] - total[c];
            }
            if (this.spanPredictor.useBeginAndEndPairs && nextIndex != -1 && (endI = this.spanPredictor.getEndIndex(lastIndex, nextIndex) * this.nClasses) >= 0) {
                endI += this.startIndexEndPair;
                for (int c4 = 0; c4 < total.length; ++c4) {
                    int n = endI + c4;
                    counts[n] = counts[n] - total[c4];
                }
            }
            nextIndex = lastIndex;
        }
    }

    @Override
    public double[] getLinearizedSpanPredictor() {
        return this.getLinearizedSpanPredictor(false);
    }

    @Override
    public int getNGrammarWeights() {
        return this.nGrammarWeights;
    }

    @Override
    public int getNLexiconWeights() {
        return this.nLexiconWeights;
    }

    @Override
    public int getNSpanWeights() {
        return this.nSpanWeights;
    }
}

