/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.io;

import edu.berkeley.nlp.io.AbstractMapLabel;
import edu.berkeley.nlp.io.Label;
import edu.berkeley.nlp.io.LabelFactory;
import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.Interner;
import edu.berkeley.nlp.util.MapFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureLabel
extends AbstractMapLabel {
    public static String TOSTRING_FORMAT = null;
    public Collection features = null;
    private static final long serialVersionUID = 19L;

    public FeatureLabel() {
    }

    public FeatureLabel(MapFactory mapFactory) {
        super(mapFactory);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public FeatureLabel(String[] keys, String[] values) {
        for (int i = 0; i < keys.length && i < values.length; ++i) {
            if (keys[i] == null) continue;
            this.put(keys[i], values[i]);
        }
    }

    public static FeatureLabel valueOf(String s, MapFactory mf) throws Exception {
        return new FeatureLabel(CollectionUtils.getMapFromString(s, Class.forName("java.lang.String"), Class.forName("java.lang.String"), mf));
    }

    public FeatureLabel(AbstractMapLabel other) {
        super(other.mapFactory);
        this.map = this.mapFactory.buildMap();
        this.map.putAll(other.map);
    }

    public FeatureLabel(Map map) {
        this.map = map;
    }

    public static String[] mapStringToArray(String map) {
        String[] m = map.split("[,;]");
        int maxIndex = 0;
        String[] keys = new String[m.length];
        int[] indices = new int[m.length];
        for (int i = 0; i < m.length; ++i) {
            int index = m[i].lastIndexOf("=");
            keys[i] = m[i].substring(0, index);
            indices[i] = Integer.parseInt(m[i].substring(index + 1));
            if (indices[i] <= maxIndex) continue;
            maxIndex = indices[i];
        }
        Object[] mapArr = new String[maxIndex + 1];
        Arrays.fill(mapArr, null);
        for (int i = 0; i < m.length; ++i) {
            mapArr[indices[i]] = keys[i];
        }
        return mapArr;
    }

    @Override
    public String word() {
        return this.getString("word");
    }

    @Override
    public String answer() {
        return this.getString("answer");
    }

    @Override
    public String goldAnswer() {
        return this.getString("goldAnswer");
    }

    @Override
    public void setWord(String word) {
        this.put("word", word);
    }

    @Override
    public void setAnswer(String answer) {
        this.put("answer", answer);
    }

    @Override
    public void setGoldAnswer(String goldAnswer) {
        this.put("goldAnswer", goldAnswer);
    }

    @Override
    public String before() {
        return this.getString("before");
    }

    @Override
    public void setBefore(String before) {
        this.map.put("before", before);
    }

    @Override
    public void prependBefore(String before) {
        String oldBefore = this.before();
        this.setBefore(before + oldBefore);
    }

    @Override
    public String current() {
        return this.getString("current");
    }

    @Override
    public void setCurrent(String current) {
        this.map.put("current", current);
    }

    @Override
    public String after() {
        return this.getString("after");
    }

    @Override
    public void setAfter(String after) {
        this.map.put("after", after);
    }

    @Override
    public void appendAfter(String after) {
        String oldAfter = this.after();
        this.setAfter(oldAfter + after);
    }

    @Override
    public String ner() {
        return this.getString("ner");
    }

    @Override
    public void setNER(String ner) {
        this.map.put("ner", ner);
    }

    public String coref() {
        return this.getString("coref");
    }

    public static String toOriginalString(List<FeatureLabel> sentence) {
        StringBuilder text = new StringBuilder();
        int sz = sentence.size();
        for (int i = 0; i < sz; ++i) {
            FeatureLabel iw = sentence.get(i);
            text.append(iw.before());
            text.append(iw.current());
            if (i != sz - 1) continue;
            text.append(iw.after());
        }
        return text.toString();
    }

    public static String toSentence(List<? extends FeatureLabel> sentence) {
        StringBuilder text = new StringBuilder();
        int sz = sentence.size();
        for (int i = 0; i < sz; ++i) {
            FeatureLabel iw = sentence.get(i);
            text.append(iw.word());
            if (i >= sz - 1) continue;
            text.append(" ");
        }
        return text.toString();
    }

    @Override
    public String value() {
        return this.getString("value");
    }

    @Override
    public void setValue(String value) {
        this.put("value", value);
    }

    @Override
    public String toString() {
        return this.toString(TOSTRING_FORMAT);
    }

    public String toString(String format) {
        if (format == null || format.equals("")) {
            StringBuffer sb = new StringBuffer("{");
            ArrayList sortedKeys = new ArrayList(this.map.keySet());
            Collections.sort(sortedKeys);
            boolean first = true;
            for (Object k : sortedKeys) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(k).append("=").append(this.map.get(k));
                first = false;
            }
            sb.append("}");
            return sb.toString();
        }
        if (format.equals("word")) {
            return this.word();
        }
        if (format.equals("wordtag")) {
            String tag = this.tag();
            if (tag != null && tag.length() > 0) {
                return this.word() + "/" + tag;
            }
            return this.word();
        }
        return this.map.toString();
    }

    @Override
    public void setFromString(String labelStr) {
        this.put("value", labelStr);
    }

    @Override
    public LabelFactory labelFactory() {
        return new FeatureLabelFactory();
    }

    public static LabelFactory factory() {
        return new FeatureLabelFactory();
    }

    public void internValues(Interner interner) {
        Map newMap = this.mapFactory.buildMap();
        Iterator i$ = this.map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            newMap.put(key, interner.intern(value));
        }
        this.map = newMap;
    }

    public String lemma() {
        return this.getString("lemma");
    }

    @Override
    public String tag() {
        return this.getString("tag");
    }

    public String getString(Object attribute) {
        String v = (String)this.map.get(attribute);
        if (v == null) {
            return "";
        }
        return v;
    }

    public void set(Object attribute, Object value) {
        this.put(attribute, value);
    }

    @Override
    public Map map() {
        return this.map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeatureLabel)) {
            return false;
        }
        FeatureLabel featureLabel = (FeatureLabel)o;
        return this.map == null ? featureLabel.map == null : ((Object)this.map).equals(featureLabel.map);
    }

    public int hashCode() {
        return this.map != null ? ((Object)this.map).hashCode() : 7;
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    private static class FeatureLabelFactory
    implements LabelFactory {
        private FeatureLabelFactory() {
        }

        public Label newLabel(String labelStr) {
            FeatureLabel result = new FeatureLabel();
            result.setValue(labelStr);
            return result;
        }

        public Label newLabel(String labelStr, int options) {
            FeatureLabel result = new FeatureLabel();
            result.setValue(labelStr);
            return result;
        }

        public Label newLabelFromString(String encodedLabelStr) {
            FeatureLabel result = new FeatureLabel();
            result.setValue(encodedLabelStr);
            return result;
        }

        public Label newLabel(Label oldLabel) {
            FeatureLabel result = new FeatureLabel();
            result.setValue(oldLabel.value());
            return result;
        }
    }
}

