/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.io;

import edu.berkeley.nlp.io.NumberRangeFileFilter;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.ConcatenationIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PennTreebankReader {
    public static Collection<Tree<String>> readTrees(String path, Charset charset) {
        return PennTreebankReader.readTrees(path, -1, Integer.MAX_VALUE, charset);
    }

    public static Collection<Tree<String>> readTrees(String path, int lowFileNum, int highFileNumber, Charset charset) {
        return new TreeCollection(path, lowFileNum, highFileNumber, charset);
    }

    public static void main(String[] args) {
        Collection<Tree<String>> trees = PennTreebankReader.readTrees(args[0], Charset.defaultCharset());
        for (Tree<String> tree : trees) {
            tree = new Trees.StandardTreeNormalizer().transformTree(tree);
            System.out.println(Trees.PennTreeRenderer.render(tree));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TreeCollection
    extends AbstractCollection<Tree<String>> {
        List<File> files;
        Charset charset;

        @Override
        public Iterator<Tree<String>> iterator() {
            return new ConcatenationIterator<Tree<String>>(new TreeIteratorIterator(this.files, this.charset));
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<Tree<String>> i = this.iterator();
            while (i.hasNext()) {
                ++size;
                i.next();
            }
            return size;
        }

        private List<File> getFilesUnder(String path, FileFilter fileFilter) {
            File root = new File(path);
            ArrayList<File> files = new ArrayList<File>();
            this.addFilesUnder(root, files, fileFilter);
            return files;
        }

        private void addFilesUnder(File root, List<File> files, FileFilter fileFilter) {
            if (!fileFilter.accept(root)) {
                return;
            }
            if (root.isFile()) {
                files.add(root);
                return;
            }
            if (root.isDirectory()) {
                TreeSet<File> children = new TreeSet<File>(Arrays.asList(root.listFiles()));
                for (File child : children) {
                    this.addFilesUnder(child, files, fileFilter);
                }
            }
        }

        public TreeCollection(String path, int lowFileNum, int highFileNum, Charset charset) {
            NumberRangeFileFilter fileFilter = new NumberRangeFileFilter(".mrg", lowFileNum, highFileNum, true);
            this.files = this.getFilesUnder(path, fileFilter);
            this.charset = charset;
        }

        public TreeCollection(String path, int lowFileNum, int highFileNum, String charsetName) {
            this(path, lowFileNum, highFileNum, Charset.forName(charsetName));
        }

        public TreeCollection(String path, int lowFileNum, int highFileNum) {
            this(path, lowFileNum, highFileNum, Charset.defaultCharset());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TreeIteratorIterator
        implements Iterator<Iterator<Tree<String>>> {
            Iterator<File> fileIterator;
            Iterator<Tree<String>> nextTreeIterator;
            Charset charset;
            BufferedReader currentFileReader;
            BufferedReader lastReader;
            BufferedReader readerToClose;

            @Override
            public boolean hasNext() {
                return this.nextTreeIterator != null;
            }

            @Override
            public Iterator<Tree<String>> next() {
                Iterator<Tree<String>> currentTreeIterator = this.nextTreeIterator;
                this.advance();
                return currentTreeIterator;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                this.nextTreeIterator = null;
                while (this.nextTreeIterator == null && this.fileIterator.hasNext()) {
                    File file = this.fileIterator.next();
                    try {
                        if (this.readerToClose != null) {
                            this.readerToClose.close();
                        }
                        this.readerToClose = this.lastReader;
                        this.lastReader = this.currentFileReader;
                        this.nextTreeIterator = new Trees.PennTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset)));
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new Error("Unsupported charset in file " + file.getPath());
                    }
                    catch (IOException e) {
                        new Error("Error closing file handle");
                    }
                }
                if (this.readerToClose != null) {
                    try {
                        this.readerToClose.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            TreeIteratorIterator(List<File> files, Charset charset) {
                this.fileIterator = files.iterator();
                this.charset = charset;
                this.advance();
            }
        }
    }
}

