/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mapper;

import edu.berkeley.nlp.mapper.SimpleMapper;
import edu.berkeley.nlp.util.functional.FunctionalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousMapper {
    public static <T> void doMapping(Collection<T> elems, List<? extends SimpleMapper<T>> mappers) {
        if (elems.isEmpty()) {
            return;
        }
        ArrayBlockingQueue<T> queue = new ArrayBlockingQueue<T>(elems.size(), true, elems);
        ExecutorService es = Executors.newFixedThreadPool(mappers.size());
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Worker
        implements Runnable {
            SimpleMapper mapper;
            int numCompleted = 0;
            final /* synthetic */ BlockingQueue val$queue;

            public Worker(SimpleMapper simpleMapper) {
                this.val$queue = simpleMapper;
                this.mapper = mapper;
            }

            @Override
            public void run() {
                while (!this.val$queue.isEmpty()) {
                    try {
                        Object elem = this.val$queue.poll(1000L, TimeUnit.MILLISECONDS);
                        if (elem == null) break;
                        this.mapper.map(elem);
                        ++this.numCompleted;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ArrayList<Worker> workers = new ArrayList<Worker>();
        for (SimpleMapper<T> mapper : mappers) {
            Worker worker = new Worker(mapper, queue);
            workers.add(worker);
            es.execute(worker);
        }
        es.shutdown();
        try {
            es.awaitTermination(100000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int totalCompleted = 0;
        for (Worker worker : workers) {
            totalCompleted += worker.numCompleted;
        }
        if (totalCompleted < elems.size()) {
            throw new RuntimeException("Completed only " + totalCompleted + " out of " + elems.size() + " tasks!");
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException();
        }
    }

    public static <T> void doMapping(Iterator<T> it, int batchSize, List<? extends SimpleMapper<T>> mappers) {
        while (it.hasNext()) {
            List<T> items = FunctionalUtils.take(it, batchSize);
            AsynchronousMapper.doMapping(items, mappers);
        }
    }
}

