/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.DoubleArrays;

public class DoubleMatrices {
    public static double[][] transpose(double[][] A) {
        double[][] B = new double[A[0].length][A.length];
        for (int i = 0; i < B.length; ++i) {
            for (int j = 0; j < B[0].length; ++j) {
                B[i][j] = A[j][i];
            }
        }
        return B;
    }

    public static double[] getColumnVector(double[][] A, int j) {
        double[] v = new double[A.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = A[i][j];
        }
        return v;
    }

    public static double[][] product(double[][] A, double[][] B) {
        if (A[0].length != B.length) {
            throw new RuntimeException("cols in A (" + A.length + ") differs from rows in B ( " + B.length + ")");
        }
        double[][] C = new double[A.length][B[0].length];
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < B[0].length; ++j) {
                C[i][j] = DoubleArrays.innerProduct(A[i], DoubleMatrices.getColumnVector(B, j));
            }
        }
        return C;
    }

    public static double add(double[][] m) {
        double sum = 0.0;
        for (double[] row : m) {
            sum += DoubleArrays.add(row);
        }
        return sum;
    }

    public static double[] product(double[] v, double[][] B) {
        double[][] A = new double[][]{v};
        return DoubleMatrices.product((double[][])A, B)[0];
    }

    public static double[] product(double[][] A, double[] v) {
        double[][] B = new double[][]{v};
        return DoubleMatrices.transpose(DoubleMatrices.product(A, DoubleMatrices.transpose(B)))[0];
    }

    public static void normalizeEachRow(double[][] M) {
        for (double[] row : M) {
            DoubleArrays.probabilisticNormalize(row);
        }
    }

    public static void scale(double[][] M, double scale) {
        for (double[] row : M) {
            DoubleArrays.scale(row, scale);
        }
    }

    public static double[][] constantMatrix(double c, int m, int n) {
        double[][] M = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                M[i][j] = c;
            }
        }
        return M;
    }
}

