/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.util.IOUtils;
import edu.berkeley.nlp.util.Option;
import edu.berkeley.nlp.util.StrUtils;
import edu.berkeley.nlp.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerProgram {
    @Option(gloss="Location of the lp_solve executable")
    public static String lpSolveLocation = "/opt/local/bin/lp_solve";
    @Option(gloss="Maximum time for the solver (disaster strikes if it doesn't finish.")
    public static double maxIntegerProgramTime = -1.0;
    @Option(gloss="Relaxes integer constraint on variables.")
    public static boolean relaxIntegerConstraint = false;
    @Option(gloss="Don't optimize; used for profiling.")
    public static boolean dontOptimize = false;
    @Option(gloss="Don't delete ilp files; used for testing.")
    public static boolean dontDeleteFiles = false;
    @Option(gloss="Branch and bound depth limit (0 = no limit).")
    public static int depthLimit = 0;
    private int numVars;
    private List<String> constraints = new ArrayList<String>();
    private List<String> integerVariables = new ArrayList<String>();
    private double[] objectiveCoefficients;
    private double[] lp_solve_solution;
    private double lp_solve_objective_value;
    private boolean maximize;
    private boolean optimized;

    public void setToMaximize() {
        this.maximize = true;
    }

    public double objectiveValue() {
        if (!this.optimized) {
            this.optimize();
        }
        return this.lp_solve_objective_value;
    }

    public double[] solution() {
        if (!this.optimized) {
            this.optimize();
        }
        return this.lp_solve_solution;
    }

    public void suggestSolution(double[] solution) {
    }

    public void cleanUp() {
    }

    public void addObjectiveWeights(List<Integer> indices, List<Double> weights) {
        for (int i = 0; i < indices.size(); ++i) {
            this.addObjectiveWeight(indices.get(i), weights.get(i));
        }
    }

    private void addObjectiveWeight(int pos, double val) {
        if (this.objectiveCoefficients == null) {
            this.objectiveCoefficients = new double[this.numVars];
        }
        if (this.objectiveCoefficients.length < this.numVars) {
            double[] oldCoef = this.objectiveCoefficients;
            this.objectiveCoefficients = new double[this.numVars];
            System.arraycopy(oldCoef, 0, this.objectiveCoefficients, 0, oldCoef.length);
        }
        this.objectiveCoefficients[pos] = val;
    }

    public void addObjectiveWeights(int[] indices, double[] weights) {
        for (int i = 0; i < indices.length; ++i) {
            this.addObjectiveWeight(indices[i], weights[i]);
        }
    }

    public void addEqualityConstraint(int var, double weight, double rhs) {
        int[] vars = new int[1];
        double[] weights = new double[1];
        vars[0] = var;
        weights[0] = weight;
        this.addEqualityConstraint(vars, weights, rhs);
    }

    public void addEqualityConstraint(int[] indices, double[] weights, double rhs) {
        this.addConstraint(indices, weights, rhs, "=");
    }

    public void addLessThanConstraint(int var, double weight, double rhs) {
        int[] vars = new int[1];
        double[] weights = new double[1];
        vars[0] = var;
        weights[0] = weight;
        this.addLessThanConstraint(vars, weights, rhs);
    }

    public void addLessThanConstraint(int[] indices, double[] weights, double rhs) {
        this.addConstraint(indices, weights, rhs, "<=");
    }

    public void addConstraint(int[] indices, double[] weights, double rhs, String op) {
        StringBuilder sb = new StringBuilder();
        assert (indices.length == weights.length);
        for (int i = 0; i < indices.length; ++i) {
            sb.append("+ ");
            sb.append(weights[i]);
            sb.append(" ");
            sb.append(IntegerProgram.var(indices[i]));
            sb.append(" ");
        }
        sb.append(op);
        sb.append(" ");
        sb.append(rhs);
        sb.append(";");
        this.constraints.add(sb.toString());
    }

    public void addBoundedVars(int k, double lower, double upper) {
        for (int i = this.numVars; i < k + this.numVars; ++i) {
            this.integerVariables.add(IntegerProgram.var(i));
            if (lower != 0.0) {
                this.addLessThanConstraint(i, -1.0, lower);
            }
            this.addLessThanConstraint(i, 1.0, upper);
        }
        this.numVars += k;
    }

    private static String var(int i) {
        return "x" + i;
    }

    public void optimize() {
        if (dontOptimize) {
            this.lp_solve_objective_value = 0.0;
            this.lp_solve_solution = new double[this.numVars];
            this.optimized = true;
        } else {
            try {
                File temp = File.createTempFile("ilp-", ".mps");
                if (dontDeleteFiles) {
                    System.err.println("[IntPgrm] " + temp.getPath());
                }
                this.writeProgram(temp);
                this.executeLPSolve(temp.getAbsolutePath());
                if (!dontDeleteFiles) {
                    temp.delete();
                }
                this.optimized = true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void writeProgram(File temp) {
        PrintWriter out = IOUtils.openOutHard(temp);
        this.writeObjective(out);
        for (String c : this.constraints) {
            out.println(c);
        }
        String intCons = "int " + StrUtils.join(this.integerVariables, ", ") + ";";
        if (!relaxIntegerConstraint) {
            out.println(intCons);
        }
        out.close();
    }

    private void writeObjective(PrintWriter out) {
        out.print(this.maximize ? "max: " : "min: ");
        assert (this.numVars == this.objectiveCoefficients.length);
        for (int i = 0; i < this.numVars; ++i) {
            out.print("+ ");
            out.print(this.objectiveCoefficients[i]);
            out.print(" ");
            out.print(IntegerProgram.var(i));
            out.print(" ");
        }
        out.print(";\n");
    }

    private void executeLPSolve(String problemPath) {
        StringBuilder command = new StringBuilder();
        command.append(lpSolveLocation + " ");
        if (maxIntegerProgramTime > 0.0) {
            command.append("-timeout " + maxIntegerProgramTime + " ");
        }
        command.append("-depth " + depthLimit + " ");
        command.append(problemPath);
        StringWriter output = new StringWriter();
        PrintWriter out = new PrintWriter(output);
        StringWriter error = new StringWriter();
        PrintWriter err = new PrintWriter(error);
        Utils.systemHard(command.toString(), out, err);
        BufferedReader reader = new BufferedReader(new StringReader(output.toString()));
        this.lp_solve_solution = new double[this.numVars];
        int var = 0;
        try {
            while (reader.ready()) {
                String[] parts;
                String next = reader.readLine();
                if (next == null) {
                    return;
                }
                if (next.startsWith("x")) {
                    double val;
                    parts = next.trim().split("\\s+");
                    if (parts[0].equals("x")) continue;
                    assert (parts[0].equals(IntegerProgram.var(var)));
                    this.lp_solve_solution[var] = val = Double.parseDouble(parts[1]);
                    ++var;
                    continue;
                }
                if (!next.startsWith("Value of objective function")) continue;
                parts = next.split("\\s+");
                this.lp_solve_objective_value = Double.parseDouble(parts[parts.length - 1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        dontDeleteFiles = true;
        IntegerProgram ip = new IntegerProgram();
        ip.addBoundedVars(3, 0.0, 1.0);
        ip.addObjectiveWeight(0, 10.0);
        ip.addObjectiveWeight(1, -5.0);
        ip.addObjectiveWeight(2, 1.0);
        int[] cvars = new int[]{0, 1, 2};
        double[] cweights = new double[]{1.0, 0.0, 1.0};
        ip.setToMaximize();
        ip.addEqualityConstraint(cvars, cweights, 1.0);
        double[] sol = ip.solution();
        for (int i = 0; i < sol.length; ++i) {
            System.out.println("x" + i + ":\t" + sol[i]);
        }
        System.out.println("obj:\t" + ip.objectiveValue());
    }

    public void addAndConstraint(int combined, int left, int right) {
        int[] vars1 = new int[]{combined, left};
        int[] vars2 = new int[]{combined, right};
        double[] weights = new double[]{1.0, -1.0};
        this.addLessThanConstraint(vars1, weights, 0.0);
        this.addLessThanConstraint(vars2, weights, 0.0);
    }
}

