/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.Regularizer;

public class L2Regularizer
implements Regularizer {
    double sigmaSquared = 1.0;

    public L2Regularizer(double sigmaSquared) {
        this.sigmaSquared = sigmaSquared;
    }

    public L2Regularizer() {
    }

    public double getSigmaSquared() {
        return this.sigmaSquared;
    }

    public void setSigmaSquared(double sigmaSquared) {
        this.sigmaSquared = sigmaSquared;
    }

    public double update(double[] weights, double[] grad, double c) {
        double l2 = 0.0;
        int w = 0;
        while (w < weights.length) {
            double weight = weights[w];
            l2 += c * weight * weight / this.sigmaSquared;
            int n = w++;
            grad[n] = grad[n] + c * 2.0 * weight / this.sigmaSquared;
        }
        return l2;
    }

    public double val(double[] weights, double c) {
        double l2 = 0.0;
        for (int w = 0; w < weights.length; ++w) {
            double weight = weights[w];
            l2 += weight * weight / this.sigmaSquared;
        }
        return l2;
    }
}

