/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.mapper.AsynchronousMapper;
import edu.berkeley.nlp.mapper.SimpleMapper;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.ObjectiveItemDifferentiableFunction;
import edu.berkeley.nlp.math.Regularizer;
import edu.berkeley.nlp.util.CallbackFunction;
import edu.berkeley.nlp.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldStochasticObjectiveOptimizer<I> {
    Collection<I> items;
    List<? extends ObjectiveItemDifferentiableFunction<I>> itemFns;
    Regularizer regularizer;
    double initAlpha = 0.5;
    double upAlphaMult = 1.1;
    double downAlphaMult = 0.5;
    Object weightLock = new Object();
    double[] weights;
    double alpha;
    CallbackFunction iterDoneCallback;

    public OldStochasticObjectiveOptimizer(double initAlpha, double upAlphaMult, double downAlphaMult) {
        this.initAlpha = initAlpha;
        this.upAlphaMult = upAlphaMult;
        this.downAlphaMult = downAlphaMult;
    }

    public void setIterationCallback(CallbackFunction iterDoneCallback) {
        this.iterDoneCallback = iterDoneCallback;
    }

    private double doIter() {
        ArrayList<Mapper> mappers = new ArrayList<Mapper>();
        for (ObjectiveItemDifferentiableFunction<I> itemFn : this.itemFns) {
            mappers.add(new Mapper(itemFn));
        }
        AsynchronousMapper.doMapping(this.items, mappers);
        double val = 0.0;
        for (Mapper mapper : mappers) {
            val += mapper.val;
        }
        return val;
    }

    public double[] minimize(double[] initWeights, int numIters, Collection<I> items, List<? extends ObjectiveItemDifferentiableFunction<I>> itemFns, Regularizer regularizer) {
        this.items = items;
        this.itemFns = itemFns;
        this.regularizer = regularizer;
        this.alpha = this.initAlpha;
        this.weights = DoubleArrays.clone(initWeights);
        double lastVal = Double.POSITIVE_INFINITY;
        for (int iter = 0; iter < numIters; ++iter) {
            double val = this.doIter();
            this.alpha *= val < lastVal ? this.upAlphaMult : this.downAlphaMult;
            lastVal = val;
            Logger.logs("[StochasticObjectiveOptimizer] Ended Iteration %d with value %.5f", iter + 1, val);
            if (this.iterDoneCallback == null) continue;
            this.iterDoneCallback.callback(iter, this.weights, val, this.alpha);
        }
        return this.weights;
    }

    public int dimension() {
        return this.itemFns.get(0).dimension();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Mapper
    implements SimpleMapper<I> {
        double val = 0.0;
        ObjectiveItemDifferentiableFunction<I> itemFn;

        Mapper(ObjectiveItemDifferentiableFunction<I> itemFn) {
            this.itemFn = itemFn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void map(I elem) {
            double[] localWeights;
            Object object = OldStochasticObjectiveOptimizer.this.weightLock;
            synchronized (object) {
                localWeights = DoubleArrays.clone(OldStochasticObjectiveOptimizer.this.weights);
            }
            double[] localGrad = new double[OldStochasticObjectiveOptimizer.this.dimension()];
            this.itemFn.setWeights(localWeights);
            this.val += this.itemFn.update(elem, localGrad);
            this.val += OldStochasticObjectiveOptimizer.this.regularizer.update(localWeights, localGrad, 1.0 / (double)OldStochasticObjectiveOptimizer.this.items.size());
            Object object2 = OldStochasticObjectiveOptimizer.this.weightLock;
            synchronized (object2) {
                DoubleArrays.addInPlace(OldStochasticObjectiveOptimizer.this.weights, localGrad, -OldStochasticObjectiveOptimizer.this.alpha);
            }
        }
    }
}

