/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.BacktrackingLineSearcher;
import edu.berkeley.nlp.math.DifferentiableFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.GradientMinimizer;
import edu.berkeley.nlp.util.Logger;

public class SubgradientMinimizer
implements GradientMinimizer {
    private static final double initialStepSize = 1.0;
    int minIterations = -1;
    double initialStepSizeMultiplier = 0.01;
    double stepSizeMultiplier = 0.5;
    double EPS = 1.0E-10;
    int maxIterations = 2000;
    double stepSizeGrowthAmount = 0.0;

    public double[] minimize(DifferentiableFunction function, double[] initial, double tolerance, boolean project) {
        return null;
    }

    public double[] minimize(DifferentiableFunction function, double[] initial, double tolerance) {
        boolean printProgress = true;
        BacktrackingLineSearcher lineSearcher = new BacktrackingLineSearcher();
        double[] guess = DoubleArrays.clone(initial);
        double stepSize = 1.0;
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            stepSize = this.stepSizeGrowthAmount == 0.0 ? 1.0 : (stepSize *= this.stepSizeGrowthAmount);
            double[] subgradient = function.derivativeAt(guess);
            double value = function.valueAt(guess);
            double[] direction = subgradient;
            DoubleArrays.scale(direction, -1.0);
            lineSearcher.stepSizeMultiplier = iteration == 0 ? this.initialStepSizeMultiplier : this.stepSizeMultiplier;
            lineSearcher.initialStepSize = stepSize;
            double[] nextGuess = this.doLineSearch(function, lineSearcher, guess, direction);
            stepSize = lineSearcher.getFinalStepSize();
            double[] nextDerivative = function.derivativeAt(nextGuess);
            double nextValue = function.valueAt(nextGuess);
            if (printProgress) {
                Logger.i().logs("[Subgradient] Iteration %d: %.6f", iteration, nextValue);
            }
            if (iteration >= this.minIterations && this.converged(value, nextValue, tolerance)) {
                return nextGuess;
            }
            guess = nextGuess;
            value = nextValue;
            subgradient = nextDerivative;
        }
        return guess;
    }

    protected double[] doLineSearch(DifferentiableFunction function, BacktrackingLineSearcher lineSearcher, double[] guess, double[] direction) {
        return lineSearcher.minimize(function, guess, direction);
    }

    private boolean converged(double value, double nextValue, double tolerance) {
        double valueAverage;
        if (value == nextValue) {
            return true;
        }
        double valueChange = Math.abs(nextValue - value);
        return valueChange / (valueAverage = Math.abs(nextValue + value + this.EPS) / 2.0) < tolerance;
    }

    public void setMaxIterations(int maxIterations2) {
        this.maxIterations = maxIterations2;
    }

    public void setMinIteratons(int minIterations2) {
        this.minIterations = minIterations2;
    }

    public void setStepSizeGrowthAmount(double amount) {
        this.stepSizeGrowthAmount = amount;
    }
}

