/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.parser;

import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishPennTreebankParseEvaluator<L> {
    public static void main(String[] args) throws Throwable {
        Object goldTree = new Trees.PennTreeReader(new StringReader("(ROOT (S (NP (DT the) (NN can)) (VP (VBD fell))))")).next();
        Object guessedTree = new Trees.PennTreeReader(new StringReader("(ROOT (S (NP (DT the)) (VP (MB can) (VP (VBD fell)))))")).next();
        LabeledConstituentEval<String> eval = new LabeledConstituentEval<String>(Collections.singleton("ROOT"), new HashSet());
        RuleEval<String> rule_eval = new RuleEval<String>(Collections.singleton("ROOT"), new HashSet());
        System.out.println("Gold tree:\n" + Trees.PennTreeRenderer.render(goldTree));
        System.out.println("Guessed tree:\n" + Trees.PennTreeRenderer.render(guessedTree));
        eval.evaluate((Tree)guessedTree, (Tree)goldTree);
        eval.display(true);
        rule_eval.evaluate((Tree)guessedTree, (Tree)goldTree);
        rule_eval.display(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RuleConstituent<L> {
        L label;
        L lChild;
        L rChild;
        int start;
        int end;

        public L getLabel() {
            return this.label;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RuleConstituent)) {
                return false;
            }
            RuleConstituent labeledConstituent = (RuleConstituent)o;
            if (this.end != labeledConstituent.end) {
                return false;
            }
            if (this.start != labeledConstituent.start) {
                return false;
            }
            if (this.label != null ? !this.label.equals(labeledConstituent.label) : labeledConstituent.label != null) {
                return false;
            }
            if (this.lChild != null ? !this.lChild.equals(labeledConstituent.lChild) : labeledConstituent.lChild != null) {
                return false;
            }
            return !(this.rChild != null ? !this.rChild.equals(labeledConstituent.rChild) : labeledConstituent.rChild != null);
        }

        public int hashCode() {
            int result = (this.label != null ? this.label.hashCode() : 0) + 17 * (this.lChild != null ? this.lChild.hashCode() : 0) - 7 * (this.rChild != null ? this.rChild.hashCode() : 0);
            result = 29 * result + this.start;
            result = 29 * result + this.end;
            return result;
        }

        public String toString() {
            String rChildStr = this.rChild == null ? "" : this.rChild.toString();
            return this.label + "->" + this.lChild + " " + rChildStr + "[" + this.start + "," + this.end + "]";
        }

        public RuleConstituent(L label, L lChild, L rChild, int start, int end) {
            this.label = label;
            this.lChild = lChild;
            this.rChild = rChild;
            this.start = start;
            this.end = end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleEval<L>
    extends AbstractEval<L> {
        Set<L> labelsToIgnore;
        Set<L> punctuationTags;

        static <L> Tree<L> stripLeaves(Tree<L> tree) {
            if (tree.isLeaf()) {
                return null;
            }
            if (tree.isPreTerminal()) {
                return new Tree<L>(tree.getLabel());
            }
            ArrayList children = new ArrayList();
            for (Tree<L> child : tree.getChildren()) {
                children.add(RuleEval.stripLeaves(child));
            }
            return new Tree<L>(tree.getLabel(), children);
        }

        @Override
        Set<Object> makeObjects(Tree<L> tree) {
            Tree<L> noLeafTree = RuleEval.stripLeaves(tree);
            HashSet<Object> set = new HashSet<Object>();
            this.addConstituents(noLeafTree, set, 0);
            return set;
        }

        private int addConstituents(Tree<L> tree, Set<Object> set, int start) {
            if (tree == null) {
                return 0;
            }
            if (tree.isLeaf()) {
                return 1;
            }
            int end = start;
            int i = 0;
            Object lC = null;
            Object rC = null;
            for (Tree<L> child : tree.getChildren()) {
                int childSpan = this.addConstituents(child, set, end);
                if (i == 0) {
                    lC = child.getLabel();
                } else {
                    rC = child.getLabel();
                }
                ++i;
                end += childSpan;
            }
            L label = tree.getLabel();
            if (!this.labelsToIgnore.contains(label)) {
                set.add(new RuleConstituent<Object>(label, lC, rC, start, end));
            }
            return end - start;
        }

        public RuleEval(Set<L> labelsToIgnore, Set<L> punctuationTags) {
            this.labelsToIgnore = labelsToIgnore;
            this.punctuationTags = punctuationTags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LabeledConstituentEval<L>
    extends AbstractEval<L> {
        Set<L> labelsToIgnore;
        Set<L> punctuationTags;

        static <L> Tree<L> stripLeaves(Tree<L> tree) {
            if (tree.isLeaf()) {
                return null;
            }
            if (tree.isPreTerminal()) {
                return new Tree<L>(tree.getLabel());
            }
            ArrayList children = new ArrayList();
            for (Tree<L> child : tree.getChildren()) {
                children.add(LabeledConstituentEval.stripLeaves(child));
            }
            return new Tree<L>(tree.getLabel(), children);
        }

        @Override
        Set<Object> makeObjects(Tree<L> tree) {
            Tree<L> noLeafTree = LabeledConstituentEval.stripLeaves(tree);
            HashSet<Object> set = new HashSet<Object>();
            this.addConstituents(noLeafTree, set, 0);
            return set;
        }

        private int addConstituents(Tree<L> tree, Set<Object> set, int start) {
            if (tree == null) {
                return 0;
            }
            if (tree.isLeaf()) {
                if (this.punctuationTags.contains(tree.getLabel())) {
                    return 0;
                }
                return 1;
            }
            int end = start;
            for (Tree<L> child : tree.getChildren()) {
                int childSpan = this.addConstituents(child, set, end);
                end += childSpan;
            }
            L label = tree.getLabel();
            if (!this.labelsToIgnore.contains(label)) {
                set.add(new LabeledConstituent<L>(label, start, end));
            }
            return end - start;
        }

        public LabeledConstituentEval(Set<L> labelsToIgnore, Set<L> punctuationTags) {
            this.labelsToIgnore = labelsToIgnore;
            this.punctuationTags = punctuationTags;
        }

        public int getHammingDistance(Tree<L> guess, Tree<L> gold) {
            Set<Object> guessedSet = this.makeObjects(guess);
            Set<Object> goldSet = this.makeObjects(gold);
            HashSet<Object> correctSet = new HashSet<Object>();
            correctSet.addAll(goldSet);
            correctSet.retainAll(guessedSet);
            return guessedSet.size() - correctSet.size() + (goldSet.size() - correctSet.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnlabeledConstituentEval<L>
    extends AbstractEval<L> {
        @Override
        Set<Object> makeObjects(Tree<L> tree) {
            Tree<L> noLeafTree = LabeledConstituentEval.stripLeaves(tree);
            HashSet<Object> set = new HashSet<Object>();
            this.addConstituents(noLeafTree, set, 0);
            return set;
        }

        private int addConstituents(Tree<L> tree, Set<Object> set, int start) {
            if (tree == null) {
                return 0;
            }
            if (tree.getYield().size() == 1) {
                return 1;
            }
            int end = start;
            for (Tree<L> child : tree.getChildren()) {
                int childSpan = this.addConstituents(child, set, end);
                end += childSpan;
            }
            set.add(new UnlabeledConstituent(start, end));
            return end - start;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LabeledConstituent<L> {
        L label;
        int start;
        int end;

        public L getLabel() {
            return this.label;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LabeledConstituent)) {
                return false;
            }
            LabeledConstituent labeledConstituent = (LabeledConstituent)o;
            if (this.end != labeledConstituent.end) {
                return false;
            }
            if (this.start != labeledConstituent.start) {
                return false;
            }
            return !(this.label != null ? !this.label.equals(labeledConstituent.label) : labeledConstituent.label != null);
        }

        public int hashCode() {
            int result = this.label != null ? this.label.hashCode() : 0;
            result = 29 * result + this.start;
            result = 29 * result + this.end;
            return result;
        }

        public String toString() {
            return this.label + "[" + this.start + "," + this.end + "]";
        }

        public LabeledConstituent(L label, int start, int end) {
            this.label = label;
            this.start = start;
            this.end = end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractEval<L> {
        protected String str = "";
        private int exact = 0;
        private int total = 0;
        private int correctEvents = 0;
        private int guessedEvents = 0;
        private int goldEvents = 0;

        AbstractEval() {
        }

        abstract Set<Object> makeObjects(Tree<L> var1);

        public double evaluate(Tree<L> guess, Tree<L> gold) {
            return this.evaluate(guess, gold, new PrintWriter(System.out, true));
        }

        public double evaluate(Tree<L> guess, Tree<L> gold, boolean b) {
            return this.evaluate(guess, gold, null);
        }

        public double evaluate(Tree<L> guess, Tree<L> gold, PrintWriter pw) {
            Set<Object> guessedSet = this.makeObjects(guess);
            Set<Object> goldSet = this.makeObjects(gold);
            HashSet<Object> correctSet = new HashSet<Object>();
            correctSet.addAll(goldSet);
            correctSet.retainAll(guessedSet);
            this.correctEvents += correctSet.size();
            this.guessedEvents += guessedSet.size();
            this.goldEvents += goldSet.size();
            int currentExact = 0;
            if (correctSet.size() == guessedSet.size() && correctSet.size() == goldSet.size()) {
                ++this.exact;
                currentExact = 1;
            }
            ++this.total;
            double f1 = this.displayPRF(this.str + " [Current] ", correctSet.size(), guessedSet.size(), goldSet.size(), currentExact, 1, pw);
            return f1;
        }

        public double evaluateMultiple(List<Tree<L>> guesses, List<Tree<L>> golds, PrintWriter pw) {
            assert (guesses.size() == golds.size());
            int correctCount = 0;
            int guessedCount = 0;
            int goldCount = 0;
            for (int i = 0; i < guesses.size(); ++i) {
                Tree<L> guess = guesses.get(i);
                Tree<L> gold = golds.get(i);
                Set<Object> guessedSet = this.makeObjects(guess);
                Set<Object> goldSet = this.makeObjects(gold);
                HashSet<Object> correctSet = new HashSet<Object>();
                correctSet.addAll(goldSet);
                correctSet.retainAll(guessedSet);
                correctCount += correctSet.size();
                guessedCount += guessedSet.size();
                goldCount += goldSet.size();
            }
            this.correctEvents += correctCount;
            this.guessedEvents += guessedCount;
            this.goldEvents += goldCount;
            int currentExact = 0;
            if (correctCount == guessedCount && correctCount == goldCount) {
                ++this.exact;
                currentExact = 1;
            }
            ++this.total;
            double f1 = this.displayPRF(this.str + " [Current] ", correctCount, guessedCount, goldCount, currentExact, 1, pw);
            return f1;
        }

        public double[] massEvaluate(Tree<L> guess, Tree<L>[] goldTrees) {
            Set<Object> guessedSet = this.makeObjects(guess);
            double cEvents = 0.0;
            double guEvents = 0.0;
            double goEvents = 0.0;
            double exactM = 0.0;
            double precision = 0.0;
            double recall = 0.0;
            double f1 = 0.0;
            for (int treeI = 0; treeI < goldTrees.length; ++treeI) {
                Tree<L> gold = goldTrees[treeI];
                Set<Object> goldSet = this.makeObjects(gold);
                HashSet<Object> correctSet = new HashSet<Object>();
                correctSet.addAll(goldSet);
                correctSet.retainAll(guessedSet);
                cEvents = correctSet.size();
                guEvents = guessedSet.size();
                goEvents = goldSet.size();
                double p = cEvents / guEvents;
                double r = cEvents / goEvents;
                double f = p > 0.0 && r > 0.0 ? 2.0 / (1.0 / p + 1.0 / r) : 0.0;
                precision += p;
                recall += r;
                f1 += f;
                if (cEvents != guEvents || cEvents != goEvents) continue;
                exactM += 1.0;
            }
            double ex = exactM / (double)goldTrees.length;
            double[] results = new double[]{precision, recall, f1, ex};
            return results;
        }

        private double displayPRF(String prefixStr, int correct, int guessed, int gold, int exact, int total, PrintWriter pw) {
            double precision = guessed > 0 ? (double)correct / (double)guessed : 1.0;
            double recall = gold > 0 ? (double)correct / (double)gold : 1.0;
            double f1 = precision > 0.0 && recall > 0.0 ? 2.0 / (1.0 / precision + 1.0 / recall) : 0.0;
            double exactMatch = (double)exact / (double)total;
            String displayStr = " P: " + (double)((int)(precision * 10000.0)) / 100.0 + " R: " + (double)((int)(recall * 10000.0)) / 100.0 + " F1: " + (double)((int)(f1 * 10000.0)) / 100.0 + " EX: " + (double)((int)(exactMatch * 10000.0)) / 100.0;
            if (pw != null) {
                pw.println(prefixStr + displayStr);
            }
            return f1;
        }

        public double display(boolean verbose) {
            return this.display(verbose, new PrintWriter(System.out, true));
        }

        public double display(boolean verbose, PrintWriter pw) {
            return this.displayPRF(this.str + " [Average] ", this.correctEvents, this.guessedEvents, this.goldEvents, this.exact, this.total, pw);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnlabeledConstituent<L> {
        int start;
        int end;

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnlabeledConstituent)) {
                return false;
            }
            UnlabeledConstituent unlabeledConstituent = (UnlabeledConstituent)o;
            if (this.end != unlabeledConstituent.end) {
                return false;
            }
            return this.start == unlabeledConstituent.start;
        }

        public int hashCode() {
            int result = this.start;
            result = 29 * result + this.end;
            return result;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "]";
        }

        public UnlabeledConstituent(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

