/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constituent<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    L label;
    int start;
    int end;

    public L getLabel() {
        return this.label;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public String toString() {
        return "<" + this.label + " : " + this.start + ", " + this.end + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Constituent)) {
            return false;
        }
        Constituent constituent = (Constituent)o;
        if (this.end != constituent.end) {
            return false;
        }
        if (this.start != constituent.start) {
            return false;
        }
        return !(this.label != null ? !this.label.equals(constituent.label) : constituent.label != null);
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 29 * result + this.start;
        result = 29 * result + this.end;
        return result;
    }

    public Constituent(L label, int start, int end) {
        this.label = label;
        this.start = start;
        this.end = end;
    }
}

