/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.ScalingTools;

public class StateSet {
    public static final double SCALE = Math.exp(100.0);
    double[] iScores;
    double[] oScores;
    int iScale;
    int oScale;
    String word;
    public int wordIndex;
    public int sigIndex;
    short numSubStates;
    short state;
    public short from;
    public short to;

    public void allocate() {
        this.iScores = new double[this.numSubStates];
        this.oScores = new double[this.numSubStates];
    }

    public void deallocate() {
        this.iScores = null;
        this.oScores = null;
    }

    public String toString() {
        if (this.word != null) {
            return this.word + " " + this.from + "-" + this.to;
        }
        String s = Numberer.getGlobalNumberer("tags").object(this.state) + " ";
        return s;
    }

    public final short getState() {
        return this.state;
    }

    public final double getIScore(int i) {
        return this.iScores[i];
    }

    public final double[] getIScores() {
        return this.iScores;
    }

    public final double getOScore(int i) {
        return this.oScores[i];
    }

    public final double[] getOScores() {
        return this.oScores;
    }

    public final void setIScores(double[] s) {
        this.iScores = s;
    }

    public final void setIScore(int i, double s) {
        if (this.iScores == null) {
            this.iScores = new double[this.numSubStates];
        }
        this.iScores[i] = s;
    }

    public final void setOScores(double[] s) {
        this.oScores = s;
    }

    public final void setOScore(int i, double s) {
        if (this.oScores == null) {
            this.oScores = new double[this.numSubStates];
        }
        this.oScores[i] = s;
    }

    public final int numSubStates() {
        return this.numSubStates;
    }

    public StateSet(short state, short nSubStates) {
        this.numSubStates = nSubStates;
        this.state = state;
    }

    public StateSet(short s, short nSubStates, String word, short from, short to) {
        this.numSubStates = nSubStates;
        this.state = s;
        this.word = word;
        this.from = from;
        this.to = to;
    }

    public StateSet(StateSet oldS, short nSubStates) {
        this.numSubStates = nSubStates;
        this.state = oldS.state;
        this.word = oldS.word;
        this.from = oldS.from;
        this.to = oldS.to;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public void scaleIScores(int previousScale) {
        this.iScale = ScalingTools.scaleArray(this.iScores, previousScale);
    }

    public void scaleOScores(int previousScale) {
        this.oScale = ScalingTools.scaleArray(this.oScores, previousScale);
    }

    public int getIScale() {
        return this.iScale;
    }

    public void setIScale(int scale) {
        this.iScale = scale;
    }

    public int getOScale() {
        return this.oScale;
    }

    public void setOScale(int scale) {
        this.oScale = scale;
    }

    public StateSet copy() {
        return new StateSet(this, this.numSubStates);
    }
}

