/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.tokenizer;

import edu.berkeley.nlp.tokenizer.LineTokenizer;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChineseRetokenizer
implements LineTokenizer {
    @Override
    public List<String> tokenizeLine(String line) {
        String replaced = this.replaceChars(line);
        String[] tokens = replaced.split(" ");
        boolean rightDoubleQuote = false;
        boolean rightSingleQuote = false;
        LinkedList<String> newTokens = new LinkedList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            String tok = tokens[i];
            if (tok.equals("\"")) {
                newTokens.add(rightDoubleQuote ? "\u201d" : "\u201c");
                rightDoubleQuote = !rightDoubleQuote;
                continue;
            }
            if (tok.equals("'")) {
                newTokens.add(rightSingleQuote ? "\u2019" : "\u2018");
                rightSingleQuote = !rightSingleQuote;
                continue;
            }
            if (tok.equals(".")) {
                if (i == tokens.length - 1) {
                    newTokens.add("\u3002");
                    continue;
                }
                newTokens.add("\uff0c");
                continue;
            }
            newTokens.add(tok);
        }
        return newTokens;
    }

    private String replaceChars(String line) {
        String s = line;
        return s;
    }
}

