/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.treebank;

import edu.berkeley.nlp.treebank.AbstractTreebankLanguagePack;
import java.io.Serializable;

public class PennTreebankLanguagePack
extends AbstractTreebankLanguagePack
implements Serializable {
    private static String[] pennPunctTags = new String[]{"''", "``", "-LRB-", "-RRB-", ".", ":", ","};
    private static String[] pennSFPunctTags = new String[]{"."};
    private static String[] collinsPunctTags = new String[]{"''", "``", ".", ":", ","};
    private static String[] pennPunctWords = new String[]{"''", "'", "``", "`", "-LRB-", "-RRB-", "-LCB-", "-RCB-", ".", "?", "!", ",", ":", "-", "--", "...", ";"};
    private static String[] pennSFPunctWords = new String[]{".", "!", "?"};
    private static char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~', '_'};
    private static String[] pennStartSymbols = new String[]{"ROOT", "TOP"};
    private static final long serialVersionUID = 9081305982861675328L;

    public String[] punctuationTags() {
        return pennPunctTags;
    }

    public String[] punctuationWords() {
        return pennPunctWords;
    }

    public String[] sentenceFinalPunctuationTags() {
        return pennSFPunctTags;
    }

    public String[] sentenceFinalPunctuationWords() {
        return pennSFPunctWords;
    }

    public String[] evalBIgnoredPunctuationTags() {
        return collinsPunctTags;
    }

    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    public String[] startSymbols() {
        return pennStartSymbols;
    }

    public String treebankFileExtension() {
        return "mrg";
    }

    public static void main(String[] args) {
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        System.out.println("Start symbol: " + tlp.startSymbol());
        String start = tlp.startSymbol();
        System.out.println("Should be true: " + tlp.isStartSymbol(start));
        String[] strs = new String[]{"-", "-LLB-", "NP-2", "NP=3", "NP-LGS", "NP-TMP=3"};
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            System.out.println("String: " + str + " basic: " + tlp.basicCategory(str) + " basicAndFunc: " + tlp.categoryAndFunction(str));
        }
    }
}

