/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.treebank;

import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.treebank.PennTreebankReader;
import edu.berkeley.nlp.util.Logger;
import edu.berkeley.nlp.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreebankFetcher {
    private final List<Trees.TreeTransformer<String>> transformers = new ArrayList<Trees.TreeTransformer<String>>();
    private int maxLength = Integer.MAX_VALUE;
    private int minLength = 0;
    private int maxTrees = Integer.MAX_VALUE;
    private final boolean verbose;

    public TreebankFetcher(boolean verbose) {
        this.verbose = verbose;
    }

    public TreebankFetcher() {
        this(false);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxTrees(int maxTrees) {
        this.maxTrees = maxTrees;
    }

    public void addTransformer(Trees.TreeTransformer<String> transformer) {
        this.transformers.add(transformer);
    }

    public Iterable<Tree<String>> getTrees(String path) {
        return this.getTrees(path, -1, Integer.MAX_VALUE);
    }

    public Iterable<Tree<String>> getTrees(String path, String ext) {
        return this.getTrees(path, ext, -1, Integer.MAX_VALUE);
    }

    public Iterable<Tree<String>> getTrees(String path, int start, int stop) {
        return this.getTrees(path, "mrg", start, stop);
    }

    public Iterable<Tree<String>> getTrees(String path, String ext, int start, int stop) {
        StopWatch stopwatch = new StopWatch();
        if (this.verbose) {
            Logger.i().logs("Loading Trees from %s [%d,%d]...", path, start, stop);
            System.err.flush();
            stopwatch.start();
        }
        final Collection<Tree<String>> rawTrees = PennTreebankReader.readTrees(path, start * 100, stop * 100);
        if (this.verbose) {
            stopwatch.accumStop();
            Logger.i().logs("Done loaded %d trees in %.3f seconds\n", rawTrees.size(), stopwatch.ms);
            Logger.i().logs("Applying transformers %s...\n", this.transformers.toString());
            stopwatch.reset();
            stopwatch.start();
        }
        return new Iterable<Tree<String>>(){

            @Override
            public Iterator<Tree<String>> iterator() {
                final Iterator rawIt = rawTrees.iterator();
                return new Iterator<Tree<String>>(){
                    Tree<String> nextTree = null;
                    int count = 0;

                    @Override
                    public boolean hasNext() {
                        if (this.count >= TreebankFetcher.this.maxTrees) {
                            return false;
                        }
                        this.queueNext();
                        return this.nextTree != null;
                    }

                    @Override
                    public Tree<String> next() {
                        this.queueNext();
                        Tree<String> retTree = this.nextTree;
                        this.nextTree = null;
                        ++this.count;
                        return retTree;
                    }

                    private void queueNext() {
                        if (this.nextTree != null) {
                            return;
                        }
                        if (!rawIt.hasNext()) {
                            return;
                        }
                        Tree tree = (Tree)rawIt.next();
                        for (Trees.TreeTransformer transformer : TreebankFetcher.this.transformers) {
                            tree = transformer.transformTree(tree);
                        }
                        if (tree.getYield().size() > TreebankFetcher.this.maxLength) {
                            this.queueNext();
                            return;
                        }
                        if (tree.getYield().size() < TreebankFetcher.this.minLength) {
                            this.queueNext();
                            return;
                        }
                        this.nextTree = tree;
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException();
                    }
                };
            }
        };
    }
}

