/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ui;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyFormat {
    private static DecimalFormat stdFormat = null;

    public static DecimalFormat getStdFormat() {
        if (stdFormat == null) {
            DecimalFormatSymbols dsymb = new DecimalFormatSymbols();
            dsymb.setDecimalSeparator('.');
            stdFormat = new DecimalFormat("0.0000");
            stdFormat.setDecimalFormatSymbols(dsymb);
        }
        return stdFormat;
    }

    public static String std(double number) {
        return EasyFormat.getStdFormat().format(number);
    }

    public static String fmt(double number) {
        return EasyFormat.std(number);
    }

    public static String fmt(List<Double> numbers) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < numbers.size(); ++i) {
            result.append(EasyFormat.fmt(numbers.get(i)));
            if (i == numbers.size() - 1) continue;
            result.append(" ");
        }
        result.append("]");
        return result.toString();
    }
}

