/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedList<E>
extends AbstractList<E> {
    private E leftBoundary;
    private E rightBoundary;
    private List<E> list;

    @Override
    public E get(int index) {
        if (index < 0) {
            return this.leftBoundary;
        }
        if (index >= this.list.size()) {
            return this.rightBoundary;
        }
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public BoundedList(List<E> list, E leftBoundary, E rightBoundary) {
        this.list = list;
        this.leftBoundary = leftBoundary;
        this.rightBoundary = rightBoundary;
    }

    public BoundedList(List<E> list, E boundary) {
        this(list, boundary, boundary);
    }

    public BoundedList(List<E> list) {
        this(list, null);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ArrayList<E> retVal = new ArrayList<E>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            retVal.add(this.get(i));
        }
        return retVal;
    }
}

