/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedIterator<T>
implements Iterator<T> {
    private Iterator<T> it;
    private Queue<T> buffer;
    private int numToBuffer;

    public BufferedIterator(Iterator<T> it, int numToBuffer) {
        this.it = it;
        this.buffer = new LinkedList<T>();
        this.numToBuffer = numToBuffer;
        this.refill();
    }

    public BufferedIterator(Iterator<T> it) {
        this(it, 100);
    }

    @Override
    public boolean hasNext() {
        if (!this.buffer.isEmpty()) {
            return false;
        }
        return this.it.hasNext();
    }

    @Override
    public T next() {
        if (this.buffer.isEmpty()) {
            this.refill();
        }
        if (this.buffer.isEmpty()) {
            throw new RuntimeException();
        }
        return this.buffer.remove();
    }

    private void refill() {
        for (int i = 0; i < this.numToBuffer; ++i) {
            if (!this.it.hasNext()) continue;
            this.buffer.add(this.it.next());
        }
    }

    @Override
    public void remove() {
    }
}

