/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Iterators;
import edu.berkeley.nlp.util.MapFactory;
import edu.berkeley.nlp.util.PriorityQueue;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counter<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<E, Double> entries;
    boolean dirty = true;
    double cacheTotal = 0.0;
    MapFactory<E, Double> mf;
    double deflt = 0.0;

    public double getDeflt() {
        return this.deflt;
    }

    public void setDeflt(double deflt) {
        this.deflt = deflt;
    }

    public Set<E> keySet() {
        return this.entries.keySet();
    }

    public Set<Map.Entry<E, Double>> entrySet() {
        return this.entries.entrySet();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(E key) {
        return this.entries.containsKey(key);
    }

    public double getCount(E key) {
        Double value = this.entries.get(key);
        if (value == null) {
            return this.deflt;
        }
        return value;
    }

    public double getProbability(E key) {
        double count = this.getCount(key);
        double total = this.totalCount();
        if (total < 0.0) {
            throw new RuntimeException("Can't call getProbability() with totalCount < 0.0");
        }
        return total > 0.0 ? count / total : 0.0;
    }

    public void normalize() {
        double totalCount = this.totalCount();
        for (E key : this.keySet()) {
            this.setCount(key, this.getCount(key) / totalCount);
        }
        this.dirty = true;
    }

    public void setCount(E key, double count) {
        this.entries.put(key, count);
        this.dirty = true;
    }

    public void put(E key, double count, boolean keepHigher) {
        if (keepHigher && this.entries.containsKey(key)) {
            double oldCount = this.entries.get(key);
            if (count > oldCount) {
                this.entries.put(key, count);
            }
        } else {
            this.entries.put(key, count);
        }
        this.dirty = true;
    }

    public E sample(Random rand) {
        double total = this.totalCount();
        if (total <= 0.0) {
            throw new RuntimeException(String.format("Attempting to sample() with totalCount() %.3f\n", total));
        }
        double sum = 0.0;
        double r = rand.nextDouble();
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            double count = entry.getValue();
            double frac = count / total;
            if (!(r < (sum += frac))) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Shoudl've have returned a sample by now....");
    }

    public E sample() {
        return this.sample(new Random());
    }

    public void removeKey(E key) {
        this.setCount(key, 0.0);
        this.dirty = true;
        this.removeKeyFromEntries(key);
    }

    protected void removeKeyFromEntries(E key) {
        this.entries.remove(key);
    }

    public void setMaxCount(E key, double val) {
        Double value = this.entries.get(key);
        if (value == null || val > value) {
            this.setCount(key, val);
            this.dirty = true;
        }
    }

    public void setMinCount(E key, double val) {
        Double value = this.entries.get(key);
        if (value == null || val < value) {
            this.setCount(key, val);
            this.dirty = true;
        }
    }

    public double incrementCount(E key, double increment) {
        double newVal = this.getCount(key) + increment;
        this.setCount(key, newVal);
        this.dirty = true;
        return newVal;
    }

    public void incrementAll(Collection<? extends E> collection, double count) {
        for (E key : collection) {
            this.incrementCount(key, count);
        }
        this.dirty = true;
    }

    public <T extends E> void incrementAll(Counter<T> counter) {
        for (T key : counter.keySet()) {
            double count = counter.getCount(key);
            this.incrementCount(key, count);
        }
        this.dirty = true;
    }

    public double totalCount() {
        if (!this.dirty) {
            return this.cacheTotal;
        }
        double total = 0.0;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            total += entry.getValue().doubleValue();
        }
        this.cacheTotal = total;
        this.dirty = false;
        return total;
    }

    public List<E> getSortedKeys() {
        PriorityQueue<E> pq = this.asPriorityQueue();
        ArrayList<E> keys = new ArrayList<E>();
        while (pq.hasNext()) {
            keys.add(pq.next());
        }
        return keys;
    }

    public E argMax() {
        double maxCount = Double.NEGATIVE_INFINITY;
        E maxKey = null;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            if (!(entry.getValue() > maxCount) && maxKey != null) continue;
            maxKey = entry.getKey();
            maxCount = entry.getValue();
        }
        return maxKey;
    }

    public double min() {
        return this.maxMinHelp(false);
    }

    public double max() {
        return this.maxMinHelp(true);
    }

    private double maxMinHelp(boolean max) {
        double maxCount = max ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            if (!(max && entry.getValue() > maxCount) && (max || !(entry.getValue() < maxCount))) continue;
            maxCount = entry.getValue();
        }
        return maxCount;
    }

    public String toString() {
        return this.toString(this.keySet().size());
    }

    public String toStringSortedByKeys() {
        StringBuilder sb = new StringBuilder("[");
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(5);
        int numKeysPrinted = 0;
        for (E element : new TreeSet<E>(this.keySet())) {
            sb.append(element.toString());
            sb.append(" : ");
            sb.append(f.format(this.getCount(element)));
            if (numKeysPrinted < this.size() - 1) {
                sb.append(", ");
            }
            ++numKeysPrinted;
        }
        if (numKeysPrinted < this.size()) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString(int maxKeysToPrint) {
        return this.asPriorityQueue().toString(maxKeysToPrint, false);
    }

    public String toString(int maxKeysToPrint, boolean multiline) {
        return this.asPriorityQueue().toString(maxKeysToPrint, multiline);
    }

    public PriorityQueue<E> asPriorityQueue() {
        PriorityQueue<E> pq = new PriorityQueue<E>(this.entries.size());
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            pq.add(entry.getKey(), entry.getValue());
        }
        return pq;
    }

    public PriorityQueue<E> asMinPriorityQueue() {
        PriorityQueue<E> pq = new PriorityQueue<E>(this.entries.size());
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            pq.add(entry.getKey(), -entry.getValue().doubleValue());
        }
        return pq;
    }

    public Counter() {
        this(false);
    }

    public Counter(boolean identityHashMap) {
        this(identityHashMap ? new MapFactory.IdentityHashMapFactory() : new MapFactory.HashMapFactory());
    }

    public Counter(MapFactory<E, Double> mf) {
        this.mf = mf;
        this.entries = mf.buildMap();
    }

    public Counter(Map<? extends E, Double> mapCounts) {
        this(false);
        this.entries = new HashMap<E, Double>();
        for (Map.Entry<E, Double> entry : mapCounts.entrySet()) {
            this.incrementCount(entry.getKey(), entry.getValue());
        }
    }

    public Counter(Counter<? extends E> counter) {
        this();
        this.incrementAll(counter);
    }

    public Counter(Collection<? extends E> collection) {
        this();
        this.incrementAll(collection, 1.0);
    }

    public void pruneKeysBelowThreshold(double cutoff) {
        Iterator<E> it = this.entries.keySet().iterator();
        while (it.hasNext()) {
            E key = it.next();
            double val = this.entries.get(key);
            if (!(val < cutoff)) continue;
            it.remove();
        }
        this.dirty = true;
    }

    public Set<Map.Entry<E, Double>> getEntrySet() {
        return this.entries.entrySet();
    }

    public boolean isEqualTo(Counter<E> counter) {
        boolean tmp = true;
        Counter bigger = counter.size() > this.size() ? counter : this;
        for (E e : bigger.keySet()) {
            tmp &= counter.getCount(e) == this.getCount(e);
        }
        return tmp;
    }

    public static void main(String[] args) {
        Counter<String> counter = new Counter<String>();
        System.out.println(counter);
        counter.incrementCount("planets", 7.0);
        System.out.println(counter);
        counter.incrementCount("planets", 1.0);
        System.out.println(counter);
        counter.setCount("suns", 1.0);
        System.out.println(counter);
        counter.setCount("aliens", 0.0);
        System.out.println(counter);
        System.out.println(counter.toString(2));
        System.out.println("Total: " + counter.totalCount());
    }

    public void clear() {
        this.entries = this.mf.buildMap();
        this.dirty = true;
    }

    public void keepTopNKeys(int keepN) {
        this.keepKeysHelper(keepN, true);
    }

    public void keepBottomNKeys(int keepN) {
        this.keepKeysHelper(keepN, false);
    }

    private void keepKeysHelper(int keepN, boolean top) {
        Counter<E> tmp = new Counter<E>();
        int n = 0;
        for (E e : Iterators.able(top ? this.asPriorityQueue() : this.asMinPriorityQueue())) {
            if (n <= keepN) {
                tmp.setCount(e, this.getCount(e));
            }
            ++n;
        }
        this.clear();
        this.incrementAll(tmp);
        this.dirty = true;
    }

    public void setAllCounts(double val) {
        for (E e : this.keySet()) {
            this.setCount(e, val);
        }
    }

    public double dotProduct(Counter<E> other) {
        double sum = 0.0;
        for (Map.Entry<E, Double> entry : this.getEntrySet()) {
            double value;
            double otherCount = other.getCount(entry.getKey());
            if (otherCount == 0.0 || (value = entry.getValue().doubleValue()) == 0.0) continue;
            sum += value * otherCount;
        }
        return sum;
    }

    public void scale(double c) {
        for (Map.Entry<E, Double> entry : this.getEntrySet()) {
            entry.setValue(entry.getValue() * c);
        }
    }

    public Counter<E> scaledClone(double c) {
        Counter<E> newCounter = new Counter<E>();
        for (Map.Entry<E, Double> entry : this.getEntrySet()) {
            newCounter.setCount(entry.getKey(), entry.getValue() * c);
        }
        return newCounter;
    }

    public Counter<E> difference(Counter<E> counter) {
        Counter<E> clone = new Counter<E>(this);
        for (E key : counter.keySet()) {
            double count = counter.getCount(key);
            clone.incrementCount(key, -1.0 * count);
        }
        return clone;
    }

    public Counter<E> toLogSpace() {
        Counter<E> newCounter = new Counter<E>(this);
        for (E key : newCounter.keySet()) {
            newCounter.setCount(key, Math.log(this.getCount(key)));
        }
        return newCounter;
    }

    public boolean approxEquals(Counter<E> other, double tol) {
        for (E key : this.keySet()) {
            if (!(Math.abs(this.getCount(key) - other.getCount(key)) > tol)) continue;
            return false;
        }
        for (E key : other.keySet()) {
            if (!(Math.abs(this.getCount(key) - other.getCount(key)) > tol)) continue;
            return false;
        }
        return true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String toStringTabSeparated() {
        StringBuilder sb = new StringBuilder();
        for (E key : this.getSortedKeys()) {
            sb.append(key.toString() + "\t" + this.getCount(key) + "\n");
        }
        return sb.toString();
    }
}

