/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.MapFactory;
import edu.berkeley.nlp.util.Pair;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    MapFactory<V, Double> mf;
    Map<K, Counter<V>> counterMap;
    double defltVal = 0.0;

    protected Counter<V> ensureCounter(K key) {
        Counter<V> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            valueCounter = this.buildCounter(this.mf);
            valueCounter.setDeflt(this.defltVal);
            this.counterMap.put(key, valueCounter);
        }
        return valueCounter;
    }

    public Collection<Counter<V>> getCounters() {
        return this.counterMap.values();
    }

    protected Counter<V> buildCounter(MapFactory<V, Double> mf) {
        return new Counter<V>(mf);
    }

    public Set<K> keySet() {
        return this.counterMap.keySet();
    }

    public void setCount(K key, V value, double count) {
        Counter<V> valueCounter = this.ensureCounter(key);
        valueCounter.setCount(value, count);
    }

    public void incrementCount(K key, V value, double count) {
        Counter<V> valueCounter = this.ensureCounter(key);
        valueCounter.incrementCount(value, count);
    }

    public double getCount(K key, V value) {
        Counter<V> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            return this.defltVal;
        }
        return valueCounter.getCount(value);
    }

    public Counter<V> getCounter(K key) {
        return this.ensureCounter(key);
    }

    public void incrementAll(Map<K, V> map, double count) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.incrementCount(entry.getKey(), entry.getValue(), count);
        }
    }

    public void incrementAll(CounterMap<K, V> cMap) {
        for (Map.Entry<K, Counter<V>> entry : cMap.counterMap.entrySet()) {
            K key = entry.getKey();
            Counter<V> innerCounter = entry.getValue();
            for (Map.Entry<V, Double> innerEntry : innerCounter.entrySet()) {
                V value = innerEntry.getKey();
                this.incrementCount(key, value, innerEntry.getValue());
            }
        }
    }

    public double getCount(K key) {
        Counter<V> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            return 0.0;
        }
        return valueCounter.totalCount();
    }

    public double totalCount() {
        double total = 0.0;
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            Counter<V> counter = entry.getValue();
            total += counter.totalCount();
        }
        return total;
    }

    public int totalSize() {
        int total = 0;
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            Counter<V> counter = entry.getValue();
            total += counter.size();
        }
        return total;
    }

    public int size() {
        return this.counterMap.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Pair<K, V> argMax() {
        double maxCount = Double.NEGATIVE_INFINITY;
        Pair<K, V> maxKey = null;
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            V localMax;
            Counter<V> counter = entry.getValue();
            if (!(counter.getCount(localMax = counter.argMax()) > maxCount) && maxKey != null) continue;
            maxKey = new Pair<K, V>(entry.getKey(), localMax);
            maxCount = counter.getCount(localMax);
        }
        return maxKey;
    }

    public String toString(int maxValsPerKey) {
        StringBuilder sb = new StringBuilder("[\n");
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            sb.append("  ");
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue().toString(maxValsPerKey));
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return this.toString(20);
    }

    public String toString(Collection<String> keyFilter) {
        StringBuilder sb = new StringBuilder("[\n");
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            if (keyFilter != null && !keyFilter.contains(entry.getKey())) continue;
            sb.append("  ");
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue().toString(20));
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public CounterMap(CounterMap<K, V> cm) {
        this();
        this.incrementAll(cm);
    }

    public CounterMap() {
        this(false);
    }

    public boolean isEqualTo(CounterMap<K, V> map) {
        boolean tmp = true;
        CounterMap bigger = map.size() > this.size() ? map : this;
        for (K k : bigger.keySet()) {
            tmp &= map.getCounter(k).isEqualTo(this.getCounter(k));
        }
        return tmp;
    }

    public CounterMap(MapFactory<K, Counter<V>> outerMF, MapFactory<V, Double> innerMF) {
        this.mf = innerMF;
        this.counterMap = outerMF.buildMap();
    }

    public CounterMap(boolean identityHashMap) {
        this(identityHashMap ? new MapFactory.IdentityHashMapFactory() : new MapFactory.HashMapFactory(), identityHashMap ? new MapFactory.IdentityHashMapFactory() : new MapFactory.HashMapFactory());
    }

    public static void main(String[] args) {
        CounterMap<String, String> bigramCounterMap = new CounterMap<String, String>();
        bigramCounterMap.incrementCount("people", "run", 1.0);
        bigramCounterMap.incrementCount("cats", "growl", 2.0);
        bigramCounterMap.incrementCount("cats", "scamper", 3.0);
        System.out.println(bigramCounterMap);
        System.out.println("Entries for cats: " + bigramCounterMap.getCounter("cats"));
        System.out.println("Entries for dogs: " + bigramCounterMap.getCounter("dogs"));
        System.out.println("Count of cats scamper: " + bigramCounterMap.getCount("cats", "scamper"));
        System.out.println("Count of snakes slither: " + bigramCounterMap.getCount("snakes", "slither"));
        System.out.println("Total size: " + bigramCounterMap.totalSize());
        System.out.println("Total count: " + bigramCounterMap.totalCount());
        System.out.println(bigramCounterMap);
    }

    public void normalize() {
        for (K key : this.keySet()) {
            this.getCounter(key).normalize();
        }
    }

    public void normalizeWithDiscount(double discount) {
        for (K key : this.keySet()) {
            Counter<V> ctr = this.getCounter(key);
            double totalCount = ctr.totalCount();
            for (V value : ctr.keySet()) {
                ctr.setCount(value, (ctr.getCount(value) - discount) / totalCount);
            }
        }
    }

    public CounterMap<V, K> invert() {
        CounterMap<V, K> invertCounterMap = new CounterMap<V, K>();
        for (K key : this.keySet()) {
            Counter<V> keyCounts = this.getCounter(key);
            for (V val : keyCounts.keySet()) {
                double count = keyCounts.getCount(val);
                invertCounterMap.setCount(val, key, count);
            }
        }
        return invertCounterMap;
    }

    public void scale(double scaleFactor) {
        for (K key : this.keySet()) {
            Counter<V> counts = this.getCounter(key);
            counts.scale(scaleFactor);
        }
    }

    public boolean containsKey(K key) {
        return this.counterMap.containsKey(key);
    }

    public Iterator<Pair<K, V>> getPairIterator() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PairIterator
        implements Iterator<Pair<K, V>> {
            Iterator<K> outerIt;
            Iterator<V> innerIt;
            K curKey;

            public PairIterator() {
                this.outerIt = CounterMap.this.keySet().iterator();
            }

            private boolean advance() {
                if (this.innerIt == null || !this.innerIt.hasNext()) {
                    if (!this.outerIt.hasNext()) {
                        return false;
                    }
                    this.curKey = this.outerIt.next();
                    this.innerIt = CounterMap.this.getCounter(this.curKey).keySet().iterator();
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.advance();
            }

            @Override
            public Pair<K, V> next() {
                this.advance();
                assert (this.curKey != null);
                return Pair.newPair(this.curKey, this.innerIt.next());
            }

            @Override
            public void remove() {
            }
        }
        return new PairIterator();
    }

    public Set<Map.Entry<K, Counter<V>>> getEntrySet() {
        return this.counterMap.entrySet();
    }

    public void removeKey(K oldIndex) {
        this.counterMap.remove(oldIndex);
    }

    public void setCounter(K newIndex, Counter<V> counter) {
        this.counterMap.put(newIndex, counter);
    }

    public void setDefault(double defltVal) {
        this.defltVal = defltVal;
        for (Counter<V> vCounter : this.counterMap.values()) {
            vCounter.setDeflt(defltVal);
        }
    }
}

