/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Iterators;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.StopWatch;
import edu.berkeley.nlp.util.TDoubleMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastCounter<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    TDoubleMap<E> entries = new TDoubleMap();

    public Set<E> keySet() {
        return this.entries.keySet();
    }

    public void multAll(double dValue) {
        this.entries.multAll(dValue);
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(E key) {
        return this.entries.containsKey(key);
    }

    public double getCount(E key) {
        return this.entries.get(key, 0.0);
    }

    public void normalize() {
        this.entries.multAll(1.0 / this.entries.sum());
    }

    public void setCount(E key, double count) {
        this.entries.put(key, count);
    }

    public void incrementCount(E key, double increment) {
        this.entries.incr(key, increment);
    }

    public void incrementAll(Collection<? extends E> collection, double count) {
        for (E key : collection) {
            this.incrementCount(key, count);
        }
    }

    public <T extends E> void incrementAll(Counter<T> counter) {
        for (T key : counter.keySet()) {
            double count = counter.getCount(key);
            this.incrementCount(key, count);
        }
    }

    public <T extends E> void incrementAll(FastCounter<T> counter) {
        for (T key : counter.keySet()) {
            double count = counter.getCount(key);
            this.incrementCount(key, count);
        }
    }

    public double totalCount() {
        return this.entries.sum();
    }

    public List<E> getSortedKeys() {
        PriorityQueue<E> pq = this.asPriorityQueue();
        ArrayList<E> keys = new ArrayList<E>();
        while (pq.hasNext()) {
            keys.add(pq.next());
        }
        return keys;
    }

    public E argMax() {
        return this.entries.argmax();
    }

    public double min() {
        return this.maxMinHelp(false);
    }

    public double max() {
        return this.maxMinHelp(true);
    }

    private double maxMinHelp(boolean max) {
        double maxCount = max ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (Object key : this.entries.keySet()) {
            double val = this.entries.getSure(key);
            if (!(max && val > maxCount) && (max || !(val < maxCount))) continue;
            maxCount = val;
        }
        return maxCount;
    }

    public String toString() {
        return this.toString(this.keySet().size());
    }

    public String toString(int maxKeysToPrint) {
        return this.asPriorityQueue().toString(maxKeysToPrint, false);
    }

    public PriorityQueue<E> asPriorityQueue() {
        PriorityQueue pq = new PriorityQueue(this.entries.size());
        for (Object key : this.entries.keySet()) {
            pq.add(key, this.entries.getSure(key));
        }
        return pq;
    }

    public PriorityQueue<E> asMinPriorityQueue() {
        PriorityQueue pq = new PriorityQueue(this.entries.size());
        for (Object key : this.entries.keySet()) {
            pq.add(key, -1.0 * this.entries.getSure(key));
        }
        return pq;
    }

    public void pruneKeysBelowThreshold(double cutoff) {
        Iterator it = this.entries.keySet().iterator();
        HashSet remaining = new HashSet();
        while (it.hasNext()) {
            Object key = it.next();
            double val = this.entries.getSure(key);
            if (!(val >= cutoff)) continue;
            remaining.add(key);
        }
        this.entries = this.entries.restrict(remaining);
    }

    public void clear() {
        this.entries.gut();
    }

    public void keepTopNKeys(int keepN) {
        this.keepKeysHelper(keepN, true);
    }

    public void keepBottomNKeys(int keepN) {
        this.keepKeysHelper(keepN, false);
    }

    private void keepKeysHelper(int keepN, boolean top) {
        Counter<E> tmp = new Counter<E>();
        int n = 0;
        for (E e : Iterators.able(top ? this.asPriorityQueue() : this.asMinPriorityQueue())) {
            if (n <= keepN) {
                tmp.setCount(e, this.getCount(e));
            }
            ++n;
        }
        this.clear();
        this.incrementAll(tmp);
    }

    public void setAllCounts(double val) {
        for (E e : this.keySet()) {
            this.setCount(e, val);
        }
    }

    public void switchToSortedList() {
        this.entries.switchToSortedList();
    }

    public void switchToHashTable() {
        this.entries.switchToHashTable();
    }

    public static void main(String[] args) {
        int i;
        FastCounter<String> counter = new FastCounter<String>();
        System.out.println(counter);
        counter.incrementCount("planets", 7.0);
        System.out.println(counter);
        counter.incrementCount("planets", 1.0);
        System.out.println(counter);
        counter.setCount("suns", 1.0);
        System.out.println(counter);
        counter.setCount("aliens", 0.5);
        System.out.println(counter);
        System.out.println(counter.toString(2));
        System.out.println("Total: " + counter.totalCount());
        counter.pruneKeysBelowThreshold(0.6);
        System.out.println(counter);
        System.out.println(counter.totalCount());
        System.out.println("Waiting for profiler...");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Done.");
        FastCounter<Integer> fast = new FastCounter<Integer>();
        Counter<Integer> baseline = new Counter<Integer>();
        StopWatch watch = new StopWatch();
        Random r = new Random();
        int size = 50000000;
        watch.start();
        for (i = 0; i < size; ++i) {
            fast.incrementCount(r.nextInt(size / 10), 1.0);
        }
        watch.stop();
        System.out.println("Fast: " + watch.toString());
        try {
            Thread.sleep(5000L);
            System.out.println("Waiting for profiler...");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        watch.reset();
        watch.start();
        fast.entries.switchToSortedList();
        watch.stop();
        System.out.println("Switching: " + watch.toString());
        try {
            Thread.sleep(5000L);
            System.out.println("Waiting for profiler...");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        watch.reset();
        watch.start();
        for (i = 0; i < size; ++i) {
            baseline.incrementCount(r.nextInt(size / 10), 1.0);
        }
        watch.stop();
        System.out.println("Baseline: " + watch.toString());
    }
}

