/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.FastCounter;
import edu.berkeley.nlp.util.Pair;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastCounterMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<K, FastCounter<V>> counterMap = new HashMap<K, FastCounter<V>>();
    boolean sortedList;

    protected FastCounter<V> ensureCounter(K key) {
        FastCounter<Object> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            valueCounter = new FastCounter();
            if (this.sortedList) {
                valueCounter.switchToSortedList();
            }
            this.counterMap.put(key, valueCounter);
        }
        return valueCounter;
    }

    public Set<K> keySet() {
        return this.counterMap.keySet();
    }

    public void setCount(K key, V value, double count) {
        FastCounter<V> valueCounter = this.ensureCounter(key);
        valueCounter.setCount(value, count);
    }

    public void incrementCount(K key, V value, double count) {
        FastCounter<V> valueCounter = this.ensureCounter(key);
        valueCounter.incrementCount(value, count);
    }

    public double getCount(K key, V value) {
        FastCounter<V> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            return 0.0;
        }
        return valueCounter.getCount(value);
    }

    public FastCounter<V> getCounter(K key) {
        return this.ensureCounter(key);
    }

    public void incrementAll(Map<K, V> map, double count) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.incrementCount(entry.getKey(), entry.getValue(), count);
        }
    }

    public void incrementAll(FastCounterMap<K, V> cMap) {
        for (K key : cMap.keySet()) {
            for (V value : cMap.getCounter(key).keySet()) {
                this.incrementCount(key, value, cMap.getCounter(key).getCount(value));
            }
        }
    }

    public double getCount(K key) {
        FastCounter<V> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            return 0.0;
        }
        return valueCounter.totalCount();
    }

    public double totalCount() {
        double total = 0.0;
        for (Map.Entry<K, FastCounter<V>> entry : this.counterMap.entrySet()) {
            FastCounter<V> counter = entry.getValue();
            total += counter.totalCount();
        }
        return total;
    }

    public int totalSize() {
        int total = 0;
        for (Map.Entry<K, FastCounter<V>> entry : this.counterMap.entrySet()) {
            FastCounter<V> counter = entry.getValue();
            total += counter.size();
        }
        return total;
    }

    public int size() {
        return this.counterMap.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Pair<K, V> argMax() {
        double maxCount = Double.NEGATIVE_INFINITY;
        Pair<K, V> maxKey = null;
        for (Map.Entry<K, FastCounter<V>> entry : this.counterMap.entrySet()) {
            V localMax;
            FastCounter<V> counter = entry.getValue();
            if (!(counter.getCount(localMax = counter.argMax()) > maxCount) && maxKey != null) continue;
            maxKey = new Pair<K, V>(entry.getKey(), localMax);
            maxCount = counter.getCount(localMax);
        }
        return maxKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[\n");
        for (Map.Entry<K, FastCounter<V>> entry : this.counterMap.entrySet()) {
            sb.append("  ");
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue().toString(20));
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public FastCounterMap(FastCounterMap<K, V> cm) {
        this();
        this.incrementAll(cm);
    }

    public FastCounterMap() {
    }

    public static void main(String[] args) {
        FastCounterMap<String, String> bigramCounterMap = new FastCounterMap<String, String>();
        bigramCounterMap.incrementCount("people", "run", 1.0);
        bigramCounterMap.incrementCount("cats", "growl", 2.0);
        bigramCounterMap.incrementCount("cats", "scamper", 3.0);
        System.out.println(bigramCounterMap);
        System.out.println("Entries for cats: " + bigramCounterMap.getCounter("cats"));
        System.out.println("Entries for dogs: " + bigramCounterMap.getCounter("dogs"));
        System.out.println("Count of cats scamper: " + bigramCounterMap.getCount("cats", "scamper"));
        System.out.println("Count of snakes slither: " + bigramCounterMap.getCount("snakes", "slither"));
        System.out.println("Total size: " + bigramCounterMap.totalSize());
        System.out.println("Total count: " + bigramCounterMap.totalCount());
        System.out.println(bigramCounterMap);
    }

    public void normalize() {
        for (K key : this.keySet()) {
            this.getCounter(key).normalize();
        }
    }

    public void normalizeWithDiscount(double discount) {
        for (K key : this.keySet()) {
            FastCounter<V> ctr = this.getCounter(key);
            double totalCount = ctr.totalCount();
            for (V value : ctr.keySet()) {
                ctr.setCount(value, (ctr.getCount(value) - discount) / totalCount);
            }
        }
    }

    public FastCounterMap<V, K> invert() {
        FastCounterMap<V, K> invertCounterMap = new FastCounterMap<V, K>();
        for (K key : this.keySet()) {
            FastCounter<V> keyCounts = this.getCounter(key);
            for (V val : keyCounts.keySet()) {
                double count = keyCounts.getCount(val);
                invertCounterMap.setCount(val, key, count);
            }
        }
        return invertCounterMap;
    }

    public boolean containsKey(K key) {
        return this.counterMap.containsKey(key);
    }

    public Iterator<Pair<K, V>> getPairIterator() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PairIterator
        implements Iterator<Pair<K, V>> {
            Iterator<K> outerIt;
            Iterator<V> innerIt;
            K curKey;

            public PairIterator() {
                this.outerIt = FastCounterMap.this.keySet().iterator();
            }

            private boolean advance() {
                if (this.innerIt == null || !this.innerIt.hasNext()) {
                    if (!this.outerIt.hasNext()) {
                        return false;
                    }
                    this.curKey = this.outerIt.next();
                    this.innerIt = FastCounterMap.this.getCounter(this.curKey).keySet().iterator();
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.advance();
            }

            @Override
            public Pair<K, V> next() {
                this.advance();
                assert (this.curKey != null);
                return Pair.newPair(this.curKey, this.innerIt.next());
            }

            @Override
            public void remove() {
            }
        }
        return new PairIterator();
    }

    public Set<Map.Entry<K, FastCounter<V>>> getEntrySet() {
        return this.counterMap.entrySet();
    }

    public void removeKey(K oldIndex) {
        this.counterMap.remove(oldIndex);
    }

    public void setCounter(K newIndex, FastCounter<V> counter) {
        this.counterMap.put(newIndex, counter);
    }

    public void setSortedList(boolean sortedList) {
        this.sortedList = sortedList;
        for (Map.Entry<K, FastCounter<V>> entry : this.getEntrySet()) {
            FastCounter<V> ctr = entry.getValue();
            if (sortedList) {
                ctr.switchToSortedList();
                continue;
            }
            ctr.switchToHashTable();
        }
    }
}

