/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Fmt;
import edu.berkeley.nlp.util.ListUtils;
import java.util.Random;

public class NumUtils {
    @Deprecated
    private static Random random = new Random();
    private static double[] logGammaCoeff = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double[] cachedLogFactorial = null;
    private static int numCachedLogFactorial = 1024;
    private static double logMaxValue = Math.log(Double.MAX_VALUE);

    @Deprecated
    public static Random getRandom() {
        return random;
    }

    @Deprecated
    public static void setRandom(long seed) {
        NumUtils.setRandom(new Random(seed));
    }

    @Deprecated
    public static void setRandom(Random random) {
        NumUtils.random = random;
    }

    @Deprecated
    public static double randDouble() {
        return random.nextDouble();
    }

    @Deprecated
    public static int randInt(int n) {
        return random.nextInt(n);
    }

    @Deprecated
    public static boolean randBernoulli(double p) {
        return random.nextDouble() < p;
    }

    @Deprecated
    public static int randMultinomial(double[] probs, Random random) {
        double v = random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            if (!(v < (sum += probs[i]))) continue;
            return i;
        }
        throw new RuntimeException(sum + " < " + v);
    }

    @Deprecated
    public static int randMultinomial(double[] probs) {
        return NumUtils.randMultinomial(probs, random);
    }

    public static boolean isFinite(double x) {
        return !Double.isNaN(x) && !Double.isInfinite(x);
    }

    public static void assertIsFinite(double x) {
        assert (NumUtils.isFinite(x)) : "Not finite: " + x;
    }

    public static void assertIsFinite(double[] xs) {
        for (double x : xs) {
            assert (NumUtils.isFinite(x)) : "Not finite: " + Fmt.D(xs);
        }
    }

    public static void assertIsFinite(double[][] xss) {
        double[][] arr$ = xss;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] xs;
            for (double x : xs = arr$[i$]) {
                assert (NumUtils.isFinite(x)) : "Not finite: " + Fmt.D(xss);
            }
        }
    }

    public static boolean isProb(double x) {
        return x >= 0.0 && x <= 1.0 && !Double.isNaN(x);
    }

    public static void assertIsProb(double x) {
        assert (NumUtils.isProb(x)) : "Not a probability [0, 1]: " + x;
    }

    public static void assertEquals(double x, double y) {
        NumUtils.assertEquals(x, y, 1.0E-10);
    }

    public static void assertEquals(double x, double y, double tol) {
        assert (Math.abs(x - y) < tol) : x + " != " + y;
    }

    public static void assertNormalized(double[] p) {
        NumUtils.assertEquals(ListUtils.sum(p), 1.0);
    }

    public static void assertNormalized(double[] p, double tol) {
        NumUtils.assertEquals(ListUtils.sum(p), 1.0, tol);
    }

    public static boolean normalize(float[] data) {
        float sum = 0.0f;
        for (float x : data) {
            sum += x;
        }
        if (sum == 0.0f) {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return true;
    }

    public static boolean normalize(double[] data) {
        double sum = 0.0;
        for (double x : data) {
            sum += x;
        }
        if (sum == 0.0) {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return true;
    }

    public static boolean normalize(double[][] data) {
        double sum = 0.0;
        double[][] arr$ = data;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] v;
            for (double x : v = arr$[i$]) {
                sum += x;
            }
        }
        if (sum == 0.0) {
            return false;
        }
        for (double[] v : data) {
            int i = 0;
            while (i < v.length) {
                int n = i++;
                v[n] = v[n] / sum;
            }
        }
        return true;
    }

    public static boolean normalizeEachRow(double[][] data) {
        boolean allRowsOkay = true;
        for (double[] row : data) {
            if (NumUtils.normalize(row)) continue;
            allRowsOkay = false;
        }
        return allRowsOkay;
    }

    public static boolean normalize(double[][][] data) {
        double[][] m;
        int i$;
        double sum = 0.0;
        double[][][] arr$ = data;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            double[][] arr$2 = m = arr$[i$];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                double[] v;
                for (double x : v = arr$2[i$2]) {
                    sum += x;
                }
            }
        }
        if (sum == 0.0) {
            return false;
        }
        arr$ = data;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (double[] v : m = arr$[i$]) {
                int i = 0;
                while (i < v.length) {
                    int n = i++;
                    v[n] = v[n] / sum;
                }
            }
        }
        return true;
    }

    public static boolean expNormalize(double[] probs) {
        int i;
        double max = Double.NEGATIVE_INFINITY;
        for (i = 0; i < probs.length; ++i) {
            max = Math.max(max, probs[i]);
        }
        for (i = 0; i < probs.length; ++i) {
            probs[i] = Math.exp(probs[i] - max);
        }
        return NumUtils.normalize(probs);
    }

    public static boolean expNormalize(double[][] probs) {
        int i;
        double max = Double.NEGATIVE_INFINITY;
        for (double[] v : probs) {
            for (i = 0; i < v.length; ++i) {
                max = Math.max(max, v[i]);
            }
        }
        for (double[] v : probs) {
            for (i = 0; i < v.length; ++i) {
                v[i] = Math.exp(v[i] - max);
            }
        }
        return NumUtils.normalize(probs);
    }

    public static boolean expNormalize(double[][][] probs) {
        int i;
        double[][] m;
        int i$;
        double max = Double.NEGATIVE_INFINITY;
        double[][][] arr$ = probs;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (double[] v : m = arr$[i$]) {
                for (i = 0; i < v.length; ++i) {
                    max = Math.max(max, v[i]);
                }
            }
        }
        arr$ = probs;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (double[] v : m = arr$[i$]) {
                for (i = 0; i < v.length; ++i) {
                    v[i] = Math.exp(v[i] - max);
                }
            }
        }
        return NumUtils.normalize(probs);
    }

    public static int[][] toInt(double[][] data) {
        int[][] newdata = new int[data.length][];
        for (int r = 0; r < data.length; ++r) {
            newdata[r] = new int[data[r].length];
            for (int c = 0; c < data[r].length; ++c) {
                newdata[r][c] = (int)data[r][c];
            }
        }
        return newdata;
    }

    public static double l1Dist(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.abs(x[i] - y[i]);
        }
        return sum;
    }

    public static double lInfDist(double[] x, double[] y) {
        double max = 0.0;
        for (int i = 0; i < x.length; ++i) {
            max = Math.max(max, Math.abs(x[i] - y[i]));
        }
        return max;
    }

    public static double l2Dist(double[] x, double[] y) {
        return Math.sqrt(NumUtils.l2DistSquared(x, y));
    }

    public static double l2DistSquared(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += (x[i] - y[i]) * (x[i] - y[i]);
        }
        return sum;
    }

    public static double l2Norm(double[] x) {
        return Math.sqrt(NumUtils.l2NormSquared(x));
    }

    public static double l2NormSquared(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i];
        }
        return sum;
    }

    public static double[] l2NormalizedMut(double[] x) {
        double norm = NumUtils.l2Norm(x);
        if (norm > 0.0) {
            ListUtils.multMut(x, 1.0 / norm);
        }
        return x;
    }

    public static boolean normalizeForce(double[] data) {
        double sum = 0.0;
        for (double x : data) {
            sum += x;
        }
        if (sum == 0.0) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = 1.0 / (double)data.length;
            }
            return false;
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return true;
    }

    public static double[][] transpose(double[][] mat) {
        int m = mat.length;
        int n = mat[0].length;
        double[][] newMat = new double[n][m];
        for (int r = 0; r < m; ++r) {
            for (int c = 0; c < n; ++c) {
                newMat[c][r] = mat[r][c];
            }
        }
        return newMat;
    }

    public static double[][] elementWiseMult(double[][] mat1, double[][] mat2) {
        int m = mat1.length;
        int n = mat1[0].length;
        double[][] newMat = new double[m][n];
        for (int r = 0; r < m; ++r) {
            for (int c = 0; c < n; ++c) {
                newMat[r][c] = mat1[r][c] * mat2[r][c];
            }
        }
        return newMat;
    }

    public static void scalarMult(double[][] mat, double x) {
        int m = mat.length;
        int n = mat[0].length;
        for (int r = 0; r < m; ++r) {
            int c = 0;
            while (c < n) {
                double[] dArray = mat[r];
                int n2 = c++;
                dArray[n2] = dArray[n2] * x;
            }
        }
    }

    public static double[][] copy(double[][] mat) {
        int m = mat.length;
        double[][] newMat = new double[m][];
        for (int r = 0; r < m; ++r) {
            int n = mat[r].length;
            newMat[r] = new double[n];
            for (int c = 0; c < n; ++c) {
                newMat[r][c] = mat[r][c];
            }
        }
        return newMat;
    }

    public static boolean equals(double x, double y) {
        return Math.abs(x - y) < 1.0E-10;
    }

    public static boolean equals(double x, double y, double tol) {
        return Math.abs(x - y) < tol;
    }

    public static double round(double x, int numPlaces) {
        double scale = Math.pow(10.0, numPlaces);
        return (double)Math.round(x * scale) / scale;
    }

    public static double[] round(double[] vec, int numPlaces) {
        double[] newVec = new double[vec.length];
        double scale = Math.pow(10.0, numPlaces);
        for (int i = 0; i < vec.length; ++i) {
            newVec[i] = (double)Math.round(vec[i] * scale) / scale;
        }
        return newVec;
    }

    public static double bound(double x, double lower, double upper) {
        if (x < lower) {
            return lower;
        }
        if (x > upper) {
            return upper;
        }
        return x;
    }

    public static int bound(int x, int lower, int upper) {
        if (x < lower) {
            return lower;
        }
        if (x > upper) {
            return upper;
        }
        return x;
    }

    public static double entropy(double[] probs) {
        double e = 0.0;
        for (double p : probs) {
            if (!(p > 0.0)) continue;
            e += -p * Math.log(p);
        }
        return e;
    }

    public static double condEntropy(double[] probs) {
        double sum = ListUtils.sum(probs);
        double e = 0.0;
        for (double p : probs) {
            if (!(p > 0.0)) continue;
            e += -p * Math.log(p / sum);
        }
        NumUtils.assertIsFinite(sum);
        return e;
    }

    public static double condEntropy(double[][] probs) {
        double sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            sum += NumUtils.condEntropy(probs[i]);
        }
        return sum;
    }

    public static double logGamma(double xx) {
        double x;
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += logGammaCoeff[j] / (y += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    public static double logFactorial(int n) {
        if (n < numCachedLogFactorial) {
            if (cachedLogFactorial == null) {
                cachedLogFactorial = new double[numCachedLogFactorial];
                for (int i = 1; i < numCachedLogFactorial; ++i) {
                    NumUtils.cachedLogFactorial[i] = cachedLogFactorial[i - 1] + Math.log(i);
                }
            }
            return cachedLogFactorial[n];
        }
        return NumUtils.logGamma(n + 1);
    }

    public static double logChoose(int n, int k) {
        return NumUtils.logFactorial(n) - NumUtils.logFactorial(k) - NumUtils.logFactorial(n - k);
    }

    public static double digamma(double x) {
        assert (x > 0.0) : x;
        double r = 0.0;
        while (x <= 5.0) {
            r -= 1.0 / x;
            x += 1.0;
        }
        double f = 1.0 / (x * x);
        double t = f * (-0.08333333333333333 + f * (0.008333333333333333 + f * (-0.003968253968253968 + f * (0.004166666666666667 + f * (-0.007575757575757576 + f * (0.021092796092796094 + f * (-0.08333333333333333 + f * 3617.0 / 8160.0)))))));
        return r + Math.log(x) - 0.5 / x + t;
    }

    public static double logAdd(double a, double b) {
        if (a > b) {
            if (Double.isInfinite(b) || a - b > logMaxValue) {
                return a;
            }
            return b + Math.log(1.0 + Math.exp(a - b));
        }
        if (Double.isInfinite(a) || b - a > logMaxValue) {
            return b;
        }
        return a + Math.log(1.0 + Math.exp(b - a));
    }

    public static double fastExp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static double fastLog(double val) {
        double x = Double.doubleToLongBits(val) >> 32;
        return (x - 1.072632447E9) / 1512775.0;
    }
}

