/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.IdentityHashSet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetFactory<K>
implements Serializable {
    public abstract Set<K> buildSet();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeMapFactory<K>
    extends SetFactory<K> {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<K> buildSet() {
            return new TreeSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdentityHashMapFactory<K>
    extends SetFactory<K> {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<K> buildSet() {
            return new IdentityHashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashSetFactory<K>
    extends SetFactory<K> {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<K> buildSet() {
            return new HashSet();
        }
    }
}

