/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Semaphore;

public class Shell {
    public static String execute(String cmd) {
        return Shell.execute(cmd, false);
    }

    public static String execute(String cmd, boolean echo) {
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERR> ", echo);
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUT> ", echo);
            errorGobbler.start();
            outputGobbler.start();
            proc.waitFor();
            return outputGobbler.getOutput();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String output;
        Semaphore semaphore;
        String prefix;
        boolean echo;

        StreamGobbler(InputStream is, String prefix, boolean echo) {
            this.is = is;
            this.semaphore = new Semaphore(1);
            this.semaphore.acquireUninterruptibly();
            this.echo = echo;
            this.prefix = prefix;
        }

        public void run() {
            StringBuilder outputBuilder = new StringBuilder();
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    outputBuilder.append(line + "\n");
                    if (!this.echo) continue;
                    System.out.println(this.prefix + line);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.output = outputBuilder.toString();
            this.semaphore.release();
        }

        public String getOutput() {
            this.semaphore.acquireUninterruptibly();
            this.semaphore.release();
            return this.output;
        }
    }
}

